/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.conversion.impl;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConverterProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.PathUtilRt;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class CachedConversionResult {
    private static final String RELATIVE_PREFIX = "./";
    public final Set<String> appliedConverters;
    public final Object2LongMap<String> projectFilesTimestamps;

    private CachedConversionResult(@NotNull Set<String> appliedConverters, @NotNull Object2LongMap<String> projectFilesTimestamps) {
        if (appliedConverters == null) {
            CachedConversionResult.$$$reportNull$$$0(0);
        }
        if (projectFilesTimestamps == null) {
            CachedConversionResult.$$$reportNull$$$0(1);
        }
        this.appliedConverters = appliedConverters;
        this.projectFilesTimestamps = projectFilesTimestamps;
    }

    @NotNull
    static Path getConversionInfoFile(@NotNull Path projectFile) {
        Path projectFileFileName;
        if (projectFile == null) {
            CachedConversionResult.$$$reportNull$$$0(2);
        }
        String dirName = PathUtilRt.suggestFileName((String)(((projectFileFileName = projectFile.getFileName()) == null ? "" : projectFileFileName.toString()) + Integer.toHexString(projectFile.toAbsolutePath().hashCode())));
        Path path2 = Paths.get(PathManager.getSystemPath(), "conversion", dirName + ".xml");
        if (path2 == null) {
            CachedConversionResult.$$$reportNull$$$0(3);
        }
        return path2;
    }

    static void saveConversionResult(@NotNull Object2LongMap<String> projectFilesMap, @NotNull Path outFile, @NotNull Path baseDir) throws CannotConvertException, IOException {
        if (projectFilesMap == null) {
            CachedConversionResult.$$$reportNull$$$0(4);
        }
        if (outFile == null) {
            CachedConversionResult.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            CachedConversionResult.$$$reportNull$$$0(6);
        }
        Element root2 = new Element("conversion");
        Element appliedConverters = new Element("applied-converters");
        root2.addContent(appliedConverters);
        ExtensionPointImpl point = (ExtensionPointImpl)ConverterProvider.EP_NAME.getPoint();
        point.processIdentifiableImplementations((supplier2, id2) -> {
            String providerId = id2;
            if (providerId == null) {
                ConverterProvider provider2 = (ConverterProvider)supplier2.get();
                String string = providerId = provider2 == null ? null : provider2.getDeprecatedId();
            }
            if (providerId != null) {
                appliedConverters.addContent(new Element("converter").setAttribute("id", providerId));
            }
        });
        Element projectFiles = new Element("project-files");
        root2.addContent(projectFiles);
        String basePathWithSlash = baseDir + File.separator;
        ObjectIterator iterator2 = Object2LongMaps.fastIterator(projectFilesMap);
        while (iterator2.hasNext()) {
            Object2LongMap.Entry entry2 = (Object2LongMap.Entry)iterator2.next();
            Element element2 = new Element("f");
            String path2 = (String)entry2.getKey();
            element2.setAttribute("p", (String)(path2.startsWith(basePathWithSlash) ? RELATIVE_PREFIX + path2.substring(basePathWithSlash.length()) : path2));
            element2.setAttribute("t", Long.toString(entry2.getLongValue()));
            projectFiles.addContent(element2);
        }
        JDOMUtil.write((Element)root2, (Path)outFile);
    }

    @NotNull
    static CachedConversionResult load(@NotNull Path infoFile, @NotNull Path baseDir) throws JDOMException, IOException {
        Element root2;
        if (infoFile == null) {
            CachedConversionResult.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            CachedConversionResult.$$$reportNull$$$0(8);
        }
        try {
            root2 = JDOMUtil.load((Path)infoFile);
        }
        catch (NoSuchFileException ignore) {
            return CachedConversionResult.createEmpty();
        }
        Object2LongMap<String> projectFilesTimestamps = CachedConversionResult.createPathToLastModifiedMap();
        CachedConversionResult result2 = new CachedConversionResult(new HashSet<String>(), projectFilesTimestamps);
        String basePathWithSlash = baseDir + File.separator;
        for (Element child2 : root2.getChildren()) {
            if (child2.getName().equals("applied-converters")) {
                for (Element element2 : child2.getChildren()) {
                    String id2 = element2.getAttributeValue("id");
                    if (id2 == null) continue;
                    result2.appliedConverters.add(id2);
                }
                continue;
            }
            if (!child2.getName().equals("project-files")) continue;
            List projectFiles = child2.getChildren();
            for (Element element3 : projectFiles) {
                Object path2 = element3.getAttributeValue("p");
                if (path2 == null) {
                    path2 = element3.getAttributeValue("path");
                } else if (((String)path2).startsWith(RELATIVE_PREFIX)) {
                    path2 = basePathWithSlash + ((String)path2).substring(RELATIVE_PREFIX.length());
                }
                if (path2 == null || ((String)path2).isEmpty()) continue;
                try {
                    String timestamp = element3.getAttributeValue("t");
                    if (timestamp == null) {
                        timestamp = element3.getAttributeValue("timestamp");
                        if (timestamp == null) continue;
                        projectFilesTimestamps.put(path2, TimeUnit.MILLISECONDS.toSeconds(Long.parseLong(timestamp)));
                        continue;
                    }
                    projectFilesTimestamps.put(path2, Long.parseLong(timestamp));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        CachedConversionResult cachedConversionResult = result2;
        if (cachedConversionResult == null) {
            CachedConversionResult.$$$reportNull$$$0(9);
        }
        return cachedConversionResult;
    }

    @NotNull
    static Object2LongMap<String> createPathToLastModifiedMap() {
        Object2LongOpenHashMap result2 = new Object2LongOpenHashMap();
        result2.defaultReturnValue(-1L);
        Object2LongOpenHashMap object2LongOpenHashMap = result2;
        if (object2LongOpenHashMap == null) {
            CachedConversionResult.$$$reportNull$$$0(10);
        }
        return object2LongOpenHashMap;
    }

    @NotNull
    static CachedConversionResult createEmpty() {
        return new CachedConversionResult(Collections.emptySet(), (Object2LongMap<String>)Object2LongMaps.emptyMap());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliedConverters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilesTimestamps";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/conversion/impl/CachedConversionResult";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFilesMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFile";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/conversion/impl/CachedConversionResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversionInfoFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathToLastModifiedMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConversionInfoFile";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveConversionResult";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

