/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageLogger;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageSuite
implements CoverageSuite,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)BaseCoverageSuite.class.getName());
    @NonNls
    private static final String FILE_PATH = "FILE_PATH";
    @NonNls
    private static final String SOURCE_PROVIDER = "SOURCE_PROVIDER";
    @NonNls
    private static final String MODIFIED_STAMP = "MODIFIED";
    @NonNls
    private static final String NAME_ATTRIBUTE = "NAME";
    @NonNls
    private static final String COVERAGE_RUNNER = "RUNNER";
    @NonNls
    private static final String COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME = "COVERAGE_BY_TEST_ENABLED";
    @NonNls
    private static final String TRACING_ENABLED_ATTRIBUTE_NAME = "COVERAGE_TRACING_ENABLED";
    private SoftReference<ProjectData> myCoverageData = new SoftReference<Object>(null);
    private String myName;
    private long myLastCoverageTimeStamp;
    private boolean myCoverageByTestEnabled;
    private CoverageRunner myRunner;
    private CoverageFileProvider myCoverageDataFileProvider;
    private boolean myTrackTestFolders;
    private boolean myTracingEnabled;
    private Project myProject;
    private RunConfigurationBase myConfiguration;

    protected BaseCoverageSuite() {
    }

    public BaseCoverageSuite(String name2, @Nullable CoverageFileProvider fileProvider, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner) {
        this(name2, fileProvider, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, coverageRunner, null);
    }

    public BaseCoverageSuite(String name2, @Nullable CoverageFileProvider fileProvider, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner, Project project) {
        this.myCoverageDataFileProvider = fileProvider;
        this.myName = name2;
        this.myLastCoverageTimeStamp = lastCoverageTimeStamp;
        this.myCoverageByTestEnabled = coverageByTestEnabled;
        this.myTrackTestFolders = trackTestFolders;
        this.myTracingEnabled = tracingEnabled;
        this.myRunner = coverageRunner;
        this.myProject = project;
    }

    @Nullable
    public static CoverageRunner readRunnerAttribute(Element element2) {
        String runner = element2.getAttributeValue(COVERAGE_RUNNER);
        if (runner != null) {
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)runner)) continue;
                return coverageRunner;
            }
        }
        return null;
    }

    public static CoverageFileProvider readDataFileProviderAttribute(Element element2) {
        String sourceProvider = element2.getAttributeValue(SOURCE_PROVIDER);
        String relativePath = FileUtil.toSystemDependentName((String)element2.getAttributeValue(FILE_PATH));
        File file2 = new File(relativePath);
        return new DefaultCoverageFileProvider(file2.exists() ? file2 : new File(PathManager.getSystemPath(), relativePath), sourceProvider != null ? sourceProvider : DefaultCoverageFileProvider.class.getName());
    }

    @Override
    public boolean isValid() {
        return this.myCoverageDataFileProvider.isValid();
    }

    @Override
    @NotNull
    public String getCoverageDataFileName() {
        String string = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        if (string == null) {
            BaseCoverageSuite.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider() {
        CoverageFileProvider coverageFileProvider = this.myCoverageDataFileProvider;
        if (coverageFileProvider == null) {
            BaseCoverageSuite.$$$reportNull$$$0(1);
        }
        return coverageFileProvider;
    }

    @Override
    public String getPresentableName() {
        return this.myName;
    }

    @Override
    public long getLastCoverageTimeStamp() {
        return this.myLastCoverageTimeStamp;
    }

    @Override
    public boolean isTrackTestFolders() {
        return this.myTrackTestFolders;
    }

    @Override
    public boolean isTracingEnabled() {
        return this.myTracingEnabled;
    }

    public void readExternal(Element element2) throws InvalidDataException {
        this.myCoverageDataFileProvider = BaseCoverageSuite.readDataFileProviderAttribute(element2);
        this.myName = element2.getAttributeValue(NAME_ATTRIBUTE);
        if (this.myName == null) {
            this.myName = this.generateName();
        }
        this.myLastCoverageTimeStamp = Long.parseLong(element2.getAttributeValue(MODIFIED_STAMP));
        this.myRunner = BaseCoverageSuite.readRunnerAttribute(element2);
        String collectedLineInfo = element2.getAttributeValue(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME);
        this.myCoverageByTestEnabled = collectedLineInfo != null && Boolean.valueOf(collectedLineInfo) != false;
        String tracingEnabled = element2.getAttributeValue(TRACING_ENABLED_ATTRIBUTE_NAME);
        this.myTracingEnabled = tracingEnabled != null && Boolean.valueOf(tracingEnabled) != false;
    }

    public void writeExternal(Element element2) throws WriteExternalException {
        String fileName = FileUtil.getRelativePath((File)new File(PathManager.getSystemPath()), (File)new File(this.myCoverageDataFileProvider.getCoverageDataFilePath()));
        element2.setAttribute(FILE_PATH, fileName != null ? FileUtil.toSystemIndependentName((String)fileName) : this.myCoverageDataFileProvider.getCoverageDataFilePath());
        element2.setAttribute(NAME_ATTRIBUTE, this.myName);
        element2.setAttribute(MODIFIED_STAMP, String.valueOf(this.myLastCoverageTimeStamp));
        element2.setAttribute(SOURCE_PROVIDER, this.myCoverageDataFileProvider instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)this.myCoverageDataFileProvider).getSourceProvider() : this.myCoverageDataFileProvider.getClass().getName());
        if (this.getRunner() != null) {
            element2.setAttribute(COVERAGE_RUNNER, this.myRunner.getId());
        }
        element2.setAttribute(COVERAGE_BY_TEST_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myCoverageByTestEnabled));
        element2.setAttribute(TRACING_ENABLED_ATTRIBUTE_NAME, String.valueOf(this.myTracingEnabled));
    }

    @Override
    public void setCoverageData(ProjectData projectData2) {
        this.myCoverageData = new SoftReference<ProjectData>(projectData2);
    }

    public ProjectData getCoverageData() {
        return this.myCoverageData.get();
    }

    @Override
    public void restoreCoverageData() {
        this.setCoverageData(this.loadProjectInfo());
    }

    @Override
    public boolean isCoverageByTestApplicable() {
        return this.getRunner().isCoverageByTestApplicable();
    }

    @Override
    public boolean isCoverageByTestEnabled() {
        return this.myCoverageByTestEnabled;
    }

    @Override
    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData data2 = this.getCoverageData();
        if (data2 != null) {
            return data2;
        }
        ProjectData map2 = this.loadProjectInfo();
        this.setCoverageData(map2);
        return map2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        String thisName = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        String thatName = ((BaseCoverageSuite)o).myCoverageDataFileProvider.getCoverageDataFilePath();
        return thisName.equals(thatName);
    }

    public int hashCode() {
        return this.myCoverageDataFileProvider.getCoverageDataFilePath().hashCode();
    }

    @Nullable
    protected ProjectData loadProjectInfo() {
        String sessionDataFileName = this.getCoverageDataFileName();
        File sessionDataFile = new File(sessionDataFileName);
        if (!sessionDataFile.exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Nonexistent file given +" + sessionDataFileName);
            }
            return null;
        }
        long startNs = System.nanoTime();
        ProjectData projectData2 = this.myRunner.loadCoverageData(sessionDataFile, this);
        long timeMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        if (projectData2 != null) {
            CoverageLogger.logReportLoading(this.myProject, this.myRunner, timeMs, projectData2.getClassesNumber());
        }
        return projectData2;
    }

    @Override
    public CoverageRunner getRunner() {
        return this.myRunner;
    }

    protected void setRunner(CoverageRunner runner) {
        this.myRunner = runner;
    }

    private String generateName() {
        String text2 = this.myCoverageDataFileProvider.getCoverageDataFilePath();
        int i2 = text2.lastIndexOf(File.separatorChar);
        if (i2 >= 0) {
            text2 = text2.substring(i2 + 1);
        }
        if ((i2 = text2.lastIndexOf(46)) >= 0) {
            text2 = text2.substring(0, i2);
        }
        return text2;
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setConfiguration(RunConfigurationBase configuration2) {
        this.myConfiguration = configuration2;
    }

    @Nullable
    public RunConfigurationBase getConfiguration() {
        return this.myConfiguration;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coverage/BaseCoverageSuite";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileProvider";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

