/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.AbstractCoverageProjectViewNodeDecorator;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.ColoredTreeCellRenderer;
import org.jetbrains.annotations.NotNull;

final class CoverageProjectViewDirectoryNodeDecorator
extends AbstractCoverageProjectViewNodeDecorator {
    CoverageProjectViewDirectoryNodeDecorator(@NotNull Project project) {
        if (project == null) {
            CoverageProjectViewDirectoryNodeDecorator.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    public void decorate(PackageDependenciesNode node2, ColoredTreeCellRenderer cellRenderer) {
        CoverageAnnotator coverageAnnotator;
        PsiElement element2 = node2.getPsiElement();
        if (element2 == null || !element2.isValid()) {
            return;
        }
        Project project = element2.getProject();
        CoverageDataManager manager2 = this.getCoverageDataManager(project);
        if (manager2 == null) {
            return;
        }
        CoverageSuitesBundle currentSuite = manager2.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = currentSuite != null ? currentSuite.getAnnotator(project) : null;
        if (coverageAnnotator == null) {
            return;
        }
        String informationString = null;
        if (element2 instanceof PsiDirectory) {
            informationString = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)element2, currentSuite, manager2);
        } else if (element2 instanceof PsiFile) {
            informationString = coverageAnnotator.getFileCoverageInformationString((PsiFile)element2, currentSuite, manager2);
        }
        if (informationString != null) {
            CoverageProjectViewDirectoryNodeDecorator.appendCoverageInfo(cellRenderer, informationString);
        }
    }

    public void decorate(ProjectViewNode node2, PresentationData data2) {
        CoverageAnnotator coverageAnnotator;
        Project project = node2.getProject();
        if (project == null) {
            return;
        }
        CoverageDataManager manager2 = this.getCoverageDataManager(project);
        if (manager2 == null) {
            return;
        }
        CoverageSuitesBundle currentSuite = manager2.getCurrentSuitesBundle();
        CoverageAnnotator coverageAnnotator2 = coverageAnnotator = currentSuite == null ? null : currentSuite.getAnnotator(project);
        if (coverageAnnotator == null) {
            return;
        }
        Object value2 = node2.getValue();
        PsiElement element2 = null;
        if (value2 instanceof PsiElement) {
            element2 = (PsiElement)value2;
        } else if (value2 instanceof SmartPsiElementPointer) {
            element2 = ((SmartPsiElementPointer)value2).getElement();
        }
        String informationString = null;
        if (element2 instanceof PsiDirectory) {
            informationString = coverageAnnotator.getDirCoverageInformationString((PsiDirectory)element2, currentSuite, manager2);
        } else if (element2 instanceof PsiFile) {
            informationString = coverageAnnotator.getFileCoverageInformationString((PsiFile)element2, currentSuite, manager2);
        }
        if (informationString != null) {
            data2.setLocationString(informationString);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageProjectViewDirectoryNodeDecorator", "<init>"));
    }
}

