/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageDataManagerImpl;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuiteChooserDialog
extends DialogWrapper {
    @NonNls
    private static final String LOCAL = "Local";
    private final Project myProject;
    private final CheckboxTree mySuitesTree;
    private final CoverageDataManager myCoverageManager;
    private final CheckedTreeNode myRootNode;
    private CoverageEngine myEngine;

    public CoverageSuiteChooserDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.myCoverageManager = CoverageDataManager.getInstance(project);
        this.myRootNode = new CheckedTreeNode((Object)"");
        this.initTree();
        this.mySuitesTree = new CheckboxTree(new SuitesRenderer(), this.myRootNode){

            @Override
            protected void installSpeedSearch() {
                new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)path2 -> {
                    DefaultMutableTreeNode component2 = (DefaultMutableTreeNode)path2.getLastPathComponent();
                    Object userObject = component2.getUserObject();
                    if (userObject instanceof CoverageSuite) {
                        return ((CoverageSuite)userObject).getPresentableName();
                    }
                    return userObject.toString();
                }));
            }
        };
        this.mySuitesTree.getEmptyText().appendText(CoverageBundle.message("no.coverage.suites.configured", new Object[0]));
        this.mySuitesTree.setRootVisible(false);
        this.mySuitesTree.setShowsRootHandles(false);
        TreeUtil.installActions((JTree)((Object)this.mySuitesTree));
        TreeUtil.expandAll((JTree)((Object)this.mySuitesTree));
        TreeUtil.promiseSelectFirst((JTree)((Object)this.mySuitesTree));
        this.mySuitesTree.setMinimumSize(new Dimension(25, -1));
        this.setOKButtonText(CoverageBundle.message("coverage.data.show.selected.button", new Object[0]));
        this.init();
        this.setTitle(CoverageBundle.message("choose.coverage.suite.to.display", new Object[0]));
    }

    protected JComponent createCenterPanel() {
        return ScrollPaneFactory.createScrollPane((Component)((Object)this.mySuitesTree));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySuitesTree;
    }

    protected JComponent createNorthPanel() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new AddExternalSuiteAction());
        group2.add((AnAction)new DeleteSuiteAction());
        group2.add((AnAction)new SwitchEngineAction());
        return ActionManager.getInstance().createActionToolbar("CoverageSuiteChooser", (ActionGroup)group2, true).getComponent();
    }

    protected void doOKAction() {
        List<CoverageSuite> suites = this.collectSelectedSuites();
        this.myCoverageManager.chooseSuitesBundle(suites.isEmpty() ? null : new CoverageSuitesBundle(suites.toArray(new CoverageSuite[0])));
        ((CoverageDataManagerImpl)this.myCoverageManager).addRootsToWatch(suites);
        super.doOKAction();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        CoverageEngine engine = null;
        for (CoverageSuite suite : this.collectSelectedSuites()) {
            if (engine == null) {
                engine = suite.getCoverageEngine();
                continue;
            }
            if (Comparing.equal((Object)engine, (Object)suite.getCoverageEngine())) continue;
            List<ValidationInfo> list2 = Collections.singletonList(new ValidationInfo(CoverageBundle.message("cannot.show.coverage.reports.from.different.engines", new Object[0]), (JComponent)((Object)this.mySuitesTree)));
            if (list2 == null) {
                CoverageSuiteChooserDialog.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List list3 = super.doValidateAll();
        if (list3 == null) {
            CoverageSuiteChooserDialog.$$$reportNull$$$0(1);
        }
        return list3;
    }

    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), new NoCoverageAction(), this.getCancelAction()};
        if (actionArray == null) {
            CoverageSuiteChooserDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    private Set<CoverageEngine> collectEngines() {
        HashSet<CoverageEngine> engines = new HashSet<CoverageEngine>();
        for (CoverageSuite suite : this.myCoverageManager.getSuites()) {
            engines.add(suite.getCoverageEngine());
        }
        return engines;
    }

    private static String getCoverageRunnerTitle(CoverageRunner coverageRunner) {
        return CoverageBundle.message("coverage.data.runner.name", coverageRunner.getPresentableName());
    }

    @Nullable
    private static CoverageRunner getCoverageRunner(@NotNull VirtualFile file2) {
        if (file2 == null) {
            CoverageSuiteChooserDialog.$$$reportNull$$$0(3);
        }
        for (CoverageRunner runner : CoverageRunner.EP_NAME.getExtensionList()) {
            for (String extension2 : runner.getDataFileExtensions()) {
                if (!Comparing.strEqual((String)file2.getExtension(), (String)extension2)) continue;
                return runner;
            }
        }
        return null;
    }

    private List<CoverageSuite> collectSelectedSuites() {
        ArrayList<CoverageSuite> suites = new ArrayList<CoverageSuite>();
        TreeUtil.treeNodeTraverser((TreeNode)this.myRootNode).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(treeNode2 -> {
            Object userObject;
            if (treeNode2 instanceof CheckedTreeNode && ((CheckedTreeNode)treeNode2).isChecked() && (userObject = ((CheckedTreeNode)treeNode2).getUserObject()) instanceof CoverageSuite) {
                suites.add((CoverageSuite)userObject);
            }
            return true;
        });
        return suites;
    }

    private void initTree() {
        this.myRootNode.removeAllChildren();
        HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> grouped = new HashMap<CoverageRunner, Map<String, List<CoverageSuite>>>();
        CoverageSuiteChooserDialog.groupSuites(grouped, this.myCoverageManager.getSuites(), this.myEngine);
        CoverageSuitesBundle currentSuite = this.myCoverageManager.getCurrentSuitesBundle();
        ArrayList<CoverageRunner> runners = new ArrayList<CoverageRunner>(grouped.keySet());
        runners.sort((o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName()));
        for (CoverageRunner runner : runners) {
            DefaultMutableTreeNode runnerNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.getCoverageRunnerTitle(runner));
            Map<String, List<CoverageSuite>> providers = grouped.get(runner);
            DefaultMutableTreeNode remoteNode = new DefaultMutableTreeNode(CoverageBundle.message("remote.suites.node", new Object[0]));
            if (providers.size() == 1) {
                String providersKey = providers.keySet().iterator().next();
                DefaultMutableTreeNode suitesNode = runnerNode;
                if (!Comparing.strEqual((String)providersKey, (String)DefaultCoverageFileProvider.class.getName())) {
                    suitesNode = remoteNode;
                    runnerNode.add(remoteNode);
                }
                List<CoverageSuite> suites = providers.get(providersKey);
                suites.sort((o1, o2) -> o1.getPresentableName().compareToIgnoreCase(o2.getPresentableName()));
                for (CoverageSuite suite : suites) {
                    CheckedTreeNode treeNode2 = new CheckedTreeNode((Object)suite);
                    treeNode2.setChecked((currentSuite != null && currentSuite.contains(suite) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                    suitesNode.add((MutableTreeNode)treeNode2);
                }
            } else {
                DefaultMutableTreeNode localNode = new DefaultMutableTreeNode(LOCAL);
                runnerNode.add(localNode);
                runnerNode.add(remoteNode);
                for (String aClass : providers.keySet()) {
                    DefaultMutableTreeNode node2 = Comparing.strEqual((String)aClass, (String)DefaultCoverageFileProvider.class.getName()) ? localNode : remoteNode;
                    for (CoverageSuite suite : providers.get(aClass)) {
                        CheckedTreeNode treeNode3 = new CheckedTreeNode((Object)suite);
                        treeNode3.setChecked((currentSuite != null && currentSuite.contains(suite) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                        node2.add((MutableTreeNode)treeNode3);
                    }
                }
            }
            this.myRootNode.add((MutableTreeNode)runnerNode);
        }
    }

    private static void groupSuites(HashMap<CoverageRunner, Map<String, List<CoverageSuite>>> grouped, CoverageSuite[] suites, CoverageEngine engine) {
        for (CoverageSuite suite : suites) {
            String sourceProvider;
            List<CoverageSuite> list2;
            CoverageFileProvider provider2;
            if (engine != null && suite.getCoverageEngine() != engine || (provider2 = suite.getCoverageDataFileProvider()) instanceof DefaultCoverageFileProvider && Comparing.strEqual((String)((DefaultCoverageFileProvider)provider2).getSourceProvider(), (String)DefaultCoverageFileProvider.class.getName()) && !provider2.ensureFileExists()) continue;
            CoverageRunner runner = suite.getRunner();
            Map<String, List<CoverageSuite>> byProviders = grouped.get(runner);
            if (byProviders == null) {
                byProviders = new HashMap<String, List<CoverageSuite>>();
                grouped.put(runner, byProviders);
            }
            if ((list2 = byProviders.get(sourceProvider = provider2 instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)provider2).getSourceProvider() : provider2.getClass().getName())) == null) {
                list2 = new ArrayList<CoverageSuite>();
                byProviders.put(sourceProvider, list2);
            }
            list2.add(suite);
        }
    }

    private void updateTree() {
        ((DefaultTreeModel)this.mySuitesTree.getModel()).reload();
        TreeUtil.expandAll((JTree)((Object)this.mySuitesTree));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCoverageRunner";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SwitchEngineAction
    extends ComboBoxAction {
        private SwitchEngineAction() {
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button4) {
            DefaultActionGroup engChooser = new DefaultActionGroup();
            for (final CoverageEngine engine : CoverageSuiteChooserDialog.this.collectEngines()) {
                engChooser.add(new AnAction(engine.getPresentableText()){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        CoverageSuiteChooserDialog.this.myEngine = engine;
                        CoverageSuiteChooserDialog.this.initTree();
                        CoverageSuiteChooserDialog.this.updateTree();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction$1", "actionPerformed"));
                    }
                });
            }
            DefaultActionGroup defaultActionGroup = engChooser;
            if (defaultActionGroup == null) {
                SwitchEngineAction.$$$reportNull$$$0(0);
            }
            return defaultActionGroup;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchEngineAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setVisible(CoverageSuiteChooserDialog.this.collectEngines().size() > 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$SwitchEngineAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class DeleteSuiteAction
    extends AnAction {
        DeleteSuiteAction() {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)CoverageSuiteChooserDialog.this.mySuitesTree));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CheckedTreeNode[] selectedNodes;
            if (e == null) {
                DeleteSuiteAction.$$$reportNull$$$0(0);
            }
            for (CheckedTreeNode selectedNode : selectedNodes = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null)) {
                CoverageSuite selectedSuite;
                Object userObject = selectedNode.getUserObject();
                if (!(userObject instanceof CoverageSuite) || !(selectedSuite = (CoverageSuite)userObject).canRemove()) continue;
                CoverageSuiteChooserDialog.this.myCoverageManager.removeCoverageSuite(selectedSuite);
                TreeUtil.removeLastPathComponent((JTree)((Object)CoverageSuiteChooserDialog.this.mySuitesTree), (TreePath)new TreePath(selectedNode.getPath()));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeleteSuiteAction.$$$reportNull$$$0(1);
            }
            CheckedTreeNode[] selectedSuites = (CheckedTreeNode[])CoverageSuiteChooserDialog.this.mySuitesTree.getSelectedNodes(CheckedTreeNode.class, null);
            Presentation presentation2 = e.getPresentation();
            presentation2.setEnabled(false);
            for (CheckedTreeNode node2 : selectedSuites) {
                CoverageSuite selectedSuite;
                Object userObject = node2.getUserObject();
                if (!(userObject instanceof CoverageSuite) || !(selectedSuite = (CoverageSuite)userObject).canRemove()) continue;
                presentation2.setEnabled(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/actions/CoverageSuiteChooserDialog$DeleteSuiteAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddExternalSuiteAction
    extends AnAction {
        AddExternalSuiteAction() {
            super(CommonBundle.message((String)"button.add", (Object[])new Object[0]), CommonBundle.message((String)"button.add", (Object[])new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)CoverageSuiteChooserDialog.this.mySuitesTree));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile file2;
            if (e == null) {
                AddExternalSuiteAction.$$$reportNull$$$0(0);
            }
            if ((file2 = FileChooser.chooseFile((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, false){

                public boolean isFileSelectable(@Nullable VirtualFile file2) {
                    return file2 != null && CoverageSuiteChooserDialog.getCoverageRunner(file2) != null;
                }
            }, (Project)CoverageSuiteChooserDialog.this.myProject, null)) != null) {
                TreeNode childNode;
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{file2});
                CoverageRunner coverageRunner = CoverageSuiteChooserDialog.getCoverageRunner(file2);
                if (coverageRunner == null) {
                    Messages.showErrorDialog((Project)CoverageSuiteChooserDialog.this.myProject, (String)CoverageBundle.message("no.coverage.runner.available.for", file2.getName()), (String)CommonBundle.getErrorTitle());
                    return;
                }
                CoverageSuite coverageSuite = CoverageSuiteChooserDialog.this.myCoverageManager.addExternalCoverageSuite(file2.getName(), file2.getTimeStamp(), coverageRunner, new DefaultCoverageFileProvider(file2.getPath()));
                String coverageRunnerTitle = CoverageSuiteChooserDialog.getCoverageRunnerTitle(coverageRunner);
                DefaultMutableTreeNode node2 = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)CoverageSuiteChooserDialog.this.myRootNode, (Object)coverageRunnerTitle);
                if (node2 == null) {
                    node2 = new DefaultMutableTreeNode(coverageRunnerTitle);
                    CoverageSuiteChooserDialog.this.myRootNode.add((MutableTreeNode)node2);
                }
                if (node2.getChildCount() > 0 && !((childNode = node2.getChildAt(0)) instanceof CheckedTreeNode)) {
                    if (CoverageSuiteChooserDialog.LOCAL.equals(((DefaultMutableTreeNode)childNode).getUserObject())) {
                        node2 = (DefaultMutableTreeNode)childNode;
                    } else {
                        DefaultMutableTreeNode localNode = new DefaultMutableTreeNode(CoverageSuiteChooserDialog.LOCAL);
                        node2.add(localNode);
                        node2 = localNode;
                    }
                }
                CheckedTreeNode suiteNode = new CheckedTreeNode((Object)coverageSuite);
                suiteNode.setChecked(true);
                node2.add((MutableTreeNode)suiteNode);
                TreeUtil.sort((DefaultMutableTreeNode)node2, (o1, o2) -> {
                    if (o1 instanceof CheckedTreeNode && o2 instanceof CheckedTreeNode) {
                        Object userObject1 = ((CheckedTreeNode)o1).getUserObject();
                        Object userObject2 = ((CheckedTreeNode)o2).getUserObject();
                        if (userObject1 instanceof CoverageSuite && userObject2 instanceof CoverageSuite) {
                            String presentableName1 = ((CoverageSuite)userObject1).getPresentableName();
                            String presentableName2 = ((CoverageSuite)userObject2).getPresentableName();
                            return presentableName1.compareToIgnoreCase(presentableName2);
                        }
                    }
                    return 0;
                });
                CoverageSuiteChooserDialog.this.updateTree();
                TreeUtil.selectNode((JTree)((Object)CoverageSuiteChooserDialog.this.mySuitesTree), (TreeNode)suiteNode);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/actions/CoverageSuiteChooserDialog$AddExternalSuiteAction", "actionPerformed"));
        }
    }

    private class NoCoverageAction
    extends DialogWrapper.DialogWrapperAction {
        NoCoverageAction() {
            super((DialogWrapper)CoverageSuiteChooserDialog.this, CoverageBundle.message("coverage.data.no.coverage.button", new Object[0]));
        }

        protected void doAction(ActionEvent e) {
            CoverageSuiteChooserDialog.this.myCoverageManager.chooseSuitesBundle(null);
            CoverageSuiteChooserDialog.this.close(0);
        }
    }

    private static class SuitesRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private SuitesRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded2, boolean leaf, int row2, boolean hasFocus) {
            Object userObject;
            if (value2 instanceof CheckedTreeNode) {
                Object userObject2 = ((CheckedTreeNode)value2).getUserObject();
                if (userObject2 instanceof CoverageSuite) {
                    CoverageSuite suite = (CoverageSuite)userObject2;
                    this.getTextRenderer().append(suite.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    String date = " (" + DateFormatUtil.formatPrettyDateTime((long)suite.getLastCoverageTimeStamp()) + ")";
                    this.getTextRenderer().append(date, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            } else if (value2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof String) {
                this.getTextRenderer().append((String)userObject);
            }
        }
    }
}

