/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.hint.PsiImplementationViewElement;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithText;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.ui.popup.NotLookupOrSearchCondition;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ShowCoveringTestsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ShowCoveringTestsAction.class);
    private final String myClassFQName;
    private final LineData myLineData;

    public ShowCoveringTestsAction(String classFQName, LineData lineData) {
        super(CoverageBundle.message("action.text.show.tests.covering.line", new Object[0]), CoverageBundle.message("action.description.show.tests.covering.line", new Object[0]), PlatformIcons.TEST_SOURCE_FOLDER);
        this.myClassFQName = classFQName;
        this.myLineData = lineData;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowCoveringTestsAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((project = e.getProject()) != null);
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        LOG.assertTrue(editor2 != null);
        CoverageSuitesBundle currentSuite = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
        LOG.assertTrue(currentSuite != null);
        CoverageEngine coverageEngine = currentSuite.getCoverageEngine();
        HashSet tests = new HashSet();
        if (((Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> tests.addAll(coverageEngine.getTestsForLine(project, this.myClassFQName, this.myLineData.getLineNumber())), CoverageBundle.message("extract.information.about.tests", new Object[0]), false, project)).booleanValue()) {
            ComponentPopupBuilder popupBuilder;
            ImplementationViewComponent component2;
            Object[] testNames = ArrayUtilRt.toStringArray(tests);
            Arrays.sort(testNames);
            if (testNames.length == 0) {
                HintManager.getInstance().showErrorHint(editor2, CoverageBundle.message("hint.text.failed.to.load.covered.tests", new Object[0]));
                return;
            }
            List<PsiElement> elements = coverageEngine.findTestsByNames((String[])testNames, project);
            String title2 = CoverageBundle.message("popup.title.tests.covering.line", this.myClassFQName, this.myLineData.getLineNumber());
            if (!elements.isEmpty()) {
                Consumer<ImplementationViewComponent> processor2 = viewComponent -> viewComponent.showInUsageView();
                component2 = new ImplementationViewComponent(ContainerUtil.map(elements, PsiImplementationViewElement::new), 0, processor2);
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component2, component2.getPreferredFocusableComponent()).setDimensionServiceKey(project, "ShowTestsPopup", false);
            } else {
                component2 = null;
                @NonNls String testsPresentation = StringUtil.join((String[])testNames, (String)"<br/>").replace("_", ".");
                PanelWithText panel2 = new PanelWithText(CoverageBundle.message("following.test.could.not.be.found.1", testNames.length, testsPresentation));
                popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, null);
            }
            JBPopup popup2 = popupBuilder.setRequestFocusCondition(project, (Condition)NotLookupOrSearchCondition.INSTANCE).setProject(project).setResizable(true).setMovable(true).setTitle(title2).createPopup();
            popup2.showInBestPositionFor(editor2);
            if (component2 != null) {
                component2.setHint(popup2, title2);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowCoveringTestsAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = e.getPresentation();
        presentation2.setEnabled(false);
        if (this.myLineData != null && this.myLineData.getStatus() != 0 && (project = e.getProject()) != null) {
            CoverageSuitesBundle currentSuitesBundle = CoverageDataManager.getInstance(project).getCurrentSuitesBundle();
            presentation2.setEnabled(currentSuitesBundle != null && currentSuitesBundle.isCoverageByTestEnabled() && currentSuitesBundle.getCoverageEngine().wasTestDataCollected(project));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/coverage/actions/ShowCoveringTestsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

