/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewBuilder;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoverageView
extends BorderLayoutPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String ACTION_DRILL_DOWN = "DrillDown";
    @NonNls
    private static final String ACTION_GO_UP = "GoUp";
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.Coverage";
    private final CoverageTableModel myModel;
    private final JBTable myTable;
    private final CoverageViewBuilder myBuilder;
    private final Project myProject;
    private final CoverageViewManager.StateBean myStateBean;

    public CoverageView(final Project project, CoverageDataManager dataManager, CoverageViewManager.StateBean stateBean) {
        this.myProject = project;
        this.myStateBean = stateBean;
        JLabel titleLabel = new JLabel();
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        CoverageSuitesBundle suitesBundle = dataManager.getCurrentSuitesBundle();
        this.myModel = new CoverageTableModel(suitesBundle, stateBean, project);
        this.myTable = new JBTable((TableModel)this.myModel);
        StatusText emptyText = this.myTable.getEmptyText();
        emptyText.setText(CoverageBundle.message("coverage.view.no.coverage.results", new Object[0]));
        final RunConfigurationBase configuration2 = suitesBundle.getRunConfiguration();
        if (configuration2 != null) {
            emptyText.appendText(" " + CoverageBundle.message("coverage.view.edit.run.configuration.0", new Object[0]) + " ");
            emptyText.appendText(CoverageBundle.message("coverage.view.edit.run.configuration.1", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunnerAndConfigurationSettings configurationSettings = RunManager.getInstance((Project)project).findSettings((RunConfiguration)configuration2);
                    if (configurationSettings != null) {
                        RunDialog.editConfiguration(project, configurationSettings, ExecutionBundle.message((String)"edit.run.configuration.for.item.dialog.title", (Object[])new Object[]{configuration2.getName()}));
                    } else {
                        Messages.showErrorDialog((Project)project, (String)CoverageBundle.message("coverage.view.configuration.was.not.found", configuration2.getName()), (String)CommonBundle.getErrorTitle());
                    }
                }
            });
            emptyText.appendText(" " + CoverageBundle.message("coverage.view.edit.run.configuration.2", new Object[0]));
        }
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn nameColumn = columnModel.getColumn(0);
        nameColumn.setCellRenderer(new NodeDescriptorTableCellRenderer());
        nameColumn.setPreferredWidth(this.myStateBean.myElementSize);
        this.myTable.getTableHeader().setReorderingAllowed(false);
        BorderLayoutPanel centerPanel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)this.myTable)).addToTop((Component)titleLabel);
        this.addToCenter((Component)centerPanel);
        final CoverageViewTreeStructure structure = new CoverageViewTreeStructure(project, suitesBundle, stateBean);
        this.myBuilder = new CoverageViewBuilder(project, (JList)new JBList(), this.myModel, structure, this.myTable);
        this.myBuilder.setParentTitle(titleLabel);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CoverageView.this.drillDown(structure);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/coverage/view/CoverageView$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable);
        TableSpeedSearch speedSearch2 = new TableSpeedSearch((JTable)this.myTable);
        speedSearch2.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installPopupMenu((JComponent)this.myTable, (ActionGroup)CoverageView.createPopupGroup(), (String)"CoverageViewPopup");
        ScrollingUtil.installActions((JTable)this.myTable);
        this.myTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.myBuilder.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_DRILL_DOWN);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), ACTION_DRILL_DOWN);
        this.myTable.getActionMap().put(ACTION_DRILL_DOWN, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.drillDown(structure);
            }
        });
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), ACTION_GO_UP);
        this.myTable.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), ACTION_GO_UP);
        this.myTable.getActionMap().put(ACTION_GO_UP, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageView.this.goUp();
            }
        });
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("CoverageView", this.createToolbarActions(structure, suitesBundle), false);
        actionToolbar.setTargetComponent((JComponent)this.myTable);
        this.addToLeft(actionToolbar.getComponent());
    }

    public void dispose() {
        if (!this.myProject.isDisposed()) {
            CoverageDataManager.getInstance(this.myProject).chooseSuitesBundle(null);
        }
    }

    public void saveSize() {
        this.myStateBean.myElementSize = this.myTable.getColumnModel().getColumn(0).getWidth();
    }

    private static ActionGroup createPopupGroup() {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add(ActionManager.getInstance().getAction("EditSource"));
        return actionGroup2;
    }

    private ActionGroup createToolbarActions(CoverageViewTreeStructure treeStructure, CoverageSuitesBundle suite) {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add((AnAction)new GoUpAction(treeStructure));
        if (treeStructure.supportFlattenPackages()) {
            actionGroup2.add((AnAction)new FlattenPackagesAction());
        }
        this.installAutoScrollToSource(actionGroup2);
        this.installAutoScrollFromSource(actionGroup2);
        actionGroup2.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        CoverageViewExtension viewExtension = suite.getCoverageEngine().createCoverageViewExtension(this.myProject, suite, this.myStateBean);
        List<AnAction> extraActions = viewExtension.createExtraToolbarActions();
        extraActions.forEach(arg_0 -> ((DefaultActionGroup)actionGroup2).add(arg_0));
        return actionGroup2;
    }

    private void installAutoScrollFromSource(DefaultActionGroup actionGroup2) {
        MyAutoScrollFromSourceHandler handler2 = new MyAutoScrollFromSourceHandler();
        handler2.install();
        actionGroup2.add((AnAction)handler2.createToggleAction());
    }

    private void installAutoScrollToSource(DefaultActionGroup actionGroup2) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return CoverageView.this.myStateBean.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state) {
                CoverageView.this.myStateBean.myAutoScrollToSource = state;
            }
        };
        autoScrollToSourceHandler.install((JTable)this.myTable);
        actionGroup2.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    public void goUp() {
        if (this.myBuilder == null) {
            return;
        }
        this.myBuilder.goUp();
    }

    private void drillDown(CoverageViewTreeStructure treeStructure) {
        AbstractTreeNode element2 = this.getSelectedValue();
        if (element2 == null) {
            return;
        }
        ReadAction.nonBlocking(() -> treeStructure.getChildElements(element2)).expireWith((Disposable)this).finishOnUiThread(ModalityState.NON_MODAL, children2 -> {
            if (((Object[])children2).length == 0) {
                if (element2.canNavigate()) {
                    element2.navigate(true);
                }
                return;
            }
            this.myBuilder.drillDown(element2, (Object[])children2);
        }).submit((Executor)AppExecutorUtil.getAppScheduledExecutorService());
    }

    public void updateParentTitle() {
        this.myBuilder.updateParentTitle();
    }

    private AbstractTreeNode getSelectedValue() {
        return (AbstractTreeNode)this.myBuilder.getSelectedValue();
    }

    private boolean topElementIsSelected(CoverageViewTreeStructure treeStructure) {
        if (this.myTable == null) {
            return false;
        }
        if (this.myModel.getSize() >= 1) {
            AbstractTreeNode rootElement = (AbstractTreeNode)treeStructure.getRootElement();
            AbstractTreeNode node2 = (AbstractTreeNode)this.myModel.getElementAt(0);
            if (node2.getParent() == rootElement) {
                return true;
            }
        }
        return false;
    }

    public boolean canSelect(VirtualFile file2) {
        return this.myBuilder.canSelect(file2);
    }

    public void select(VirtualFile file2) {
        this.myBuilder.select(file2);
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CoverageView.$$$reportNull$$$0(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.getSelectedValue();
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/coverage/view/CoverageView", "getData"));
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.myProject, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return CoverageView.this.myStateBean.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state) {
            CoverageView.this.myStateBean.myAutoScrollFromSource = state;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor2) {
            VirtualFile file2;
            if (editor2 == null) {
                MyAutoScrollFromSourceHandler.$$$reportNull$$$0(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (CoverageView.this.myStateBean.myAutoScrollFromSource && (file2 = editor2.getFile()) != null && CoverageView.this.canSelect(file2)) {
                VirtualFile e = null;
                if (editor2 instanceof TextEditor) {
                    int offset = ((TextEditor)editor2).getEditor().getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
                    if (psiFile != null) {
                        e = psiFile.findElementAt(offset);
                    }
                }
                CoverageView.this.myBuilder.select(e != null ? e : file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }

    private class GoUpAction
    extends DumbAwareAction {
        private final CoverageViewTreeStructure myTreeStructure;

        GoUpAction(CoverageViewTreeStructure treeStructure) {
            super(CoverageBundle.message("coverage.view.action.go.up", new Object[0]), CoverageBundle.message("coverage.view.action.go.up.description", new Object[0]), AllIcons.Nodes.UpLevel);
            this.myTreeStructure = treeStructure;
            this.registerCustomShortcutSet(8, 0, (JComponent)CoverageView.this.myTable);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                GoUpAction.$$$reportNull$$$0(0);
            }
            CoverageView.this.goUp();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoUpAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(!CoverageView.this.topElementIsSelected(this.myTreeStructure));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$GoUpAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class FlattenPackagesAction
    extends ToggleAction {
        private FlattenPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.flatten.packages", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.flatten.packages", (Object[])new Object[0]), AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(0);
            }
            return CoverageView.this.myStateBean.myFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                FlattenPackagesAction.$$$reportNull$$$0(1);
            }
            CoverageView.this.myStateBean.myFlattenPackages = state;
            Object selectedValue = CoverageView.this.myBuilder.getSelectedValue();
            CoverageView.this.myBuilder.buildRoot();
            if (selectedValue != null) {
                CoverageView.this.myBuilder.select(((CoverageListNode)((Object)selectedValue)).getValue());
            }
            CoverageView.this.myBuilder.ensureSelectionExist();
            CoverageView.this.myBuilder.updateParentTitle();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NodeDescriptorTableCellRenderer
    extends DefaultTableCellRenderer {
        private NodeDescriptorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
            Component component2 = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row2, column2);
            if (value2 instanceof NodeDescriptor) {
                NodeDescriptor descriptor2 = (NodeDescriptor)value2;
                this.setIcon(descriptor2.getIcon());
                this.setText(descriptor2.toString());
                if (!isSelected) {
                    this.setForeground(((FileStatus)SlowOperations.allowSlowOperations(() -> ((CoverageListNode)descriptor2).getFileStatus())).getColor());
                }
            }
            return component2;
        }
    }
}

