/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageListRootNode;
import com.intellij.coverage.view.CoverageViewExtension;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.ide.commander.AbstractListBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class CoverageViewBuilder
extends AbstractListBuilder {
    private final JBTable myTable;
    private final FileStatusListener myFileStatusListener;
    private final CoverageViewExtension myCoverageViewExtension;

    CoverageViewBuilder(Project project, JList list2, AbstractListBuilder.Model model2, AbstractTreeStructure treeStructure, final JBTable table) {
        super(project, list2, model2, treeStructure, (Comparator)AlphaComparator.INSTANCE, true);
        this.myTable = table;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, CoverageBundle.message("coverage.report.building", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                CoverageViewBuilder.this.buildRoot();
            }

            public void onSuccess() {
                CoverageViewBuilder.this.ensureSelectionExist();
                CoverageViewBuilder.this.updateParentTitle();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/view/CoverageViewBuilder$1", "run"));
            }
        });
        this.myFileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                table.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile2) {
                if (virtualFile2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                table.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/coverage/view/CoverageViewBuilder$2", "fileStatusChanged"));
            }
        };
        this.myCoverageViewExtension = ((CoverageViewTreeStructure)this.myTreeStructure).myData.getCoverageEngine().createCoverageViewExtension(this.myProject, ((CoverageViewTreeStructure)this.myTreeStructure).myData, ((CoverageViewTreeStructure)this.myTreeStructure).myStateBean);
        FileStatusManager.getInstance((Project)this.myProject).addFileStatusListener(this.myFileStatusListener, (Disposable)this);
    }

    @Override
    protected boolean shouldEnterSingleTopLevelElement(Object rootChild) {
        return false;
    }

    @Override
    protected boolean shouldAddTopElement() {
        return false;
    }

    @Override
    protected boolean nodeIsAcceptableForElement(AbstractTreeNode node2, Object element2) {
        return Comparing.equal((Object)node2.getValue(), (Object)element2);
    }

    @Override
    protected List<AbstractTreeNode<?>> getAllAcceptableNodes(Object[] childElements, VirtualFile file2) {
        ArrayList result2 = new ArrayList();
        for (Object childElement1 : childElements) {
            CoverageListNode childElement = (CoverageListNode)((Object)childElement1);
            if (!childElement.contains(file2)) continue;
            result2.add(childElement);
        }
        return result2;
    }

    @Override
    protected void updateParentTitle() {
        if (this.myParentTitle == null) {
            return;
        }
        AbstractTreeNode parentNode = this.getParentNode();
        AbstractTreeNode node2 = parentNode == null ? (AbstractTreeNode)this.myTreeStructure.getRootElement() : parentNode;
        ReadAction.nonBlocking(() -> node2 instanceof CoverageListRootNode ? this.myCoverageViewExtension.getSummaryForRootNode(node2) : this.myCoverageViewExtension.getSummaryForNode(node2)).finishOnUiThread(ModalityState.NON_MODAL, text2 -> this.myParentTitle.setText((String)text2)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    public Object getSelectedValue() {
        int row2 = this.myTable.getSelectedRow();
        if (row2 == -1) {
            return null;
        }
        return this.myModel.getElementAt(this.myTable.convertRowIndexToModel(row2));
    }

    @Override
    protected void ensureSelectionExist() {
        TableUtil.ensureSelectionExists((JTable)this.myTable);
    }

    @Override
    protected void selectItem(int i2) {
        TableUtil.selectRows((JTable)this.myTable, (int[])new int[]{this.myTable.convertRowIndexToView(i2)});
        TableUtil.scrollSelectionToVisible((JTable)this.myTable);
    }

    public boolean canSelect(VirtualFile file2) {
        return this.myCoverageViewExtension.canSelectInCoverageView(file2);
    }

    public void select(Object object) {
        ReadAction.nonBlocking(() -> {
            PsiElement element2 = this.myCoverageViewExtension.getElementToSelect(object);
            VirtualFile file2 = this.myCoverageViewExtension.getVirtualFile(object);
            this.selectElement(element2, file2);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }
}

