/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageView;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public final class SelectInCoverageView
implements SelectInTarget {
    private final Project myProject;

    private SelectInCoverageView(@NotNull Project project) {
        if (project == null) {
            SelectInCoverageView.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public String toString() {
        return CoverageBundle.message("coverage.view.title", new Object[0]);
    }

    public boolean canSelect(SelectInContext context2) {
        CoverageView coverageView;
        CoverageSuitesBundle suitesBundle = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (suitesBundle != null && (coverageView = CoverageViewManager.getInstance(this.myProject).getToolwindow(suitesBundle)) != null) {
            VirtualFile file2 = context2.getVirtualFile();
            return !file2.isDirectory() && coverageView.canSelect(file2);
        }
        return false;
    }

    public void selectIn(SelectInContext context2, boolean requestFocus) {
        CoverageSuitesBundle suitesBundle = CoverageDataManager.getInstance(this.myProject).getCurrentSuitesBundle();
        if (suitesBundle != null) {
            CoverageViewManager coverageViewManager = CoverageViewManager.getInstance(this.myProject);
            CoverageView coverageView = coverageViewManager.getToolwindow(suitesBundle);
            coverageView.select(context2.getVirtualFile());
            coverageViewManager.activateToolwindow(coverageView, requestFocus);
        }
    }

    public String getToolWindowId() {
        return "Coverage";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.5f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/view/SelectInCoverageView", "<init>"));
    }
}

