/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.CredentialStoreUiService;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.kdbx.IncorrectMasterPasswordException;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.MasterKey;
import com.intellij.credentialStore.keePass.MasterKeyFileStorage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.messages.MessagesService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.SecureRandom;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0002J\u001a\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0004J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010!\u001a\u00020\u000e2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014JQ\u0010$\u001a\u00020\u000e2\b\b\u0001\u0010%\u001a\u00020\u00122\n\b\u0003\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010#2%\b\u0001\u0010&\u001a\u001f\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b(\u0012\b\b)\u0012\u0004\b\b(\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00120'H\u0014J\u0006\u0010*\u001a\u00020\u0014J\u000e\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0003J\u0006\u0010-\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "", "file", "Ljava/nio/file/Path;", "masterKeyFile", "masterKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/credentialStore/EncryptionSpec;Lkotlin/Lazy;)V", "masterKeyFileStorage", "Lcom/intellij/credentialStore/keePass/MasterKeyFileStorage;", "askAndSetMasterKey", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "topNote", "", "clear", "", "createMasterKey", "Lcom/intellij/credentialStore/keePass/MasterKey;", "value", "", "isAutoGenerated", "", "doImportOrUseExisting", "doSetNewMasterPassword", "current", "new", "import", "fromFile", "requestCurrentAndNewKeys", "contextComponent", "Ljava/awt/Component;", "requestMasterPassword", "title", "ok", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "saveMasterKeyToApplyNewEncryptionSpec", "setCustomMasterPasswordIfNeeded", "defaultDbFile", "useExisting", "intellij.platform.credentialStore"})
public class KeePassFileManager {
    private final MasterKeyFileStorage masterKeyFileStorage;
    private final Path file;
    private final EncryptionSpec masterKeyEncryptionSpec;
    private final Lazy<SecureRandom> secureRandom;

    public final void clear() {
        block4: {
            if (!PathKt.exists((Path)this.file)) {
                return;
            }
            try {
                byte[] masterPassword = this.masterKeyFileStorage.load();
                if (masterPassword != null) {
                    KeePassDatabase db = KdbxKt.loadKdbx(this.file, KdbxPassword.Companion.createAndClear(masterPassword));
                    KeePassCredentialStore store = new KeePassCredentialStore(this.file, this.masterKeyFileStorage, db);
                    store.clear();
                    store.save(this.masterKeyEncryptionSpec);
                    return;
                }
            }
            catch (Exception e) {
                if (e instanceof IncorrectMasterPasswordException) break block4;
                Application application = ApplicationManager.getApplication();
                if (application == null) break block4;
                if (application.isUnitTestMode()) break block4;
                CredentialStoreKt.getLOG().error((Throwable)e);
            }
        }
        PathKt.delete$default((Path)this.file, (boolean)false, (int)1, null);
    }

    public final void import(@NotNull Path fromFile, @Nullable AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)fromFile, (String)"fromFile");
        if (Intrinsics.areEqual((Object)this.file, (Object)fromFile)) {
            return;
        }
        try {
            this.doImportOrUseExisting(fromFile, event);
        }
        catch (IncorrectMasterPasswordException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            CredentialStoreKt.getLOG().warn((Throwable)e);
            AnActionEvent anActionEvent = event;
            String string = null;
            boolean bl = false;
            String[] stringArray = new String[]{};
            DoNotAskOption doNotAskOption = null;
            int n = 0;
            int n2 = 0;
            Icon icon2 = UIUtil.getErrorIcon();
            String string2 = CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.message", new Object[0]);
            String string3 = CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.title.cannot.import", new Object[0]);
            MessagesService.DefaultImpls.showMessageDialog$default((MessagesService)MessagesService.Companion.getInstance(), null, (Component)(anActionEvent != null ? (Component)anActionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) : null), (String)string2, (String)string3, (String[])stringArray, (int)n2, (int)n, (Icon)icon2, doNotAskOption, (boolean)bl, string, (int)1632, null);
        }
    }

    public final void useExisting() throws IncorrectMasterPasswordException {
        if (PathKt.exists((Path)this.file)) {
            if (!this.doImportOrUseExisting(this.file, null)) {
                throw (Throwable)new IncorrectMasterPasswordException(false, 1, null);
            }
        } else {
            KeePassCredentialStoreKt.saveDatabase(this.file, new KeePassDatabase(null, 1, null), KeePassCredentialStoreKt.generateRandomMasterKey(this.masterKeyEncryptionSpec, (SecureRandom)this.secureRandom.getValue()), this.masterKeyFileStorage, (SecureRandom)this.secureRandom.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean doImportOrUseExisting(Path file2, AnActionEvent event) {
        void masterPassword;
        AnActionEvent anActionEvent = event;
        Component contextComponent = anActionEvent != null ? (Component)anActionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) : null;
        Path possibleMasterKeyFile = file2.getParent().resolve("c.pwd");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Path path2 = possibleMasterKeyFile;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"possibleMasterKeyFile");
        objectRef.element = new MasterKeyFileStorage(path2).load();
        if ((byte[])masterPassword.element != null) {
            try {
                KdbxKt.loadKdbx(file2, new KdbxPassword((byte[])masterPassword.element));
            }
            catch (IncorrectMasterPasswordException e) {
                CredentialStoreKt.getLOG().warn("On import \"" + file2 + "\" found existing master key file \"" + possibleMasterKeyFile + "\" but key is not correct");
                masterPassword.element = null;
            }
        }
        if ((byte[])masterPassword.element == null && !KeePassFileManager.requestMasterPassword$default(this, CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.request.master.title", new Object[0]), null, contextComponent, (Function1)new Function1<byte[], String>(file2, (Ref.ObjectRef)masterPassword){
            final /* synthetic */ Path $file;
            final /* synthetic */ Ref.ObjectRef $masterPassword;

            @Nullable
            public final String invoke(@NotNull byte[] it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    KdbxKt.loadKdbx(this.$file, new KdbxPassword(it));
                    this.$masterPassword.element = it;
                    string = null;
                }
                catch (IncorrectMasterPasswordException e) {
                    string = CredentialStoreBundle.INSTANCE.message("dialog.message.master.password.not.correct", new Object[0]);
                }
                return string;
            }
            {
                this.$file = path2;
                this.$masterPassword = objectRef;
                super(1);
            }
        }, 2, null)) {
            return false;
        }
        if (file2 != this.file) {
            Files.copy(file2, this.file, StandardCopyOption.REPLACE_EXISTING);
        }
        byte[] byArray = (byte[])masterPassword.element;
        Intrinsics.checkNotNull((Object)byArray);
        this.masterKeyFileStorage.save(KeePassFileManager.createMasterKey$default(this, byArray, false, 2, null));
        return true;
    }

    public final boolean askAndSetMasterKey(@Nullable AnActionEvent event, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String topNote) {
        KeePassDatabase keePassDatabase;
        AnActionEvent anActionEvent = event;
        Component contextComponent = anActionEvent != null ? (Component)anActionEvent.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT) : null;
        try {
            KeePassDatabase keePassDatabase2;
            if (PathKt.exists((Path)this.file)) {
                byte[] byArray = this.masterKeyFileStorage.load();
                if (byArray == null) {
                    throw (Throwable)new IncorrectMasterPasswordException(true);
                }
                keePassDatabase2 = KdbxKt.loadKdbx(this.file, new KdbxPassword(byArray));
            } else {
                keePassDatabase2 = new KeePassDatabase(null, 1, null);
            }
            keePassDatabase = keePassDatabase2;
        }
        catch (IncorrectMasterPasswordException e) {
            return this.requestCurrentAndNewKeys(contextComponent);
        }
        KeePassDatabase db = keePassDatabase;
        return this.requestMasterPassword(CredentialStoreBundle.INSTANCE.message("kee.pass.dialog.title.set.master.password", new Object[0]), topNote, contextComponent, (Function1<? super byte[], String>)((Function1)new Function1<byte[], String>(this, db){
            final /* synthetic */ KeePassFileManager this$0;
            final /* synthetic */ KeePassDatabase $db;

            @Nullable
            public final String invoke(@NotNull byte[] it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KeePassCredentialStoreKt.saveDatabase(KeePassFileManager.access$getFile$p(this.this$0), this.$db, KeePassFileManager.createMasterKey$default(this.this$0, it, false, 2, null), KeePassFileManager.access$getMasterKeyFileStorage$p(this.this$0), (SecureRandom)KeePassFileManager.access$getSecureRandom$p(this.this$0).getValue());
                return null;
            }
            {
                this.this$0 = keePassFileManager;
                this.$db = keePassDatabase;
                super(1);
            }
        }));
    }

    public static /* synthetic */ boolean askAndSetMasterKey$default(KeePassFileManager keePassFileManager, AnActionEvent anActionEvent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: askAndSetMasterKey");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return keePassFileManager.askAndSetMasterKey(anActionEvent, string);
    }

    protected boolean requestCurrentAndNewKeys(@Nullable Component contextComponent) {
        return CredentialStoreUiService.Companion.getInstance().showChangeMasterPasswordDialog(contextComponent, (Function2<? super char[], ? super char[], Boolean>)((Function2)new Function2<char[], char[], Boolean>(this){

            public final boolean invoke(@NotNull char[] p1, @NotNull char[] p2) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                return ((KeePassFileManager)this.receiver).doSetNewMasterPassword(p1, p2);
            }
        }));
    }

    protected final boolean doSetNewMasterPassword(@NotNull char[] current2, @NotNull char[] cArray) {
        Intrinsics.checkNotNullParameter((Object)current2, (String)"current");
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"new");
        KeePassDatabase db = KdbxKt.loadKdbx(this.file, KdbxPassword.Companion.createAndClear(EncryptionSupportKt.toByteArrayAndClear(current2)));
        KeePassCredentialStoreKt.saveDatabase(this.file, db, this.createMasterKey(cArray), this.masterKeyFileStorage, (SecureRandom)this.secureRandom.getValue());
        return false;
    }

    private final MasterKey createMasterKey(char[] value2) {
        return KeePassFileManager.createMasterKey$default(this, EncryptionSupportKt.toByteArrayAndClear(value2), false, 2, null);
    }

    private final MasterKey createMasterKey(byte[] value2, boolean isAutoGenerated) {
        return new MasterKey(value2, isAutoGenerated, this.masterKeyEncryptionSpec);
    }

    static /* synthetic */ MasterKey createMasterKey$default(KeePassFileManager keePassFileManager, byte[] byArray, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createMasterKey");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return keePassFileManager.createMasterKey(byArray, bl);
    }

    protected boolean requestMasterPassword(@NlsContexts.DialogTitle @NotNull String title2, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String topNote, @Nullable Component contextComponent, @NlsContexts.DialogMessage @NotNull Function1<? super byte[], String> ok) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter(ok, (String)"ok");
        return CredentialStoreUiService.Companion.getInstance().showRequestMasterPasswordDialog(title2, topNote, contextComponent, ok);
    }

    public static /* synthetic */ boolean requestMasterPassword$default(KeePassFileManager keePassFileManager, String string, String string2, Component component2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestMasterPassword");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            component2 = null;
        }
        return keePassFileManager.requestMasterPassword(string, string2, component2, (Function1<? super byte[], String>)function1);
    }

    public final void saveMasterKeyToApplyNewEncryptionSpec() {
        byte[] byArray = this.masterKeyFileStorage.load();
        if (byArray == null) {
            return;
        }
        byte[] existing = byArray;
        this.masterKeyFileStorage.save(this.createMasterKey(existing, this.masterKeyFileStorage.isAutoGenerated()));
    }

    public final void setCustomMasterPasswordIfNeeded(@NotNull Path defaultDbFile) {
        Intrinsics.checkNotNullParameter((Object)defaultDbFile, (String)"defaultDbFile");
        if (Intrinsics.areEqual((Object)this.file, (Object)defaultDbFile)) {
            return;
        }
        if (!this.masterKeyFileStorage.isAutoGenerated()) {
            return;
        }
        this.askAndSetMasterKey(null, CredentialStoreBundle.INSTANCE.message("kee.pass.top.note", new Object[0]));
    }

    public KeePassFileManager(@NotNull Path file2, @NotNull Path masterKeyFile, @NotNull EncryptionSpec masterKeyEncryptionSpec, @NotNull Lazy<? extends SecureRandom> secureRandom2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)masterKeyFile, (String)"masterKeyFile");
        Intrinsics.checkNotNullParameter((Object)masterKeyEncryptionSpec, (String)"masterKeyEncryptionSpec");
        Intrinsics.checkNotNullParameter(secureRandom2, (String)"secureRandom");
        this.file = file2;
        this.masterKeyEncryptionSpec = masterKeyEncryptionSpec;
        this.secureRandom = secureRandom2;
        this.masterKeyFileStorage = new MasterKeyFileStorage(masterKeyFile);
    }

    public static final /* synthetic */ Path access$getFile$p(KeePassFileManager $this) {
        return $this.file;
    }

    public static final /* synthetic */ MasterKeyFileStorage access$getMasterKeyFileStorage$p(KeePassFileManager $this) {
        return $this.masterKeyFileStorage;
    }

    public static final /* synthetic */ Lazy access$getSecureRandom$p(KeePassFileManager $this) {
        return $this.secureRandom;
    }
}

