/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diagnostic/GcPauseWatcher;", "", "()V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "watchers", "", "Lcom/intellij/diagnostic/GcPauseWatcher$SingleCollectorWatcher;", "checkForPauses", "", "recordGcPauseTime", "name", "", "currPauseDuration", "", "Companion", "SingleCollectorWatcher", "intellij.platform.ide.impl"})
public class GcPauseWatcher {
    private final List<SingleCollectorWatcher> watchers;
    private final AtomicInteger counter;
    private static final long SAMPLING_RATE_MS = 50L;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    protected void recordGcPauseTime(@NotNull String name2, long currPauseDuration) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        if (StartUpMeasurer.isEnabled()) {
            StartUpMeasurer.addCompletedActivity((long)(StartUpMeasurer.getCurrentTime() - TimeUnit.MILLISECONDS.toNanos(currPauseDuration)), (String)Integer.toString(this.counter.incrementAndGet()), (ActivityCategory)ActivityCategory.GC, null);
        }
    }

    private final void checkForPauses() {
        Iterable $this$forEach$iv = this.watchers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleCollectorWatcher it = (SingleCollectorWatcher)element$iv;
            boolean bl = false;
            it.update();
        }
    }

    /*
     * WARNING - void declaration
     */
    public GcPauseWatcher() {
        Collection<SingleCollectorWatcher> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ManagementFactory.getGarbageCollectorMXBeans()");
        Iterable iterable = list2;
        GcPauseWatcher gcPauseWatcher = this;
        GcPauseWatcher gcPauseWatcher2 = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            GarbageCollectorMXBean garbageCollectorMXBean = (GarbageCollectorMXBean)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            SingleCollectorWatcher singleCollectorWatcher = gcPauseWatcher.new SingleCollectorWatcher((GarbageCollectorMXBean)p1);
            collection.add(singleCollectorWatcher);
        }
        collection = (List)destination$iv$iv;
        gcPauseWatcher2.watchers = collection;
        this.counter = new AtomicInteger();
        iterable = (Function0)new Function0<Unit>(this){

            public final void invoke() {
                ((GcPauseWatcher)this.receiver).checkForPauses();
            }
        };
        AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(new Runnable((Function0)iterable){
            private final /* synthetic */ Function0 function;
            {
                this.function = function0;
            }

            public final /* synthetic */ void run() {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
            }
        }, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(GcPauseWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(GcPauseWatcher::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/diagnostic/GcPauseWatcher$SingleCollectorWatcher;", "", "bean", "Ljava/lang/management/GarbageCollectorMXBean;", "(Lcom/intellij/diagnostic/GcPauseWatcher;Ljava/lang/management/GarbageCollectorMXBean;)V", "getBean", "()Ljava/lang/management/GarbageCollectorMXBean;", "count", "", "cumulativePauseTime", "update", "", "intellij.platform.ide.impl"})
    private final class SingleCollectorWatcher {
        private long count;
        private long cumulativePauseTime;
        @NotNull
        private final GarbageCollectorMXBean bean;

        public final void update() {
            long newCount = this.bean.getCollectionCount();
            long newPauseTime = this.bean.getCollectionTime();
            long currPauseDuration = newPauseTime - this.cumulativePauseTime;
            if (newCount - this.count > 0L && currPauseDuration > 0L) {
                String string = this.bean.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bean.name");
                GcPauseWatcher.this.recordGcPauseTime(string, currPauseDuration);
            }
            this.count = newCount;
            this.cumulativePauseTime = newPauseTime;
        }

        @NotNull
        public final GarbageCollectorMXBean getBean() {
            return this.bean;
        }

        public SingleCollectorWatcher(GarbageCollectorMXBean bean) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            this.bean = bean;
            this.count = this.bean.getCollectionCount();
            this.cumulativePauseTime = this.bean.getCollectionTime();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/GcPauseWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SAMPLING_RATE_MS", "", "getInstance", "Lcom/intellij/diagnostic/GcPauseWatcher;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final GcPauseWatcher getInstance() {
            Object object = ApplicationManager.getApplication().getService(GcPauseWatcher.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026PauseWatcher::class.java)");
            return (GcPauseWatcher)object;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

