/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.google.gson.stream.JsonWriter;
import com.intellij.diagnostic.HeapDumpAnalysisSupport;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.diagnostic.LogMessage;
import com.intellij.diagnostic.hprof.action.AnalysisRunnableKt;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diagnostic/HeapDumpAnalysisSupport;", "", "()V", "analysisComplete", "", "heapProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "analysisFailed", "checkPendingSnapshot", "", "getPrivacyPolicyUrl", "", "saveSnapshotForAnalysis", "hprofPath", "Ljava/nio/file/Path;", "reportProperties", "uploadReport", "reportText", "heapReportProperties", "parentComponent", "Ljava/awt/Component;", "Companion", "intellij.platform.ide.impl"})
public class HeapDumpAnalysisSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getPrivacyPolicyUrl() {
        return "https://www.jetbrains.com/company/privacy.html";
    }

    public void uploadReport(@NotNull String reportText, @NotNull HeapReportProperties heapReportProperties, @NotNull Component parentComponent) {
        Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
        Intrinsics.checkNotNullParameter((Object)heapReportProperties, (String)"heapReportProperties");
        Intrinsics.checkNotNullParameter((Object)parentComponent, (String)"parentComponent");
        String text2 = AnalysisRunnableKt.getHeapDumpReportText(reportText, heapReportProperties);
        Attachment attachment = new Attachment("report.txt", text2);
        attachment.setIncluded(true);
        IdeaLoggingEvent loggingEvent = LogMessage.createEvent(new OutOfMemoryError(), "Heap analysis results", attachment);
        ITNReporter iTNReporter = new ITNReporter();
        IdeaLoggingEvent[] ideaLoggingEventArray = new IdeaLoggingEvent[1];
        IdeaLoggingEvent ideaLoggingEvent = loggingEvent;
        Intrinsics.checkNotNullExpressionValue((Object)ideaLoggingEvent, (String)"loggingEvent");
        ideaLoggingEventArray[0] = ideaLoggingEvent;
        iTNReporter.submit(ideaLoggingEventArray, null, parentComponent, (Consumer<? super SubmittedReportInfo>)((Consumer)uploadReport.1.INSTANCE));
    }

    public boolean checkPendingSnapshot() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSnapshotForAnalysis(@NotNull Path hprofPath, @NotNull HeapReportProperties reportProperties) {
        Intrinsics.checkNotNullParameter((Object)hprofPath, (String)"hprofPath");
        Intrinsics.checkNotNullParameter((Object)reportProperties, (String)"reportProperties");
        File jsonPath = new File(PathManager.getSystemPath(), "pending-snapshot.json");
        Closeable closeable = (Closeable)new JsonWriter((Writer)new OutputStreamWriter(new FileOutputStream(jsonPath)));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            JsonWriter it = (JsonWriter)closeable;
            boolean bl3 = false;
            it.beginObject();
            it.name("path").value(((Object)hprofPath).toString());
            it.name("reason").value(reportProperties.getReason().toString());
            it.name("liveStats").value(reportProperties.getLiveStats());
            JsonWriter jsonWriter = it.endObject();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public void analysisFailed(@NotNull HeapReportProperties heapProperties) {
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
    }

    public void analysisComplete(@NotNull HeapReportProperties heapProperties) {
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/diagnostic/HeapDumpAnalysisSupport$Companion;", "", "()V", "getInstance", "Lcom/intellij/diagnostic/HeapDumpAnalysisSupport;", "intellij.platform.ide.impl"})
    public static final class Companion {
        @NotNull
        public final HeapDumpAnalysisSupport getInstance() {
            boolean $i$f$service = false;
            Class<HeapDumpAnalysisSupport> serviceClass$iv = HeapDumpAnalysisSupport.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            return (HeapDumpAnalysisSupport)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

