/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerformanceWatcher
implements Disposable {
    public static final String DUMP_PREFIX = "threadDump-";
    @Nullable
    protected static PerformanceWatcher ourInstance = (PerformanceWatcher)CachedSingletonsRegistry.markCachedField(PerformanceWatcher.class);

    @ApiStatus.Internal
    @Nullable
    public static PerformanceWatcher getInstanceOrNull() {
        Application app2;
        PerformanceWatcher watcher = ourInstance;
        if (watcher == null && LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && (app2 = ApplicationManager.getApplication()) != null) {
            watcher = (PerformanceWatcher)app2.getServiceIfCreated(PerformanceWatcher.class);
        }
        return watcher;
    }

    @NotNull
    public static PerformanceWatcher getInstance() {
        LoadingState.CONFIGURATION_STORE_INITIALIZED.checkOccurred();
        PerformanceWatcher performanceWatcher = ourInstance != null ? ourInstance : (PerformanceWatcher)ApplicationManager.getApplication().getService(PerformanceWatcher.class);
        if (performanceWatcher == null) {
            PerformanceWatcher.$$$reportNull$$$0(0);
        }
        return performanceWatcher;
    }

    public abstract ScheduledExecutorService getExecutor();

    @NotNull
    public static Snapshot takeSnapshot() {
        Snapshot snapshot = PerformanceWatcher.getInstance().newSnapshot();
        if (snapshot == null) {
            PerformanceWatcher.$$$reportNull$$$0(1);
        }
        return snapshot;
    }

    protected abstract Snapshot newSnapshot();

    public abstract void processUnfinishedFreeze(@NotNull BiConsumer<? super File, ? super Integer> var1);

    public abstract int getDumpInterval();

    public abstract int getUnresponsiveInterval();

    public abstract int getMaxDumpDuration();

    @Nullable
    public abstract String getJitProblem();

    public abstract void clearFreezeStacktraces();

    @ApiStatus.Internal
    public abstract void edtEventStarted();

    @ApiStatus.Internal
    public abstract void edtEventFinished();

    @Nullable
    public abstract File dumpThreads(@NotNull String var1, boolean var2);

    @NotNull
    public static String printStacktrace(@NotNull String headerMsg, @NotNull Thread thread, StackTraceElement @NotNull [] stackTrace) {
        if (headerMsg == null) {
            PerformanceWatcher.$$$reportNull$$$0(2);
        }
        if (thread == null) {
            PerformanceWatcher.$$$reportNull$$$0(3);
        }
        if (stackTrace == null) {
            PerformanceWatcher.$$$reportNull$$$0(4);
        }
        StringBuilder trace = new StringBuilder(headerMsg + thread + " (" + (thread.isAlive() ? "alive" : "dead") + ") " + thread.getState() + "\n--- its stacktrace:\n");
        for (StackTraceElement stackTraceElement : stackTrace) {
            trace.append(" at ").append(stackTraceElement).append("\n");
        }
        trace.append("---\n");
        String string = trace.toString();
        if (string == null) {
            PerformanceWatcher.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void dumpThreadsToConsole(@NonNls String message2) {
        System.err.println(message2);
        System.err.println(ThreadDumper.dumpThreadsToString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerMsg";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackTrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "takeSnapshot";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/PerformanceWatcher";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "printStacktrace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "printStacktrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Snapshot {
        public void logResponsivenessSinceCreation(@NonNls @NotNull String var1);

        public String getLogResponsivenessSinceCreationMessage(@NonNls @NotNull String var1);
    }
}

