/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.SmartList;
import com.intellij.util.system.CpuArch;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class VMOptions {
    private static final Logger LOG = Logger.getInstance(VMOptions.class);
    private static final ReadWriteLock ourUserFileLock = new ReentrantReadWriteLock();

    public static int readOption(@NotNull MemoryKind kind, boolean effective) {
        String strValue;
        if (kind == null) {
            VMOptions.$$$reportNull$$$0(0);
        }
        if ((strValue = VMOptions.readOption(kind.option, effective)) != null) {
            try {
                return (int)(VMOptions.parseMemoryOption(strValue) >> 20);
            }
            catch (IllegalArgumentException e) {
                LOG.info((Throwable)e);
            }
        }
        return -1;
    }

    @Nullable
    public static String readOption(@NotNull String prefix, boolean effective) {
        if (prefix == null) {
            VMOptions.$$$reportNull$$$0(1);
        }
        List<String> lines2 = VMOptions.options(effective);
        for (int i2 = lines2.size() - 1; i2 >= 0; --i2) {
            String line = lines2.get(i2).trim();
            if (!line.startsWith(prefix)) continue;
            return line.substring(prefix.length());
        }
        return null;
    }

    @NotNull
    public static List<String> readOptions(@NotNull String prefix, boolean effective) {
        if (prefix == null) {
            VMOptions.$$$reportNull$$$0(2);
        }
        List<String> lines2 = VMOptions.options(effective);
        SmartList values2 = new SmartList();
        for (String s : lines2) {
            String line = s.trim();
            if (!line.startsWith(prefix)) continue;
            values2.add(line.substring(prefix.length()));
        }
        SmartList smartList = values2;
        if (smartList == null) {
            VMOptions.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> options(boolean effective) {
        Path userFile;
        if (effective) {
            return ManagementFactory.getRuntimeMXBean().getInputArguments();
        }
        List<Object> platformOptions = List.of();
        List<Object> userOptions = List.of();
        Path platformFile = VMOptions.getPlatformOptionsFile();
        if (Files.exists(platformFile, new LinkOption[0])) {
            try {
                platformOptions = Files.readAllLines(platformFile, VMOptions.getFileCharset());
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        if ((userFile = VMOptions.getUserOptionsFile()) != null && Files.exists(userFile, new LinkOption[0])) {
            ourUserFileLock.readLock().lock();
            try {
                userOptions = Files.readAllLines(userFile, VMOptions.getFileCharset());
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            finally {
                ourUserFileLock.readLock().unlock();
            }
        }
        ArrayList<String> result2 = new ArrayList<String>(platformOptions.size() + userOptions.size());
        result2.addAll(platformOptions);
        result2.addAll(userOptions);
        return result2;
    }

    public static long parseMemoryOption(@NotNull String strValue) throws IllegalArgumentException {
        int p;
        if (strValue == null) {
            VMOptions.$$$reportNull$$$0(4);
        }
        for (p = 0; p < strValue.length() && StringUtil.isDecimalDigit((char)strValue.charAt(p)); ++p) {
        }
        long numValue = Long.parseLong(strValue.substring(0, p));
        if (p < strValue.length()) {
            String unit = strValue.substring(p);
            if ("k".equalsIgnoreCase(unit)) {
                numValue <<= 10;
            } else if ("m".equalsIgnoreCase(unit)) {
                numValue <<= 20;
            } else if ("g".equalsIgnoreCase(unit)) {
                numValue <<= 30;
            } else {
                throw new IllegalArgumentException("Invalid unit: " + unit);
            }
        }
        return numValue;
    }

    public static void setOption(@NotNull MemoryKind option2, int value2) throws IOException {
        if (option2 == null) {
            VMOptions.$$$reportNull$$$0(5);
        }
        VMOptions.setOption(option2.option, value2 > 0 ? value2 + "m" : null);
    }

    public static void setProperty(@NotNull String name2, @Nullable String newValue2) throws IOException {
        if (name2 == null) {
            VMOptions.$$$reportNull$$$0(6);
        }
        VMOptions.setOption("-D" + name2 + "=", newValue2);
    }

    public static void setOption(@NotNull String prefix, @Nullable String newValue2) throws IOException {
        if (prefix == null) {
            VMOptions.$$$reportNull$$$0(7);
        }
        VMOptions.setOptions(List.of(Pair.pair((Object)prefix, (Object)newValue2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOptions(@NotNull @NotNull List<Pair<@NotNull String, @Nullable String>> _options) throws IOException {
        Path file2;
        if (_options == null) {
            VMOptions.$$$reportNull$$$0(8);
        }
        if ((file2 = VMOptions.getUserOptionsFile()) == null) {
            throw new IOException("The IDE is not configured for using custom VM options (jb.vmOptionsFile=" + System.getProperty("jb.vmOptionsFile") + ")");
        }
        ArrayList<String> lines2 = Files.exists(file2, new LinkOption[0]) ? new ArrayList<String>(Files.readAllLines(file2, VMOptions.getFileCharset())) : new ArrayList();
        ArrayList<Pair<String, @Nullable String>> options2 = new ArrayList<Pair<String, String>>(_options);
        boolean modified = false;
        ListIterator<CallSite> il = lines2.listIterator(lines2.size());
        block3: while (il.hasPrevious()) {
            String string = ((String)il.previous()).trim();
            Iterator io = options2.iterator();
            while (io.hasNext()) {
                Pair option2 = (Pair)io.next();
                if (!string.startsWith((String)option2.first)) continue;
                if (option2.second == null) {
                    il.remove();
                    modified = true;
                    continue block3;
                }
                String newLine = (String)option2.first + (String)option2.second;
                if (!newLine.equals(string)) {
                    il.set((CallSite)((Object)newLine));
                    modified = true;
                }
                io.remove();
                continue block3;
            }
        }
        for (Pair pair : options2) {
            if (pair.second == null) continue;
            lines2.add((String)pair.first + (String)pair.second);
            modified = true;
        }
        if (modified) {
            NioFiles.createDirectories((Path)file2.getParent());
            ourUserFileLock.writeLock().lock();
            try {
                Files.write(file2, lines2, VMOptions.getFileCharset(), new OpenOption[0]);
            }
            finally {
                ourUserFileLock.writeLock().unlock();
            }
        }
    }

    public static boolean canWriteOptions() {
        return VMOptions.getUserOptionsFile() != null;
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getPlatformOptionsFile() {
        Path path2 = Path.of(PathManager.getBinPath(), VMOptions.getFileName());
        if (path2 == null) {
            VMOptions.$$$reportNull$$$0(9);
        }
        return path2;
    }

    @ApiStatus.Internal
    @Nullable
    public static Path getUserOptionsFile() {
        String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
        if (vmOptionsFile == null) {
            return null;
        }
        Path candidate = Path.of(vmOptionsFile, new String[0]).toAbsolutePath();
        if (!PathManager.isUnderHomeDirectory((Path)candidate)) {
            return candidate;
        }
        String location = PathManager.getCustomOptionsDirectory();
        if (location == null) {
            return null;
        }
        return Path.of(location, VMOptions.getFileName());
    }

    @ApiStatus.Internal
    @NotNull
    public static String getFileName() {
        Object fileName = ApplicationNamesInfo.getInstance().getScriptName();
        if (!SystemInfo.isMac && CpuArch.isIntel64()) {
            fileName = (String)fileName + "64";
        }
        if (SystemInfo.isWindows) {
            fileName = (String)fileName + ".exe";
        }
        Object object = fileName = (String)fileName + ".vmoptions";
        if (object == null) {
            VMOptions.$$$reportNull$$$0(10);
        }
        return object;
    }

    @ApiStatus.Internal
    @NotNull
    public static Charset getFileCharset() {
        Charset charset = CharsetToolkit.getPlatformCharset();
        if (charset == null) {
            VMOptions.$$$reportNull$$$0(11);
        }
        return charset;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public static void writeOption(@NotNull MemoryKind option2, int value2) {
        if (option2 == null) {
            VMOptions.$$$reportNull$$$0(12);
        }
        try {
            VMOptions.setOption(option2.option, value2 + "m");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    public static void writeOption(@NotNull String option2, @NotNull String separator2, @NotNull String value2) {
        if (option2 == null) {
            VMOptions.$$$reportNull$$$0(13);
        }
        if (separator2 == null) {
            VMOptions.$$$reportNull$$$0(14);
        }
        if (value2 == null) {
            VMOptions.$$$reportNull$$$0(15);
        }
        try {
            VMOptions.setOption("-D" + option2 + separator2, value2);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    @Nullable
    public static String read() {
        try {
            Path newFile = VMOptions.getUserOptionsFile();
            if (newFile != null && Files.exists(newFile, new LinkOption[0])) {
                return Files.readString(newFile, VMOptions.getFileCharset());
            }
            String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
            if (vmOptionsFile != null) {
                return Files.readString(Path.of(vmOptionsFile, new String[0]), VMOptions.getFileCharset());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    @Nullable
    public static Path getWriteFile() {
        return VMOptions.getUserOptionsFile();
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="2022.3")
    @NotNull
    public static String getCustomVMOptionsFileName() {
        return VMOptions.getFileName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/VMOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strValue";
                break;
            }
            case 5: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_options";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/VMOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readOptions";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformOptionsFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileCharset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readOptions";
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseMemoryOption";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setOptions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum MemoryKind {
        HEAP("Xmx", "", "change.memory.max.heap"),
        MIN_HEAP("Xms", "", "change.memory.min.heap"),
        METASPACE("XX:MaxMetaspaceSize", "=", "change.memory.metaspace"),
        CODE_CACHE("XX:ReservedCodeCacheSize", "=", "change.memory.code.cache");

        @NlsSafe
        public final String optionName;
        public final String option;
        private final String labelKey;

        private MemoryKind(@PropertyKey(resourceBundle="messages.IdeCoreBundle") @PropertyKey(resourceBundle="messages.IdeCoreBundle") String name2, String separator2, String key) {
            this.optionName = name2;
            this.option = "-" + name2 + separator2;
            this.labelKey = key;
        }

        @NlsContexts.Label
        public String label() {
            return IdeCoreBundle.message((String)this.labelKey, (Object[])new Object[0]);
        }
    }
}

