/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.action;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.HeapDumpAnalysisSupport;
import com.intellij.diagnostic.hprof.action.AnalysisRunnable;
import com.intellij.diagnostic.hprof.action.ShowReportDialog;
import com.intellij.diagnostic.hprof.action.SystemTempFilenameSupplier;
import com.intellij.diagnostic.hprof.analysis.AnalysisContext;
import com.intellij.diagnostic.hprof.analysis.HProfAnalysis;
import com.intellij.diagnostic.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.intellij.diagnostic.report.HeapReportProperties;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ui.UIUtil;
import java.io.Closeable;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0003\u000f\u0010\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable;", "Ljava/lang/Runnable;", "hprofPath", "Ljava/nio/file/Path;", "heapProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "deleteAfterAnalysis", "", "(Ljava/nio/file/Path;Lcom/intellij/diagnostic/report/HeapReportProperties;Z)V", "getHeapProperties", "()Lcom/intellij/diagnostic/report/HeapReportProperties;", "getHprofPath", "()Ljava/nio/file/Path;", "run", "", "AnalysisTask", "Companion", "ReviewReportAction", "intellij.platform.ide.impl"})
public final class AnalysisRunnable
implements Runnable {
    @NotNull
    private final Path hprofPath;
    @NotNull
    private final HeapReportProperties heapProperties;
    private final boolean deleteAfterAnalysis;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    public void run() {
        new AnalysisTask().queue();
    }

    @NotNull
    public final Path getHprofPath() {
        return this.hprofPath;
    }

    @NotNull
    public final HeapReportProperties getHeapProperties() {
        return this.heapProperties;
    }

    public AnalysisRunnable(@NotNull Path hprofPath, @NotNull HeapReportProperties heapProperties, boolean deleteAfterAnalysis) {
        Intrinsics.checkNotNullParameter((Object)hprofPath, (String)"hprofPath");
        Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
        this.hprofPath = hprofPath;
        this.heapProperties = heapProperties;
        this.deleteAfterAnalysis = deleteAfterAnalysis;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(AnalysisRunnable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(AnalysisRunnable::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable$AnalysisTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "(Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable;)V", "deleteHprofFileAsync", "", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.impl"})
    public final class AnalysisTask
    extends Task.Backgroundable {
        public void onThrowable(@NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            LOG.error(error);
            HeapDumpAnalysisSupport.Companion.getInstance().analysisFailed(AnalysisRunnable.this.getHeapProperties());
            String string = DiagnosticBundle.message("heap.dump.analysis.exception", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DiagnosticBundle.message\u2026dump.analysis.exception\")");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string, NotificationType.INFORMATION);
            if (ShowLogAction.isSupported()) {
                notification.addAction((AnAction)ShowLogAction.notificationAction());
            }
            notification.notify(null);
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
        }

        private final void deleteHprofFileAsync() {
            CompletableFuture.runAsync(new Runnable(this){
                final /* synthetic */ AnalysisTask this$0;

                public final void run() {
                    Files.deleteIfExists(this.this$0.AnalysisRunnable.this.getHprofPath());
                }
                {
                    this.this$0 = analysisTask;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
            indicator2.setIndeterminate(false);
            indicator2.setText(DiagnosticBundle.message("heap.dump.analysis.indicator.title", new Object[0]));
            indicator2.setFraction(0.0);
            Set openOptions = null;
            openOptions = AnalysisRunnable.this.deleteAfterAnalysis ? SetsKt.setOf((Object[])new StandardOpenOption[]{StandardOpenOption.READ, StandardOpenOption.DELETE_ON_CLOSE}) : SetsKt.setOf((Object)StandardOpenOption.READ);
            Closeable closeable = FileChannel.open(AnalysisRunnable.this.getHprofPath(), openOptions, new FileAttribute[0]);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileChannel channel2 = (FileChannel)closeable;
                boolean bl3 = false;
                FileChannel fileChannel = channel2;
                Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"channel");
                string = new HProfAnalysis(fileChannel, new SystemTempFilenameSupplier(), (Function2<? super AnalysisContext, ? super ProgressIndicator, String>)((Function2)run.reportString.1.1.INSTANCE)).analyze(indicator2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String reportString2 = string;
            if (AnalysisRunnable.this.deleteAfterAnalysis) {
                this.deleteHprofFileAsync();
            }
            String string2 = DiagnosticBundle.message("heap.dump.analysis.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DiagnosticBundle.message\u2026ysis.notification.title\")");
            String string3 = DiagnosticBundle.message("heap.dump.analysis.notification.ready.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DiagnosticBundle.message\u2026ification.ready.content\")");
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(string2, string3, NotificationType.INFORMATION);
            notification.setImportant(true);
            notification.addAction((AnAction)new ReviewReportAction(reportString2, AnalysisRunnable.this.getHeapProperties()));
            notification.notify(null);
        }

        public AnalysisTask() {
            super(null, DiagnosticBundle.message("heap.dump.analysis.task.title", new Object[0]), false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable$ReviewReportAction;", "Lcom/intellij/notification/NotificationAction;", "reportText", "", "heapProperties", "Lcom/intellij/diagnostic/report/HeapReportProperties;", "(Ljava/lang/String;Lcom/intellij/diagnostic/report/HeapReportProperties;)V", "reportShown", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notification", "Lcom/intellij/notification/Notification;", "intellij.platform.ide.impl"})
    public static final class ReviewReportAction
    extends NotificationAction {
        private boolean reportShown;
        private final String reportText;
        private final HeapReportProperties heapProperties;

        public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
            JFrame jFrame = WindowManager.getInstance().getFrame(e.getProject());
            if (jFrame == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)jFrame, (String)"WindowManager.getInstanc\u2026rame(e.project) ?: return");
            JFrame parentComponent = jFrame;
            if (this.reportShown) {
                return;
            }
            this.reportShown = true;
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, notification, parentComponent){
                final /* synthetic */ ReviewReportAction this$0;
                final /* synthetic */ Notification $notification;
                final /* synthetic */ JFrame $parentComponent;

                public final void run() {
                    this.$notification.expire();
                    ShowReportDialog reportDialog = new ShowReportDialog(ReviewReportAction.access$getReportText$p(this.this$0), ReviewReportAction.access$getHeapProperties$p(this.this$0));
                    boolean userAgreedToSendReport = reportDialog.showAndGet();
                    HeapDumpAnalysisSupport.Companion.getInstance().analysisComplete(ReviewReportAction.access$getHeapProperties$p(this.this$0));
                    if (userAgreedToSendReport) {
                        HeapDumpAnalysisSupport.Companion.getInstance().uploadReport(ReviewReportAction.access$getReportText$p(this.this$0), ReviewReportAction.access$getHeapProperties$p(this.this$0), this.$parentComponent);
                    }
                }
                {
                    this.this$0 = reviewReportAction;
                    this.$notification = notification;
                    this.$parentComponent = jFrame;
                }
            });
        }

        public ReviewReportAction(@NotNull String reportText, @NotNull HeapReportProperties heapProperties) {
            Intrinsics.checkNotNullParameter((Object)reportText, (String)"reportText");
            Intrinsics.checkNotNullParameter((Object)heapProperties, (String)"heapProperties");
            super(DiagnosticBundle.message("heap.dump.analysis.notification.action.title", new Object[0]));
            this.reportText = reportText;
            this.heapProperties = heapProperties;
        }

        public static final /* synthetic */ String access$getReportText$p(ReviewReportAction $this) {
            return $this.reportText;
        }

        public static final /* synthetic */ HeapReportProperties access$getHeapProperties$p(ReviewReportAction $this) {
            return $this.heapProperties;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/action/AnalysisRunnable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

