/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.hprof.parser;

import com.google.common.base.Stopwatch;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfEventBasedParser$WhenMappings;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.diagnostic.hprof.parser.VisitorContext;
import com.intellij.diagnostic.hprof.util.HProfReadBuffer;
import com.intellij.diagnostic.hprof.util.HProfReadBufferSlidingWindow;
import com.intellij.openapi.diagnostic.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.function.LongUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0016\u0018\u0000 =2\u00020\u0001:\u0001=B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020(H\u0002J\b\u0010)\u001a\u00020\nH\u0002J\b\u0010*\u001a\u00020\fH\u0002J\b\u0010+\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\nH\u0002J\b\u0010-\u001a\u00020\u0018H\u0002J\b\u0010.\u001a\u00020\nH\u0002J\u0010\u0010/\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\b\u00100\u001a\u00020\fH\u0002J\b\u00101\u001a\u00020\nH\u0002J\b\u00102\u001a\u00020\fH\u0002J\u000e\u00103\u001a\u00020\n2\u0006\u00104\u001a\u00020\nJ\u0010\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u00020\nH\u0002J\u000e\u00107\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u00108\u001a\u00020\u00142\u0006\u00109\u001a\u00020\nH\u0002J\u0010\u0010:\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010;\u001a\u00020\u00142\u0006\u0010<\u001a\u00020\u0018H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser;", "Ljava/lang/AutoCloseable;", "fileChannel", "Ljava/nio/channels/FileChannel;", "(Ljava/nio/channels/FileChannel;)V", "buffer", "Lcom/intellij/diagnostic/hprof/util/HProfReadBuffer;", "getBuffer", "()Lcom/intellij/diagnostic/hprof/util/HProfReadBuffer;", "heapRecordPosition", "", "<set-?>", "", "idSize", "getIdSize", "()I", "remapFunction", "Ljava/util/function/LongUnaryOperator;", "reparsePosition", "accept", "", "visitor", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "description", "", "acceptClassDump", "acceptHeapDumpRecord", "heapDumpRecordType", "Lcom/intellij/diagnostic/hprof/parser/HeapDumpRecordType;", "acceptHeapDumpSegment", "length", "acceptInstanceDump", "acceptObjectArrayDump", "acceptPrimitiveArrayDump", "close", "getElementTypeSize", "elementType", "Lcom/intellij/diagnostic/hprof/parser/Type;", "initialParse", "readByte", "", "readId", "readInt", "readLong", "readNonNullTerminatedString", "readNullTerminatedString", "readRawId", "readTypeSizeValue", "readUnsignedByte", "readUnsignedInt", "readUnsignedShort", "remap", "id", "saveHeapRecordPosition", "position", "setIdRemappingFunction", "skip", "count", "skipHeapDumpRecord", "verifyFormat", "version", "Companion", "intellij.platform.ide.impl"})
public final class HProfEventBasedParser
implements AutoCloseable {
    private int idSize;
    private long reparsePosition;
    private LongUnaryOperator remapFunction;
    @NotNull
    private final HProfReadBuffer buffer;
    private long heapRecordPosition;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final int getIdSize() {
        return this.idSize;
    }

    @NotNull
    public final HProfReadBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public final void setIdRemappingFunction(@NotNull LongUnaryOperator remapFunction) {
        Intrinsics.checkNotNullParameter((Object)remapFunction, (String)"remapFunction");
        this.remapFunction = remapFunction;
    }

    private final void initialParse() {
        this.buffer.position(0L);
        this.verifyFormat(this.readNullTerminatedString());
        this.idSize = this.readInt();
        this.buffer.setIdSize(this.idSize);
        this.readLong();
        this.reparsePosition = this.buffer.position();
    }

    public final void accept(@NotNull HProfVisitor visitor, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Stopwatch stopwatch2 = Stopwatch.createStarted();
        this.buffer.position(this.reparsePosition);
        visitor.setVisitorContext(new VisitorContext(this){
            final /* synthetic */ HProfEventBasedParser this$0;

            public long getCurrentHeapRecordOffset() {
                return HProfEventBasedParser.access$getHeapRecordPosition$p(this.this$0);
            }

            public int getIdSize() {
                return this.this$0.getIdSize();
            }
            {
                this.this$0 = this$0;
            }
        });
        visitor.preVisit();
        block15: while (!this.buffer.isEof()) {
            int tag2 = this.readUnsignedByte();
            this.readInt();
            long length = this.readUnsignedInt();
            RecordType recordType = RecordType.Companion.fromInt(tag2);
            if (!visitor.isEnabled(recordType)) {
                this.skip(length);
                continue;
            }
            switch (HProfEventBasedParser$WhenMappings.$EnumSwitchMapping$0[recordType.ordinal()]) {
                case 1: {
                    visitor.visitStringInUTF8(this.readRawId(), this.readNonNullTerminatedString(length - (long)this.idSize));
                    continue block15;
                }
                case 2: {
                    visitor.visitLoadClass(this.readUnsignedInt(), this.readId(), this.readUnsignedInt(), this.readRawId());
                    continue block15;
                }
                case 3: {
                    visitor.visitUnloadClass(this.readUnsignedInt());
                    continue block15;
                }
                case 4: 
                case 5: {
                    this.acceptHeapDumpSegment(visitor, length);
                    continue block15;
                }
                case 6: {
                    visitor.visitHeapDumpEnd();
                    continue block15;
                }
                case 7: {
                    visitor.visitHeapSummary(this.readUnsignedInt(), this.readUnsignedInt(), this.readLong(), this.readLong());
                    continue block15;
                }
                case 8: {
                    visitor.visitAllocSites();
                    this.skip(length);
                    continue block15;
                }
                case 9: {
                    visitor.visitEndThread(this.readUnsignedInt());
                    continue block15;
                }
                case 10: {
                    visitor.visitStackFrame(this.readRawId(), this.readRawId(), this.readRawId(), this.readRawId(), this.readUnsignedInt(), this.readInt());
                    continue block15;
                }
                case 11: {
                    long stackTraceSerialNumber = this.readUnsignedInt();
                    long threadSerialNumber = this.readUnsignedInt();
                    int numberOfFrames = this.readInt();
                    long[] lArray = new long[numberOfFrames];
                    int n = 0;
                    while (n < numberOfFrames) {
                        long l;
                        int n2 = n;
                        int n3 = n++;
                        long[] lArray2 = lArray;
                        boolean bl = false;
                        lArray2[n3] = l = this.readRawId();
                    }
                    long[] frameIds = lArray;
                    visitor.visitStackTrace(stackTraceSerialNumber, threadSerialNumber, numberOfFrames, frameIds);
                    continue block15;
                }
                case 12: {
                    visitor.visitCPUSamples();
                    this.skip(length);
                    continue block15;
                }
                case 13: {
                    visitor.visitStartThread();
                    this.skip(length);
                    continue block15;
                }
                case 14: {
                    visitor.visitControlSettings();
                    this.skip(length);
                    continue block15;
                }
            }
            throw (Throwable)new RuntimeException("Invalid format.");
        }
        visitor.postVisit();
        LOG.info("HProfEventBasedParser" + (description != null ? " - " + description : "") + ": " + stopwatch2);
    }

    private final void skip(long count) {
        this.buffer.position(this.buffer.position() + count);
    }

    private final void acceptHeapDumpSegment(HProfVisitor visitor, long length) {
        visitor.visitHeapDump();
        long segmentEndPosition = this.buffer.position() + length;
        long currentPosition = this.buffer.position();
        while (currentPosition < segmentEndPosition) {
            int type = this.readUnsignedByte();
            HeapDumpRecordType heapDumpRecordType = HeapDumpRecordType.Companion.fromInt(type);
            if (visitor.isEnabled(heapDumpRecordType)) {
                this.saveHeapRecordPosition(currentPosition);
                this.acceptHeapDumpRecord(heapDumpRecordType, visitor);
            } else {
                this.skipHeapDumpRecord(heapDumpRecordType);
            }
            currentPosition = this.buffer.position();
        }
    }

    public final void acceptHeapDumpRecord(@NotNull HeapDumpRecordType heapDumpRecordType, @NotNull HProfVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)((Object)heapDumpRecordType), (String)"heapDumpRecordType");
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        switch (HProfEventBasedParser$WhenMappings.$EnumSwitchMapping$1[heapDumpRecordType.ordinal()]) {
            case 1: {
                visitor.visitRootUnknown(this.readId());
                break;
            }
            case 2: {
                visitor.visitRootGlobalJNI(this.readId(), this.readRawId());
                break;
            }
            case 3: {
                visitor.visitRootLocalJNI(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 4: {
                visitor.visitRootJavaFrame(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 5: {
                visitor.visitRootNativeStack(this.readId(), this.readUnsignedInt());
                break;
            }
            case 6: {
                visitor.visitRootStickyClass(this.readId());
                break;
            }
            case 7: {
                visitor.visitRootThreadBlock(this.readId(), this.readUnsignedInt());
                break;
            }
            case 8: {
                visitor.visitRootMonitorUsed(this.readId());
                break;
            }
            case 9: {
                visitor.visitRootThreadObject(this.readId(), this.readUnsignedInt(), this.readUnsignedInt());
                break;
            }
            case 10: {
                this.acceptClassDump(visitor);
                break;
            }
            case 11: {
                this.acceptInstanceDump(visitor);
                break;
            }
            case 12: {
                this.acceptObjectArrayDump(visitor);
                break;
            }
            case 13: {
                this.acceptPrimitiveArrayDump(visitor);
                break;
            }
            default: {
                throw (Throwable)new IOException("Unknown heap dump record type: " + (Object)((Object)heapDumpRecordType));
            }
        }
    }

    private final void skipHeapDumpRecord(HeapDumpRecordType heapDumpRecordType) {
        switch (HProfEventBasedParser$WhenMappings.$EnumSwitchMapping$2[heapDumpRecordType.ordinal()]) {
            case 1: {
                this.skip(this.idSize);
                break;
            }
            case 2: {
                this.skip(this.idSize * 2);
                break;
            }
            case 3: {
                this.skip(this.idSize + 8);
                break;
            }
            case 4: {
                this.skip(this.idSize + 8);
                break;
            }
            case 5: {
                this.skip(this.idSize + 4);
                break;
            }
            case 6: {
                this.skip(this.idSize);
                break;
            }
            case 7: {
                this.skip(this.idSize + 4);
                break;
            }
            case 8: {
                this.skip(this.idSize);
                break;
            }
            case 9: {
                this.skip(this.idSize + 8);
                break;
            }
            case 10: {
                int i2;
                this.skip(7 * this.idSize + 8);
                int toSkip = this.readUnsignedShort();
                int n = 0;
                int n2 = toSkip;
                while (n < n2) {
                    this.skip(2L);
                    this.readTypeSizeValue(Type.Companion.getType(this.readUnsignedByte()));
                    ++i2;
                }
                toSkip = this.readUnsignedShort();
                n2 = toSkip;
                for (i2 = 0; i2 < n2; ++i2) {
                    this.skip(this.idSize);
                    this.readTypeSizeValue(Type.Companion.getType(this.readUnsignedByte()));
                }
                toSkip = this.readUnsignedShort();
                this.skip(toSkip * (this.idSize + 1));
                break;
            }
            case 11: {
                this.skip(this.idSize * 2 + 4);
                long remainingBytes = this.readUnsignedInt();
                this.skip(remainingBytes);
                break;
            }
            case 12: {
                this.skip(this.idSize + 4);
                long objectArraySize = this.readUnsignedInt();
                this.skip((long)this.idSize * (objectArraySize + 1L));
                break;
            }
            case 13: {
                this.skip(this.idSize + 4);
                long primitiveArraySize = this.readUnsignedInt();
                byte elementTypeID = this.readByte();
                this.skip(primitiveArraySize * (long)Type.Companion.getType(elementTypeID).getSize());
                break;
            }
            default: {
                throw (Throwable)new IOException("Unknown heap dump record type: " + (Object)((Object)heapDumpRecordType));
            }
        }
    }

    private final void saveHeapRecordPosition(long position) {
        this.heapRecordPosition = position;
    }

    private final void acceptInstanceDump(HProfVisitor visitor) {
        long objectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long classObjectId = this.readId();
        int remainingBytes = this.readInt();
        ByteBuffer byteBuffer = this.buffer.getByteBuffer(remainingBytes);
        visitor.visitInstanceDump(objectId, stackTraceSerialNumber, classObjectId, byteBuffer);
    }

    /*
     * WARNING - void declaration
     */
    private final void acceptObjectArrayDump(HProfVisitor visitor) {
        long arrayObjectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long numberOfElements = this.readUnsignedInt();
        long arrayClassObjectId = this.readId();
        long[] objects = new long[(int)numberOfElements];
        int n = 0;
        int n2 = objects.length;
        while (n < n2) {
            void i2;
            objects[i2] = this.readId();
            ++i2;
        }
        visitor.visitObjectArrayDump(arrayObjectId, stackTraceSerialNumber, arrayClassObjectId, objects);
    }

    private final void acceptPrimitiveArrayDump(HProfVisitor visitor) {
        long arrayObjectId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long numberOfElements = this.readUnsignedInt();
        int elementTypeId = this.readUnsignedByte();
        Type elementType = Type.Companion.getType(elementTypeId);
        ByteBuffer primitiveArrayData = this.buffer.getByteBuffer((int)(numberOfElements * (long)elementType.getSize()));
        visitor.visitPrimitiveArrayDump(arrayObjectId, stackTraceSerialNumber, numberOfElements, elementType, primitiveArrayData);
    }

    private final void acceptClassDump(HProfVisitor visitor) {
        Object object;
        int constantPoolIndex;
        int n;
        Object[] objectArray;
        int n2;
        long classId = this.readId();
        long stackTraceSerialNumber = this.readUnsignedInt();
        long superClassId = this.readId();
        long classloaderClassId = this.readId();
        this.skip(this.idSize * 4);
        long instanceSize = this.readUnsignedInt();
        int countOfConstantPool = this.readUnsignedShort();
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[countOfConstantPool];
        for (int j = 0; j < countOfConstantPool; ++j) {
            int n3 = j;
            n2 = j;
            objectArray = constantPoolEntryArray;
            n = 0;
            constantPoolIndex = this.readUnsignedShort();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            long value2 = this.readTypeSizeValue(elementType);
            objectArray[n2] = object = elementType == Type.OBJECT ? new ConstantPoolEntry(constantPoolIndex, elementType, this.remap(value2)) : new ConstantPoolEntry(constantPoolIndex, elementType, value2);
        }
        ConstantPoolEntry[] constants = constantPoolEntryArray;
        int countOfStaticFields = this.readUnsignedShort();
        StaticFieldEntry[] it = new StaticFieldEntry[countOfStaticFields];
        for (n = 0; n < countOfStaticFields; ++n) {
            constantPoolIndex = n;
            n2 = n;
            objectArray = it;
            boolean bl = false;
            long staticFieldStringId = this.readRawId();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            long value3 = this.readTypeSizeValue(elementType);
            objectArray[n2] = object = elementType == Type.OBJECT ? new StaticFieldEntry(staticFieldStringId, elementType, this.remap(value3)) : new StaticFieldEntry(staticFieldStringId, elementType, value3);
        }
        StaticFieldEntry[] staticFields = it;
        int countOfInstanceFields = this.readUnsignedShort();
        InstanceFieldEntry[] instanceFieldEntryArray = new InstanceFieldEntry[countOfInstanceFields];
        int n4 = 0;
        while (n4 < countOfInstanceFields) {
            int staticFieldStringId = n4;
            n2 = n4++;
            objectArray = instanceFieldEntryArray;
            boolean bl = false;
            long fieldNameStringId = this.readRawId();
            Type elementType = Type.Companion.getType(this.readUnsignedByte());
            objectArray[n2] = object = new InstanceFieldEntry(fieldNameStringId, elementType);
        }
        InstanceFieldEntry[] instanceFields = instanceFieldEntryArray;
        visitor.visitClassDump(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields);
    }

    public final long remap(long id2) {
        LongUnaryOperator longUnaryOperator = this.remapFunction;
        return longUnaryOperator != null ? longUnaryOperator.applyAsLong(id2) : id2;
    }

    private final long readTypeSizeValue(Type elementType) {
        if (elementType == Type.OBJECT) {
            return this.readRawId();
        }
        switch (this.getElementTypeSize(elementType)) {
            case 1: {
                return this.buffer.get();
            }
            case 2: {
                return this.buffer.getShort();
            }
            case 4: {
                return this.buffer.getInt();
            }
            case 8: {
                return this.buffer.getLong();
            }
        }
        throw (Throwable)new IllegalArgumentException("Invalid size of element type.");
    }

    private final int getElementTypeSize(Type elementType) {
        return elementType == Type.OBJECT ? this.idSize : elementType.getSize();
    }

    private final String readNonNullTerminatedString(long length) {
        if (length > (long)Integer.MAX_VALUE) {
            throw (Throwable)new IOException("Strings larger then 2GB not supported.");
        }
        byte[] bytes = new byte[(int)length];
        this.buffer.get(bytes);
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        Charset charset2 = charset;
        boolean bl = false;
        return new String(bytes, charset2);
    }

    private final void verifyFormat(String version2) {
        if (Intrinsics.areEqual((Object)version2, (Object)"JAVA PROFILE 1.0.1") ^ true && Intrinsics.areEqual((Object)version2, (Object)"JAVA PROFILE 1.0.2") ^ true) {
            throw (Throwable)new RuntimeException("Invalid format. Got: " + version2);
        }
    }

    private final String readNullTerminatedString() {
        byte c = 0;
        long initialPosition = this.buffer.position();
        while ((c = this.buffer.get()) > 0) {
        }
        if (c == -1) {
            throw (Throwable)new EOFException();
        }
        byte[] bytes = new byte[(int)(this.buffer.position() - initialPosition - 1L)];
        this.buffer.position(initialPosition);
        this.buffer.get(bytes);
        this.buffer.get();
        Charset charset = Charset.forName("UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"UTF-8\")");
        Charset charset2 = charset;
        boolean bl = false;
        return new String(bytes, charset2);
    }

    private final int readInt() {
        return this.buffer.getInt();
    }

    private final int readUnsignedByte() {
        return Byte.toUnsignedInt(this.readByte());
    }

    private final byte readByte() {
        return this.buffer.get();
    }

    private final long readLong() {
        return this.buffer.getLong();
    }

    private final long readUnsignedInt() {
        return this.buffer.getUnsignedInt();
    }

    private final int readUnsignedShort() {
        return this.buffer.getUnsignedShort();
    }

    private final long readRawId() {
        return this.buffer.getRawId();
    }

    private final long readId() {
        return this.buffer.getId();
    }

    public HProfEventBasedParser(@NotNull FileChannel fileChannel) {
        Intrinsics.checkNotNullParameter((Object)fileChannel, (String)"fileChannel");
        this.buffer = new HProfReadBufferSlidingWindow(fileChannel, this);
        this.initialParse();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HProfEventBasedParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ long access$getHeapRecordPosition$p(HProfEventBasedParser $this) {
        return $this.heapRecordPosition;
    }

    public static final /* synthetic */ void access$setHeapRecordPosition$p(HProfEventBasedParser $this, long l) {
        $this.heapRecordPosition = l;
    }

    public static final /* synthetic */ int access$getIdSize$p(HProfEventBasedParser $this) {
        return $this.idSize;
    }

    public static final /* synthetic */ void access$setIdSize$p(HProfEventBasedParser $this, int n) {
        $this.idSize = n;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/diagnostic/hprof/parser/HProfEventBasedParser$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

