/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.diagnostic.logging.LogConsoleManager;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LogFilesManager {
    private final LogConsoleManager myManager;
    private final List<LogFile> myLogFiles;
    private final SingleAlarm myUpdateAlarm;

    public LogFilesManager(final @NotNull Project project, @NotNull LogConsoleManager manager2, @NotNull Disposable parentDisposable) {
        if (project == null) {
            LogFilesManager.$$$reportNull$$$0(0);
        }
        if (manager2 == null) {
            LogFilesManager.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            LogFilesManager.$$$reportNull$$$0(2);
        }
        this.myLogFiles = new ArrayList<LogFile>();
        this.myManager = manager2;
        this.myUpdateAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (project.isDisposed()) {
                    return;
                }
                for (LogFile logFile : new ArrayList<LogFile>(LogFilesManager.this.myLogFiles)) {
                    ProcessHandler process2 = logFile.getProcess();
                    if (process2 != null && process2.isProcessTerminated()) {
                        LogFilesManager.this.myLogFiles.remove(logFile);
                        continue;
                    }
                    Set<String> oldPaths = logFile.getPaths();
                    Set newPaths = logFile.getOptions().getPaths();
                    logFile.setPaths(newPaths);
                    HashSet<String> obsoletePaths = new HashSet<String>(oldPaths);
                    obsoletePaths.removeAll(newPaths);
                    try {
                        SwingUtilities.invokeAndWait(() -> {
                            if (project.isDisposed()) {
                                return;
                            }
                            LogFilesManager.this.addConfigurationConsoles(logFile.getOptions(), (Condition<? super String>)((Condition)file2 -> !oldPaths.contains(file2)), newPaths, logFile.getConfiguration());
                            for (String each : obsoletePaths) {
                                LogFilesManager.this.myManager.removeLogConsole(each);
                            }
                        });
                    }
                    catch (InterruptedException | InvocationTargetException exception) {}
                }
                if (!LogFilesManager.this.myLogFiles.isEmpty()) {
                    LogFilesManager.this.myUpdateAlarm.cancelAndRequest();
                }
            }
        }, 500, Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public void addLogConsoles(@NotNull RunConfigurationBase<?> runConfiguration, @Nullable ProcessHandler startedProcess) {
        if (runConfiguration == null) {
            LogFilesManager.$$$reportNull$$$0(3);
        }
        for (LogFileOptions logFileOptions : runConfiguration.getAllLogFiles()) {
            if (!logFileOptions.isEnabled()) continue;
            this.myLogFiles.add(new LogFile(logFileOptions, runConfiguration, startedProcess));
        }
        this.myUpdateAlarm.request();
        runConfiguration.createAdditionalTabComponents((AdditionalTabComponentManager)this.myManager, startedProcess);
    }

    private void addConfigurationConsoles(@NotNull LogFileOptions logFile, @NotNull Condition<? super String> shouldInclude, @NotNull Set<String> paths2, @NotNull RunConfigurationBase runConfiguration) {
        if (logFile == null) {
            LogFilesManager.$$$reportNull$$$0(4);
        }
        if (shouldInclude == null) {
            LogFilesManager.$$$reportNull$$$0(5);
        }
        if (paths2 == null) {
            LogFilesManager.$$$reportNull$$$0(6);
        }
        if (runConfiguration == null) {
            LogFilesManager.$$$reportNull$$$0(7);
        }
        if (paths2.isEmpty()) {
            return;
        }
        TreeMap<String, String> titleToPath = new TreeMap<String, String>();
        if (paths2.size() == 1) {
            String path2 = paths2.iterator().next();
            if (shouldInclude.value((Object)path2)) {
                titleToPath.put(logFile.getName(), path2);
            }
        } else {
            for (String path3 : paths2) {
                if (!shouldInclude.value((Object)path3)) continue;
                String title2 = new File(path3).getName();
                if (titleToPath.containsKey(title2)) {
                    title2 = path3;
                }
                titleToPath.put(title2, path3);
            }
        }
        for (String title3 : titleToPath.keySet()) {
            String path4 = (String)titleToPath.get(title3);
            assert (path4 != null);
            this.myManager.addLogConsole(title3, path4, logFile.getCharset(), logFile.isSkipContent() ? new File(path4).length() : 0L, runConfiguration);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldInclude";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/logging/LogFilesManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addLogConsoles";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addConfigurationConsoles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class LogFile {
        private final LogFileOptions myOptions;
        private final RunConfigurationBase myConfiguration;
        private final ProcessHandler myProcess;
        private Set<String> myPaths = new HashSet<String>();

        LogFile(LogFileOptions options2, RunConfigurationBase configuration2, ProcessHandler process2) {
            this.myOptions = options2;
            this.myConfiguration = configuration2;
            this.myProcess = process2;
        }

        public LogFileOptions getOptions() {
            return this.myOptions;
        }

        public RunConfigurationBase getConfiguration() {
            return this.myConfiguration;
        }

        public ProcessHandler getProcess() {
            return this.myProcess;
        }

        public Set<String> getPaths() {
            return this.myPaths;
        }

        public void setPaths(Set<String> paths2) {
            this.myPaths = paths2;
        }
    }
}

