/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.StartUpPerformanceService;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter$Companion$WhenMappings;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterValues;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\n\u0010\f\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0016J\u001a\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b0\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter;", "Lcom/intellij/openapi/startup/StartupActivity;", "Lcom/intellij/diagnostic/StartUpPerformanceService;", "()V", "lastMetrics", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "", "lastReport", "Ljava/nio/ByteBuffer;", "pluginCostMap", "", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "getLastReport", "getMetrics", "getPluginCostMap", "logStats", "", "projectName", "reportStatistics", "project", "Lcom/intellij/openapi/project/Project;", "runActivity", "ActivityListener", "Companion", "intellij.platform.diagnostic"})
public final class StartUpPerformanceReporter
implements StartupActivity,
StartUpPerformanceService {
    private Map<String, ? extends Object2LongMap<String>> pluginCostMap;
    private ByteBuffer lastReport;
    private Object2IntMap<String> lastMetrics;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final String VERSION = "35";
    @NotNull
    public static final Companion Companion;

    @Override
    @Nullable
    public Object2IntMap<String> getMetrics() {
        return this.lastMetrics;
    }

    @Override
    @NotNull
    public Map<String, Object2LongMap<String>> getPluginCostMap() {
        Map<String, ? extends Object2LongMap<String>> map2 = this.pluginCostMap;
        Intrinsics.checkNotNull(map2);
        return map2;
    }

    @Override
    @Nullable
    public ByteBuffer getLastReport() {
        return this.lastReport;
    }

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ActivityImpl.listener != null) {
            return;
        }
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
        String projectName = string;
        ActivityImpl.listener = new ActivityListener(projectName);
    }

    @Override
    public void reportStatistics(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ForkJoinPool.commonPool().execute(new Runnable(this, project){
            final /* synthetic */ StartUpPerformanceReporter this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                String string = this.$project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
                StartUpPerformanceReporter.access$logStats(this.this$0, string);
            }
            {
                this.this$0 = startUpPerformanceReporter;
                this.$project = project;
            }
        });
    }

    private final synchronized void logStats(String projectName) {
        StartUpPerformanceReporterValues params = StartUpPerformanceReporter.Companion.doLogStats(projectName);
        this.pluginCostMap = params.getPluginCostMap();
        this.lastReport = params.getLastReport();
        this.lastMetrics = params.getLastMetrics();
    }

    public StartUpPerformanceReporter() {
        Application app2;
        Application application = app2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isUnitTestMode() || app2.isHeadlessEnvironment()) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"ExtensionNotApplicableException.INSTANCE");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(StartUpMeasurer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\nH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter$ActivityListener;", "Ljava/util/function/Consumer;", "Lcom/intellij/diagnostic/ActivityImpl;", "projectName", "", "(Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter;Ljava/lang/String;)V", "editorRestoringTillPaint", "", "projectOpenedActivitiesPassed", "accept", "", "activity", "completed", "intellij.platform.diagnostic"})
    public final class ActivityListener
    implements Consumer<ActivityImpl> {
        private volatile boolean projectOpenedActivitiesPassed;
        private volatile boolean editorRestoringTillPaint;
        private final String projectName;

        @Override
        public void accept(@NotNull ActivityImpl activity) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (activity.getCategory() != null && activity.getCategory() != ActivityCategory.DEFAULT) {
                return;
            }
            if (activity.getEnd() == 0L) {
                if (Intrinsics.areEqual((Object)activity.getName(), (Object)"editor restoring till paint")) {
                    this.editorRestoringTillPaint = false;
                }
            } else {
                switch (activity.getName()) {
                    case "project post-startup dumb-aware activities": {
                        this.projectOpenedActivitiesPassed = true;
                        if (!this.editorRestoringTillPaint) break;
                        this.completed();
                        break;
                    }
                    case "editor restoring till paint": {
                        this.editorRestoringTillPaint = true;
                        if (!this.projectOpenedActivitiesPassed) break;
                        this.completed();
                        break;
                    }
                }
            }
        }

        private final void completed() {
            ActivityImpl.listener = null;
            StartUpMeasurer.stopPluginCostMeasurement();
            if (!Boolean.getBoolean("idea.collect.project.import.performance")) {
                StartUpPerformanceReporter.this.logStats(this.projectName);
            }
        }

        public ActivityListener(String projectName) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            this.projectName = projectName;
            this.editorRestoringTillPaint = true;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tJ\u001b\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u00a2\u0006\u0002\b\u0013R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG$intellij_platform_diagnostic", "()Lcom/intellij/openapi/diagnostic/Logger;", "VERSION", "", "doLogStats", "Lcom/intellij/diagnostic/startUpPerformanceReporter/StartUpPerformanceReporterValues;", "projectName", "logStats", "", "sortItems", "items", "", "Lcom/intellij/diagnostic/ActivityImpl;", "sortItems$intellij_platform_diagnostic", "intellij.platform.diagnostic"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_diagnostic() {
            return LOG;
        }

        public final void sortItems$intellij_platform_diagnostic(@NotNull List<ActivityImpl> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            CollectionsKt.sortWith(items, (Comparator)sortItems.1.INSTANCE);
        }

        public final void logStats(@NotNull String projectName) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            this.doLogStats(projectName);
        }

        /*
         * WARNING - void declaration
         */
        private final StartUpPerformanceReporterValues doLogStats(String projectName) {
            long startTime;
            void end;
            boolean bl = false;
            List instantEvents = new ArrayList();
            LinkedHashMap activities2 = new LinkedHashMap();
            HashMap serviceActivities = new HashMap();
            boolean bl2 = false;
            List services = new ArrayList();
            IdeThreadNameManager threadNameManager = new IdeThreadNameManager();
            Ref.LongRef longRef = new Ref.LongRef();
            longRef.element = -1L;
            StartUpMeasurer.processAndClear((boolean)SystemProperties.getBooleanProperty((String)"idea.collect.perf.after.first.project", (boolean)false), (Consumer)new Consumer(threadNameManager, instantEvents, (Ref.LongRef)end, activities2, services, serviceActivities){
                final /* synthetic */ IdeThreadNameManager $threadNameManager;
                final /* synthetic */ List $instantEvents;
                final /* synthetic */ Ref.LongRef $end;
                final /* synthetic */ LinkedHashMap $activities;
                final /* synthetic */ List $services;
                final /* synthetic */ HashMap $serviceActivities;

                /*
                 * WARNING - void declaration
                 */
                public final void accept(ActivityImpl item) {
                    ActivityImpl activityImpl = item;
                    Intrinsics.checkNotNullExpressionValue((Object)activityImpl, (String)"item");
                    this.$threadNameManager.getThreadName(activityImpl);
                    if (item.getEnd() == -1L) {
                        this.$instantEvents.add(item);
                    } else {
                        ActivityCategory activityCategory = item.getCategory();
                        if (activityCategory == null) {
                            activityCategory = ActivityCategory.DEFAULT;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)activityCategory, (String)"item.category ?: ActivityCategory.DEFAULT");
                        ActivityCategory activityCategory2 = activityCategory;
                        switch (StartUpPerformanceReporter$Companion$WhenMappings.$EnumSwitchMapping$0[activityCategory2.ordinal()]) {
                            case 1: {
                                void category;
                                if (Intrinsics.areEqual((Object)item.getName(), (Object)"project post-startup dumb-aware activities")) {
                                    this.$end.element = item.getEnd();
                                }
                                ((List)this.$activities.computeIfAbsent(category.getJsonName(), doLogStats.1.INSTANCE)).add(item);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                void category;
                                this.$services.add(item);
                                ((List)this.$serviceActivities.computeIfAbsent(category.getJsonName(), doLogStats.2.INSTANCE)).add(item);
                                break;
                            }
                            default: {
                                void category;
                                ((List)this.$activities.computeIfAbsent(category.getJsonName(), doLogStats.3.INSTANCE)).add(item);
                            }
                        }
                    }
                }
                {
                    this.$threadNameManager = ideThreadNameManager;
                    this.$instantEvents = list2;
                    this.$end = longRef;
                    this.$activities = linkedHashMap;
                    this.$services = list3;
                    this.$serviceActivities = hashMap;
                }
            });
            Map pluginCostMap = StartUpPerformanceReporterKt.access$computePluginCostMap();
            IdeIdeaFormatWriter w = new IdeIdeaFormatWriter((Map<String, ? extends List<ActivityImpl>>)activities2, pluginCostMap, threadNameManager);
            List defaultActivities = (List)activities2.get(ActivityCategory.DEFAULT.getJsonName());
            List list2 = defaultActivities;
            long l = list2 != null && (list2 = (ActivityImpl)CollectionsKt.first((List)list2)) != null ? list2.getStart() : (startTime = 0L);
            if (defaultActivities != null) {
                for (ActivityImpl item : defaultActivities) {
                    String pluginId22;
                    if (item.getPluginId() == null) {
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId22, (String)"item.pluginId ?: continue");
                    Object object = item.getCategory();
                    if (object == null || (object = object.name()) == null) {
                        object = "unknown";
                    }
                    StartUpMeasurer.doAddPluginCost((String)pluginId22, (String)object, (long)(item.getEnd() - item.getStart()), (Map)pluginCostMap);
                }
            }
            w.write(startTime, serviceActivities, instantEvents, end.element, projectName);
            ByteBuffer currentReport = w.toByteBuffer();
            String string = System.getProperty("idea.log.perf.stats", "false");
            boolean pluginId22 = false;
            if (Boolean.parseBoolean(string)) {
                w.writeToLog(this.getLOG$intellij_platform_diagnostic());
            }
            String perfFilePath = System.getProperty("idea.log.perf.stats.file");
            CharSequence pluginId22 = perfFilePath;
            boolean bl3 = false;
            boolean bl4 = false;
            if (!(pluginId22 == null || StringsKt.isBlank((CharSequence)pluginId22))) {
                this.getLOG$intellij_platform_diagnostic().info("StartUp Measurement report was written to: " + perfFilePath);
                Path path2 = Path.of(perfFilePath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Path.of(perfFilePath)");
                PathKt.write$default((Path)path2, (ByteBuffer)currentReport, (boolean)false, (int)2, null);
            }
            String classReport = System.getProperty("idea.log.class.list.file");
            CharSequence charSequence = classReport;
            bl4 = false;
            boolean bl5 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                Path path3 = Path.of(FileUtil.expandUserHome((String)classReport), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Path.of(FileUtil.expandUserHome(classReport))");
                StartUpPerformanceReporterKt.access$generateJarAccessLog(path3);
            }
            return new StartUpPerformanceReporterValues(pluginCostMap, currentReport, (Object2IntMap<String>)((Object2IntMap)w.getPublicStatMetrics()));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

