/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.ui;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.RunnablesListener;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

@ApiStatus.Experimental
final class EventWatcherToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    EventWatcherToolWindowFactory() {
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow2) {
        if (project == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(0);
        }
        if (toolWindow2 == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(1);
        }
        TableProvidingListener listener2 = new TableProvidingListener();
        project.getMessageBus().connect((Disposable)project).subscribe(TableProvidingListener.TOPIC, (Object)listener2);
        ContentManager manager2 = toolWindow2.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        listener2.createNamedPanels().map(entry2 -> {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)entry2.getValue(), "Center");
            return contentFactory.createContent((JComponent)panel2, (String)entry2.getKey(), false);
        }).forEach(arg_0 -> ((ContentManager)manager2).addContent(arg_0));
    }

    public void init(@NotNull ToolWindow toolWindow2) {
        if (toolWindow2 == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(2);
        }
        toolWindow2.setStripeTitle(DiagnosticBundle.message("event.watcher.tab.title", new Object[0]));
    }

    public boolean isApplicable(@NotNull Project project) {
        if (project == null) {
            EventWatcherToolWindowFactory.$$$reportNull$$$0(3);
        }
        return EventWatcher.isEnabled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createToolWindowContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TableProvidingListener
    implements RunnablesListener {
        @NotNull
        private final ListTableModel<RunnablesListener.InvocationsInfo> myInvocationsModel = TableProvidingListener.createDescendingTableModel(FunctionBasedColumnInfo.stringBased("event.watcher.column.name.runnable.callable", RunnablesListener.InvocationsInfo::getFQN), new FunctionBasedColumnInfo<RunnablesListener.InvocationsInfo, String>("event.watcher.column.name.average.duration.ms", String.class, info2 -> DEFAULT_DURATION_FORMAT.format(info2.getAverageDuration()), Comparator.comparingDouble(RunnablesListener.InvocationsInfo::getAverageDuration)), new FunctionBasedColumnInfo<RunnablesListener.InvocationsInfo, Integer>("event.watcher.column.name.count", Integer.TYPE, RunnablesListener.InvocationsInfo::getCount));
        @NotNull
        private final ListTableModel<RunnablesListener.InvocationDescription> myRunnablesModel = TableProvidingListener.createDescendingTableModel(FunctionBasedColumnInfo.stringBased("event.watcher.column.name.runnable", RunnablesListener.InvocationDescription::getProcessId), new FunctionBasedColumnInfo<RunnablesListener.InvocationDescription, Long>("event.watcher.column.name.duration.ms", Long.TYPE, RunnablesListener.InvocationDescription::getDuration), new FunctionBasedColumnInfo<RunnablesListener.InvocationDescription, String>("event.watcher.column.name.started.at", String.class, description -> DEFAULT_DATE_FORMAT.format(description.getStartDateTime()), Comparator.comparingLong(RunnablesListener.InvocationDescription::getStartedAt)));
        @NotNull
        private final ListTableModel<RunnablesListener.WrapperDescription> myWrappersModel = TableProvidingListener.createDescendingTableModel(FunctionBasedColumnInfo.stringBased("event.watcher.column.name.runnable.callable", RunnablesListener.WrapperDescription::getFQN), new FunctionBasedColumnInfo<RunnablesListener.WrapperDescription, Integer>("event.watcher.column.name.usages.count", Integer.TYPE, RunnablesListener.WrapperDescription::getUsagesCount));
        private final @NotNull Map<@PropertyKey(resourceBundle="messages.DiagnosticBundle") String, ? extends ListTableModel<?>> myModels = Map.of("event.watcher.tab.title.invocations", this.myInvocationsModel, "event.watcher.tab.title.runnables", this.myRunnablesModel, "event.watcher.tab.title.wrappers", this.myWrappersModel);

        TableProvidingListener() {
        }

        @NotNull Stream<Map.Entry<@Nls String, JPanel>> createNamedPanels() {
            Stream<Map.Entry<String, JPanel>> stream = this.myModels.entrySet().stream().map(entry2 -> Map.entry(DiagnosticBundle.message((String)entry2.getKey(), new Object[0]), TableProvidingListener.createPanel((ListTableModel)entry2.getValue())));
            if (stream == null) {
                TableProvidingListener.$$$reportNull$$$0(0);
            }
            return stream;
        }

        @Override
        public void runnablesProcessed(@NotNull Collection<RunnablesListener.InvocationDescription> invocations, @NotNull Collection<RunnablesListener.InvocationsInfo> infos, @NotNull Collection<RunnablesListener.WrapperDescription> wrappers) {
            if (invocations == null) {
                TableProvidingListener.$$$reportNull$$$0(1);
            }
            if (infos == null) {
                TableProvidingListener.$$$reportNull$$$0(2);
            }
            if (wrappers == null) {
                TableProvidingListener.$$$reportNull$$$0(3);
            }
            this.myRunnablesModel.addRows(invocations);
            TableProvidingListener.setItems(this.myInvocationsModel, infos);
            TableProvidingListener.setItems(this.myWrappersModel, wrappers);
        }

        @NotNull
        private static <Item extends Comparable<? super Item>> ListTableModel<Item> createDescendingTableModel(FunctionBasedColumnInfo<Item, ?> ... columns) {
            if (columns == null) {
                TableProvidingListener.$$$reportNull$$$0(4);
            }
            return new ListTableModel((ColumnInfo[])columns, new ArrayList(), 1, SortOrder.DESCENDING);
        }

        private static <Item> void setItems(@NotNull ListTableModel<? super Item> model2, @NotNull Collection<? extends Item> infos) {
            if (model2 == null) {
                TableProvidingListener.$$$reportNull$$$0(5);
            }
            if (infos == null) {
                TableProvidingListener.$$$reportNull$$$0(6);
            }
            model2.setItems(new ArrayList<Item>(infos));
        }

        @NotNull
        private static JPanel createPanel(final @NotNull ListTableModel<?> tableModel) {
            if (tableModel == null) {
                TableProvidingListener.$$$reportNull$$$0(7);
            }
            JPanel jPanel2 = ToolbarDecorator.createDecorator((JTable)new TableView(tableModel)).disableUpDownActions().disableAddAction().disableRemoveAction().setToolbarPosition(ActionToolbarPosition.RIGHT).addExtraAction((AnActionButton)new DumbAwareActionButton(DiagnosticBundle.message("event.watcher.clear.button.title", new Object[0]), AllIcons.Actions.GC){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Objects.requireNonNull(EventWatcher.getInstanceOrNull()).reset();
                    TableProvidingListener.setItems(tableModel, List.of());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener$1", "actionPerformed"));
                }
            }).createPanel();
            if (jPanel2 == null) {
                TableProvidingListener.$$$reportNull$$$0(8);
            }
            return jPanel2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "invocations";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infos";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNamedPanels";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runnablesProcessed";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescendingTableModel";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "setItems";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createPanel";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static final class FunctionBasedColumnInfo<Item extends Comparable<? super Item>, Aspect extends Comparable<? super Aspect>>
        extends ColumnInfo<Item, Aspect> {
            @NotNull
            private final Class<? extends Aspect> myColumnClass;
            @NotNull
            private final Function<? super Item, ? extends Aspect> myExtractor;
            @NotNull
            private final Comparator<Item> myComparator;

            private FunctionBasedColumnInfo(@NotNull @PropertyKey(resourceBundle="messages.DiagnosticBundle") @NotNull @PropertyKey(resourceBundle="messages.DiagnosticBundle") String nameKey, @NotNull Class<? extends Aspect> columnClass, @NotNull Function<? super Item, ? extends Aspect> extractor, @NotNull Comparator<Item> comparator2) {
                if (nameKey == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(0);
                }
                if (columnClass == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(1);
                }
                if (extractor == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(2);
                }
                if (comparator2 == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(3);
                }
                super(DiagnosticBundle.message(nameKey, new Object[0]));
                this.myColumnClass = columnClass;
                this.myExtractor = extractor;
                this.myComparator = comparator2;
            }

            private FunctionBasedColumnInfo(@NotNull @PropertyKey(resourceBundle="messages.DiagnosticBundle") @NotNull @PropertyKey(resourceBundle="messages.DiagnosticBundle") String nameKey, @NotNull Class<? extends Aspect> columnClass, @NotNull Function<? super Item, ? extends Aspect> extractor) {
                if (nameKey == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(4);
                }
                if (columnClass == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(5);
                }
                if (extractor == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(6);
                }
                this(nameKey, columnClass, extractor, Comparator.comparing(extractor));
            }

            @Nullable
            public Aspect valueOf(@NotNull Item item) {
                if (item == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(7);
                }
                return (Aspect)((Comparable)this.myExtractor.apply(item));
            }

            @NotNull
            public Class<? extends Aspect> getColumnClass() {
                Class<? extends Aspect> clazz = this.myColumnClass;
                if (clazz == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(8);
                }
                return clazz;
            }

            @NotNull
            public Comparator<Item> getComparator() {
                Comparator<Item> comparator2 = this.myComparator;
                if (comparator2 == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(9);
                }
                return comparator2;
            }

            private static <Item extends Comparable<? super Item>> FunctionBasedColumnInfo<Item, String> stringBased(@NotNull @PropertyKey(resourceBundle="messages.DiagnosticBundle") @NotNull @PropertyKey(resourceBundle="messages.DiagnosticBundle") String nameKey, @NotNull Function<? super Item, String> extractor) {
                if (nameKey == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(10);
                }
                if (extractor == null) {
                    FunctionBasedColumnInfo.$$$reportNull$$$0(11);
                }
                return new FunctionBasedColumnInfo<Item, String>(nameKey, String.class, extractor, Comparator.naturalOrder());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 8: 
                    case 9: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 8: 
                    case 9: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "nameKey";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columnClass";
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extractor";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comparator";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "item";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener$FunctionBasedColumnInfo";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/diagnostic/ui/EventWatcherToolWindowFactory$TableProvidingListener$FunctionBasedColumnInfo";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnClass";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComparator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "valueOf";
                        break;
                    }
                    case 8: 
                    case 9: {
                        break;
                    }
                    case 10: 
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "stringBased";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 8: 
                    case 9: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

