/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.editor;

import com.intellij.diff.editor.ChainDiffVirtualFile;
import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffRequestProcessorEditor;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001f\u0010\u000b\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001f\u0010\r\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001b\u0010\u000f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000e*\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/editor/DiffEditorTabTitleProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getEditorTabTitle", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getEditorTabTooltipText", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "getTitle", "Lorg/jetbrains/annotations/Nls;", "shorten", "maxLength", "", "intellij.platform.diff.impl"})
public final class DiffEditorTabTitleProvider
implements EditorTabTitleProvider,
DumbAware {
    @Override
    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String title2 = this.getTitle(project, file2);
        if (DiffEditorTabFilesManager.Companion.isDiffOpenedInNewWindow(file2)) {
            string = title2;
        } else {
            String string2 = title2;
            string = string2 != null ? DiffEditorTabTitleProvider.shorten$default(this, string2, 0, 1, null) : null;
        }
        return string;
    }

    @Override
    @Nullable
    public String getEditorTabTooltipText(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getTitle(project, file2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getTitle(Project project, VirtualFile file2) {
        if (!(file2 instanceof ChainDiffVirtualFile)) {
            return null;
        }
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
        Object object = fileEditor;
        if (fileEditor == null) return null;
        FileEditor fileEditor2 = object;
        boolean bl = false;
        boolean bl2 = false;
        FileEditor it = fileEditor2;
        boolean bl3 = false;
        FileEditor fileEditor3 = it;
        if (!(fileEditor3 instanceof DiffRequestProcessorEditor)) {
            fileEditor3 = null;
        }
        DiffRequestProcessorEditor diffRequestProcessorEditor = (DiffRequestProcessorEditor)fileEditor3;
        object = diffRequestProcessorEditor;
        if (diffRequestProcessorEditor == null) return null;
        DiffRequestProcessor diffRequestProcessor = ((DiffRequestProcessorEditor)((Object)object)).getProcessor();
        object = diffRequestProcessor;
        if (diffRequestProcessor == null) return null;
        DiffRequest diffRequest = ((DiffRequestProcessor)object).getActiveRequest();
        object = diffRequest;
        if (diffRequest == null) return null;
        String string = object.getTitle();
        return string;
    }

    private final String shorten(String $this$shorten, int maxLength) {
        if ($this$shorten.length() < maxLength) {
            return $this$shorten;
        }
        int index2 = StringsKt.indexOf$default((CharSequence)$this$shorten, (char)'(', (int)0, (boolean)false, (int)6, null);
        int n = index2;
        if (1 <= n && maxLength > n) {
            String string = $this$shorten;
            int n2 = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n2, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)$this$shorten, (int)maxLength, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.shortenTextWi\u2026ipsis(this, maxLength, 0)");
        return string;
    }

    static /* synthetic */ String shorten$default(DiffEditorTabTitleProvider diffEditorTabTitleProvider, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 30;
        }
        return diffEditorTabTitleProvider.shorten(string, n);
    }
}

