/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.util.Side;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThreeDiffSplitter
extends JPanel {
    @NotNull
    private final List<? extends JComponent> myContents;
    @NotNull
    private final Divider myDivider1;
    @NotNull
    private final Divider myDivider2;
    private float myProportion1;
    private float myProportion2;

    public ThreeDiffSplitter(@NotNull List<? extends JComponent> components) {
        if (components == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(0);
        }
        assert (components.size() == 3);
        this.myContents = components;
        this.myDivider1 = new Divider(Side.LEFT);
        this.myDivider2 = new Divider(Side.RIGHT);
        this.add(this.myDivider1);
        this.add(this.myDivider2);
        for (JComponent jComponent : this.myContents) {
            this.add(jComponent);
        }
        this.resetProportions();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setPainter(@Nullable DiffSplitter.Painter painter, @NotNull Side side) {
        void painter2;
        void side2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (side2 == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(1);
        }
        this.getDivider((Side)side2).setPainter((DiffSplitter.Painter)painter2);
    }

    public void repaintDivider(@NotNull Side side) {
        if (side == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(2);
        }
        this.getDivider(side).repaint();
    }

    @NotNull
    private Divider getDivider(@NotNull Side side) {
        if (side == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(3);
        }
        Divider divider = (Divider)side.select((Object)this.myDivider1, (Object)this.myDivider2);
        if (divider == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(4);
        }
        return divider;
    }

    private void resetProportions() {
        this.myProportion2 = 0.33333334f;
        this.myProportion1 = 0.33333334f;
    }

    private void expandMiddlePanel() {
        this.myProportion2 = 0.0f;
        this.myProportion1 = 0.0f;
    }

    private boolean areDefaultProportions() {
        int width = this.getWidth();
        int[] widths1 = ThreeDiffSplitter.calcComponentsWidths(width, this.myProportion1, this.myProportion2);
        int[] widths2 = ThreeDiffSplitter.calcComponentsWidths(width, 0.33333334f, 0.33333334f);
        return Arrays.equals(widths1, widths2);
    }

    private void setProportion(float proportion, @NotNull Side side) {
        if (side == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(5);
        }
        proportion = MathUtil.clamp((float)proportion, (float)0.0f, (float)1.0f);
        float otherProportion = ((Float)side.select((Object)Float.valueOf(this.myProportion2), (Object)Float.valueOf(this.myProportion1))).floatValue();
        otherProportion = Math.min(otherProportion, 1.0f - proportion);
        this.myProportion1 = ((Float)side.select((Object)Float.valueOf(proportion), (Object)Float.valueOf(otherProportion))).floatValue();
        this.myProportion2 = ((Float)side.select((Object)Float.valueOf(otherProportion), (Object)Float.valueOf(proportion))).floatValue();
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        JComponent[] components = new JComponent[]{this.myContents.get(0), this.myDivider1, this.myContents.get(1), this.myDivider2, this.myContents.get(2)};
        int[] contentWidths = ThreeDiffSplitter.calcComponentsWidths(width, this.myProportion1, this.myProportion2);
        int x = 0;
        for (int i2 = 0; i2 < 5; ++i2) {
            JComponent component2 = components[i2];
            component2.setBounds(x, 0, contentWidths[i2], height);
            component2.validate();
            x += contentWidths[i2];
        }
    }

    private static int @NotNull [] calcComponentsWidths(int width, float proportion1, float proportion2) {
        int dividersTotalWidth = ThreeDiffSplitter.getDividerWidth() * 2;
        int contentsTotalWidth = Math.max(width - dividersTotalWidth, 0);
        int[] contentWidths = new int[5];
        contentWidths[1] = ThreeDiffSplitter.getDividerWidth();
        contentWidths[3] = ThreeDiffSplitter.getDividerWidth();
        contentWidths[0] = (int)((float)contentsTotalWidth * proportion1);
        contentWidths[4] = (int)((float)contentsTotalWidth * proportion2);
        contentWidths[2] = Math.max(contentsTotalWidth - contentWidths[0] - contentWidths[4], 0);
        if (contentWidths == null) {
            ThreeDiffSplitter.$$$reportNull$$$0(6);
        }
        return contentWidths;
    }

    @Override
    public Dimension getMinimumSize() {
        int width = ThreeDiffSplitter.getDividerWidth() * 2;
        int height = 0;
        for (JComponent jComponent : this.myContents) {
            Dimension size = jComponent.getMinimumSize();
            width += size.width;
            height = Math.max(height, size.height);
        }
        return new Dimension(width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        int width = ThreeDiffSplitter.getDividerWidth() * 2;
        int height = 0;
        for (JComponent jComponent : this.myContents) {
            Dimension size = jComponent.getPreferredSize();
            width += size.width;
            height = Math.max(height, size.height);
        }
        return new Dimension(width, height);
    }

    private static int getDividerWidth() {
        return JBUIScale.scale((int)Registry.intValue((String)"diff.divider.width"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/ThreeDiffSplitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/ThreeDiffSplitter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDivider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcComponentsWidths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPainter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "repaintDivider";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDivider";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setProportion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Divider
    extends JPanel {
        @NotNull
        private final Side mySide;
        @Nullable
        private DiffSplitter.Painter myPainter;

        Divider(Side side) {
            if (side == null) {
                Divider.$$$reportNull$$$0(0);
            }
            this.mySide = side;
            this.enableEvents(48L);
            this.setCursor(Cursor.getPredefinedCursor(10));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.myPainter != null) {
                this.myPainter.paint(g, this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @RequiresEdt
        public void setPainter(@Nullable DiffSplitter.Painter painter) {
            void painter2;
            ApplicationManager.getApplication().assertIsDispatchThread();
            this.myPainter = painter2;
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            int totalWidth;
            super.processMouseMotionEvent(e);
            if (e.getID() == 506 && (totalWidth = ThreeDiffSplitter.this.getWidth()) > 0) {
                Point point = SwingUtilities.convertPoint(this, e.getPoint(), ThreeDiffSplitter.this);
                float proportion = (float)this.mySide.select(point.x, totalWidth - point.x) / (float)totalWidth;
                ThreeDiffSplitter.this.setProportion(proportion, this.mySide);
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getID() == 500 && e.getClickCount() == 2) {
                if (ThreeDiffSplitter.this.areDefaultProportions()) {
                    ThreeDiffSplitter.this.expandMiddlePanel();
                } else {
                    ThreeDiffSplitter.this.resetProportions();
                }
                this.revalidate();
                this.repaint();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/util/ThreeDiffSplitter$Divider", "<init>"));
        }
    }
}

