/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InitialScrollPositionSupport {
    public static Point @NotNull [] doGetScrollingPositions(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(0);
        }
        Point[] carets = new Point[editors2.size()];
        for (int i2 = 0; i2 < editors2.size(); ++i2) {
            carets[i2] = DiffUtil.getScrollingPosition(editors2.get(i2));
        }
        if (carets == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(1);
        }
        return carets;
    }

    public static LogicalPosition @NotNull [] doGetCaretPositions(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(2);
        }
        LogicalPosition[] carets = new LogicalPosition[editors2.size()];
        for (int i2 = 0; i2 < editors2.size(); ++i2) {
            carets[i2] = DiffUtil.getCaretPosition(editors2.get(i2));
        }
        if (carets == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(3);
        }
        return carets;
    }

    @Nullable
    public static EditorsVisiblePositions doGetVisiblePositions(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(4);
        }
        LogicalPosition[] carets = InitialScrollPositionSupport.doGetCaretPositions(editors2);
        Point[] points = InitialScrollPositionSupport.doGetScrollingPositions(editors2);
        return new EditorsVisiblePositions(carets, points);
    }

    public static void doMoveCaretsToPositions(LogicalPosition @NotNull [] positions, @NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(5);
        }
        if (positions == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(6);
        }
        for (int i2 = 0; i2 < editors2.size(); ++i2) {
            Editor editor2 = editors2.get(i2);
            if (editor2 == null) continue;
            editor2.getCaretModel().moveToLogicalPosition(positions[i2]);
        }
    }

    public static void doScrollToVisiblePositions(@NotNull EditorsVisiblePositions visiblePositions, @NotNull List<? extends Editor> editors2) {
        if (visiblePositions == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(7);
        }
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(8);
        }
        for (int i2 = 0; i2 < editors2.size(); ++i2) {
            Editor editor2 = editors2.get(i2);
            if (editor2 == null) continue;
            DiffUtil.scrollToPoint(editor2, visiblePositions.myPoints[i2], false);
        }
    }

    public static void doScrollToCaret(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(9);
        }
        for (int i2 = 0; i2 < editors2.size(); ++i2) {
            Editor editor2 = editors2.get(i2);
            if (editor2 == null) continue;
            DiffUtil.scrollToCaret(editor2, false);
        }
    }

    public static boolean wasScrolled(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(10);
        }
        for (Editor editor2 : editors2) {
            if (editor2 == null) continue;
            if (editor2.getCaretModel().getOffset() != 0) {
                return true;
            }
            if (editor2.getScrollingModel().getVerticalScrollOffset() != 0) {
                return true;
            }
            if (editor2.getScrollingModel().getHorizontalScrollOffset() == 0) continue;
            return true;
        }
        return false;
    }

    public static void ensureEditorSizeIsUpToDate(@NotNull List<? extends Editor> editors2) {
        if (editors2 == null) {
            InitialScrollPositionSupport.$$$reportNull$$$0(11);
        }
        Set windows = ContainerUtil.map2SetNotNull(editors2, editor2 -> UIUtil.getWindow((Component)editor2.getComponent()));
        for (Window window : windows) {
            window.validate();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positions";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetScrollingPositions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetCaretPositions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doGetScrollingPositions";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doGetCaretPositions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doGetVisiblePositions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doMoveCaretsToPositions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToVisiblePositions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doScrollToCaret";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "wasScrolled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "ensureEditorSizeIsUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EditorsVisiblePositions {
        public static final Key<EditorsVisiblePositions> KEY = Key.create((String)"Diff.EditorsVisiblePositions");
        public final LogicalPosition @NotNull [] myCaretPosition;
        public final Point @NotNull [] myPoints;

        public EditorsVisiblePositions(@NotNull LogicalPosition caretPosition, @NotNull Point points) {
            if (caretPosition == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(0);
            }
            if (points == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(1);
            }
            this(new LogicalPosition[]{caretPosition}, new Point[]{points});
        }

        public EditorsVisiblePositions(LogicalPosition @NotNull [] caretPosition, Point @NotNull [] points) {
            if (caretPosition == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(2);
            }
            if (points == null) {
                EditorsVisiblePositions.$$$reportNull$$$0(3);
            }
            this.myCaretPosition = caretPosition;
            this.myPoints = points;
        }

        public boolean isSame(LogicalPosition ... caretPosition) {
            if (caretPosition == null) {
                return true;
            }
            if (this.myCaretPosition.length != caretPosition.length) {
                return false;
            }
            for (int i2 = 0; i2 < caretPosition.length; ++i2) {
                if (caretPosition[i2].equals((Object)this.myCaretPosition[i2])) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "caretPosition";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "points";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$EditorsVisiblePositions";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ThreesideInitialScrollHelper
    extends SideInitialScrollHelper {
        @Nullable
        protected Pair<ThreeSide, Integer> myScrollToLine;

        @Override
        public void processContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                ThreesideInitialScrollHelper.$$$reportNull$$$0(0);
            }
            super.processContext(request2);
            this.myScrollToLine = (Pair)request2.getUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE);
        }

        @Override
        public void updateContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                ThreesideInitialScrollHelper.$$$reportNull$$$0(1);
            }
            super.updateContext(request2);
            request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE_THREESIDE, null);
        }

        public void onSlowRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myScrollToChange != null) {
                return;
            }
            InitialScrollPositionSupport.ensureEditorSizeIsUpToDate(this.getEditors());
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        public void onRediff() {
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            InitialScrollPositionSupport.ensureEditorSizeIsUpToDate(this.getEditors());
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                this.doScrollToFirstChange();
            }
            this.myShouldScroll = false;
        }

        @RequiresEdt
        protected abstract boolean doScrollToChange();

        @RequiresEdt
        protected abstract boolean doScrollToFirstChange();

        @RequiresEdt
        protected abstract boolean doScrollToLine();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "request";
            objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$ThreesideInitialScrollHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class TwosideInitialScrollHelper
    extends SideInitialScrollHelper {
        @Nullable
        protected Pair<Side, Integer> myScrollToLine;
        @Nullable
        protected DiffNavigationContext myNavigationContext;

        @Override
        public void processContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                TwosideInitialScrollHelper.$$$reportNull$$$0(0);
            }
            super.processContext(request2);
            this.myScrollToLine = (Pair)request2.getUserData(DiffUserDataKeys.SCROLL_TO_LINE);
            this.myNavigationContext = (DiffNavigationContext)request2.getUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT);
        }

        @Override
        public void updateContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                TwosideInitialScrollHelper.$$$reportNull$$$0(1);
            }
            super.updateContext(request2);
            request2.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, null);
            request2.putUserData(DiffUserDataKeysEx.NAVIGATION_CONTEXT, null);
        }

        @RequiresEdt
        public void onSlowRediff() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            if (this.myScrollToChange != null) {
                return;
            }
            InitialScrollPositionSupport.ensureEditorSizeIsUpToDate(this.getEditors());
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myNavigationContext != null) {
                return;
            }
            if (this.myShouldScroll) {
                this.myShouldScroll = !this.doScrollToPosition();
            }
        }

        @RequiresEdt
        public void onRediff() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (InitialScrollPositionSupport.wasScrolled(this.getEditors())) {
                this.myShouldScroll = false;
            }
            InitialScrollPositionSupport.ensureEditorSizeIsUpToDate(this.getEditors());
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToChange();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToLine();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToContext();
            }
            if (this.myShouldScroll) {
                boolean bl = this.myShouldScroll = !this.doScrollToPosition();
            }
            if (this.myShouldScroll) {
                this.doScrollToFirstChange();
            }
            this.myShouldScroll = false;
        }

        @RequiresEdt
        protected abstract boolean doScrollToChange();

        @RequiresEdt
        protected abstract boolean doScrollToFirstChange();

        @RequiresEdt
        protected abstract boolean doScrollToContext();

        @RequiresEdt
        protected abstract boolean doScrollToLine();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "request";
            objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$TwosideInitialScrollHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class SideInitialScrollHelper
    extends InitialScrollHelperBase {
        private SideInitialScrollHelper() {
        }

        @Override
        protected LogicalPosition @Nullable [] getCaretPositions() {
            return InitialScrollPositionSupport.doGetCaretPositions(this.getEditors());
        }

        @Override
        @Nullable
        protected EditorsVisiblePositions getVisiblePositions() {
            return InitialScrollPositionSupport.doGetVisiblePositions(this.getEditors());
        }

        @RequiresEdt
        protected boolean doScrollToPosition() {
            ApplicationManager.getApplication().assertIsDispatchThread();
            List<? extends Editor> editors2 = this.getEditors();
            if (this.myCaretPosition == null || this.myCaretPosition.length != editors2.size()) {
                return false;
            }
            InitialScrollPositionSupport.doMoveCaretsToPositions(this.myCaretPosition, editors2);
            try {
                this.disableSyncScroll(true);
                if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(this.myCaretPosition)) {
                    InitialScrollPositionSupport.doScrollToVisiblePositions(this.myEditorsPosition, editors2);
                } else {
                    InitialScrollPositionSupport.doScrollToCaret(editors2);
                }
            }
            finally {
                this.disableSyncScroll(false);
            }
            return true;
        }

        @NotNull
        protected abstract List<? extends Editor> getEditors();

        protected abstract void disableSyncScroll(boolean var1);
    }

    public static abstract class InitialScrollHelperBase {
        protected boolean myShouldScroll = true;
        @Nullable
        protected DiffUserDataKeysEx.ScrollToPolicy myScrollToChange;
        @Nullable
        protected EditorsVisiblePositions myEditorsPosition;
        protected LogicalPosition @Nullable [] myCaretPosition;

        public void processContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                InitialScrollHelperBase.$$$reportNull$$$0(0);
            }
            this.myScrollToChange = (DiffUserDataKeysEx.ScrollToPolicy)((Object)request2.getUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE));
            this.myEditorsPosition = (EditorsVisiblePositions)request2.getUserData(EditorsVisiblePositions.KEY);
            this.myCaretPosition = (LogicalPosition[])request2.getUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION);
        }

        public void updateContext(@NotNull DiffRequest request2) {
            if (request2 == null) {
                InitialScrollHelperBase.$$$reportNull$$$0(1);
            }
            LogicalPosition[] carets = this.getCaretPositions();
            EditorsVisiblePositions visiblePositions = this.getVisiblePositions();
            request2.putUserData(DiffUserDataKeysEx.SCROLL_TO_CHANGE, null);
            request2.putUserData(EditorsVisiblePositions.KEY, (Object)visiblePositions);
            request2.putUserData(DiffUserDataKeysEx.EDITORS_CARET_POSITION, (Object)carets);
        }

        protected abstract LogicalPosition @Nullable [] getCaretPositions();

        @Nullable
        protected abstract EditorsVisiblePositions getVisiblePositions();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "request";
            objectArray2[1] = "com/intellij/diff/tools/util/base/InitialScrollPositionSupport$InitialScrollHelperBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateContext";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

