/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.tools.util.breadcrumbs.BreadcrumbsPlacement;
import com.intellij.diff.tools.util.breadcrumbs.DiffBreadcrumbsPanel;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.InvisibleWrapper;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DiffContentPanel
extends JPanel {
    @Nullable
    private DiffBreadcrumbsPanel myBreadcrumbs;
    private final Wrapper myTitle;
    private final Wrapper myTopBreadcrumbs;
    private final JComponent myContent;
    private final Wrapper myBottomBreadcrumbs;

    DiffContentPanel(@NotNull JComponent content2) {
        if (content2 == null) {
            DiffContentPanel.$$$reportNull$$$0(0);
        }
        this.myTitle = new InvisibleWrapper();
        this.myTopBreadcrumbs = new InvisibleWrapper();
        this.myBottomBreadcrumbs = new InvisibleWrapper();
        this.myContent = content2;
        DiffContentPanel.initLayout(this, (JComponent)this.myTitle, (JComponent)this.myTopBreadcrumbs, this.myContent, (JComponent)this.myBottomBreadcrumbs);
    }

    public void setTitle(@Nullable JComponent titles) {
        this.myTitle.setContent(titles);
    }

    public void setBreadcrumbs(@Nullable DiffBreadcrumbsPanel breadcrumbs) {
        if (breadcrumbs != null) {
            this.myBreadcrumbs = breadcrumbs;
        }
    }

    public void updateBreadcrumbsPlacement(@NotNull BreadcrumbsPlacement placement) {
        if (placement == null) {
            DiffContentPanel.$$$reportNull$$$0(1);
        }
        if (this.myBreadcrumbs == null) {
            return;
        }
        this.myTopBreadcrumbs.setContent((JComponent)(placement == BreadcrumbsPlacement.TOP ? this.myBreadcrumbs : null));
        this.myBottomBreadcrumbs.setContent((JComponent)(placement == BreadcrumbsPlacement.BOTTOM ? this.myBreadcrumbs : null));
        this.myBreadcrumbs.setCrumbsShown(placement != BreadcrumbsPlacement.HIDDEN);
        this.validate();
        this.repaint();
    }

    private static void initLayout(@NotNull DiffContentPanel contentPanel2, @NotNull JComponent title2, @NotNull JComponent topBreadcrumbs, @NotNull JComponent content2, @NotNull JComponent bottomBreadcrumbs) {
        if (contentPanel2 == null) {
            DiffContentPanel.$$$reportNull$$$0(2);
        }
        if (title2 == null) {
            DiffContentPanel.$$$reportNull$$$0(3);
        }
        if (topBreadcrumbs == null) {
            DiffContentPanel.$$$reportNull$$$0(4);
        }
        if (content2 == null) {
            DiffContentPanel.$$$reportNull$$$0(5);
        }
        if (bottomBreadcrumbs == null) {
            DiffContentPanel.$$$reportNull$$$0(6);
        }
        contentPanel2.removeAll();
        contentPanel2.setLayout((LayoutManager)((Object)new DiffContentLayout(title2, topBreadcrumbs, content2, bottomBreadcrumbs)));
        contentPanel2.add(title2);
        contentPanel2.add(topBreadcrumbs);
        contentPanel2.add(content2);
        contentPanel2.add(bottomBreadcrumbs);
    }

    public static void syncTitleHeights(@NotNull List<DiffContentPanel> panels) {
        if (panels == null) {
            DiffContentPanel.$$$reportNull$$$0(7);
        }
        List titles = ContainerUtil.map(panels, it -> it.myTitle);
        List topBreadcrumbs = ContainerUtil.map(panels, it -> it.myTopBreadcrumbs);
        List<JComponent> syncTitles = DiffUtil.createSyncHeightComponents(titles);
        List<JComponent> syncTopBreadcrumbs = DiffUtil.createSyncHeightComponents(topBreadcrumbs);
        for (int i2 = 0; i2 < panels.size(); ++i2) {
            DiffContentPanel contentPanel2 = panels.get(i2);
            JComponent title2 = syncTitles.get(i2);
            JComponent topBreadcrumb = syncTopBreadcrumbs.get(i2);
            DiffContentPanel.initLayout(contentPanel2, title2, topBreadcrumb, contentPanel2.myContent, (JComponent)contentPanel2.myBottomBreadcrumbs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topBreadcrumbs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomBreadcrumbs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panels";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/util/side/DiffContentPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateBreadcrumbsPlacement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "initLayout";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "syncTitleHeights";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class DiffContentLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JComponent myTitle;
        @NotNull
        private final JComponent myTopBreadcrumbs;
        @NotNull
        private final JComponent myContent;
        @NotNull
        private final JComponent myBottomBreadcrumbs;

        DiffContentLayout(@NotNull JComponent title2, @NotNull JComponent topBreadcrumbs, @NotNull JComponent content2, @NotNull JComponent bottomBreadcrumbs) {
            if (title2 == null) {
                DiffContentLayout.$$$reportNull$$$0(0);
            }
            if (topBreadcrumbs == null) {
                DiffContentLayout.$$$reportNull$$$0(1);
            }
            if (content2 == null) {
                DiffContentLayout.$$$reportNull$$$0(2);
            }
            if (bottomBreadcrumbs == null) {
                DiffContentLayout.$$$reportNull$$$0(3);
            }
            this.myTitle = title2;
            this.myTopBreadcrumbs = topBreadcrumbs;
            this.myContent = content2;
            this.myBottomBreadcrumbs = bottomBreadcrumbs;
        }

        public Dimension preferredLayoutSize(Container parent) {
            int totalWidth = 0;
            int totalHeight = 0;
            for (JComponent component2 : Arrays.asList(this.myTitle, this.myTopBreadcrumbs, this.myContent, this.myBottomBreadcrumbs)) {
                Dimension size = DiffContentLayout.getPreferredSize(component2);
                totalWidth = Math.max(size.width, totalWidth);
                totalHeight += size.height;
                if (component2 != this.myTitle || size.height == 0) continue;
                totalHeight += DiffUtil.TITLE_GAP.get();
            }
            return new Dimension(totalWidth, totalHeight);
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                DiffContentLayout.$$$reportNull$$$0(4);
            }
            int y = 0;
            int width = parent.getWidth();
            int totalHeight = parent.getHeight();
            Dimension titleSize = DiffContentLayout.getPreferredSize(this.myTitle);
            Dimension topSize = DiffContentLayout.getPreferredSize(this.myTopBreadcrumbs);
            Dimension bottomSize = DiffContentLayout.getPreferredSize(this.myBottomBreadcrumbs);
            int bottomY = totalHeight - bottomSize.height;
            this.myTitle.setBounds(0, y, width, titleSize.height);
            y += titleSize.height;
            if (titleSize.height != 0) {
                y += DiffUtil.TITLE_GAP.get();
            }
            this.myTopBreadcrumbs.setBounds(0, y, width, topSize.height);
            this.myContent.setBounds(0, y += topSize.height, width, Math.max(0, bottomY - y));
            this.myBottomBreadcrumbs.setBounds(0, bottomY, width, bottomSize.height);
        }

        @NotNull
        private static Dimension getPreferredSize(@NotNull JComponent component2) {
            if (component2 == null) {
                DiffContentLayout.$$$reportNull$$$0(5);
            }
            return component2.isVisible() ? component2.getPreferredSize() : new Dimension();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topBreadcrumbs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bottomBreadcrumbs";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/side/DiffContentPanel$DiffContentLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPreferredSize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

