/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.side;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.EditorHolder;
import com.intellij.diff.tools.holders.EditorHolderFactory;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.FocusTrackerSupport;
import com.intellij.diff.tools.util.SimpleDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.tools.util.side.TwosideContentPanel;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TwosideDiffViewer<T extends EditorHolder>
extends ListenerDiffViewerBase {
    @NotNull
    protected final SimpleDiffPanel myPanel;
    @NotNull
    protected final TwosideContentPanel myContentPanel;
    @NotNull
    private final List<T> myHolders;
    @NotNull
    private final FocusTrackerSupport<Side> myFocusTrackerSupport;

    public TwosideDiffViewer(@NotNull DiffContext context2, @NotNull ContentDiffRequest request2, @NotNull EditorHolderFactory<T> factory2) {
        if (context2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(0);
        }
        if (request2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(1);
        }
        if (factory2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(2);
        }
        super(context2, request2);
        this.myHolders = this.createEditorHolders(factory2);
        this.myFocusTrackerSupport = new FocusTrackerSupport.Twoside(this.myHolders);
        this.myContentPanel = TwosideContentPanel.createFromHolders(this.myHolders);
        this.myPanel = new SimpleDiffPanel(this.myContentPanel, (DataProvider)this, context2);
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myPanel.setPersistentNotifications(DiffUtil.createCustomNotifications(this, (UserDataHolder)this.myContext, (UserDataHolder)this.myRequest));
        this.myContentPanel.setTitles(this.createTitles());
    }

    @Override
    @RequiresEdt
    protected void onDispose() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.destroyEditorHolders();
        super.onDispose();
    }

    @Override
    @RequiresEdt
    protected void processContextHints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.processContextHints();
        this.myFocusTrackerSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
        Float proportion = (Float)this.myContext.getUserData(DiffUserDataKeysEx.TWO_SIDE_SPLITTER_PROPORTION);
        if (proportion != null && (double)proportion.floatValue() >= 0.05 && (double)proportion.floatValue() <= 0.95) {
            this.myContentPanel.getSplitter().setProportion(proportion.floatValue());
        }
    }

    @Override
    @RequiresEdt
    protected void updateContextHints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.updateContextHints();
        this.myFocusTrackerSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
        float proportion = this.myContentPanel.getSplitter().getProportion();
        this.myContext.putUserData(DiffUserDataKeysEx.TWO_SIDE_SPLITTER_PROPORTION, (Object)Float.valueOf(proportion));
    }

    @NotNull
    protected List<T> createEditorHolders(@NotNull EditorHolderFactory<T> factory2) {
        if (factory2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(3);
        }
        List contents = this.myRequest.getContents();
        ArrayList<T> holders = new ArrayList<T>(2);
        for (int i2 = 0; i2 < 2; ++i2) {
            DiffContent content2 = (DiffContent)contents.get(i2);
            holders.add(factory2.create(content2, this.myContext));
        }
        ArrayList<T> arrayList = holders;
        if (arrayList == null) {
            TwosideDiffViewer.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void destroyEditorHolders() {
        for (EditorHolder holder : this.myHolders) {
            Disposer.dispose((Disposable)holder);
        }
    }

    @NotNull
    protected List<JComponent> createTitles() {
        List<JComponent> list2 = DiffUtil.createSimpleTitles(this, this.myRequest);
        if (list2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public JComponent getComponent() {
        SimpleDiffPanel simpleDiffPanel = this.myPanel;
        if (simpleDiffPanel == null) {
            TwosideDiffViewer.$$$reportNull$$$0(6);
        }
        return simpleDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return ((EditorHolder)this.getCurrentEditorHolder()).getPreferredFocusedComponent();
    }

    @NotNull
    public Side getCurrentSide() {
        Side side = this.myFocusTrackerSupport.getCurrentSide();
        if (side == null) {
            TwosideDiffViewer.$$$reportNull$$$0(7);
        }
        return side;
    }

    protected void setCurrentSide(@NotNull Side side) {
        if (side == null) {
            TwosideDiffViewer.$$$reportNull$$$0(8);
        }
        this.myFocusTrackerSupport.setCurrentSide(side);
    }

    @NotNull
    protected List<T> getEditorHolders() {
        List<T> list2 = this.myHolders;
        if (list2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(9);
        }
        return list2;
    }

    @NotNull
    protected T getCurrentEditorHolder() {
        EditorHolder editorHolder = (EditorHolder)this.getCurrentSide().select(this.getEditorHolders());
        if (editorHolder == null) {
            TwosideDiffViewer.$$$reportNull$$$0(10);
        }
        return (T)editorHolder;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            TwosideDiffViewer.$$$reportNull$$$0(11);
        }
        if (DiffDataKeys.CURRENT_CONTENT.is(dataId)) {
            return this.getCurrentSide().select(this.myRequest.getContents());
        }
        return super.getData(dataId);
    }

    @Override
    @Nullable
    protected Navigatable getNavigatable() {
        Navigatable navigatable1 = ((DiffContent)this.getCurrentSide().select(this.getRequest().getContents())).getNavigatable();
        if (navigatable1 != null) {
            return navigatable1;
        }
        return ((DiffContent)this.getCurrentSide().other().select(this.getRequest().getContents())).getNavigatable();
    }

    public static <T extends EditorHolder> boolean canShowRequest(@NotNull DiffContext context2, @NotNull DiffRequest request2, @NotNull EditorHolderFactory<T> factory2) {
        if (context2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(12);
        }
        if (request2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(13);
        }
        if (factory2 == null) {
            TwosideDiffViewer.$$$reportNull$$$0(14);
        }
        if (!(request2 instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request2).getContents();
        if (contents.size() != 2) {
            return false;
        }
        boolean canShow = true;
        boolean wantShow = false;
        for (DiffContent content2 : contents) {
            canShow &= factory2.canShowContent(content2, context2);
            wantShow |= factory2.wantShowContent(content2, context2);
        }
        return canShow && wantShow;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/side/TwosideDiffViewer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "side";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/side/TwosideDiffViewer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorHolders";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTitles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentSide";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorHolders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditorHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditorHolders";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentSide";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canShowRequest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

