/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.FineMergeLineFragment;
import com.intellij.diff.tools.util.text.FineMergeLineFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleThreesideTextDiffProvider
extends TextDiffProviderBase {
    private static final IgnorePolicy[] IGNORE_POLICIES = new IgnorePolicy[]{IgnorePolicy.DEFAULT, IgnorePolicy.TRIM_WHITESPACES, IgnorePolicy.IGNORE_WHITESPACES};
    private static final HighlightPolicy[] HIGHLIGHT_POLICIES = new HighlightPolicy[]{HighlightPolicy.BY_LINE, HighlightPolicy.BY_WORD};
    private final DiffUserDataKeys.ThreeSideDiffColors myColorsMode;

    public SimpleThreesideTextDiffProvider(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull DiffUserDataKeys.ThreeSideDiffColors colorsMode, @NotNull Runnable rediff, @NotNull Disposable disposable2) {
        if (settings == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(0);
        }
        if (colorsMode == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(1);
        }
        if (rediff == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(2);
        }
        if (disposable2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(3);
        }
        super(settings, rediff, disposable2, IGNORE_POLICIES, HIGHLIGHT_POLICIES);
        this.myColorsMode = colorsMode;
    }

    @NotNull
    public List<FineMergeLineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ProgressIndicator indicator2) {
        if (text1 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(4);
        }
        if (text2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(5);
        }
        if (text3 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(6);
        }
        if (indicator2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(7);
        }
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        ComparisonPolicy comparisonPolicy = ignorePolicy.getComparisonPolicy();
        List<CharSequence> sequences = Arrays.asList(text1, text2, text3);
        List lineOffsets = ContainerUtil.map(sequences, LineOffsetsUtil::create);
        indicator2.checkCanceled();
        List lineFragments = ComparisonManager.getInstance().compareLines(text1, text2, text3, comparisonPolicy, indicator2);
        indicator2.checkCanceled();
        ArrayList<FineMergeLineFragment> result2 = new ArrayList<FineMergeLineFragment>(lineFragments.size());
        for (MergeLineFragment fragment2 : lineFragments) {
            MergeInnerDifferences innerDifferences;
            MergeConflictType conflictType = this.getConflictType(comparisonPolicy, sequences, lineOffsets, fragment2);
            if (highlightPolicy.isFineFragments()) {
                List<CharSequence> chunks = SimpleThreesideTextDiffProvider.getChunks(fragment2, sequences, lineOffsets, conflictType);
                innerDifferences = DiffUtil.compareThreesideInner(chunks, comparisonPolicy, indicator2);
            } else {
                innerDifferences = null;
            }
            result2.add(new FineMergeLineFragmentImpl(fragment2, conflictType, innerDifferences));
        }
        ArrayList<FineMergeLineFragment> arrayList = result2;
        if (arrayList == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private MergeConflictType getConflictType(@NotNull ComparisonPolicy comparisonPolicy, @NotNull List<CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull MergeLineFragment fragment2) {
        if (comparisonPolicy == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(9);
        }
        if (sequences == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(10);
        }
        if (lineOffsets == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(11);
        }
        if (fragment2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(12);
        }
        switch (this.myColorsMode) {
            case MERGE_CONFLICT: {
                MergeConflictType mergeConflictType = DiffUtil.getLineThreeWayDiffType(fragment2, sequences, lineOffsets, comparisonPolicy);
                if (mergeConflictType == null) {
                    SimpleThreesideTextDiffProvider.$$$reportNull$$$0(13);
                }
                return mergeConflictType;
            }
            case MERGE_RESULT: {
                MergeConflictType conflictType = DiffUtil.getLineThreeWayDiffType(fragment2, sequences, lineOffsets, comparisonPolicy);
                return SimpleThreesideTextDiffProvider.invertConflictType(conflictType);
            }
            case LEFT_TO_RIGHT: {
                MergeConflictType mergeConflictType = DiffUtil.getLineLeftToRightThreeSideDiffType(fragment2, sequences, lineOffsets, comparisonPolicy);
                if (mergeConflictType == null) {
                    SimpleThreesideTextDiffProvider.$$$reportNull$$$0(14);
                }
                return mergeConflictType;
            }
        }
        throw new IllegalStateException(this.myColorsMode.name());
    }

    @NotNull
    private static List<CharSequence> getChunks(@NotNull MergeLineFragment fragment2, @NotNull List<CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull MergeConflictType conflictType) {
        if (fragment2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(15);
        }
        if (sequences == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(16);
        }
        if (lineOffsets == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(17);
        }
        if (conflictType == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(18);
        }
        List list2 = ThreeSide.map(side -> {
            int endLine;
            if (!conflictType.isChange((ThreeSide)side)) {
                return null;
            }
            int startLine = fragment2.getStartLine(side);
            if (startLine == (endLine = fragment2.getEndLine(side))) {
                return null;
            }
            return DiffUtil.getLinesContent((CharSequence)side.select(sequences), (LineOffsets)side.select(lineOffsets), startLine, endLine);
        });
        if (list2 == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(19);
        }
        return list2;
    }

    @NotNull
    private static MergeConflictType invertConflictType(@NotNull MergeConflictType oldConflictType) {
        TextDiffType oldDiffType;
        if (oldConflictType == null) {
            SimpleThreesideTextDiffProvider.$$$reportNull$$$0(20);
        }
        if ((oldDiffType = oldConflictType.getDiffType()) != TextDiffType.INSERTED && oldDiffType != TextDiffType.DELETED) {
            MergeConflictType mergeConflictType = oldConflictType;
            if (mergeConflictType == null) {
                SimpleThreesideTextDiffProvider.$$$reportNull$$$0(21);
            }
            return mergeConflictType;
        }
        return new MergeConflictType(oldDiffType == TextDiffType.DELETED ? TextDiffType.INSERTED : TextDiffType.DELETED, oldConflictType.isChange(Side.LEFT), oldConflictType.isChange(Side.RIGHT), oldConflictType.canBeResolved());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rediff";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparisonPolicy";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequences";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConflictType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/text/SimpleThreesideTextDiffProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "compare";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChunks";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "invertConflictType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getConflictType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChunks";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invertConflictType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

