/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.tools.simple.SimpleAlignedDiffModel;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u000b2\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/diff/util/DiffInlayMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "type", "Lcom/intellij/diff/util/TextDiffType;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "isLastLine", "", "(Lcom/intellij/diff/util/TextDiffType;Lcom/intellij/openapi/editor/Inlay;Z)V", "getBeforeAndAfterInlaysHeight", "Lkotlin/Pair;", "", "inlayThreshold", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "getVisualLineAreaStartY", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.platform.diff.impl"})
public final class DiffInlayMarkerRenderer
implements LineMarkerRendererEx {
    private final TextDiffType type;
    private final Inlay<?> inlay;
    private final boolean isLastLine;

    public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorEx cfr_ignored_0 = (EditorEx)editor2;
        Graphics2D cfr_ignored_1 = (Graphics2D)g;
        if (this.inlay instanceof RangeMarker) {
            EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor2).getGutterComponentEx();
            Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"editor.gutterComponentEx");
            EditorGutterComponentEx gutter = editorGutterComponentEx;
            int inlayHeight = this.inlay.getHeightInPixels();
            Color preservedBackground = ((Graphics2D)g).getBackground();
            ((Graphics2D)g).setColor(SimpleAlignedDiffModel.Companion.getAlignedChangeColor(this.type, editor2));
            g.fillRect(0, this.getVisualLineAreaStartY(this.inlay), gutter.getWidth(), inlayHeight);
            ((Graphics2D)g).setColor(preservedBackground);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getVisualLineAreaStartY(Inlay<?> inlay) {
        void beforeHeight;
        Editor editor2 = inlay.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlay.editor");
        Editor editor3 = editor2;
        int visualLineY = editor3.visualLineToY(inlay.getVisualPosition().line);
        int inlayHeight = inlay.getHeightInPixels();
        Pair<Integer, Integer> pair = this.getBeforeAndAfterInlaysHeight(inlay);
        int n = ((Number)pair.component1()).intValue();
        int afterHeight = ((Number)pair.component2()).intValue();
        return this.isLastLine ? visualLineY - (afterHeight - beforeHeight) + editor3.getLineHeight() : (afterHeight == beforeHeight ? visualLineY - afterHeight - inlayHeight : visualLineY - (afterHeight + inlayHeight));
    }

    private final Pair<Integer, Integer> getBeforeAndAfterInlaysHeight(Inlay<?> inlayThreshold) {
        boolean bl = false;
        List before = new ArrayList();
        boolean bl2 = false;
        List after2 = new ArrayList();
        boolean isBefore = true;
        Editor editor2 = inlayThreshold.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"inlayThreshold.editor");
        for (Inlay inlay : editor2.getInlayModel().getBlockElementsForVisualLine(inlayThreshold.getVisualPosition().line, !this.isLastLine)) {
            boolean bl3;
            Collection collection;
            if (Intrinsics.areEqual((Object)inlay, inlayThreshold)) {
                isBefore = false;
                continue;
            }
            if (isBefore) {
                collection = before;
                bl3 = false;
                collection.add(inlay);
                continue;
            }
            collection = after2;
            bl3 = false;
            collection.add(inlay);
        }
        return TuplesKt.to((Object)EditorUtil.getTotalInlaysHeight(before), (Object)EditorUtil.getTotalInlaysHeight(after2));
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }

    public DiffInlayMarkerRenderer(@NotNull TextDiffType type, @NotNull Inlay<?> inlay, boolean isLastLine) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
        this.type = type;
        this.inlay = inlay;
        this.isLastLine = isLastLine;
    }
}

