/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.daemon.impl.HintRenderer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.ui.Gray;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffLineSeparatorRenderer
implements LineMarkerRendererEx,
LineSeparatorRenderer {
    private static Object[] ourCachedImageKey = null;
    private static BufferedImage outCachedImage = null;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BooleanGetter myCondition;
    @Nullable
    private final Computable<String> myDescription;
    public static final ColorKey BACKGROUND = ColorKey.createColorKey((String)"DIFF_SEPARATORS_BACKGROUND");

    public DiffLineSeparatorRenderer(@NotNull Editor editor2, @NotNull BooleanGetter condition, @Nullable Computable<String> description) {
        if (editor2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(1);
        }
        this.myEditor = editor2;
        this.myCondition = condition;
        this.myDescription = description;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2, int lineHeight, @Nullable EditorColorsScheme scheme2) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(2);
        }
        int step2 = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        int verticalOffset = DiffLineSeparatorRenderer.getVerticalOffset(lineHeight, step2, height);
        int start1 = y1 + verticalOffset + step2 / 2;
        int start2 = y2 + verticalOffset + step2 / 2;
        int end1 = start1 + height - 1;
        int end2 = start2 + height - 1;
        Color color = DiffLineSeparatorRenderer.getBackgroundColor(scheme2);
        DiffDrawUtil.drawCurveTrapezium(g, x1, x2, start1, end1, start2, end2, color, null);
    }

    public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
        if (editor2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(3);
        }
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(4);
        }
        if (r == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(5);
        }
        if (!this.myCondition.get()) {
            return;
        }
        int y = r.y;
        int lineHeight = this.myEditor.getLineHeight();
        EditorGutterComponentEx gutter = ((EditorEx)editor2).getGutterComponentEx();
        int annotationsOffset = gutter.getAnnotationsAreaOffset();
        int annotationsWidth = gutter.getAnnotationsAreaWidth();
        if (annotationsWidth != 0) {
            g.setColor(editor2.getColorsScheme().getColor(EditorColors.GUTTER_BACKGROUND));
            g.fillRect(annotationsOffset, y, annotationsWidth, lineHeight);
        }
        DiffLineSeparatorRenderer.draw(g, 0, y, lineHeight, this.myEditor.getColorsScheme());
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        String description;
        if (!this.myCondition.get()) {
            return;
        }
        ++y;
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        int interval = DiffLineSeparatorRenderer.getStepSize(lineHeight) * 2;
        int shiftX = -interval;
        if (DiffUtil.isMirrored(this.myEditor)) {
            int contentWidth = ((EditorEx)this.myEditor).getScrollPane().getViewport().getWidth();
            shiftX += contentWidth % interval - interval;
            shiftX += gutterWidth % interval - interval;
        } else {
            shiftX += -gutterWidth % interval - interval;
        }
        String string = description = this.myDescription != null && this.myEditor instanceof EditorImpl ? (String)this.myDescription.compute() : null;
        if (description != null) {
            DiffLineSeparatorRenderer.drawWithDescription((Graphics2D)g, x1, y, shiftX, lineHeight, (EditorImpl)this.myEditor, description);
        } else {
            DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, this.myEditor.getColorsScheme());
        }
    }

    private static void drawWithDescription(Graphics2D g, int x, int y, int shiftX, int lineHeight, @NotNull EditorImpl editor2, @NotNull String description) {
        if (editor2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(6);
        }
        if (description == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(7);
        }
        EditorColorsScheme scheme2 = editor2.getColorsScheme();
        int rectX = x + JBUIScale.scale((int)5);
        int rectWidth = HintRenderer.calcWidthInPixels(editor2, description, null);
        Shape oldClip = g.getClip();
        g.clip(new Rectangle(0, 0, rectX, Integer.MAX_VALUE));
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, editor2.getColorsScheme());
        g.setClip(oldClip);
        g.clip(new Rectangle(rectX + rectWidth, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        DiffLineSeparatorRenderer.draw(g, shiftX, y, lineHeight, editor2.getColorsScheme());
        g.setClip(oldClip);
        HintRenderer.paintHint(g, editor2, new Rectangle(rectX, y, rectWidth, lineHeight), description, scheme2.getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT), scheme2.getAttributes(HighlighterColors.TEXT), null);
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
        if (position == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(8);
        }
        return position;
    }

    private static void draw(@NotNull Graphics g, int shiftX, int shiftY, int lineHeight, @NotNull EditorColorsScheme scheme2) {
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(9);
        }
        if (scheme2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(10);
        }
        int step2 = DiffLineSeparatorRenderer.getStepSize(lineHeight);
        int height = DiffLineSeparatorRenderer.getHeight(lineHeight);
        Color color = DiffLineSeparatorRenderer.getBackgroundColor(scheme2);
        Rectangle clip = g.getClipBounds();
        if (clip.width <= 0) {
            return;
        }
        int startX = clip.x - shiftX;
        int endX = startX + clip.width;
        int startIndex = startX / step2;
        int endIndex = endX / step2 + 1;
        Graphics2D gg = (Graphics2D)g.create();
        gg.translate(shiftX, shiftY + DiffLineSeparatorRenderer.getVerticalOffset(lineHeight, step2, height));
        if (startIndex == 0) {
            gg.setColor(color);
            LinePainter2D.fillPolygon((Graphics2D)gg, (double[])new double[]{0.0, step2, step2, 0.0}, (double[])new double[]{step2 / 2, step2, step2 + height, step2 / 2 + height}, (int)4, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)1.0, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
        } else if (startIndex % 2 == 0) {
            --startIndex;
        }
        BufferedImage image = DiffLineSeparatorRenderer.createImage(gg, color, step2, height);
        gg.setComposite(AlphaComposite.SrcOver);
        for (int index2 = startIndex; index2 < endIndex; ++index2) {
            if (index2 % 2 == 0) continue;
            UIUtil.drawImage((Graphics)gg, (Image)image, (int)(index2 * step2), (int)0, null);
        }
        gg.dispose();
    }

    @NotNull
    private static BufferedImage createImage(@NotNull Graphics2D g, @NotNull Color color, int step2, int height) {
        Object[] key;
        if (g == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(11);
        }
        if (color == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(12);
        }
        if (Arrays.equals(ourCachedImageKey, key = new Object[]{color.getRGB(), Float.valueOf(JBUIScale.sysScale((Graphics2D)g)), step2, height}) && outCachedImage != null) {
            BufferedImage bufferedImage = outCachedImage;
            if (bufferedImage == null) {
                DiffLineSeparatorRenderer.$$$reportNull$$$0(13);
            }
            return bufferedImage;
        }
        int imageWidth = step2 * 2;
        int imageHeight = step2 + height;
        BufferedImage image = ImageUtil.createImage((Graphics)g, (int)imageWidth, (int)imageHeight, (int)2);
        Graphics2D gg = image.createGraphics();
        gg.setColor(color);
        LinePainter2D.fillPolygon((Graphics2D)gg, (double[])new double[]{0.0, step2, step2 * 2, step2 * 2, step2, 0.0}, (double[])new double[]{step2, 0.0, step2, step2 + height, height, step2 + height}, (int)6, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED_CAPS_SQUARE, (double)1.0, (Object)RenderingHints.VALUE_ANTIALIAS_OFF);
        outCachedImage = image;
        ourCachedImageKey = key;
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(14);
        }
        return bufferedImage;
    }

    private static int getStepSize(int lineHeight) {
        return Math.max(lineHeight / 3, 1);
    }

    private static int getHeight(int lineHeight) {
        return Math.max(lineHeight / 2, 1);
    }

    private static int getVerticalOffset(int lineHeight, int step2, int height) {
        return (lineHeight - height - step2) / 2;
    }

    @NotNull
    private static Color getBackgroundColor(@Nullable EditorColorsScheme scheme2) {
        Color color;
        if (scheme2 == null) {
            scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        }
        Color color2 = (color = scheme2.getColor(BACKGROUND)) != null ? color : Gray._128;
        if (color2 == null) {
            DiffLineSeparatorRenderer.$$$reportNull$$$0(15);
        }
        return color2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffLineSeparatorRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createImage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "drawConnectorLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drawWithDescription";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "draw";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createImage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

