/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.CompareBranchesDiffPanel;
import com.intellij.dvcs.ui.CompareBranchesHelper;
import com.intellij.dvcs.ui.CompareBranchesLogPanel;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.util.CommitCompareInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.WindowWrapperBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.TabbedPaneImpl;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class CompareBranchesDialog {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JPanel myLogPanel;
    @NotNull
    private final TabbedPaneImpl myTabbedPane;
    @NotNull
    @NlsContexts.DialogTitle
    private final String myTitle;
    @NotNull
    private final WindowWrapper.Mode myMode;
    private WindowWrapper myWrapper;

    public CompareBranchesDialog(@NotNull CompareBranchesHelper helper2, @NotNull String branchName, @NotNull String currentBranchName, @NotNull CommitCompareInfo compareInfo, @NotNull Repository initialRepo, boolean dialog2) {
        if (helper2 == null) {
            CompareBranchesDialog.$$$reportNull$$$0(0);
        }
        if (branchName == null) {
            CompareBranchesDialog.$$$reportNull$$$0(1);
        }
        if (currentBranchName == null) {
            CompareBranchesDialog.$$$reportNull$$$0(2);
        }
        if (compareInfo == null) {
            CompareBranchesDialog.$$$reportNull$$$0(3);
        }
        if (initialRepo == null) {
            CompareBranchesDialog.$$$reportNull$$$0(4);
        }
        this.myProject = helper2.getProject();
        this.myTitle = compareInfo.getRepositories().size() == 1 && helper2.getRepositoryManager().moreThanOneRoot() ? DvcsBundle.message((String)"compare.branches.dialog.title.branch.with.branch.in.root", (Object[])new Object[]{currentBranchName, branchName, DvcsUtil.getShortRepositoryName(initialRepo)}) : DvcsBundle.message((String)"compare.branches.dialog.title.branch.with.branch", (Object[])new Object[]{currentBranchName, branchName});
        this.myMode = dialog2 ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        CompareBranchesDiffPanel diffPanel = new CompareBranchesDiffPanel(helper2.getProject(), helper2.getDvcsCompareSettings(), branchName, currentBranchName);
        diffPanel.setCompareInfo(compareInfo);
        this.myLogPanel = new CompareBranchesLogPanel(helper2, branchName, currentBranchName, compareInfo, initialRepo);
        this.myTabbedPane = new TabbedPaneImpl(1);
        this.myTabbedPane.addTab(DvcsBundle.message((String)"compare.branches.tab.name.log", (Object[])new Object[0]), AllIcons.Vcs.Branch, this.myLogPanel);
        this.myTabbedPane.addTab(DvcsBundle.message((String)"compare.branches.tab.name.files", (Object[])new Object[0]), AllIcons.Actions.ListChanges, diffPanel);
        this.myTabbedPane.setKeyboardNavigation(TabbedPaneImpl.DEFAULT_PREV_NEXT_SHORTCUTS);
    }

    public void show() {
        if (this.myWrapper == null) {
            this.myWrapper = new WindowWrapperBuilder(this.myMode, (JComponent)((Object)this.myTabbedPane)).setProject(this.myProject).setTitle(this.myTitle).setPreferredFocusedComponent(this.myLogPanel).setDimensionServiceKey(CompareBranchesDialog.class.getName()).build();
        }
        this.myWrapper.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "branchName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "currentBranchName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "compareInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "initialRepo";
                break;
            }
        }
        objectArray[1] = "com/intellij/dvcs/ui/CompareBranchesDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

