/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsShortCommitDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogAction<Repo extends Repository>
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        log.requestSelectedDetails(details2 -> {
            MultiMap grouped = this.groupCommits(project, (Collection)details2, VcsShortCommitDetails::getRoot);
            if (grouped == null) {
                return;
            }
            this.actionPerformed(project, grouped);
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            VcsLogAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MultiMap<Repo, Hash> grouped = this.groupFirstPackOfCommits(project, log);
        if (grouped == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setVisible(this.isVisible(project, grouped));
            e.getPresentation().setEnabled(!grouped.isEmpty() && this.isEnabled(grouped));
        }
    }

    protected abstract void actionPerformed(@NotNull Project var1, @NotNull MultiMap<Repo, VcsFullCommitDetails> var2);

    protected abstract boolean isEnabled(@NotNull MultiMap<Repo, Hash> var1);

    protected boolean isVisible(@NotNull Project project, @NotNull MultiMap<Repo, Hash> grouped) {
        if (project == null) {
            VcsLogAction.$$$reportNull$$$0(2);
        }
        if (grouped == null) {
            VcsLogAction.$$$reportNull$$$0(3);
        }
        AbstractRepositoryManager<Repo> manager2 = this.getRepositoryManager(project);
        return grouped.keySet().stream().noneMatch(arg_0 -> manager2.isExternal(arg_0));
    }

    @NotNull
    protected abstract AbstractRepositoryManager<Repo> getRepositoryManager(@NotNull Project var1);

    @Nullable
    protected abstract Repo getRepositoryForRoot(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    private MultiMap<Repo, Hash> groupFirstPackOfCommits(@NotNull Project project, @NotNull VcsLog log) {
        MultiMap commitIds;
        if (project == null) {
            VcsLogAction.$$$reportNull$$$0(4);
        }
        if (log == null) {
            VcsLogAction.$$$reportNull$$$0(5);
        }
        if ((commitIds = this.groupCommits(project, ContainerUtil.getFirstItems((List)log.getSelectedCommits(), (int)1000), CommitId::getRoot)) == null) {
            return null;
        }
        MultiMap hashes = MultiMap.create();
        for (Map.Entry entry2 : commitIds.entrySet()) {
            hashes.putValues((Object)((Repository)entry2.getKey()), (Collection)ContainerUtil.map((Collection)((Collection)entry2.getValue()), CommitId::getHash));
        }
        return hashes;
    }

    @Nullable
    private <T> MultiMap<Repo, T> groupCommits(@NotNull Project project, @NotNull Collection<? extends T> commits, @NotNull Function<? super T, ? extends VirtualFile> rootGetter) {
        if (project == null) {
            VcsLogAction.$$$reportNull$$$0(6);
        }
        if (commits == null) {
            VcsLogAction.$$$reportNull$$$0(7);
        }
        if (rootGetter == null) {
            VcsLogAction.$$$reportNull$$$0(8);
        }
        MultiMap map2 = MultiMap.create();
        for (T commit2 : commits) {
            Repo root2 = this.getRepositoryForRoot(project, (VirtualFile)rootGetter.fun(commit2));
            if (root2 == null) {
                return null;
            }
            map2.putValue(root2, commit2);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouped";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/ui/VcsLogAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisible";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "groupFirstPackOfCommits";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "groupCommits";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

