/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionActionSuppressor;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.actions.RunContextAction;
import com.intellij.execution.actions.RunNewConfigurationContextAction;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.ExecutorGroup;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.ExecutionManagerImplKt;
import com.intellij.execution.runToolbar.RunToolbarAdditionActionsHolder;
import com.intellij.execution.runToolbar.RunToolbarExecutorGroup;
import com.intellij.execution.runToolbar.RunToolbarExecutorGroupAction;
import com.intellij.execution.runToolbar.RunToolbarGroupProcessAction;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarProcessAction;
import com.intellij.execution.runToolbar.RunToolbarProcessMainAction;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.SplitButtonAction;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class ExecutorRegistryImpl
extends ExecutorRegistry {
    private static final Logger LOG = Logger.getInstance(ExecutorRegistryImpl.class);
    public static final String RUNNERS_GROUP = "RunnerActions";
    public static final String RUN_CONTEXT_GROUP = "RunContextGroupInner";
    public static final String RUN_CONTEXT_GROUP_MORE = "RunContextGroupMore";
    private final Set<String> myContextActionIdSet = new HashSet<String>();
    private final Map<String, AnAction> myIdToAction = new HashMap<String, AnAction>();
    private final Map<String, AnAction> myContextActionIdToAction = new HashMap<String, AnAction>();
    private final Map<String, AnAction> myRunWidgetIdToAction = new HashMap<String, AnAction>();

    public ExecutorRegistryImpl() {
        Executor.EXECUTOR_EXTENSION_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<Executor>(){

            public void extensionAdded(@NotNull Executor extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExecutorRegistryImpl.this.initExecutorActions(extension2, ActionManager.getInstance());
            }

            public void extensionRemoved(@NotNull Executor extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                ExecutorRegistryImpl.this.deinitExecutor(extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    @TestOnly
    public synchronized void initExecutorActions(@NotNull Executor executor, @NotNull ActionManager actionManager) {
        ActionGroup runNonExistingContextAction;
        ActionGroup runContextAction;
        UpdateInBackground toolbarAction;
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(0);
        }
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(1);
        }
        if (this.myContextActionIdSet.contains(executor.getContextActionId())) {
            LOG.error("Executor with context action id: \"" + executor.getContextActionId() + "\" was already registered!");
        }
        if (executor instanceof ExecutorGroup) {
            ExecutorGroup executorGroup = (ExecutorGroup)executor;
            SplitButtonAction toolbarActionGroup = new SplitButtonAction(new ExecutorGroupActionGroup(executorGroup, ExecutorAction::new));
            Presentation presentation2 = toolbarActionGroup.getTemplatePresentation();
            presentation2.setIcon(executor.getIcon());
            presentation2.setText(executor.getStartActionText());
            presentation2.setDescription(executor.getDescription());
            toolbarAction = toolbarActionGroup;
            runContextAction = new ExecutorGroupActionGroup(executorGroup, RunContextAction::new);
            runNonExistingContextAction = new ExecutorGroupActionGroup(executorGroup, RunNewConfigurationContextAction::new);
        } else {
            toolbarAction = new ExecutorAction(executor);
            runContextAction = new RunContextAction(executor);
            runNonExistingContextAction = new RunNewConfigurationContextAction(executor);
        }
        Executor.ActionWrapper customizer = executor.runnerActionsGroupExecutorActionCustomizer();
        ExecutorRegistryImpl.registerActionInGroup(actionManager, executor.getId(), (AnAction)(customizer == null ? toolbarAction : customizer.wrap((AnAction)toolbarAction)), RUNNERS_GROUP, this.myIdToAction);
        AnAction action2 = ExecutorRegistryImpl.registerAction(actionManager, executor.getContextActionId(), (AnAction)runContextAction, this.myContextActionIdToAction);
        if (ExecutorRegistryImpl.isExecutorInMainGroup(executor)) {
            ((DefaultActionGroup)actionManager.getAction(RUN_CONTEXT_GROUP)).add(action2, new Constraints(Anchor.BEFORE, RUN_CONTEXT_GROUP_MORE), actionManager);
        } else {
            ((DefaultActionGroup)actionManager.getAction(RUN_CONTEXT_GROUP_MORE)).add(action2, new Constraints(Anchor.BEFORE, "CreateRunConfiguration"), actionManager);
        }
        AnAction nonExistingAction = ExecutorRegistryImpl.registerAction(actionManager, ExecutorRegistryImpl.newConfigurationContextActionId(executor), (AnAction)runNonExistingContextAction, this.myContextActionIdToAction);
        ((DefaultActionGroup)actionManager.getAction(RUN_CONTEXT_GROUP_MORE)).add(nonExistingAction, new Constraints(Anchor.BEFORE, "CreateNewRunConfiguration"), actionManager);
        this.initRunToolbarExecutorActions(executor, actionManager);
        this.myContextActionIdSet.add(executor.getContextActionId());
    }

    private synchronized void initRunToolbarExecutorActions(@NotNull Executor executor, @NotNull ActionManager actionManager) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(2);
        }
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(3);
        }
        if (RunToolbarProcess.isAvailable()) {
            RunToolbarProcess.getProcessesByExecutorId((String)executor.getId()).forEach(process2 -> {
                if (executor instanceof ExecutorGroup) {
                    ExecutorGroup executorGroup = (ExecutorGroup)executor;
                    if (process2.getShowInBar()) {
                        RunToolbarExecutorGroupAction wrappedAction = new RunToolbarExecutorGroupAction(new RunToolbarExecutorGroup((ExecutorGroup<?>)executorGroup, ex -> new RunToolbarGroupProcessAction((RunToolbarProcess)process2, (Executor)ex), (RunToolbarProcess)process2));
                        Presentation presentation2 = wrappedAction.getTemplatePresentation();
                        presentation2.setIcon(executor.getIcon());
                        presentation2.setText(process2.getName());
                        presentation2.setDescription(executor.getDescription());
                        ExecutorRegistryImpl.registerActionInGroup(actionManager, process2.getActionId(), (AnAction)wrappedAction, "RunToolbarProcessActionGroup", this.myRunWidgetIdToAction);
                    } else {
                        RunToolbarAdditionActionsHolder holder = new RunToolbarAdditionActionsHolder((ExecutorGroup<?>)executorGroup, (RunToolbarProcess)process2);
                        ExecutorRegistryImpl.registerActionInGroup(actionManager, RunToolbarAdditionActionsHolder.getAdditionActionId(process2), holder.getAdditionAction(), process2.getMoreActionSubGroupName(), this.myRunWidgetIdToAction);
                        ExecutorRegistryImpl.registerActionInGroup(actionManager, RunToolbarAdditionActionsHolder.getAdditionActionChooserGroupId(process2), (AnAction)holder.getMoreActionChooserGroup(), process2.getMoreActionSubGroupName(), this.myRunWidgetIdToAction);
                    }
                } else if (!process2.isTemporaryProcess()) {
                    RunToolbarProcessAction wrappedAction = new RunToolbarProcessAction((RunToolbarProcess)process2, executor);
                    RunToolbarProcessMainAction wrappedMainAction = new RunToolbarProcessMainAction((RunToolbarProcess)process2, executor);
                    ExecutorRegistryImpl.registerActionInGroup(actionManager, process2.getActionId(), wrappedAction, "RunToolbarProcessActionGroup", this.myRunWidgetIdToAction);
                    ExecutorRegistryImpl.registerActionInGroup(actionManager, process2.getMainActionId(), wrappedMainAction, "RunToolbarProcessMainActionGroup", this.myRunWidgetIdToAction);
                }
            });
        }
    }

    @NonNls
    private static String newConfigurationContextActionId(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(4);
        }
        return "newConfiguration" + executor.getContextActionId();
    }

    private static boolean isExecutorInMainGroup(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(5);
        }
        return !Registry.is((String)"executor.actions.submenu") || executor.getId().equals("Run") || executor.getId().equals("Debug");
    }

    private static void registerActionInGroup(@NotNull ActionManager actionManager, @NotNull String actionId, @NotNull AnAction anAction2, @NotNull String groupId2, @NotNull Map<String, AnAction> map2) {
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(6);
        }
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(7);
        }
        if (anAction2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(8);
        }
        if (groupId2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(9);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(10);
        }
        AnAction action2 = ExecutorRegistryImpl.registerAction(actionManager, actionId, anAction2, map2);
        ((DefaultActionGroup)actionManager.getAction(groupId2)).add(action2, actionManager);
    }

    @NotNull
    private static AnAction registerAction(@NotNull ActionManager actionManager, @NotNull String actionId, @NotNull AnAction anAction2, @NotNull Map<String, AnAction> map2) {
        AnAction action2;
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(11);
        }
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(12);
        }
        if (anAction2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(13);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(14);
        }
        if ((action2 = actionManager.getAction(actionId)) == null) {
            actionManager.registerAction(actionId, anAction2);
            map2.put(actionId, anAction2);
            action2 = anAction2;
        }
        AnAction anAction3 = action2;
        if (anAction3 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(15);
        }
        return anAction3;
    }

    synchronized void deinitExecutor(@NotNull Executor executor) {
        if (executor == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(16);
        }
        this.myContextActionIdSet.remove(executor.getContextActionId());
        ExecutorRegistryImpl.unregisterAction(executor.getId(), RUNNERS_GROUP, this.myIdToAction);
        if (ExecutorRegistryImpl.isExecutorInMainGroup(executor)) {
            ExecutorRegistryImpl.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP, this.myContextActionIdToAction);
        } else {
            ExecutorRegistryImpl.unregisterAction(executor.getContextActionId(), RUN_CONTEXT_GROUP_MORE, this.myContextActionIdToAction);
        }
        ExecutorRegistryImpl.unregisterAction(ExecutorRegistryImpl.newConfigurationContextActionId(executor), RUN_CONTEXT_GROUP_MORE, this.myContextActionIdToAction);
        RunToolbarProcess.getProcessesByExecutorId((String)executor.getId()).forEach(process2 -> {
            ExecutorRegistryImpl.unregisterAction(process2.getActionId(), "RunToolbarProcessActionGroup", this.myRunWidgetIdToAction);
            ExecutorRegistryImpl.unregisterAction(process2.getMainActionId(), "RunToolbarProcessMainActionGroup", this.myRunWidgetIdToAction);
            if (executor instanceof ExecutorGroup) {
                ExecutorRegistryImpl.unregisterAction(RunToolbarAdditionActionsHolder.getAdditionActionId(process2), process2.getMoreActionSubGroupName(), this.myRunWidgetIdToAction);
                ExecutorRegistryImpl.unregisterAction(RunToolbarAdditionActionsHolder.getAdditionActionChooserGroupId(process2), process2.getMoreActionSubGroupName(), this.myRunWidgetIdToAction);
            }
        });
    }

    private static void unregisterAction(@NotNull String actionId, @NotNull String groupId2, @NotNull Map<String, AnAction> map2) {
        ActionManager actionManager;
        DefaultActionGroup group2;
        if (actionId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(17);
        }
        if (groupId2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(18);
        }
        if (map2 == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(19);
        }
        if ((group2 = (DefaultActionGroup)(actionManager = ActionManager.getInstance()).getAction(groupId2)) == null) {
            return;
        }
        AnAction action2 = map2.get(actionId);
        if (action2 != null) {
            group2.remove(action2, actionManager);
            actionManager.unregisterAction(actionId);
            map2.remove(actionId);
        } else {
            action2 = ActionManager.getInstance().getAction(actionId);
            if (action2 != null) {
                group2.remove(action2, actionManager);
            }
        }
    }

    public Executor getExecutorById(@NotNull String executorId) {
        if (executorId == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(20);
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }

    private void init(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            ExecutorRegistryImpl.$$$reportNull$$$0(21);
        }
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            try {
                this.initExecutorActions(executor, actionManager);
            }
            catch (Throwable t) {
                LOG.error("executor initialization failed: " + executor.getClass().getName(), t);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutorRegistryImpl";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "registerAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExecutorActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initRunToolbarExecutorActions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newConfigurationContextActionId";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isExecutorInMainGroup";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerActionInGroup";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deinitExecutor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExecutorById";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RunnerHelper {
        public static void run(@NotNull Project project, @Nullable RunConfiguration configuration2, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext, @NotNull Executor executor) {
            if (project == null) {
                RunnerHelper.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                RunnerHelper.$$$reportNull$$$0(1);
            }
            if (executor == null) {
                RunnerHelper.$$$reportNull$$$0(2);
            }
            if (configuration2 instanceof CompoundRunConfiguration) {
                RunManager runManager = RunManager.getInstance((Project)project);
                for (SettingsAndEffectiveTarget settingsAndEffectiveTarget : ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets()) {
                    RunConfiguration subConfiguration = settingsAndEffectiveTarget.getConfiguration();
                    RunnerHelper.run(project, subConfiguration, runManager.findSettings(subConfiguration), dataContext, executor);
                }
            } else {
                ExecutionEnvironmentBuilder builder2;
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder2 = settings == null ? null : ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
                if (builder2 == null) {
                    return;
                }
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.activeTarget().dataContext(dataContext).build());
            }
        }

        public static boolean canRun(@NotNull Project project, @NotNull List<SettingsAndEffectiveTarget> pairs, @NotNull Executor executor) {
            if (project == null) {
                RunnerHelper.$$$reportNull$$$0(3);
            }
            if (pairs == null) {
                RunnerHelper.$$$reportNull$$$0(4);
            }
            if (executor == null) {
                RunnerHelper.$$$reportNull$$$0(5);
            }
            if (pairs.isEmpty()) {
                return false;
            }
            for (SettingsAndEffectiveTarget pair : pairs) {
                ProgramRunner runner;
                RunConfiguration configuration2 = pair.getConfiguration();
                if (!(configuration2 instanceof CompoundRunConfiguration ? !RunnerHelper.canRun(project, ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets(), executor) : (runner = ProgramRunner.getRunner((String)executor.getId(), (RunProfile)configuration2)) == null || !ExecutionTargetManager.canRun((RunConfiguration)configuration2, (ExecutionTarget)pair.getTarget()) || ExecutionManager.getInstance((Project)project).isStarting(executor.getId(), runner.getRunnerId()))) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$RunnerHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static class ExecutorGroupActionGroup
    extends ActionGroup
    implements DumbAware,
    UpdateInBackground {
        protected final ExecutorGroup<?> myExecutorGroup;
        private final Function<? super Executor, ? extends AnAction> myChildConverter;

        protected ExecutorGroupActionGroup(@NotNull ExecutorGroup<?> executorGroup, @NotNull Function<? super Executor, ? extends AnAction> childConverter) {
            if (executorGroup == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(0);
            }
            if (childConverter == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(1);
            }
            this.myExecutorGroup = executorGroup;
            this.myChildConverter = childConverter;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            List childExecutors = this.myExecutorGroup.childExecutors();
            AnAction[] result2 = new AnAction[childExecutors.size()];
            for (int i2 = 0; i2 < childExecutors.size(); ++i2) {
                result2[i2] = this.myChildConverter.apply((Executor)childExecutors.get(i2));
            }
            if (result2 == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(2);
            }
            return result2;
        }

        public void update(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ExecutorGroupActionGroup.$$$reportNull$$$0(3);
            }
            if ((project = e.getProject()) == null || !project.isInitialized() || project.isDisposed()) {
                e.getPresentation().setEnabled(false);
                return;
            }
            e.getPresentation().setEnabledAndVisible(this.myExecutorGroup.isApplicable(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorGroup";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childConverter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorGroupActionGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorGroupActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ExecutorAction
    extends AnAction
    implements DumbAware,
    UpdateInBackground {
        protected final Executor myExecutor;

        protected ExecutorAction(@NotNull Executor executor) {
            if (executor == null) {
                ExecutorAction.$$$reportNull$$$0(0);
            }
            super(executor.getStartActionText(), executor.getDescription(), IconLoader.createLazy(() -> executor.getIcon()));
            this.myExecutor = executor;
        }

        private boolean canRun(@NotNull Project project, @NotNull List<SettingsAndEffectiveTarget> pairs) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(1);
            }
            if (pairs == null) {
                ExecutorAction.$$$reportNull$$$0(2);
            }
            return RunnerHelper.canRun(project, pairs, this.myExecutor);
        }

        public void update(@NotNull AnActionEvent e) {
            String text2;
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(3);
            }
            Presentation presentation2 = e.getPresentation();
            Project project = e.getProject();
            if (project == null || !project.isInitialized() || project.isDisposed()) {
                presentation2.setEnabled(false);
                return;
            }
            RunnerAndConfigurationSettings selectedSettings = this.getSelectedConfiguration(e);
            boolean enabled = false;
            boolean hideDisabledExecutorButtons = false;
            if (selectedSettings != null) {
                if (DumbService.isDumb((Project)project) && !selectedSettings.getType().isDumbAware()) {
                    presentation2.setEnabled(false);
                    return;
                }
                presentation2.setIcon(this.getInformativeIcon(project, selectedSettings));
                RunConfiguration configuration2 = selectedSettings.getConfiguration();
                if (!ExecutorAction.isSuppressed(project)) {
                    if (configuration2 instanceof CompoundRunConfiguration) {
                        enabled = this.canRun(project, ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets());
                    } else {
                        ExecutionTarget target2 = ExecutionTargetManager.getActiveTarget((Project)project);
                        enabled = this.canRun(project, Collections.singletonList(new SettingsAndEffectiveTarget(configuration2, target2)));
                    }
                }
                if (!(configuration2 instanceof CompoundRunConfiguration)) {
                    hideDisabledExecutorButtons = configuration2.hideDisabledExecutorButtons();
                }
                if (enabled) {
                    presentation2.setDescription(this.myExecutor.getDescription());
                }
                text2 = this.myExecutor.getStartActionText(configuration2.getName());
            } else {
                text2 = this.getTemplatePresentation().getTextWithMnemonic();
            }
            if (hideDisabledExecutorButtons) {
                presentation2.setEnabledAndVisible(enabled);
            } else {
                presentation2.setEnabled(enabled);
            }
            if (presentation2.isVisible()) {
                presentation2.setVisible(this.myExecutor.isApplicable(project));
            }
            presentation2.setText(text2);
        }

        private static boolean isSuppressed(Project project) {
            for (ExecutionActionSuppressor suppressor : ExecutionActionSuppressor.EP_NAME.getExtensionList()) {
                if (!suppressor.isSuppressed(project)) continue;
                return true;
            }
            return false;
        }

        protected Icon getInformativeIcon(@NotNull Project project, @NotNull RunnerAndConfigurationSettings selectedConfiguration2) {
            RunnerIconProvider provider2;
            Icon icon2;
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(4);
            }
            if (selectedConfiguration2 == null) {
                ExecutorAction.$$$reportNull$$$0(5);
            }
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            RunConfiguration configuration2 = selectedConfiguration2.getConfiguration();
            if (configuration2 instanceof RunnerIconProvider && (icon2 = (provider2 = (RunnerIconProvider)configuration2).getExecutorIcon(configuration2, this.myExecutor)) != null) {
                return icon2;
            }
            List runningDescriptors2 = executionManager.getRunningDescriptors((Condition<? super RunnerAndConfigurationSettings>)((Condition)s -> ExecutionManagerImplKt.isOfSameType(s, selectedConfiguration2)));
            runningDescriptors2 = ContainerUtil.filter(runningDescriptors2, descriptor2 -> executionManager.getExecutors((RunContentDescriptor)descriptor2).contains(this.myExecutor));
            if (!configuration2.isAllowRunningInParallel() && !runningDescriptors2.isEmpty() && "Run".equals(this.myExecutor.getId())) {
                return AllIcons.Actions.Restart;
            }
            if (runningDescriptors2.isEmpty()) {
                return this.myExecutor.getIcon();
            }
            if (runningDescriptors2.size() == 1) {
                return ExecutionUtil.getLiveIndicator((Icon)this.myExecutor.getIcon());
            }
            return IconUtil.addText(this.myExecutor.getIcon(), Integer.toString(runningDescriptors2.size()));
        }

        @Nullable
        protected RunnerAndConfigurationSettings getSelectedConfiguration(@NotNull AnActionEvent e) {
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(6);
            }
            if (e.getProject() == null) {
                return null;
            }
            return RunManager.getInstance((Project)e.getProject()).getSelectedConfiguration();
        }

        private void run(@NotNull Project project, @Nullable RunConfiguration configuration2, @Nullable RunnerAndConfigurationSettings settings, @NotNull DataContext dataContext) {
            if (project == null) {
                ExecutorAction.$$$reportNull$$$0(7);
            }
            if (dataContext == null) {
                ExecutorAction.$$$reportNull$$$0(8);
            }
            RunnerHelper.run(project, configuration2, settings, dataContext, this.myExecutor);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                ExecutorAction.$$$reportNull$$$0(9);
            }
            if ((project = e.getProject()) == null || project.isDisposed()) {
                return;
            }
            MacroManager.getInstance().cacheMacrosPreview(e.getDataContext());
            RunnerAndConfigurationSettings selectedConfiguration2 = this.getSelectedConfiguration(e);
            if (selectedConfiguration2 != null) {
                this.run(project, selectedConfiguration2.getConfiguration(), selectedConfiguration2, e.getDataContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pairs";
                    break;
                }
                case 3: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedConfiguration";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ExecutorRegistryImpl$ExecutorAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInformativeIcon";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedConfiguration";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ExecutorRegistryActionConfigurationTuner
    implements ActionConfigurationCustomizer {
        ExecutorRegistryActionConfigurationTuner() {
        }

        @Override
        public void customize(@NotNull ActionManager manager2) {
            if (manager2 == null) {
                ExecutorRegistryActionConfigurationTuner.$$$reportNull$$$0(0);
            }
            if (Executor.EXECUTOR_EXTENSION_NAME.hasAnyExtensions()) {
                ((ExecutorRegistryImpl)ExecutorRegistry.getInstance()).init(manager2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/execution/ExecutorRegistryImpl$ExecutorRegistryActionConfigurationTuner", "customize"));
        }
    }
}

