/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.SuggestUsingRunDashBoardUtil;
import com.intellij.execution.actions.BaseRunConfigurationAction;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.statistics.RunConfigurationOptionUsagesCollector;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContextAction
extends BaseRunConfigurationAction {
    private final Executor myExecutor;

    public RunContextAction(@NotNull Executor executor) {
        if (executor == null) {
            RunContextAction.$$$reportNull$$$0(0);
        }
        super(ExecutionBundle.messagePointer((String)"perform.action.with.context.configuration.action.name", (Object[])new Object[]{executor.getStartActionText()}), Presentation.NULL_STRING, IconLoader.createLazy(() -> executor.getIcon()));
        this.myExecutor = executor;
    }

    @Override
    protected void perform(ConfigurationContext context2) {
        RunManagerEx runManager = (RunManagerEx)context2.getRunManager();
        DataContext dataContext = context2.getDefaultDataContext();
        ReadAction.nonBlocking(() -> this.findExisting(context2)).finishOnUiThread(ModalityState.NON_MODAL, existingConfiguration -> this.perform(runManager, (RunnerAndConfigurationSettings)existingConfiguration, dataContext)).submit((java.util.concurrent.Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Override
    protected void perform(RunnerAndConfigurationSettings configuration2, ConfigurationContext context2) {
        RunManagerEx runManager = (RunManagerEx)context2.getRunManager();
        if (configuration2 == null) {
            RunnerAndConfigurationSettings contextConfiguration = context2.getConfiguration();
            if (contextConfiguration == null) {
                return;
            }
            runManager.setTemporaryConfiguration(contextConfiguration);
            this.perform(runManager, contextConfiguration, context2.getDataContext());
        } else {
            DataContext dataContext = context2.getDefaultDataContext();
            ReadAction.nonBlocking(() -> this.findExisting(context2)).finishOnUiThread(ModalityState.NON_MODAL, existingConfiguration -> {
                if (configuration2 != existingConfiguration) {
                    RunConfigurationOptionUsagesCollector.logAddNew(context2.getProject(), configuration2.getType().getId(), context2.getPlace());
                    runManager.setTemporaryConfiguration(configuration2);
                    this.perform(runManager, configuration2, dataContext);
                } else {
                    this.perform(runManager, configuration2, dataContext);
                }
            }).submit((java.util.concurrent.Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private void perform(RunManagerEx runManager, RunnerAndConfigurationSettings configuration2, DataContext dataContext) {
        if (runManager.shouldSetRunConfigurationFromContext()) {
            runManager.setSelectedConfiguration(configuration2);
        }
        if (LOG.isDebugEnabled()) {
            String configurationClass = configuration2.getConfiguration().getClass().getName();
            LOG.debug(String.format("Execute run configuration: %s", configurationClass));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ExecutionUtil.doRunConfiguration((RunnerAndConfigurationSettings)configuration2, (Executor)this.myExecutor, null, null, (DataContext)dataContext);
    }

    @Override
    protected boolean isEnabledFor(@NotNull RunConfiguration configuration2) {
        if (configuration2 == null) {
            RunContextAction.$$$reportNull$$$0(1);
        }
        return this.getRunner(configuration2) != null;
    }

    @Nullable
    private ProgramRunner<?> getRunner(@NotNull RunConfiguration configuration2) {
        if (configuration2 == null) {
            RunContextAction.$$$reportNull$$$0(2);
        }
        return ProgramRunner.getRunner((String)this.myExecutor.getId(), (RunProfile)configuration2);
    }

    @Override
    protected void updatePresentation(Presentation presentation2, @NotNull String actionText, ConfigurationContext context2) {
        if (actionText == null) {
            RunContextAction.$$$reportNull$$$0(3);
        }
        presentation2.setText(this.myExecutor.getStartActionText(actionText), true);
        Pair<Boolean, Boolean> b = this.isEnabledAndVisible(context2);
        presentation2.setEnabled(((Boolean)b.first).booleanValue());
        presentation2.setVisible(((Boolean)b.second).booleanValue());
    }

    @Override
    protected void approximatePresentationByPreviousAvailability(AnActionEvent event, ThreeState hadAnythingRunnable) {
        super.approximatePresentationByPreviousAvailability(event, hadAnythingRunnable);
        event.getPresentation().setText(this.myExecutor.getStartActionText() + "...");
    }

    private Pair<Boolean, Boolean> isEnabledAndVisible(ConfigurationContext context2) {
        ProgramRunner<?> runner;
        RunnerAndConfigurationSettings configuration2 = this.findExisting(context2);
        if (configuration2 == null) {
            configuration2 = context2.getConfiguration();
        }
        ProgramRunner<?> programRunner = runner = configuration2 == null ? null : this.getRunner(configuration2.getConfiguration());
        if (runner == null) {
            return Pair.create((Object)false, (Object)false);
        }
        Project project = context2.getProject();
        return Pair.create((Object)(!ExecutionManager.getInstance((Project)project).isStarting(this.myExecutor.getId(), runner.getRunnerId()) ? 1 : 0), (Object)true);
    }

    @Override
    @NotNull
    protected List<AnAction> createChildActions(@NotNull ConfigurationContext context2, @NotNull List<? extends ConfigurationFromContext> configurations) {
        if (context2 == null) {
            RunContextAction.$$$reportNull$$$0(4);
        }
        if (configurations == null) {
            RunContextAction.$$$reportNull$$$0(5);
        }
        ArrayList<AnAction> childActions = new ArrayList<AnAction>(super.createChildActions(context2, configurations));
        boolean isMultipleConfigurationsFromAlternativeLocations = configurations.size() > 1 && configurations.get(0).isFromAlternativeLocation();
        boolean isRunAction = this.myExecutor.getId().equals("Run");
        if (isMultipleConfigurationsFromAlternativeLocations && isRunAction) {
            childActions.add(this.runAllConfigurationsAction(context2, configurations));
        }
        ArrayList<AnAction> arrayList = childActions;
        if (arrayList == null) {
            RunContextAction.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private AnAction runAllConfigurationsAction(final @NotNull ConfigurationContext context2, final @NotNull List<? extends ConfigurationFromContext> configurationsFromContext) {
        if (context2 == null) {
            RunContextAction.$$$reportNull$$$0(7);
        }
        if (configurationsFromContext == null) {
            RunContextAction.$$$reportNull$$$0(8);
        }
        return new AnAction(CommonBundle.message((String)"action.text.run.all", (Object[])new Object[0]), ExecutionBundle.message((String)"run.all.configurations.available.in.this.context", (Object[])new Object[0]), AllIcons.RunConfigurations.Compound){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                long groupId2 = ExecutionEnvironment.getNextUnusedExecutionId();
                List types = ContainerUtil.map((Collection)configurationsFromContext, context1 -> context1.getConfiguration().getType());
                SuggestUsingRunDashBoardUtil.promptUserToUseRunDashboard(context2.getProject(), types);
                for (ConfigurationFromContext configuration2 : configurationsFromContext) {
                    ExecutionUtil.runConfiguration((RunnerAndConfigurationSettings)configuration2.getConfigurationSettings(), (Executor)RunContextAction.this.myExecutor, (long)groupId2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/actions/RunContextAction$1", "actionPerformed"));
            }
        };
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionText";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/RunContextAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationsFromContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/RunContextAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updatePresentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChildActions";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runAllConfigurationsAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

