/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.execution.console.ConsoleExecutionEditor;
import com.intellij.execution.console.ConsoleHistoryCopyHandler;
import com.intellij.execution.console.ConsolePromptDecorator;
import com.intellij.execution.console.EditorMergedHorizontalScrollBarLayout;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.MergedHorizontalScrollBarModel;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.DataManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.DocumentUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LanguageConsoleImpl
extends ConsoleViewImpl
implements LanguageConsoleView,
DataProvider {
    private final Helper myHelper;
    private final ConsoleExecutionEditor myConsoleExecutionEditor;
    private final EditorEx myHistoryViewer;
    private final JPanel myPanel;
    private final JScrollBar myScrollBar;
    private final MergedHorizontalScrollBarModel myMergedScrollBarModel;
    private final DocumentListener myDocumentAdapter;

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title2, @NotNull Language language2) {
        if (project == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(0);
        }
        if (title2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(1);
        }
        if (language2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(2);
        }
        this(new Helper(project, (VirtualFile)new LightVirtualFile(title2, language2, (CharSequence)"")));
    }

    public LanguageConsoleImpl(@NotNull Project project, @NotNull String title2, @NotNull VirtualFile virtualFile2) {
        if (project == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(3);
        }
        if (title2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(4);
        }
        if (virtualFile2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(5);
        }
        this(new Helper(project, virtualFile2).setTitle(title2));
    }

    public LanguageConsoleImpl(@NotNull Helper helper2) {
        if (helper2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(6);
        }
        super(helper2.project, GlobalSearchScope.allScope((Project)helper2.project), true, true);
        this.myPanel = new ConsoleEditorsPanel(this);
        this.myScrollBar = new JBScrollBar(0);
        this.myDocumentAdapter = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                LanguageConsoleImpl.this.myPanel.revalidate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/console/LanguageConsoleImpl$1", "documentChanged"));
            }
        };
        this.myHelper = helper2;
        EditorFactory editorFactory = EditorFactory.getInstance();
        this.myConsoleExecutionEditor = new ConsoleExecutionEditor(helper2);
        Disposer.register((Disposable)this, (Disposable)this.myConsoleExecutionEditor);
        this.myHistoryViewer = this.doCreateHistoryEditor();
        this.myHistoryViewer.getDocument().addDocumentListener(this.myDocumentAdapter);
        this.myConsoleExecutionEditor.getDocument().addDocumentListener(this.myDocumentAdapter);
        this.myMergedScrollBarModel = MergedHorizontalScrollBarModel.create(this.myScrollBar, this.myHistoryViewer, this.myConsoleExecutionEditor.getEditor());
        this.myScrollBar.putClientProperty(JBScrollPane.Alignment.class, JBScrollPane.Alignment.BOTTOM);
    }

    @NotNull
    protected EditorEx doCreateHistoryEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document historyDocument = ((EditorFactoryImpl)editorFactory).createDocument(true);
        UndoUtil.disableUndoFor((Document)historyDocument);
        EditorEx editorEx = (EditorEx)editorFactory.createViewer(historyDocument, this.getProject(), EditorKind.CONSOLE);
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(7);
        }
        return editorEx;
    }

    @Override
    @NotNull
    protected final EditorEx doCreateConsoleEditor() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(8);
        }
        return editorEx;
    }

    @Override
    protected final void disposeEditor() {
    }

    @Override
    @NotNull
    protected JComponent createCenterComponent() {
        this.initComponents();
        JPanel jPanel2 = this.myPanel;
        if (jPanel2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(9);
        }
        return jPanel2;
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusableComponent() {
        JComponent jComponent = this.getConsoleEditor().getContentComponent();
        if (jComponent == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    private void initComponents() {
        this.setupComponents();
        this.myPanel.setLayout((LayoutManager)((Object)new EditorMergedHorizontalScrollBarLayout(this.myScrollBar, this.myHistoryViewer, this.myConsoleExecutionEditor.getEditor(), this.isHistoryViewerForceAdditionalColumnsUsage(), this.getMinHistoryLineCount())));
        this.myPanel.add(this.myHistoryViewer.getComponent());
        this.myPanel.add(this.myConsoleExecutionEditor.getComponent());
        this.myPanel.add(this.myScrollBar);
        this.myPanel.setBackground((Color)new JBColor(() -> this.myConsoleExecutionEditor.getEditor().getBackgroundColor()));
        DataManager.registerDataProvider((JComponent)this.myPanel, (DataProvider)this);
    }

    @Override
    public void setConsoleEditorEnabled(boolean consoleEditorEnabled) {
        if (this.isConsoleEditorEnabled() == consoleEditorEnabled) {
            return;
        }
        this.myConsoleExecutionEditor.setConsoleEditorEnabled(consoleEditorEnabled);
        this.myMergedScrollBarModel.setEnabled(consoleEditorEnabled);
    }

    private void setupComponents() {
        this.myHelper.setupEditor(this.myConsoleExecutionEditor.getEditor());
        this.myHelper.setupEditor(this.myHistoryViewer);
        this.myHistoryViewer.getComponent().setMinimumSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.getComponent().setPreferredSize((Dimension)JBUI.emptySize());
        this.myHistoryViewer.setCaretEnabled(false);
        this.myConsoleExecutionEditor.initComponent();
        this.myHistoryViewer.getContentComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (LanguageConsoleImpl.this.isConsoleEditorEnabled() && UIUtil.isReallyTypedEvent((KeyEvent)event)) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)LanguageConsoleImpl.this.myConsoleExecutionEditor.getEditor().getContentComponent(), true));
                    LanguageConsoleImpl.this.myConsoleExecutionEditor.getEditor().processKeyTyped(event);
                }
            }
        });
        EmptyAction.registerActionShortcuts((JComponent)this.myHistoryViewer.getComponent(), (JComponent)this.myConsoleExecutionEditor.getComponent());
        this.myHistoryViewer.putUserData(EXECUTION_EDITOR_KEY, this.myConsoleExecutionEditor);
    }

    @Override
    public final boolean isConsoleEditorEnabled() {
        return this.myConsoleExecutionEditor.isConsoleEditorEnabled();
    }

    @Override
    @Nullable
    public String getPrompt() {
        return this.myConsoleExecutionEditor.getPrompt();
    }

    @Override
    @Nullable
    public ConsoleViewContentType getPromptAttributes() {
        return this.myConsoleExecutionEditor.getPromptAttributes();
    }

    @NotNull
    public ConsolePromptDecorator getConsolePromptDecorator() {
        ConsolePromptDecorator consolePromptDecorator = this.myConsoleExecutionEditor.getConsolePromptDecorator();
        if (consolePromptDecorator == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(11);
        }
        return consolePromptDecorator;
    }

    @Override
    public void setPromptAttributes(@NotNull ConsoleViewContentType textAttributes) {
        if (textAttributes == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(12);
        }
        this.myConsoleExecutionEditor.setPromptAttributes(textAttributes);
    }

    @Override
    public void setPrompt(@Nullable String prompt) {
        this.myConsoleExecutionEditor.setPrompt(prompt);
    }

    @Override
    public void setEditable(boolean editable) {
        this.myConsoleExecutionEditor.setEditable(editable);
    }

    @Override
    public boolean isEditable() {
        return this.myConsoleExecutionEditor.isEditable();
    }

    @Override
    @NotNull
    public final PsiFile getFile() {
        PsiFile psiFile = this.myHelper.getFileSafe();
        if (psiFile == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(13);
        }
        return psiFile;
    }

    @Override
    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myConsoleExecutionEditor.getVirtualFile();
        if (virtualFile2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(14);
        }
        return virtualFile2;
    }

    @Override
    @NotNull
    public final EditorEx getHistoryViewer() {
        EditorEx editorEx = this.myHistoryViewer;
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(15);
        }
        return editorEx;
    }

    @Override
    @NotNull
    public final Document getEditorDocument() {
        Document document = this.myConsoleExecutionEditor.getDocument();
        if (document == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(16);
        }
        return document;
    }

    @Override
    @NotNull
    public final EditorEx getConsoleEditor() {
        EditorEx editorEx = this.myConsoleExecutionEditor.getEditor();
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(17);
        }
        return editorEx;
    }

    @Override
    @NlsContexts.TabTitle
    @NotNull
    public String getTitle() {
        String string = this.myHelper.title;
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public void setTitle(@NotNull String title2) {
        if (title2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(19);
        }
        this.myHelper.setTitle(title2);
    }

    public String addToHistory(@NotNull TextRange textRange, @NotNull EditorEx editor2, boolean preserveMarkup) {
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(21);
        }
        return this.addToHistoryInner(textRange, editor2, false, preserveMarkup);
    }

    @NotNull
    public String prepareExecuteAction(boolean addToHistory, boolean preserveMarkup, boolean clearInput) {
        EditorEx editor2 = this.getCurrentEditor();
        DocumentEx document = editor2.getDocument();
        String text2 = document.getText();
        TextRange range2 = new TextRange(0, document.getTextLength());
        if (!clearInput) {
            editor2.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
        if (addToHistory) {
            this.addToHistoryInner(range2, editor2, clearInput, preserveMarkup);
        } else if (clearInput) {
            this.setInputText("");
        }
        String string = text2;
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    protected String addToHistoryInner(@NotNull TextRange textRange, @NotNull EditorEx editor2, boolean erase, boolean preserveMarkup) {
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(23);
        }
        if (editor2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String result2 = this.addTextRangeToHistory(textRange, editor2, preserveMarkup);
        if (erase) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> editor2.getDocument().deleteString(textRange.getStartOffset(), textRange.getEndOffset()));
        }
        this.scrollToEnd();
        String string = result2;
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static String printWithHighlighting(@NotNull LanguageConsoleView console2, @NotNull Editor inputEditor, @NotNull TextRange textRange) {
        String text2;
        EditorHighlighter highlighter;
        if (console2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(26);
        }
        if (inputEditor == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(27);
        }
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(28);
        }
        if (inputEditor instanceof EditorWindow) {
            PsiFile file2 = ((EditorWindow)inputEditor).getInjectedFile();
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getVirtualFile(), (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)console2.getProject());
            String fullText = InjectedLanguageUtilBase.getUnescapedText(file2, null, null);
            highlighter.setText((CharSequence)fullText);
            text2 = textRange.substring(fullText);
        } else {
            text2 = inputEditor.getDocument().getText(textRange);
            highlighter = inputEditor.getHighlighter();
        }
        SyntaxHighlighter syntax = highlighter instanceof LexerEditorHighlighter ? ((LexerEditorHighlighter)highlighter).getSyntaxHighlighter() : null;
        LanguageConsoleImpl consoleImpl = (LanguageConsoleImpl)console2;
        consoleImpl.doAddPromptToHistory();
        if (syntax != null) {
            ConsoleViewUtil.printWithHighlighting(console2, text2, syntax, () -> {
                String identPrompt = consoleImpl.myConsoleExecutionEditor.getConsolePromptDecorator().getIndentPrompt();
                if (StringUtil.isNotEmpty((String)identPrompt)) {
                    consoleImpl.addPromptToHistoryImpl(identPrompt);
                }
            });
        } else {
            console2.print(text2, ConsoleViewContentType.USER_INPUT);
        }
        console2.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        return text2;
    }

    @NotNull
    protected String addTextRangeToHistory(@NotNull TextRange textRange, @NotNull EditorEx inputEditor, boolean preserveMarkup) {
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(29);
        }
        if (inputEditor == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(30);
        }
        String string = LanguageConsoleImpl.printWithHighlighting(this, inputEditor, textRange);
        if (string == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(31);
        }
        return string;
    }

    protected void doAddPromptToHistory() {
        String prompt = this.myConsoleExecutionEditor.getPrompt();
        if (prompt != null) {
            this.addPromptToHistoryImpl(prompt);
        }
    }

    public static void duplicateHighlighters(@NotNull MarkupModel to, @NotNull MarkupModel from2, int offset, @NotNull TextRange textRange, String ... disableAttributes) {
        if (to == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(32);
        }
        if (from2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(33);
        }
        if (textRange == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(34);
        }
        for (RangeHighlighter rangeHighlighter : from2.getAllHighlighters()) {
            int end;
            HighlightInfo highlightInfo;
            if (!rangeHighlighter.isValid()) continue;
            Object tooltip2 = rangeHighlighter.getErrorStripeTooltip();
            HighlightInfo highlightInfo2 = highlightInfo = tooltip2 instanceof HighlightInfo ? (HighlightInfo)tooltip2 : null;
            if (highlightInfo != null && (highlightInfo.getSeverity() != HighlightSeverity.INFORMATION || highlightInfo.type.getAttributesKey() == EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES || Arrays.stream(disableAttributes).filter(Objects::nonNull).anyMatch(x -> x.equals(highlightInfo.type.getAttributesKey().getExternalName())))) continue;
            int localOffset = textRange.getStartOffset();
            int start2 = Math.max(rangeHighlighter.getStartOffset(), localOffset) - localOffset;
            if (start2 > (end = Math.min(rangeHighlighter.getEndOffset(), textRange.getEndOffset()) - localOffset)) continue;
            RangeHighlighter h = to.addRangeHighlighter(start2 + offset, end + offset, rangeHighlighter.getLayer(), rangeHighlighter.getTextAttributes(null), rangeHighlighter.getTargetArea());
            ((RangeHighlighterEx)h).setAfterEndOfLine(((RangeHighlighterEx)rangeHighlighter).isAfterEndOfLine());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myHistoryViewer.isDisposed()) {
            return;
        }
        this.myConsoleExecutionEditor.getDocument().removeDocumentListener(this.myDocumentAdapter);
        this.myHistoryViewer.getDocument().removeDocumentListener(this.myDocumentAdapter);
        this.myHistoryViewer.putUserData(EXECUTION_EDITOR_KEY, null);
        EditorFactory editorFactory = EditorFactory.getInstance();
        editorFactory.releaseEditor((Editor)this.myHistoryViewer);
        this.closeFile();
    }

    protected void closeFile() {
        FileEditorManager editorManager;
        if (this.getProject().isOpen() && (editorManager = FileEditorManager.getInstance((Project)this.getProject())).isFileOpen(this.getVirtualFile())) {
            editorManager.closeFile(this.getVirtualFile());
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(35);
        }
        return super.getData(dataId);
    }

    @Override
    @NotNull
    public EditorEx getCurrentEditor() {
        EditorEx editorEx = this.myConsoleExecutionEditor.getCurrentEditor();
        if (editorEx == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(36);
        }
        return editorEx;
    }

    @Override
    @NotNull
    public Language getLanguage() {
        Language language2 = this.getFile().getLanguage();
        if (language2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(37);
        }
        return language2;
    }

    @Override
    public void setLanguage(@NotNull Language language2) {
        if (language2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(38);
        }
        this.myHelper.setLanguage(language2);
        this.myHelper.getFileSafe();
    }

    @Override
    public void setInputText(@NotNull String query2) {
        if (query2 == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(39);
        }
        this.myConsoleExecutionEditor.setInputText(query2);
    }

    boolean isHistoryViewerForceAdditionalColumnsUsage() {
        return true;
    }

    protected int getMinHistoryLineCount() {
        return 2;
    }

    private void addPromptToHistoryImpl(@NotNull String prompt) {
        if (prompt == null) {
            LanguageConsoleImpl.$$$reportNull$$$0(40);
        }
        this.flushDeferredText();
        DocumentEx document = this.getHistoryViewer().getDocument();
        RangeHighlighter highlighter = this.getHistoryViewer().getMarkupModel().addRangeHighlighter(null, document.getTextLength(), document.getTextLength(), 0, HighlighterTargetArea.EXACT_RANGE);
        this.print(prompt, this.myConsoleExecutionEditor.getPromptAttributes());
        highlighter.putUserData(ConsoleHistoryCopyHandler.PROMPT_LENGTH_MARKER, (Object)prompt.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/LanguageConsoleImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 20: 
            case 23: 
            case 28: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEditor";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prompt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateHistoryEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateConsoleEditor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsolePromptDecorator";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryViewer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorDocument";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleEditor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareExecuteAction";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addToHistoryInner";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextRangeToHistory";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentEditor";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 36: 
            case 37: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setPromptAttributes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addToHistory";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addToHistoryInner";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "printWithHighlighting";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addTextRangeToHistory";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "duplicateHighlighters";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setLanguage";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setInputText";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addPromptToHistoryImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 31: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConsoleEditorsPanel
    extends JPanel {
        private final LanguageConsoleImpl myConsole;

        public ConsoleEditorsPanel(@NotNull LanguageConsoleImpl console2) {
            if (console2 == null) {
                ConsoleEditorsPanel.$$$reportNull$$$0(0);
            }
            this.myConsole = console2;
        }

        @NotNull
        public LanguageConsoleImpl getConsole() {
            LanguageConsoleImpl languageConsoleImpl = this.myConsole;
            if (languageConsoleImpl == null) {
                ConsoleEditorsPanel.$$$reportNull$$$0(1);
            }
            return languageConsoleImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "console";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/console/LanguageConsoleImpl$ConsoleEditorsPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl$ConsoleEditorsPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConsole";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Helper {
        public final Project project;
        public final VirtualFile virtualFile;
        @NlsSafe
        String title;
        PsiFile file;

        public Helper(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
            if (project == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (virtualFile2 == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.project = project;
            this.virtualFile = virtualFile2;
            this.title = virtualFile2.getName();
        }

        public String getTitle() {
            return this.title;
        }

        public Helper setTitle(@NotNull String title2) {
            if (title2 == null) {
                Helper.$$$reportNull$$$0(2);
            }
            this.title = title2;
            return this;
        }

        @NotNull
        public PsiFile getFile() {
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiUtilCore.getPsiFile((Project)this.project, (VirtualFile)this.virtualFile));
            if (psiFile == null) {
                Helper.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        @NotNull
        public Document getDocument() {
            Document document = FileDocumentManager.getInstance().getDocument(this.virtualFile);
            if (document == null) {
                Language language2 = this.virtualFile instanceof LightVirtualFile ? ((LightVirtualFile)this.virtualFile).getLanguage() : null;
                throw new AssertionError((Object)String.format("no document for: %s (fileType: %s, language: %s, length: %s, valid: %s)", this.virtualFile, this.virtualFile.getFileType(), language2, this.virtualFile.getLength(), this.virtualFile.isValid()));
            }
            Document document2 = document;
            if (document2 == null) {
                Helper.$$$reportNull$$$0(4);
            }
            return document2;
        }

        public void setLanguage(Language language2) {
            if (!(this.virtualFile instanceof LightVirtualFile)) {
                throw new UnsupportedOperationException();
            }
            ((LightVirtualFile)this.virtualFile).setLanguage(language2);
            ((LightVirtualFile)this.virtualFile).setContent((Object)this.getDocument(), (CharSequence)this.getDocument().getText(), false);
            FileContentUtil.reparseFiles((Project)this.project, Collections.singletonList(this.virtualFile), (boolean)false);
        }

        public void setupEditor(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                Helper.$$$reportNull$$$0(5);
            }
            ConsoleViewUtil.setupLanguageConsoleEditor(editor2);
            editor2.setHorizontalScrollbarVisible(true);
            editor2.setVerticalScrollbarVisible(true);
            DataManager.registerDataProvider((JComponent)editor2.getComponent(), dataId -> this.getEditorData(editor2, dataId));
        }

        @NotNull
        public PsiFile getFileSafe() {
            PsiFile psiFile = this.file == null || !this.file.isValid() ? (this.file = this.getFile()) : this.file;
            if (psiFile == null) {
                Helper.$$$reportNull$$$0(6);
            }
            return psiFile;
        }

        @Nullable
        protected Object getEditorData(@NotNull EditorEx editor2, String dataId) {
            if (editor2 == null) {
                Helper.$$$reportNull$$$0(7);
            }
            if (OpenFileDescriptor.NAVIGATE_IN_EDITOR.is(dataId)) {
                return editor2;
            }
            if (this.project.isInitialized()) {
                Caret caret = editor2.getCaretModel().getCurrentCaret();
                return FileEditorManagerEx.getInstanceEx(this.project).getData(dataId, editor2, caret);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "virtualFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/console/LanguageConsoleImpl$Helper";
                    break;
                }
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/console/LanguageConsoleImpl$Helper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileSafe";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setTitle";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setupEditor";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getEditorData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

