/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.Point;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;

public final class MergedHorizontalScrollBarModel
extends DefaultBoundedRangeModel {
    private volatile boolean myInternalChange;
    private final JScrollBar myBar;
    private final EditorEx myFirstEditor;
    private final EditorEx mySecondEditor;
    private int myFirstValue;
    private int mySecondValue;

    public MergedHorizontalScrollBarModel(@NotNull JScrollBar bar, @NotNull EditorEx first, @NotNull EditorEx second) {
        if (bar == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(0);
        }
        if (first == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(1);
        }
        if (second == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(2);
        }
        this.myBar = bar;
        this.myFirstEditor = first;
        this.mySecondEditor = second;
        this.addChangeListener(event -> this.onChange());
        first.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
        second.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
    }

    private boolean isInternal() {
        return this.myInternalChange || !this.myFirstEditor.getComponent().isVisible() || !this.mySecondEditor.getComponent().isVisible();
    }

    private void onChange() {
        if (this.isInternal()) {
            return;
        }
        this.myInternalChange = true;
        MergedHorizontalScrollBarModel.setValue(this.myFirstEditor.getScrollPane().getViewport(), this.getValue());
        MergedHorizontalScrollBarModel.setValue(this.mySecondEditor.getScrollPane().getViewport(), this.getValue());
        this.myInternalChange = false;
    }

    private void onUpdate(Object source) {
        Point position;
        if (this.isInternal()) {
            return;
        }
        JViewport first = this.myFirstEditor.getScrollPane().getViewport();
        JViewport second = this.mySecondEditor.getScrollPane().getViewport();
        int value2 = this.getValue();
        if (source == first) {
            position = first.getViewPosition();
            if (position.x != this.myFirstValue) {
                this.myFirstValue = value2 = position.x;
            }
        } else {
            position = second.getViewPosition();
            if (position.x != this.mySecondValue) {
                this.mySecondValue = value2 = position.x;
            }
        }
        int ext = Math.min(first.getExtentSize().width, second.getExtentSize().width);
        int max = Math.max(first.getViewSize().width, second.getViewSize().width);
        this.setRangeProperties(value2, ext, 0, max, false);
        this.myBar.setEnabled(ext < max);
    }

    private static void setValue(JViewport viewport, int value2) {
        Point position = viewport.getViewPosition();
        position.x = Math.max(0, Math.min(value2, viewport.getViewSize().width - viewport.getExtentSize().width));
        viewport.setViewPosition(position);
    }

    public void setEnabled(boolean enabled) {
        this.myFirstEditor.getScrollPane().getHorizontalScrollBar().setEnabled(!enabled);
        this.mySecondEditor.getScrollPane().getHorizontalScrollBar().setEnabled(!enabled);
        this.myBar.setVisible(enabled);
    }

    @NotNull
    public static MergedHorizontalScrollBarModel create(@NotNull JScrollBar bar, @NotNull EditorEx first, @NotNull EditorEx second) {
        if (bar == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(3);
        }
        if (first == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(4);
        }
        if (second == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(5);
        }
        MergedHorizontalScrollBarModel model2 = new MergedHorizontalScrollBarModel(bar, first, second);
        bar.setModel(model2);
        model2.setEnabled(true);
        MergedHorizontalScrollBarModel mergedHorizontalScrollBarModel = model2;
        if (mergedHorizontalScrollBarModel == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(6);
        }
        return mergedHorizontalScrollBarModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/MergedHorizontalScrollBarModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/MergedHorizontalScrollBarModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

