/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardComponentWrapper;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardGroup;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardServiceViewDeleteProvider;
import com.intellij.execution.dashboard.tree.FolderDashboardGroupingRule;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.execution.dashboard.tree.RunDashboardGroupImpl;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDnDDescriptor;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewLocatableDescriptor;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunDashboardServiceViewContributor
implements ServiceViewGroupingContributor<RunConfigurationContributor, GroupingNode> {
    @NonNls
    private static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";
    private static final Key<DefaultActionGroup> MORE_ACTION_GROUP_KEY = Key.create((String)"ServicesMoreActionGroup");
    private static final ServiceViewDescriptor CONTRIBUTOR_DESCRIPTOR = new SimpleServiceViewDescriptor("Run Dashboard", AllIcons.Actions.Execute){

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        public DataProvider getDataProvider() {
            return id2 -> PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(id2) ? new RunDashboardServiceViewDeleteProvider() : null;
        }
    };

    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(0);
        }
        ServiceViewDescriptor serviceViewDescriptor = CONTRIBUTOR_DESCRIPTOR;
        if (serviceViewDescriptor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(1);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<RunConfigurationContributor> getServices(@NotNull Project project) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(2);
        }
        RunDashboardManagerImpl runDashboardManager = (RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)project);
        List list2 = ContainerUtil.map(runDashboardManager.getRunConfigurations(), value2 -> new RunConfigurationContributor(new RunConfigurationNode(project, (RunDashboardManager.RunDashboardService)value2, RunDashboardManagerImpl.getCustomizers(value2.getSettings(), value2.getDescriptor()))));
        if (list2 == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull RunConfigurationContributor contributor) {
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(4);
        }
        if (contributor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(5);
        }
        ServiceViewDescriptor serviceViewDescriptor = contributor.getViewDescriptor(project);
        if (serviceViewDescriptor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(6);
        }
        return serviceViewDescriptor;
    }

    @NotNull
    public List<GroupingNode> getGroups(@NotNull RunConfigurationContributor contributor) {
        if (contributor == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(7);
        }
        ArrayList<GroupingNode> result2 = new ArrayList<GroupingNode>();
        GroupingNode parentGroupNode = null;
        for (RunDashboardGroupingRule groupingRule : (RunDashboardGroupingRule[])RunDashboardManagerImpl.GROUPING_RULE_EP_NAME.getExtensions()) {
            RunDashboardGroup group2 = groupingRule.getGroup((AbstractTreeNode)contributor.asService());
            if (group2 == null) continue;
            GroupingNode node2 = new GroupingNode(contributor.asService().getProject(), parentGroupNode == null ? null : parentGroupNode.getGroup(), group2);
            node2.setParent(parentGroupNode);
            result2.add(node2);
            parentGroupNode = node2;
        }
        ArrayList<GroupingNode> arrayList = result2;
        if (arrayList == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public ServiceViewDescriptor getGroupDescriptor(@NotNull GroupingNode node2) {
        RunDashboardGroup group2;
        if (node2 == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(9);
        }
        if ((group2 = node2.getGroup()) instanceof FolderDashboardGroupingRule.FolderDashboardGroup) {
            return new RunDashboardFolderGroupViewDescriptor(node2);
        }
        return new RunDashboardGroupViewDescriptor(node2);
    }

    @NotNull
    private static JComponent createEmptyContent() {
        JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
        panel2.setFocusable(true);
        JBPanelWithEmptyText jBPanelWithEmptyText = panel2;
        if (jBPanelWithEmptyText == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(10);
        }
        return jBPanelWithEmptyText;
    }

    private static ActionGroup getToolbarActions(@Nullable RunContentDescriptor descriptor2) {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        List<AnAction> leftToolbarActions = null;
        RunnerLayoutUiImpl ui2 = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor2);
        if (ui2 != null) {
            leftToolbarActions = ui2.getActions();
        } else {
            ActionToolbar toolbar = RunDashboardManagerImpl.findActionToolbar(descriptor2);
            if (toolbar != null) {
                leftToolbarActions = toolbar.getActions();
            }
        }
        if (leftToolbarActions != null) {
            if (leftToolbarActions.size() == 1 && leftToolbarActions.get(0) instanceof ActionGroup) {
                leftToolbarActions = Arrays.asList(((ActionGroup)leftToolbarActions.get(0)).getChildren(null));
            }
            for (AnAction action2 : leftToolbarActions) {
                if (action2 instanceof MoreActionGroup) {
                    actionGroup2.add((AnAction)RunDashboardServiceViewContributor.getServicesMoreActionGroup((MoreActionGroup)action2, descriptor2));
                    continue;
                }
                if (action2 instanceof StopAction || action2 instanceof FakeRerunAction) continue;
                actionGroup2.add(action2);
            }
        }
        return actionGroup2;
    }

    private static DefaultActionGroup getServicesMoreActionGroup(MoreActionGroup contentGroup, RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            return contentGroup;
        }
        Content content2 = descriptor2.getAttachedContent();
        if (content2 == null) {
            return contentGroup;
        }
        DefaultActionGroup moreGroup = (DefaultActionGroup)content2.getUserData(MORE_ACTION_GROUP_KEY);
        if (moreGroup == null) {
            moreGroup = new MoreActionGroup(false);
            content2.putUserData(MORE_ACTION_GROUP_KEY, (Object)moreGroup);
        }
        moreGroup.removeAll();
        moreGroup.addAll(contentGroup.getChildren(null));
        return moreGroup;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup actions2 = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        actions2.add(actionManager.getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        actions2.addSeparator();
        actions2.add(actionManager.getAction("RunDashboardPopup"));
        return actions2;
    }

    @Nullable
    private static RunDashboardRunConfigurationNode getRunConfigurationNode(@NotNull DnDEvent event, @NotNull Project project) {
        Object object;
        if (event == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(11);
        }
        if (project == null) {
            RunDashboardServiceViewContributor.$$$reportNull$$$0(12);
        }
        if (!((object = event.getAttachedObject()) instanceof DataProvider)) {
            return null;
        }
        Object data2 = ((DataProvider)object).getData(PlatformCoreDataKeys.SELECTED_ITEMS.getName());
        if (!(data2 instanceof Object[])) {
            return null;
        }
        Object[] items = (Object[])data2;
        if (items.length != 1) {
            return null;
        }
        RunDashboardRunConfigurationNode node2 = (RunDashboardRunConfigurationNode)ObjectUtils.tryCast((Object)items[0], RunDashboardRunConfigurationNode.class);
        if (node2 != null && !node2.getConfigurationSettings().getConfiguration().getProject().equals(project)) {
            return null;
        }
        return node2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServices";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getServiceDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getViewDescriptor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getServiceDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGroups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGroupDescriptor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRunConfigurationNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RunConfigurationContributor
    implements ServiceViewProvidingContributor<AbstractTreeNode<?>, RunConfigurationNode> {
        private final RunConfigurationNode myNode;

        RunConfigurationContributor(@NotNull RunConfigurationNode node2) {
            if (node2 == null) {
                RunConfigurationContributor.$$$reportNull$$$0(0);
            }
            this.myNode = node2;
        }

        @NotNull
        public RunConfigurationNode asService() {
            RunConfigurationNode runConfigurationNode = this.myNode;
            if (runConfigurationNode == null) {
                RunConfigurationContributor.$$$reportNull$$$0(1);
            }
            return runConfigurationNode;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(2);
            }
            return new RunConfigurationServiceViewDescriptor(this.myNode);
        }

        @NotNull
        public List<AbstractTreeNode<?>> getServices(@NotNull Project project) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(3);
            }
            return new ArrayList(this.myNode.getChildren());
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, final @NotNull AbstractTreeNode service) {
            if (project == null) {
                RunConfigurationContributor.$$$reportNull$$$0(4);
            }
            if (service == null) {
                RunConfigurationContributor.$$$reportNull$$$0(5);
            }
            return new ServiceViewDescriptor(){

                public ActionGroup getToolbarActions() {
                    return RunDashboardServiceViewContributor.getToolbarActions(null);
                }

                public ActionGroup getPopupActions() {
                    return RunDashboardServiceViewContributor.getPopupActions();
                }

                @NotNull
                public ItemPresentation getPresentation() {
                    PresentationData presentationData = service.getPresentation();
                    if (presentationData == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return presentationData;
                }

                @Nullable
                public String getId() {
                    List fragments;
                    ItemPresentation presentation2 = this.getPresentation();
                    String text2 = presentation2.getPresentableText();
                    if (!StringUtil.isEmpty((String)text2)) {
                        return text2;
                    }
                    if (presentation2 instanceof PresentationData && !(fragments = ((PresentationData)presentation2).getColoredText()).isEmpty()) {
                        StringBuilder result2 = new StringBuilder();
                        for (PresentableNodeDescriptor.ColoredFragment fragment2 : fragments) {
                            result2.append(fragment2.getText());
                        }
                        return result2.toString();
                    }
                    return null;
                }

                @Nullable
                public Runnable getRemover() {
                    return service instanceof RunDashboardNode ? ((RunDashboardNode)service).getRemover() : null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor$1", "getPresentation"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationContributor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getViewDescriptor";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getServices";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getServiceDescriptor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RunDashboardFolderGroupViewDescriptor
    extends RunDashboardGroupViewDescriptor
    implements ServiceViewDnDDescriptor {
        RunDashboardFolderGroupViewDescriptor(GroupingNode node2) {
            super(node2);
        }

        @Override
        @Nullable
        public Runnable getRemover() {
            return () -> {
                String groupName = this.myGroup.getName();
                Project project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject();
                List services = RunDashboardManager.getInstance((Project)project).getRunConfigurations();
                RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
                runManager.fireBeginUpdate();
                try {
                    for (RunDashboardManager.RunDashboardService service : services) {
                        RunnerAndConfigurationSettings settings = service.getSettings();
                        if (!groupName.equals(settings.getFolderName())) continue;
                        settings.setFolderName(null);
                    }
                }
                finally {
                    runManager.fireEndUpdate();
                }
            };
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(1);
            }
            return position == ServiceViewDnDDescriptor.Position.INTO && RunDashboardServiceViewContributor.getRunConfigurationNode(event, ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject()) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            Project project;
            RunDashboardRunConfigurationNode node2;
            if (event == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position == null) {
                RunDashboardFolderGroupViewDescriptor.$$$reportNull$$$0(3);
            }
            if ((node2 = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project = ((FolderDashboardGroupingRule.FolderDashboardGroup)this.myGroup).getProject())) == null) {
                return;
            }
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
            runManager.fireBeginUpdate();
            try {
                node2.getConfigurationSettings().setFolderName(this.myGroup.getName());
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardFolderGroupViewDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canDrop";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunDashboardGroupViewDescriptor
    implements ServiceViewDescriptor,
    WeighedItem {
        protected final RunDashboardGroup myGroup;
        private final GroupingNode myNode;
        private final PresentationData myPresentationData;

        protected RunDashboardGroupViewDescriptor(GroupingNode node2) {
            this.myNode = node2;
            this.myGroup = node2.getGroup();
            this.myPresentationData = new PresentationData();
            this.myPresentationData.setPresentableText(this.myGroup.getName());
            this.myPresentationData.setIcon(this.myGroup.getIcon());
        }

        @Nullable
        public String getId() {
            return RunDashboardGroupViewDescriptor.getId(this.myNode);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(null);
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myPresentationData;
            if (presentationData == null) {
                RunDashboardGroupViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        public int getWeight() {
            Object value2 = ((RunDashboardGroupImpl)this.myGroup).getValue();
            if (value2 instanceof WeighedItem) {
                return ((WeighedItem)value2).getWeight();
            }
            return 0;
        }

        @Nullable
        public Runnable getRemover() {
            ConfigurationType type = (ConfigurationType)ObjectUtils.tryCast(((RunDashboardGroupImpl)this.myGroup).getValue(), ConfigurationType.class);
            if (type != null) {
                return () -> {
                    RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myNode.getProject());
                    HashSet types = new HashSet(runDashboardManager.getTypes());
                    types.remove(type.getId());
                    runDashboardManager.setTypes(types);
                };
            }
            return null;
        }

        private static String getId(GroupingNode node2) {
            AbstractTreeNode parent = node2.getParent();
            if (parent instanceof GroupingNode) {
                return RunDashboardGroupViewDescriptor.getId((GroupingNode)parent) + "/" + RunDashboardGroupViewDescriptor.getId(node2.getGroup());
            }
            return RunDashboardGroupViewDescriptor.getId(node2.getGroup());
        }

        private static String getId(RunDashboardGroup group2) {
            Object value2;
            if (group2 instanceof RunDashboardGroupImpl && (value2 = ((RunDashboardGroupImpl)group2).getValue()) instanceof ConfigurationType) {
                return ((ConfigurationType)value2).getId();
            }
            return group2.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunDashboardGroupViewDescriptor", "getPresentation"));
        }
    }

    private static class RunConfigurationServiceViewDescriptor
    implements ServiceViewDescriptor,
    ServiceViewLocatableDescriptor,
    ServiceViewDnDDescriptor {
        private final RunConfigurationNode myNode;

        RunConfigurationServiceViewDescriptor(RunConfigurationNode node2) {
            this.myNode = node2;
        }

        @Nullable
        public String getId() {
            RunConfiguration configuration2 = this.myNode.getConfigurationSettings().getConfiguration();
            return configuration2.getType().getId() + "/" + configuration2.getName();
        }

        public JComponent getContentComponent() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return new RunDashboardComponentWrapper(RunDashboardServiceViewContributor.createEmptyContent(), null);
            }
            ContentManager contentManager2 = content2.getManager();
            if (contentManager2 == null) {
                return null;
            }
            RunContentDescriptor descriptor2 = this.myNode.getDescriptor();
            ProcessHandler handler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
            Integer contentId = handler2 == null ? null : Integer.valueOf(handler2.hashCode());
            return new RunDashboardComponentWrapper(contentManager2.getComponent(), contentId);
        }

        @NotNull
        public ItemPresentation getContentPresentation() {
            Content content2 = this.myNode.getContent();
            if (content2 != null) {
                return new PresentationData(content2.getDisplayName(), null, content2.getIcon(), null);
            }
            RunConfiguration configuration2 = this.myNode.getConfigurationSettings().getConfiguration();
            return new PresentationData(configuration2.getName(), null, configuration2.getIcon(), null);
        }

        public ActionGroup getToolbarActions() {
            return RunDashboardServiceViewContributor.getToolbarActions(this.myNode.getDescriptor());
        }

        public ActionGroup getPopupActions() {
            return RunDashboardServiceViewContributor.getPopupActions();
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = this.myNode.getPresentation();
            if (presentationData == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(0);
            }
            return presentationData;
        }

        @Nullable
        public DataProvider getDataProvider() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return null;
            }
            return DataManagerImpl.getDataProviderEx(content2.getComponent());
        }

        public void onNodeSelected() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).setSelectedContent(content2);
        }

        public void onNodeUnselected() {
            Content content2 = this.myNode.getContent();
            if (content2 == null) {
                return;
            }
            ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).removeFromSelection(content2);
        }

        @Nullable
        public Navigatable getNavigatable() {
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                final PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                if (psiElement == null) continue;
                return new Navigatable(){

                    public void navigate(boolean requestFocus) {
                        PsiNavigateUtil.navigate((PsiElement)psiElement, (boolean)requestFocus);
                    }

                    public boolean canNavigate() {
                        return true;
                    }

                    public boolean canNavigateToSource() {
                        return true;
                    }
                };
            }
            return null;
        }

        @Nullable
        public VirtualFile getVirtualFile() {
            return (VirtualFile)ReadAction.compute(() -> {
                for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                    PsiElement psiElement = customizer.getPsiElement((RunDashboardRunConfigurationNode)this.myNode);
                    if (psiElement == null) continue;
                    return PsiUtilCore.getVirtualFile((PsiElement)psiElement);
                }
                return null;
            });
        }

        @Nullable
        public Object getPresentationTag(Object fragment2) {
            Map links = (Map)this.myNode.getUserData(RunDashboardCustomizer.NODE_LINKS);
            return links == null ? null : links.get(fragment2);
        }

        @Nullable
        public Runnable getRemover() {
            RunnerAndConfigurationSettings settings = this.myNode.getConfigurationSettings();
            RunManager runManager = RunManager.getInstance((Project)settings.getConfiguration().getProject());
            return runManager.hasSettings(settings) ? () -> runManager.removeConfiguration(settings) : null;
        }

        public boolean canDrop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(1);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(2);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                return RunDashboardServiceViewContributor.getRunConfigurationNode(event, this.myNode.getConfigurationSettings().getConfiguration().getProject()) != null;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                return true;
            }
            return false;
        }

        public void drop(@NotNull DnDEvent event, @NotNull ServiceViewDnDDescriptor.Position position) {
            if (event == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(3);
            }
            if (position == null) {
                RunConfigurationServiceViewDescriptor.$$$reportNull$$$0(4);
            }
            if (position != ServiceViewDnDDescriptor.Position.INTO) {
                Project project = this.myNode.getConfigurationSettings().getConfiguration().getProject();
                RunDashboardRunConfigurationNode node2 = RunDashboardServiceViewContributor.getRunConfigurationNode(event, project);
                if (node2 != null) {
                    this.reorderConfigurations(project, node2, position);
                }
                return;
            }
            for (RunDashboardCustomizer customizer : this.myNode.getCustomizers()) {
                if (!customizer.canDrop((RunDashboardRunConfigurationNode)this.myNode, event)) continue;
                customizer.drop((RunDashboardRunConfigurationNode)this.myNode, event);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reorderConfigurations(Project project, RunDashboardRunConfigurationNode node2, ServiceViewDnDDescriptor.Position position) {
            RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
            runManager.fireBeginUpdate();
            try {
                node2.getConfigurationSettings().setFolderName(this.myNode.getConfigurationSettings().getFolderName());
                Object2IntOpenHashMap indices = new Object2IntOpenHashMap();
                int i2 = 0;
                for (RunnerAndConfigurationSettings each : runManager.getAllSettings()) {
                    if (each.equals(node2.getConfigurationSettings())) continue;
                    if (each.equals(this.myNode.getConfigurationSettings())) {
                        if (position == ServiceViewDnDDescriptor.Position.ABOVE) {
                            indices.put((Object)node2.getConfigurationSettings(), i2++);
                            indices.put((Object)this.myNode.getConfigurationSettings(), i2++);
                            continue;
                        }
                        if (position != ServiceViewDnDDescriptor.Position.BELOW) continue;
                        indices.put((Object)this.myNode.getConfigurationSettings(), i2++);
                        indices.put((Object)node2.getConfigurationSettings(), i2++);
                        continue;
                    }
                    indices.put((Object)each, i2++);
                }
                runManager.setOrder(Comparator.comparingInt(arg_0 -> ((Object2IntMap)indices).getInt(arg_0)));
            }
            finally {
                runManager.fireEndUpdate();
            }
        }

        public boolean isVisible() {
            RunDashboardStatusFilter statusFilter = ((RunDashboardManagerImpl)RunDashboardManager.getInstance((Project)this.myNode.getProject())).getStatusFilter();
            return statusFilter.isVisible(this.myNode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardServiceViewContributor$RunConfigurationServiceViewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "canDrop";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "drop";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

