/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runToolbar.RunToolbarData;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutorAction
extends DumbAwareAction
implements UpdateInBackground {
    private static final Key<List<RunDashboardRunConfigurationNode>> RUNNABLE_LEAVES_KEY = Key.create((String)"RUNNABLE_LEAVES_KEY");

    protected ExecutorAction() {
    }

    protected ExecutorAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null) {
            this.update(e, false);
            return;
        }
        JBIterable<RunDashboardRunConfigurationNode> targetNodes = RunDashboardActionUtils.getLeafTargets(e);
        boolean running = targetNodes.filter(node2 -> {
            Content content2 = node2.getContent();
            return content2 != null && !RunContentManagerImpl.isTerminated(content2);
        }).isNotEmpty();
        this.update(e, running);
        List runnableLeaves = targetNodes.filter(this::canRun).toList();
        Presentation presentation2 = e.getPresentation();
        if (!runnableLeaves.isEmpty()) {
            presentation2.putClientProperty(RUNNABLE_LEAVES_KEY, (Object)runnableLeaves);
        }
        presentation2.setEnabled(!runnableLeaves.isEmpty());
    }

    private boolean canRun(@NotNull RunDashboardRunConfigurationNode node2) {
        if (node2 == null) {
            ExecutorAction.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        Project project = node2.getProject();
        return this.canRun(node2.getConfigurationSettings(), null, DumbService.isDumb((Project)project));
    }

    private boolean canRun(RunnerAndConfigurationSettings settings, ExecutionTarget target2, boolean isDumb) {
        if (isDumb && !settings.getType().isDumbAware()) {
            return false;
        }
        String executorId = this.getExecutor().getId();
        RunConfiguration configuration2 = settings.getConfiguration();
        Project project = configuration2.getProject();
        if (configuration2 instanceof CompoundRunConfiguration) {
            if (ExecutionTargetManager.getInstance((Project)project).getTargetsFor(configuration2).isEmpty()) {
                return false;
            }
            List<SettingsAndEffectiveTarget> subConfigurations = ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets();
            if (subConfigurations.isEmpty()) {
                return false;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            for (SettingsAndEffectiveTarget subConfiguration : subConfigurations) {
                RunnerAndConfigurationSettings subSettings = runManager.findSettings(subConfiguration.getConfiguration());
                if (subSettings != null && this.canRun(subSettings, subConfiguration.getTarget(), isDumb)) continue;
                return false;
            }
            return true;
        }
        if (!ExecutorAction.isValid(settings)) {
            return false;
        }
        ProgramRunner runner = ProgramRunner.getRunner((String)executorId, (RunProfile)configuration2);
        if (runner == null) {
            return false;
        }
        if (target2 == null ? (target2 = ExecutionTargetManager.getInstance((Project)project).findTarget(configuration2)) == null : !ExecutionTargetManager.canRun((RunConfiguration)configuration2, (ExecutionTarget)target2)) {
            return false;
        }
        return !ExecutionManager.getInstance((Project)project).isStarting(executorId, runner.getRunnerId());
    }

    private static boolean isValid(RunnerAndConfigurationSettings settings) {
        try {
            settings.checkSettings(null);
            return true;
        }
        catch (IndexNotReadyException ex) {
            return true;
        }
        catch (RuntimeConfigurationError ex) {
            return false;
        }
        catch (RuntimeConfigurationException ex) {
            return true;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(2);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        List runnableLeaves = (List)e.getPresentation().getClientProperty(RUNNABLE_LEAVES_KEY);
        if (runnableLeaves == null) {
            return;
        }
        for (RunDashboardRunConfigurationNode node2 : runnableLeaves) {
            this.run(node2.getConfigurationSettings(), null, node2.getDescriptor());
        }
    }

    private void run(RunnerAndConfigurationSettings settings, ExecutionTarget target2, RunContentDescriptor descriptor2) {
        RunConfiguration configuration2 = settings.getConfiguration();
        Project project = configuration2.getProject();
        RunManager runManager = RunManager.getInstance((Project)project);
        if (configuration2 instanceof CompoundRunConfiguration) {
            List<SettingsAndEffectiveTarget> subConfigurations = ((CompoundRunConfiguration)configuration2).getConfigurationsWithEffectiveRunTargets();
            for (SettingsAndEffectiveTarget subConfiguration : subConfigurations) {
                RunnerAndConfigurationSettings subSettings = runManager.findSettings(subConfiguration.getConfiguration());
                if (subSettings == null) continue;
                this.run(subSettings, subConfiguration.getTarget(), null);
            }
        } else {
            if (target2 == null) {
                target2 = ExecutionTargetManager.getInstance((Project)project).findTarget(configuration2);
                assert (target2 != null) : "No target for configuration of type " + configuration2.getType().getDisplayName();
            }
            ProcessHandler processHandler2 = descriptor2 == null ? null : descriptor2.getProcessHandler();
            Consumer<ExecutionEnvironment> environmentCustomization = runManager.isRunWidgetActive() ? ee -> ee.putUserData(RunToolbarData.RUN_TOOLBAR_SUPPRESS_MAIN_SLOT_USER_DATA_KEY, (Object)true) : null;
            ExecutionManager.getInstance((Project)project).restartRunProfile(project, this.getExecutor(), target2, settings, processHandler2, environmentCustomization);
        }
    }

    protected abstract Executor getExecutor();

    protected abstract void update(@NotNull AnActionEvent var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/dashboard/actions/ExecutorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

