/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunOnTargetComboBox;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.RunTargetsEnabled;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentsConfigurable;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.execution.ui.TargetAwareRunConfigurationEditor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;

public class RunOnTargetPanel {
    private final RunnerAndConfigurationSettings mySettings;
    private final Project myProject;
    private final SettingsEditor<RunnerAndConfigurationSettings> myEditor;
    private final JPanel myPanel;
    private final RunOnTargetComboBox myRunOnComboBox;
    private String myDefaultTargetName;

    public RunOnTargetPanel(RunnerAndConfigurationSettings settings, SettingsEditor<RunnerAndConfigurationSettings> editor2) {
        this.mySettings = settings;
        this.myProject = settings.getConfiguration().getProject();
        this.myEditor = editor2;
        this.myRunOnComboBox = new RunOnTargetComboBox(this.myProject);
        ActionLink actionLink2 = new ActionLink(ExecutionBundle.message((String)"edit.run.configuration.run.configuration.manage.targets.label", (Object[])new Object[0]), e -> {
            LanguageRuntimeType<?> languageRuntime;
            String selectedName = this.myRunOnComboBox.getSelectedTargetName();
            TargetEnvironmentsConfigurable targetEnvironmentsConfigurable = new TargetEnvironmentsConfigurable(this.myProject, selectedName, languageRuntime = this.myRunOnComboBox.getDefaultLanguageRuntimeType());
            if (targetEnvironmentsConfigurable.openForEditing()) {
                this.resetRunOnComboBox(selectedName);
                this.setTargetName(selectedName);
            }
        });
        actionLink2.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.myPanel.add((Component)((Object)this.myRunOnComboBox));
        this.myPanel.add((Component)actionLink2);
    }

    public void buildUi(JPanel addTo, @Nullable JLabel nameLabel) {
        addTo.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        UI.PanelFactory.panel((JComponent)this.myPanel).withLabel(ExecutionBundle.message((String)"run.on", (Object[])new Object[0])).withComment(ExecutionBundle.message((String)"edit.run.configuration.run.configuration.run.on.comment", (Object[])new Object[0])).addToPanel(addTo, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0), false);
        JLabel runOnLabel = (JLabel)UIUtil.findComponentOfType((JComponent)addTo, JLabel.class);
        if (runOnLabel != null && nameLabel != null) {
            runOnLabel.setLabelFor((Component)((Object)this.myRunOnComboBox));
            Dimension nameSize = nameLabel.getPreferredSize();
            Dimension runOnSize = runOnLabel.getPreferredSize();
            double width = Math.max(nameSize.getWidth(), runOnSize.getWidth());
            nameLabel.setPreferredSize(new Dimension((int)width, (int)nameSize.getHeight()));
            runOnLabel.setPreferredSize(new Dimension((int)width, (int)runOnSize.getHeight()));
        }
        this.myRunOnComboBox.addActionListener(e -> {
            String chosenTarget = this.myRunOnComboBox.getSelectedTargetName();
            if (!StringUtil.equals((CharSequence)this.myDefaultTargetName, (CharSequence)chosenTarget)) {
                this.setTargetName(chosenTarget);
            }
        });
    }

    public void reset() {
        RunConfiguration configuration2 = this.mySettings.getConfiguration();
        boolean targetAware = configuration2 instanceof TargetEnvironmentAwareRunProfile && ((TargetEnvironmentAwareRunProfile)configuration2).getDefaultLanguageRuntimeType() != null && RunTargetsEnabled.get();
        this.myPanel.getParent().setVisible(targetAware);
        if (targetAware) {
            String defaultTargetName = ((TargetEnvironmentAwareRunProfile)configuration2).getDefaultTargetName();
            LanguageRuntimeType defaultRuntime = ((TargetEnvironmentAwareRunProfile)configuration2).getDefaultLanguageRuntimeType();
            this.myRunOnComboBox.setDefaultLanguageRuntimeType(defaultRuntime);
            this.resetRunOnComboBox(defaultTargetName);
            this.setTargetName(defaultTargetName);
        }
    }

    public void apply() {
        RunConfiguration runConfiguration = this.mySettings.getConfiguration();
        if (runConfiguration instanceof TargetEnvironmentAwareRunProfile) {
            ((TargetEnvironmentAwareRunProfile)runConfiguration).setDefaultTargetName(this.myDefaultTargetName);
        }
    }

    boolean isModified() {
        RunConfiguration runConfiguration = this.mySettings.getConfiguration();
        return runConfiguration instanceof TargetEnvironmentAwareRunProfile && !Objects.equals(this.myDefaultTargetName, ((TargetEnvironmentAwareRunProfile)runConfiguration).getDefaultTargetName());
    }

    @Nullable
    public String getDefaultTargetName() {
        return this.myDefaultTargetName;
    }

    private void setTargetName(String chosenTarget) {
        this.myDefaultTargetName = chosenTarget;
        if (this.myEditor instanceof TargetAwareRunConfigurationEditor) {
            ((TargetAwareRunConfigurationEditor)this.myEditor).targetChanged(chosenTarget);
        }
    }

    private void resetRunOnComboBox(@Nullable String targetNameToChoose) {
        this.myRunOnComboBox.initModel();
        List configs = TargetEnvironmentsManager.getInstance((Project)this.myProject).getTargets().resolvedConfigs();
        this.myRunOnComboBox.addTargets(ContainerUtil.filter((Collection)configs, configuration2 -> TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)configuration2).isSystemCompatible()));
        this.myRunOnComboBox.selectTarget(targetNameToChoose);
    }
}

