/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.impl.statistics.FusAwareRunConfiguration;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfile;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunConfigurationTypeUsagesCollector
extends ProjectUsagesCollector {
    public static final String CONFIGURED_IN_PROJECT = "configured.in.project";
    public static final EventLogGroup GROUP = new EventLogGroup("run.configuration.type", 10);
    public static final StringEventField ID_FIELD = EventFields.StringValidatedByCustomRule((String)"id", (String)"run_config_id");
    public static final StringEventField FACTORY_FIELD = EventFields.StringValidatedByCustomRule((String)"factory", (String)"run_config_factory");
    private static final IntEventField COUNT_FIELD = EventFields.Int((String)"count");
    private static final StringEventField FEATURE_NAME_FIELD = EventFields.StringValidatedByCustomRule((String)"featureName", (String)"plugin_info");
    private static final BooleanEventField SHARED_FIELD = EventFields.Boolean((String)"shared");
    private static final BooleanEventField EDIT_BEFORE_RUN_FIELD = EventFields.Boolean((String)"edit_before_run");
    private static final BooleanEventField ACTIVATE_BEFORE_RUN_FIELD = EventFields.Boolean((String)"activate_before_run");
    private static final BooleanEventField TEMPORARY_FIELD = EventFields.Boolean((String)"temporary");
    private static final BooleanEventField PARALLEL_FIELD = EventFields.Boolean((String)"parallel");
    private static final StringEventField TARGET_FIELD = EventFields.StringValidatedByCustomRule((String)"target", (String)"run_target");
    private static final ObjectEventField ADDITIONAL_FIELD = EventFields.createAdditionalDataField((String)GROUP.getId(), (String)"configured.in.project");
    private static final VarargEventId CONFIGURED_IN_PROJECT_EVENT = GROUP.registerVarargEvent("configured.in.project", new EventField[]{COUNT_FIELD, ID_FIELD, FACTORY_FIELD, SHARED_FIELD, EDIT_BEFORE_RUN_FIELD, ACTIVATE_BEFORE_RUN_FIELD, TEMPORARY_FIELD, PARALLEL_FIELD, ADDITIONAL_FIELD, TARGET_FIELD});
    private static final VarargEventId FEATURE_USED_EVENT = GROUP.registerVarargEvent("feature.used", new EventField[]{COUNT_FIELD, ID_FIELD, EventFields.PluginInfo, FEATURE_NAME_FIELD});
    static final String LOCAL_TYPE_ID = "local";

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        Object2IntOpenHashMap templates = new Object2IntOpenHashMap();
        if (project.isDisposed()) {
            Set<MetricEvent> set2 = Collections.emptySet();
            if (set2 == null) {
                RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(1);
            }
            return set2;
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        for (RunnerAndConfigurationSettings settings : runManager.getAllSettings()) {
            String assignedTargetType;
            ProgressManager.checkCanceled();
            RunConfiguration runConfiguration = settings.getConfiguration();
            ConfigurationFactory configurationFactory = runConfiguration.getFactory();
            if (configurationFactory == null) continue;
            ConfigurationType configurationType = configurationFactory.getType();
            List<EventPair<?>> pairs = RunConfigurationTypeUsagesCollector.createFeatureUsageData(configurationType, configurationFactory);
            pairs.addAll(RunConfigurationTypeUsagesCollector.getSettings(settings, runConfiguration));
            Template template = new Template(CONFIGURED_IN_PROJECT_EVENT, pairs);
            RunConfigurationTypeUsagesCollector.addOrIncrement((Object2IntMap<Template>)templates, template);
            RunConfigurationTypeUsagesCollector.collectRunConfigurationFeatures(runConfiguration, (Object2IntMap<Template>)templates);
            if (runConfiguration instanceof FusAwareRunConfiguration) {
                List<EventPair<?>> additionalData = ((FusAwareRunConfiguration)runConfiguration).getAdditionalUsageData();
                pairs.add(ADDITIONAL_FIELD.with((Object)new ObjectEventData(additionalData)));
            }
            if (!(runConfiguration instanceof TargetEnvironmentAwareRunProfile) || (assignedTargetType = RunConfigurationTypeUsagesCollector.getAssignedTargetType(project, (TargetEnvironmentAwareRunProfile)runConfiguration)) == null) continue;
            pairs.add(TARGET_FIELD.with((Object)assignedTargetType));
        }
        HashSet<MetricEvent> metrics = new HashSet<MetricEvent>();
        for (Object2IntMap.Entry entry2 : Object2IntMaps.fastIterable((Object2IntMap)templates)) {
            metrics.add(((Template)entry2.getKey()).createMetricEvent(entry2.getIntValue()));
        }
        HashSet<MetricEvent> hashSet = metrics;
        if (hashSet == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    private static void addOrIncrement(Object2IntMap<Template> templates, Template template) {
        templates.mergeInt((Object)template, 1, Math::addExact);
    }

    private static void collectRunConfigurationFeatures(RunConfiguration runConfiguration, Object2IntMap<Template> templates) {
        if (runConfiguration instanceof RunConfigurationBase) {
            PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(runConfiguration.getClass());
            if (!info2.isSafeToReport()) {
                return;
            }
            Object state = ((RunConfigurationBase)runConfiguration).getState();
            if (state instanceof RunConfigurationOptions) {
                RunConfigurationOptions runConfigurationOptions = (RunConfigurationOptions)state;
                List properties2 = runConfigurationOptions.__getProperties();
                for (StoredProperty property2 : properties2) {
                    boolean featureUsed;
                    String name2 = property2.getName();
                    if (name2 == null || name2.equals("isAllowRunningInParallel") || name2.equals("isNameGenerated")) continue;
                    Object value2 = property2.getValue((BaseState)runConfigurationOptions);
                    if (value2 instanceof Boolean) {
                        featureUsed = (Boolean)value2;
                    } else if (value2 instanceof String) {
                        featureUsed = StringUtil.isNotEmpty((String)((String)value2));
                    } else if (value2 instanceof Collection) {
                        featureUsed = ((Collection)value2).size() > 0;
                    } else {
                        if (!(value2 instanceof Map)) continue;
                        boolean bl = featureUsed = ((Map)value2).size() > 0;
                    }
                    if (!featureUsed) continue;
                    ArrayList pairs = new ArrayList();
                    pairs.add(ID_FIELD.with((Object)runConfiguration.getType().getId()));
                    pairs.add(EventFields.PluginInfo.with((Object)info2));
                    pairs.add(FEATURE_NAME_FIELD.with((Object)name2));
                    RunConfigurationTypeUsagesCollector.addOrIncrement(templates, new Template(FEATURE_USED_EVENT, pairs));
                }
            }
        }
    }

    @NotNull
    public static List<EventPair<?>> createFeatureUsageData(@NotNull ConfigurationType configuration2, @Nullable ConfigurationFactory factory2) {
        if (configuration2 == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        String id2 = configuration2 instanceof UnknownConfigurationType ? "unknown" : configuration2.getId();
        ArrayList pairs = new ArrayList();
        pairs.add(ID_FIELD.with((Object)id2));
        if (factory2 != null && configuration2.getConfigurationFactories().length > 1) {
            pairs.add(FACTORY_FIELD.with((Object)factory2.getId()));
        }
        ArrayList arrayList = pairs;
        if (arrayList == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static ArrayList<EventPair<Boolean>> getSettings(@NotNull RunnerAndConfigurationSettings settings, @NotNull RunConfiguration runConfiguration) {
        if (settings == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(5);
        }
        if (runConfiguration == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new EventPair[]{SHARED_FIELD.with((Object)settings.isShared()), EDIT_BEFORE_RUN_FIELD.with((Object)settings.isEditBeforeRun()), ACTIVATE_BEFORE_RUN_FIELD.with((Object)settings.isActivateToolWindowBeforeRun()), PARALLEL_FIELD.with((Object)runConfiguration.isAllowRunningInParallel()), TEMPORARY_FIELD.with((Object)settings.isTemporary())});
        if (arrayList == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static String getAssignedTargetType(@NotNull Project project, @NotNull TargetEnvironmentAwareRunProfile runConfiguration) {
        TargetEnvironmentConfiguration target2;
        String assignedTargetName;
        if (project == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(8);
        }
        if (runConfiguration == null) {
            RunConfigurationTypeUsagesCollector.$$$reportNull$$$0(9);
        }
        if ("@@@LOCAL@@@".equals(assignedTargetName = runConfiguration.getDefaultTargetName())) {
            return LOCAL_TYPE_ID;
        }
        if (assignedTargetName != null && (target2 = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)project).getTargets().findByName(assignedTargetName)) != null) {
            return target2.getTypeId();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFeatureUsageData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFeatureUsageData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedTargetType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RunConfigurationUtilValidator
    extends CustomValidationRule {
        public boolean acceptRuleId(@Nullable String ruleId) {
            return "run_config_id".equals(ruleId) || "run_config_factory".equals(ruleId);
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
            if (data2 == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(1);
            }
            if (RunConfigurationUtilValidator.isThirdPartyValue((String)data2) || "unknown".equals(data2)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            String configurationId = this.getEventDataField(context2, ID_FIELD.getName());
            String factoryId = this.getEventDataField(context2, FACTORY_FIELD.getName());
            if (configurationId == null) {
                ValidationResultType validationResultType = ValidationResultType.REJECTED;
                if (validationResultType == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(3);
                }
                return validationResultType;
            }
            if (StringUtil.equals((CharSequence)data2, (CharSequence)configurationId) || StringUtil.equals((CharSequence)data2, (CharSequence)factoryId)) {
                Pair<ConfigurationType, ConfigurationFactory> configurationAndFactory = RunConfigurationUtilValidator.findConfigurationAndFactory(configurationId, factoryId);
                ConfigurationType configuration2 = (ConfigurationType)configurationAndFactory.getFirst();
                ConfigurationFactory factory2 = (ConfigurationFactory)configurationAndFactory.getSecond();
                if (configuration2 != null && (StringUtil.isEmpty((String)factoryId) || factory2 != null)) {
                    PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(configuration2.getClass());
                    context2.setPayload(PLUGIN_INFO, (Object)info2);
                    ValidationResultType validationResultType = info2.isDevelopedByJetBrains() ? ValidationResultType.ACCEPTED : ValidationResultType.THIRD_PARTY;
                    if (validationResultType == null) {
                        RunConfigurationUtilValidator.$$$reportNull$$$0(4);
                    }
                    return validationResultType;
                }
            }
            ValidationResultType validationResultType = ValidationResultType.REJECTED;
            if (validationResultType == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(5);
            }
            return validationResultType;
        }

        @NotNull
        private static Pair<ConfigurationType, ConfigurationFactory> findConfigurationAndFactory(@NotNull String configurationId, @Nullable String factoryId) {
            ConfigurationType configuration2;
            if (configurationId == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(6);
            }
            if ((configuration2 = RunConfigurationUtilValidator.findRunConfigurationById(configurationId)) == null) {
                Pair pair = Pair.empty();
                if (pair == null) {
                    RunConfigurationUtilValidator.$$$reportNull$$$0(7);
                }
                return pair;
            }
            ConfigurationFactory factory2 = StringUtil.isEmpty((String)factoryId) ? null : RunConfigurationUtilValidator.findFactoryById(configuration2, factoryId);
            Pair pair = Pair.create((Object)configuration2, (Object)factory2);
            if (pair == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(8);
            }
            return pair;
        }

        @Nullable
        private static ConfigurationType findRunConfigurationById(@NotNull String configuration2) {
            ConfigurationType[] types;
            if (configuration2 == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(9);
            }
            for (ConfigurationType type : types = (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
                if (!StringUtil.equals((CharSequence)type.getId(), (CharSequence)configuration2)) continue;
                return type;
            }
            return null;
        }

        @Nullable
        private static ConfigurationFactory findFactoryById(@NotNull ConfigurationType configuration2, @NotNull String factoryId) {
            if (configuration2 == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(10);
            }
            if (factoryId == null) {
                RunConfigurationUtilValidator.$$$reportNull$$$0(11);
            }
            for (ConfigurationFactory factory2 : configuration2.getConfigurationFactories()) {
                if (!StringUtil.equals((CharSequence)factory2.getId(), (CharSequence)factoryId)) continue;
                return factory2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$RunConfigurationUtilValidator";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationId";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factoryId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$RunConfigurationUtilValidator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findConfigurationAndFactory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "findConfigurationAndFactory";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "findRunConfigurationById";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findFactoryById";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Template {
        private final VarargEventId myEventId;
        private final List<EventPair<?>> myEventPairs;

        private Template(VarargEventId id2, List<EventPair<?>> pairs) {
            this.myEventId = id2;
            this.myEventPairs = pairs;
        }

        @NotNull
        private MetricEvent createMetricEvent(int count) {
            this.myEventPairs.add(COUNT_FIELD.with((Object)count));
            MetricEvent metricEvent = this.myEventId.metric(this.myEventPairs);
            if (metricEvent == null) {
                Template.$$$reportNull$$$0(0);
            }
            return metricEvent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Template template = (Template)o;
            return Objects.equals(this.myEventId, template.myEventId) && Objects.equals(this.myEventPairs, template.myEventPairs);
        }

        public int hashCode() {
            return Objects.hash(this.myEventId, this.myEventPairs);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/statistics/RunConfigurationTypeUsagesCollector$Template", "createMetricEvent"));
        }
    }
}

