/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar;

import com.intellij.CommonBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerKt;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runToolbar.ActiveListener;
import com.intellij.execution.runToolbar.ActiveProcesses;
import com.intellij.execution.runToolbar.RunToolbarData;
import com.intellij.execution.runToolbar.RunToolbarDataKt;
import com.intellij.execution.runToolbar.RunToolbarProcess;
import com.intellij.execution.runToolbar.RunToolbarSettings;
import com.intellij.execution.runToolbar.RunToolbarShortcutHelper;
import com.intellij.execution.runToolbar.RunToolbarSlotManager;
import com.intellij.execution.runToolbar.SlotDate;
import com.intellij.execution.runToolbar.SlotListener;
import com.intellij.execution.runToolbar.StateListener;
import com.intellij.execution.runToolbar.WaitingForAProcesses;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.ActivityTracker;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 b2\u00020\u0001:\u0002bcB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010+\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b0J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b0J\u0015\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020*H\u0000\u00a2\u0006\u0002\b0J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0018H\u0002J\b\u00105\u001a\u00020.H\u0002J\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\u0018092\u0006\u00102\u001a\u000203H\u0002J\u0017\u0010:\u001a\u0004\u0018\u00010\u00182\u0006\u0010;\u001a\u000207H\u0000\u00a2\u0006\u0002\b<J\u000f\u0010=\u001a\u0004\u0018\u00010>H\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u000203H\u0002J\r\u0010B\u001a\u00020%H\u0000\u00a2\u0006\u0002\bCJ\b\u0010D\u001a\u00020\u0006H\u0002J\u0015\u0010E\u001a\u00020.2\u0006\u0010F\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bGJ\u0015\u0010H\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\bKJ\u000e\u0010L\u001a\u00020.2\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020.2\u0006\u00102\u001a\u000203J\u0015\u0010P\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\bQJ\u0015\u0010P\u001a\u00020.2\u0006\u0010/\u001a\u00020\"H\u0000\u00a2\u0006\u0002\bQJ\u0015\u0010P\u001a\u00020.2\u0006\u0010/\u001a\u00020*H\u0000\u00a2\u0006\u0002\bQJ\u0015\u0010R\u001a\u00020.2\u0006\u0010F\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\bSJ\r\u0010T\u001a\u00020.H\u0000\u00a2\u0006\u0002\bUJ\r\u0010V\u001a\u000207H\u0000\u00a2\u0006\u0002\bWJ%\u0010X\u001a\u00020.2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b^J\b\u0010_\u001a\u00020.H\u0002J\b\u0010`\u001a\u00020.H\u0002J\b\u0010a\u001a\u00020.H\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00180$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020%@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarSlotManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "value", "", "active", "getActive$intellij_platform_execution_impl", "()Z", "setActive$intellij_platform_execution_impl", "(Z)V", "activeProcesses", "Lcom/intellij/execution/runToolbar/ActiveProcesses;", "getActiveProcesses", "()Lcom/intellij/execution/runToolbar/ActiveProcesses;", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "dataIds", "", "", "listeners", "Lcom/intellij/execution/runToolbar/ActiveListener;", "mainSlotData", "Lcom/intellij/execution/runToolbar/SlotDate;", "getMainSlotData$intellij_platform_execution_impl", "()Lcom/intellij/execution/runToolbar/SlotDate;", "setMainSlotData$intellij_platform_execution_impl", "(Lcom/intellij/execution/runToolbar/SlotDate;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "runToolbarSettings", "Lcom/intellij/execution/runToolbar/RunToolbarSettings;", "slotListeners", "Lcom/intellij/execution/runToolbar/SlotListener;", "slotsData", "", "Lcom/intellij/execution/runToolbar/RunToolbarSlotManager$State;", "state", "setState", "(Lcom/intellij/execution/runToolbar/RunToolbarSlotManager$State;)V", "stateListeners", "Lcom/intellij/execution/runToolbar/StateListener;", "addAndSaveSlot", "addAndSaveSlot$intellij_platform_execution_impl", "addListener", "", "listener", "addListener$intellij_platform_execution_impl", "addNewProcess", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "addSlot", "clear", "extraSlotCount", "", "getAppropriateSettings", "", "getData", "index", "getData$intellij_platform_execution_impl", "getMainOrFirstActiveProcess", "Lcom/intellij/execution/runToolbar/RunToolbarProcess;", "getMainOrFirstActiveProcess$intellij_platform_execution_impl", "getMoveNewOnTop", "executionEnvironment", "getState", "getState$intellij_platform_execution_impl", "getUpdateMainBySelected", "moveToTop", "id", "moveToTop$intellij_platform_execution_impl", "processNotStarted", "processNotStarted$intellij_platform_execution_impl", "processStarted", "processStarted$intellij_platform_execution_impl", "processTerminated", "executionId", "", "processTerminating", "removeListener", "removeListener$intellij_platform_execution_impl", "removeSlot", "removeSlot$intellij_platform_execution_impl", "saveSlotsConfiguration", "saveSlotsConfiguration$intellij_platform_execution_impl", "slotsCount", "slotsCount$intellij_platform_execution_impl", "startWaitingForAProcess", "slotDate", "Lcom/intellij/execution/runToolbar/RunToolbarData;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "executorId", "startWaitingForAProcess$intellij_platform_execution_impl", "traceState", "update", "updateState", "Companion", "State", "intellij.platform.execution.impl"})
public final class RunToolbarSlotManager {
    private final RunToolbarSettings runToolbarSettings;
    private MessageBusConnection connection;
    private final List<SlotListener> slotListeners;
    private final List<ActiveListener> listeners;
    private final List<StateListener> stateListeners;
    private boolean active;
    @NotNull
    private SlotDate mainSlotData;
    @NotNull
    private final ActiveProcesses activeProcesses;
    private final List<String> dataIds;
    private final Map<String, SlotDate> slotsData;
    private State state;
    @NotNull
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void addListener$intellij_platform_execution_impl(@NotNull SlotListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.slotListeners.add(listener2);
    }

    public final void removeListener$intellij_platform_execution_impl(@NotNull SlotListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.slotListeners.remove(listener2);
    }

    public final void addListener$intellij_platform_execution_impl(@NotNull ActiveListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener$intellij_platform_execution_impl(@NotNull ActiveListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    public final void addListener$intellij_platform_execution_impl(@NotNull StateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.stateListeners.add(listener2);
    }

    public final void removeListener$intellij_platform_execution_impl(@NotNull StateListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.stateListeners.remove(listener2);
    }

    public final boolean getActive$intellij_platform_execution_impl() {
        return this.active;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActive$intellij_platform_execution_impl(boolean value2) {
        Object it;
        Iterable $this$forEach$iv;
        if (this.active == value2) {
            return;
        }
        this.active = value2;
        if (value2) {
            MessageBusConnection con;
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                LOG.info("SM settings: new on top " + this.runToolbarSettings.getMoveNewOnTop() + "; update by selected " + this.getUpdateMainBySelected() + " RunToolbar");
            }
            List<RunnerAndConfigurationSettings> runConfigurations = this.runToolbarSettings.getRunConfigurations();
            Iterable $this$forEachIndexed$iv = runConfigurations;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void entry2;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = (RunnerAndConfigurationSettings)item$iv;
                int index2 = n;
                boolean bl2 = false;
                if (index2 == 0) {
                    this.mainSlotData.setConfiguration((RunnerAndConfigurationSettings)entry2);
                    continue;
                }
                this.addSlot().setConfiguration((RunnerAndConfigurationSettings)entry2);
            }
            if (RunToolbarProcess.Companion.getLogNeeded()) {
                LOG.info("SM restoreRunConfigurations: " + runConfigurations + " RunToolbar");
            }
            MessageBusConnection messageBusConnection2 = this.project.getMessageBus().connect();
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection2, (String)"project.messageBus.connect()");
            this.connection = con = messageBusConnection2;
            con.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(this){
                final /* synthetic */ RunToolbarSlotManager this$0;

                public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                    if (!RunToolbarSlotManager.access$getUpdateMainBySelected(this.this$0) || Intrinsics.areEqual((Object)this.this$0.getMainSlotData$intellij_platform_execution_impl().getConfiguration(), (Object)settings)) {
                        return;
                    }
                    ExecutionEnvironment executionEnvironment = this.this$0.getMainSlotData$intellij_platform_execution_impl().getEnvironment();
                    if (executionEnvironment != null) {
                        ExecutionEnvironment executionEnvironment2 = executionEnvironment;
                        boolean bl = false;
                        boolean bl2 = false;
                        ExecutionEnvironment it = executionEnvironment2;
                        boolean bl3 = false;
                        SlotDate slot = RunToolbarSlotManager.access$addSlot(this.this$0);
                        slot.setConfiguration(settings);
                        if (RunToolbarProcess.Companion.getLogNeeded()) {
                            RunToolbarSlotManager.access$getLOG$cp().info("SM runConfigurationSelected: " + settings + " first slot added RunToolbar");
                        }
                        this.this$0.moveToTop$intellij_platform_execution_impl(slot.getId());
                    } else {
                        boolean bl = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        this.this$0.getMainSlotData$intellij_platform_execution_impl().setConfiguration(settings);
                        if (RunToolbarProcess.Companion.getLogNeeded()) {
                            RunToolbarSlotManager.access$getLOG$cp().info("SM runConfigurationSelected: " + settings + " change main configuration RunToolbar");
                        }
                        RunToolbarSlotManager.access$update(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            });
            Iterable $this$forEach$iv2 = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                ActiveListener it2 = (ActiveListener)element$iv;
                boolean bl = false;
                it2.enabled();
            }
        } else {
            $this$forEach$iv = this.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ActiveListener)element$iv;
                boolean bl = false;
                it.disabled();
            }
            this.clear();
        }
        $this$forEach$iv = this.slotListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (SlotListener)element$iv;
            boolean bl = false;
            it.rebuildPopup();
        }
    }

    private final boolean getUpdateMainBySelected() {
        return this.runToolbarSettings.getUpdateMainBySelected();
    }

    private final boolean getMoveNewOnTop(ExecutionEnvironment executionEnvironment) {
        if (!this.runToolbarSettings.getMoveNewOnTop()) {
            return false;
        }
        Boolean bl = (Boolean)executionEnvironment.getUserData(RunToolbarData.RUN_TOOLBAR_SUPPRESS_MAIN_SLOT_USER_DATA_KEY);
        if (bl == null) {
            bl = false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"executionEnvironment.get\u2026T_USER_DATA_KEY) ?: false");
        boolean suppressValue = bl;
        return !suppressValue;
    }

    private final void clear() {
        MessageBusConnection messageBusConnection2 = this.connection;
        if (messageBusConnection2 != null) {
            MessageBusConnection messageBusConnection3 = messageBusConnection2;
            boolean bl = false;
            boolean bl2 = false;
            MessageBusConnection it = messageBusConnection3;
            boolean bl3 = false;
            it.disconnect();
            this.connection = null;
        }
        this.mainSlotData.clear();
        this.dataIds.clear();
        this.slotsData.clear();
        this.slotsData.put(this.mainSlotData.getId(), this.mainSlotData);
        this.activeProcesses.clear$intellij_platform_execution_impl();
    }

    @NotNull
    public final SlotDate getMainSlotData$intellij_platform_execution_impl() {
        return this.mainSlotData;
    }

    public final void setMainSlotData$intellij_platform_execution_impl(@NotNull SlotDate slotDate) {
        Intrinsics.checkNotNullParameter((Object)slotDate, (String)"<set-?>");
        this.mainSlotData = slotDate;
    }

    @NotNull
    public final ActiveProcesses getActiveProcesses() {
        return this.activeProcesses;
    }

    /*
     * WARNING - void declaration
     */
    private final void traceState() {
        void $this$mapNotNullTo$iv$iv;
        if (!RunToolbarProcess.Companion.getLogNeeded()) {
            return;
        }
        String separator2 = " ";
        Iterable $this$mapNotNull$iv = (Iterable)CollectionsKt.getIndices((Collection)this.dataIds);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String string;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            if (it + 1 + ": " + this.slotsData.get(this.dataIds.get(it)) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String ids = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        LOG.info("SM state: " + (Object)((Object)this.state) + separator2 + "== slots: 0: " + this.mainSlotData + ", " + ids + separator2 + "== slotsData: " + this.slotsData.values() + " RunToolbar");
    }

    private final void update() {
        this.saveSlotsConfiguration$intellij_platform_execution_impl();
        this.updateState();
    }

    public final void startWaitingForAProcess$intellij_platform_execution_impl(@NotNull RunToolbarData slotDate, @NotNull RunnerAndConfigurationSettings settings, @NotNull String executorId) {
        Intrinsics.checkNotNullParameter((Object)slotDate, (String)"slotDate");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Iterable $this$forEach$iv = this.slotsData.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SlotDate it = (SlotDate)element$iv;
            boolean bl = false;
            WaitingForAProcesses waitingForAProcesses = it.getWaitingForAProcesses();
            if (Intrinsics.areEqual((Object)slotDate, (Object)it)) {
                waitingForAProcesses.start$intellij_platform_execution_impl(this.project, settings, executorId);
                continue;
            }
            if (!waitingForAProcesses.isWaitingForASubProcess$intellij_platform_execution_impl(settings, executorId)) continue;
            waitingForAProcesses.clear$intellij_platform_execution_impl();
        }
    }

    @Nullable
    public final RunToolbarProcess getMainOrFirstActiveProcess$intellij_platform_execution_impl() {
        ExecutionEnvironment executionEnvironment = this.mainSlotData.getEnvironment();
        if (executionEnvironment == null || (executionEnvironment = RunToolbarDataKt.getRunToolbarProcess(executionEnvironment)) == null) {
            executionEnvironment = (RunToolbarProcess)CollectionsKt.firstOrNull((Iterable)this.activeProcesses.getProcesses().keySet());
        }
        return executionEnvironment;
    }

    public final int slotsCount$intellij_platform_execution_impl() {
        return this.dataIds.size();
    }

    private final void setState(State value2) {
        if (value2 == this.state) {
            return;
        }
        this.state = value2;
        this.traceState();
        Iterable $this$forEach$iv = this.stateListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StateListener it = (StateListener)element$iv;
            boolean bl = false;
            it.stateChanged(value2);
        }
    }

    private final void updateState() {
        State state;
        RunToolbarSlotManager runToolbarSlotManager = this;
        switch (this.activeProcesses.getActiveCount()) {
            case 0: {
                state = State.INACTIVE;
                break;
            }
            case 1: {
                state = this.mainSlotData.getEnvironment();
                if (state != null) {
                    State state2 = state;
                    boolean bl = false;
                    boolean bl2 = false;
                    State state3 = state2;
                    RunToolbarSlotManager runToolbarSlotManager2 = runToolbarSlotManager;
                    boolean bl3 = false;
                    State state4 = State.SINGLE_MAIN;
                    runToolbarSlotManager = runToolbarSlotManager2;
                    state = state4;
                    if (state != null) break;
                }
                state = State.SINGLE_PLAIN;
                break;
            }
            default: {
                state = this.mainSlotData.getEnvironment();
                if (state != null) {
                    State state5 = state;
                    boolean bl = false;
                    boolean bl4 = false;
                    State it = state5;
                    RunToolbarSlotManager runToolbarSlotManager3 = runToolbarSlotManager;
                    boolean bl5 = false;
                    State state6 = State.MULTIPLE_WITH_MAIN;
                    runToolbarSlotManager = runToolbarSlotManager3;
                    state = state6;
                    if (state != null) break;
                }
                state = State.MULTIPLE;
            }
        }
        runToolbarSlotManager.setState(state);
    }

    @NotNull
    public final State getState$intellij_platform_execution_impl() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<SlotDate> getAppropriateSettings(ExecutionEnvironment env) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean bl = false;
        List sortedSlots = new ArrayList();
        sortedSlots.add(this.mainSlotData);
        Iterable iterable = this.dataIds;
        List list2 = sortedSlots;
        boolean $i$f$mapNotNull = false;
        void var5_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SlotDate slotDate;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (this.slotsData.get(it) == null) continue;
            boolean bl4 = false;
            boolean bl5 = false;
            SlotDate it$iv$iv = slotDate;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        list2.addAll(CollectionsKt.toList((Iterable)list3));
        Iterable $this$filter$iv = sortedSlots;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SlotDate it = (SlotDate)element$iv$iv;
            boolean bl7 = false;
            if (!Intrinsics.areEqual((Object)it.getConfiguration(), (Object)env.getRunnerAndConfigurationSettings())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void processNotStarted$intellij_platform_execution_impl(@NotNull ExecutionEnvironment env) {
        block9: {
            Object v9;
            block7: {
                void $this$firstOrNull$iv;
                void $this$filterTo$iv$iv;
                Object it;
                RunnerAndConfigurationSettings config2;
                block8: {
                    Object v3;
                    block6: {
                        void $this$firstOrNull$iv2;
                        void $this$mapTo$iv$iv;
                        Iterable $this$filterTo$iv$iv2;
                        Iterable<SlotDate> appropriateSettings;
                        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
                        if (runnerAndConfigurationSettings == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"env.runnerAndConfigurationSettings ?: return");
                        config2 = runnerAndConfigurationSettings;
                        Iterable<SlotDate> $this$filter$iv = appropriateSettings = this.getAppropriateSettings(env);
                        boolean $i$f$filter = false;
                        Iterable<SlotDate> iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            it = (SlotDate)element$iv$iv;
                            boolean bl = false;
                            if (!(((SlotDate)it).getEnvironment() == null)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List emptySlotsWithConfiguration = (List)destination$iv$iv;
                        Iterable $this$map$iv = emptySlotsWithConfiguration;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv2 = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            it = (SlotDate)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            WaitingForAProcesses waitingForAProcesses = ((SlotDate)it).getWaitingForAProcesses();
                            collection.add(waitingForAProcesses);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv2) {
                            WaitingForAProcesses it2 = (WaitingForAProcesses)element$iv;
                            boolean bl = false;
                            Executor executor = env.getExecutor();
                            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
                            String string = executor.getId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"env.executor.id");
                            if (!it2.isWaitingForASingleProcess$intellij_platform_execution_impl(config2, string)) continue;
                            v3 = element$iv;
                            break block6;
                        }
                        v3 = null;
                    }
                    WaitingForAProcesses waitingForAProcesses = v3;
                    if (waitingForAProcesses == null) break block8;
                    waitingForAProcesses.clear$intellij_platform_execution_impl();
                    break block9;
                }
                RunToolbarSlotManager runToolbarSlotManager = this;
                boolean bl = false;
                boolean bl2 = false;
                RunToolbarSlotManager $this$run = runToolbarSlotManager;
                boolean bl3 = false;
                Iterable $this$filter$iv = $this$run.slotsData.values();
                boolean $i$f$filter = false;
                it = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    SlotDate it3 = (SlotDate)element$iv$iv;
                    boolean bl4 = false;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = it3.getConfiguration();
                    if (!((runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null) instanceof CompoundRunConfiguration)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SlotDate slotsData = (SlotDate)element$iv;
                    boolean bl5 = false;
                    WaitingForAProcesses waitingForAProcesses = slotsData.getWaitingForAProcesses();
                    Executor executor = env.getExecutor();
                    Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
                    String string = executor.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"env.executor.id");
                    if (!waitingForAProcesses.isWaitingForASubProcess$intellij_platform_execution_impl(config2, string)) continue;
                    v9 = element$iv;
                    break block7;
                }
                v9 = null;
            }
            SlotDate slotDate = v9;
            if (slotDate == null) break block9;
            slotDate.clear();
        }
    }

    public final void processStarted$intellij_platform_execution_impl(@NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        this.addNewProcess(env);
        SwingUtilities.invokeLater(processStarted.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void addNewProcess(ExecutionEnvironment env) {
        SlotDate slotDate;
        SlotDate slotDate2;
        boolean bl;
        SlotDate slotDate3;
        SlotDate slotDate4;
        boolean $i$f$firstOrNull;
        Iterable $this$firstOrNull$iv;
        boolean newSlot;
        List emptySlotsWithConfiguration;
        block14: {
            void $this$filterTo$iv$iv;
            Iterable appropriateSettings;
            Iterable $this$filter$iv = appropriateSettings = this.getAppropriateSettings(env);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SlotDate it = (SlotDate)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getEnvironment() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            emptySlotsWithConfiguration = (List)destination$iv$iv;
            newSlot = false;
            $this$firstOrNull$iv = appropriateSettings;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SlotDate it = element$iv;
                boolean bl3 = false;
                ExecutionEnvironment executionEnvironment = it.getEnvironment();
                if (!(executionEnvironment != null && executionEnvironment.getExecutionId() == env.getExecutionId())) continue;
                slotDate4 = element$iv;
                break block14;
            }
            slotDate4 = null;
        }
        if ((slotDate3 = (SlotDate)slotDate4) == null) {
            Object object;
            block15: {
                $this$firstOrNull$iv = emptySlotsWithConfiguration;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl4;
                    SlotDate slotData = element$iv;
                    boolean bl5 = false;
                    if (env.getRunnerAndConfigurationSettings() != null) {
                        RunnerAndConfigurationSettings bl2;
                        boolean bl6 = false;
                        bl = false;
                        RunnerAndConfigurationSettings it = bl2;
                        boolean bl7 = false;
                        WaitingForAProcesses waitingForAProcesses = slotData.getWaitingForAProcesses();
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings = it;
                        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"it");
                        Executor executor = env.getExecutor();
                        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
                        String string = executor.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"env.executor.id");
                        bl4 = waitingForAProcesses.isWaitingForASingleProcess$intellij_platform_execution_impl(runnerAndConfigurationSettings, string);
                    } else {
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    object = element$iv;
                    break block15;
                }
                object = null;
            }
            slotDate3 = slotDate2 = (SlotDate)object;
        }
        if (slotDate3 == null) {
            slotDate2 = slotDate = (SlotDate)CollectionsKt.firstOrNull((List)emptySlotsWithConfiguration);
        }
        if (slotDate2 == null) {
            boolean $this$firstOrNull$iv2 = false;
            $i$f$firstOrNull = false;
            boolean bl8 = false;
            newSlot = true;
            slotDate = this.addSlot();
        }
        SlotDate slot = slotDate;
        slot.setEnvironment(env);
        this.activeProcesses.updateActiveProcesses$intellij_platform_execution_impl(this.slotsData);
        if (newSlot) {
            boolean isCompoundProcess;
            Object v17;
            block16: {
                void $this$firstOrNull$iv3;
                void $this$filterTo$iv$iv;
                Object element$iv;
                Iterable $this$filter$iv = this.slotsData.values();
                boolean $i$f$filter = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    SlotDate it = (SlotDate)element$iv$iv;
                    boolean bl9 = false;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = it.getConfiguration();
                    if (!((runnerAndConfigurationSettings != null ? runnerAndConfigurationSettings.getConfiguration() : null) instanceof CompoundRunConfiguration)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull2 = false;
                for (Object element$iv2 : $this$firstOrNull$iv3) {
                    boolean bl10;
                    SlotDate slotsData = (SlotDate)element$iv2;
                    boolean bl11 = false;
                    if (env.getRunnerAndConfigurationSettings() != null) {
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings;
                        bl = false;
                        boolean bl12 = false;
                        RunnerAndConfigurationSettings it = runnerAndConfigurationSettings;
                        boolean bl13 = false;
                        WaitingForAProcesses waitingForAProcesses = slotsData.getWaitingForAProcesses();
                        RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings2, (String)"it");
                        Executor executor = env.getExecutor();
                        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"env.executor");
                        String string = executor.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"env.executor.id");
                        bl10 = waitingForAProcesses.checkAndUpdate$intellij_platform_execution_impl(runnerAndConfigurationSettings2, string);
                    } else {
                        bl10 = false;
                    }
                    if (!bl10) continue;
                    v17 = element$iv2;
                    break block16;
                }
                v17 = null;
            }
            boolean bl14 = isCompoundProcess = v17 != null;
            if (!isCompoundProcess && this.getMoveNewOnTop(env)) {
                this.moveToTop$intellij_platform_execution_impl(slot.getId());
            }
        }
        this.update();
    }

    public final void processTerminating(@NotNull ExecutionEnvironment env) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            Iterable $this$firstOrNull$iv = this.slotsData.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SlotDate it = (SlotDate)element$iv;
                boolean bl = false;
                ExecutionEnvironment executionEnvironment = it.getEnvironment();
                if (!(executionEnvironment != null && executionEnvironment.getExecutionId() == env.getExecutionId())) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        SlotDate slotDate = v1;
        if (slotDate != null) {
            SlotDate slotDate2 = slotDate;
            boolean bl = false;
            boolean bl2 = false;
            SlotDate it = slotDate2;
            boolean bl3 = false;
            it.setEnvironment(env);
        }
        this.activeProcesses.updateActiveProcesses$intellij_platform_execution_impl(this.slotsData);
        this.updateState();
        SwingUtilities.invokeLater(processTerminating.3.INSTANCE);
    }

    public final void processTerminated(long executionId) {
        Object v1;
        block9: {
            Iterable $this$firstOrNull$iv = this.slotsData.values();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SlotDate it = (SlotDate)element$iv;
                boolean bl = false;
                ExecutionEnvironment executionEnvironment = it.getEnvironment();
                if (!(executionEnvironment != null && executionEnvironment.getExecutionId() == executionId)) continue;
                v1 = element$iv;
                break block9;
            }
            v1 = null;
        }
        SlotDate slotDate = v1;
        if (slotDate != null) {
            boolean removable;
            boolean bl;
            SlotDate slotDate2 = slotDate;
            boolean bl2 = false;
            boolean bl3 = false;
            SlotDate slotDate3 = slotDate2;
            boolean bl4 = false;
            ExecutionEnvironment executionEnvironment = slotDate3.getEnvironment();
            if (executionEnvironment != null && (executionEnvironment = executionEnvironment.getRunnerAndConfigurationSettings()) != null) {
                ExecutionEnvironment executionEnvironment2 = executionEnvironment;
                boolean bl5 = false;
                boolean bl6 = false;
                ExecutionEnvironment it = executionEnvironment2;
                boolean bl7 = false;
                RunManager runManager = RunManager.Companion.getInstance(this.project);
                ExecutionEnvironment executionEnvironment3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)executionEnvironment3, (String)"it");
                bl = !runManager.hasSettings((RunnerAndConfigurationSettings)executionEnvironment3);
            } else {
                bl = removable = true;
            }
            if (removable) {
                if (Intrinsics.areEqual((Object)slotDate3, (Object)this.mainSlotData) && this.slotsData.size() == 1) {
                    slotDate3.clear();
                    slotDate3.setConfiguration(RunManager.Companion.getInstance(this.project).getSelectedConfiguration());
                } else {
                    this.removeSlot$intellij_platform_execution_impl(slotDate3.getId());
                }
            } else {
                slotDate3.setEnvironment(null);
            }
        }
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("SM process stopped: " + executionId + " RunToolbar");
        }
        this.activeProcesses.updateActiveProcesses$intellij_platform_execution_impl(this.slotsData);
        this.updateState();
        SwingUtilities.invokeLater(processTerminated.3.INSTANCE);
    }

    public final int extraSlotCount() {
        return this.dataIds.size();
    }

    @NotNull
    public final SlotDate addAndSaveSlot$intellij_platform_execution_impl() {
        SlotDate slot = this.addSlot();
        this.saveSlotsConfiguration$intellij_platform_execution_impl();
        return slot;
    }

    private final SlotDate addSlot() {
        SlotDate slot = new SlotDate(null, 1, null);
        this.dataIds.add(slot.getId());
        this.slotsData.put(slot.getId(), slot);
        Iterable $this$forEach$iv = this.slotListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SlotListener it = (SlotListener)element$iv;
            boolean bl = false;
            it.slotAdded();
        }
        return slot;
    }

    @Nullable
    public final SlotDate getData$intellij_platform_execution_impl(int index2) {
        SlotDate slotDate;
        if (index2 >= 0 && index2 < this.dataIds.size()) {
            String string = this.dataIds.get(index2);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            slotDate = this.slotsData.get(it);
        } else {
            slotDate = null;
        }
        return slotDate;
    }

    public final void moveToTop$intellij_platform_execution_impl(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (Intrinsics.areEqual((Object)this.mainSlotData.getId(), (Object)id2)) {
            return;
        }
        SlotDate slotDate = this.slotsData.get(id2);
        if (slotDate != null) {
            SlotDate slotDate2 = slotDate;
            boolean bl = false;
            boolean bl2 = false;
            SlotDate newMain = slotDate2;
            boolean bl3 = false;
            SlotDate oldMain = this.mainSlotData;
            this.mainSlotData = newMain;
            this.dataIds.remove(id2);
            this.dataIds.add(0, oldMain.getId());
        }
        this.update();
    }

    public final void removeSlot$intellij_platform_execution_impl(@NotNull String id2) {
        block6: {
            block3: {
                Function0<Unit> $fun$remove$1;
                block4: {
                    ExecutionEnvironment it;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
                        int index2 = this.dataIds.indexOf(id2);
                        $fun$remove$1 = new Function0<Unit>(this, id2, index2){
                            final /* synthetic */ RunToolbarSlotManager this$0;
                            final /* synthetic */ String $id;
                            final /* synthetic */ int $index;

                            public final void invoke() {
                                if (Intrinsics.areEqual((Object)this.$id, (Object)this.this$0.getMainSlotData$intellij_platform_execution_impl().getId())) {
                                    Collection collection = RunToolbarSlotManager.access$getDataIds$p(this.this$0);
                                    boolean bl = false;
                                    if (!collection.isEmpty()) {
                                        String firstSlotId = (String)RunToolbarSlotManager.access$getDataIds$p(this.this$0).get(0);
                                        SlotDate slotDate = (SlotDate)RunToolbarSlotManager.access$getSlotsData$p(this.this$0).get(firstSlotId);
                                        if (slotDate != null) {
                                            SlotDate slotDate2 = slotDate;
                                            boolean bl2 = false;
                                            boolean bl3 = false;
                                            SlotDate it = slotDate2;
                                            boolean bl4 = false;
                                            this.this$0.setMainSlotData$intellij_platform_execution_impl(it);
                                            RunToolbarSlotManager.access$getSlotsData$p(this.this$0).remove(this.$id);
                                            RunToolbarSlotManager.access$getDataIds$p(this.this$0).remove(it.getId());
                                        }
                                    }
                                } else {
                                    RunToolbarSlotManager.access$getSlotsData$p(this.this$0).remove(this.$id);
                                    RunToolbarSlotManager.access$getDataIds$p(this.this$0).remove(this.$id);
                                }
                                SwingUtilities.invokeLater(new Runnable(this){
                                    final /* synthetic */ removeSlot.1 this$0;

                                    public final void run() {
                                        Iterable $this$forEach$iv = RunToolbarSlotManager.access$getSlotListeners$p(this.this$0.this$0);
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            SlotListener it = (SlotListener)element$iv;
                                            boolean bl = false;
                                            it.slotRemoved(this.this$0.$index);
                                        }
                                        ActivityTracker.getInstance().inc();
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                            }
                            {
                                this.this$0 = runToolbarSlotManager;
                                this.$id = string;
                                this.$index = n;
                                super(0);
                            }
                        };
                        SlotDate slotDate = index2 >= 0 ? this.getData$intellij_platform_execution_impl(index2) : (Intrinsics.areEqual((Object)this.mainSlotData.getId(), (Object)id2) ? this.mainSlotData : null);
                        if (slotDate == null) break block3;
                        SlotDate slotDate2 = slotDate;
                        boolean bl = false;
                        boolean bl2 = false;
                        SlotDate slotDate3 = slotDate2;
                        boolean bl3 = false;
                        ExecutionEnvironment executionEnvironment = slotDate3.getEnvironment();
                        if (executionEnvironment == null) break block4;
                        ExecutionEnvironment executionEnvironment2 = executionEnvironment;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        it = executionEnvironment2;
                        boolean bl6 = false;
                        if (!(Intrinsics.areEqual((Object)RunToolbarDataKt.isRunning(it), (Object)true) ^ true)) break block5;
                        $fun$remove$1.invoke();
                        break block6;
                    }
                    String string = LangBundle.message((String)"run.toolbar.remove.active.process.slot.message", (Object[])new Object[0]);
                    Object[] objectArray = new Object[1];
                    Object object = it.getRunnerAndConfigurationSettings();
                    if (object == null || (object = object.getName()) == null) {
                        object = objectArray[0] = "";
                    }
                    if (Messages.showOkCancelDialog((Project)this.project, (String)string, (String)LangBundle.message((String)"run.toolbar.remove.active.process.slot.title", (Object[])objectArray), (String)LangBundle.message((String)"run.toolbar.remove.active.process.slot.ok", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) != 0) break block6;
                    RunContentDescriptor runContentDescriptor = it.getContentToReuse();
                    if (runContentDescriptor != null) {
                        RunContentDescriptor runContentDescriptor2 = runContentDescriptor;
                        boolean bl = false;
                        boolean bl7 = false;
                        RunContentDescriptor it2 = runContentDescriptor2;
                        boolean bl8 = false;
                        ExecutionManagerImpl.Companion.stopProcess(it2);
                    }
                    $fun$remove$1.invoke();
                    break block6;
                }
                RunToolbarSlotManager runToolbarSlotManager = this;
                boolean bl = false;
                boolean bl9 = false;
                RunToolbarSlotManager $this$run = runToolbarSlotManager;
                boolean bl10 = false;
                $fun$remove$1.invoke();
                break block6;
            }
            Iterable $this$forEach$iv = this.slotListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SlotListener it = (SlotListener)element$iv;
                boolean bl = false;
                it.rebuildPopup();
            }
        }
        this.update();
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSlotsConfiguration$intellij_platform_execution_impl() {
        void $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        List list2 = new ArrayList();
        list2.add(this.mainSlotData.getId());
        list2.addAll((Collection)this.dataIds);
        if (Intrinsics.areEqual((Object)((Boolean)RunManagerKt.getIS_RUN_MANAGER_INITIALIZED().get((UserDataHolder)this.project)), (Object)true)) {
            RunManager runManager = RunManager.Companion.getInstance(this.project);
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mainSlotData.getConfiguration();
            if (runnerAndConfigurationSettings != null) {
                ExecutionEnvironment executionEnvironment;
                RunnerAndConfigurationSettings runnerAndConfigurationSettings2 = runnerAndConfigurationSettings;
                boolean bl2 = false;
                boolean bl3 = false;
                RunnerAndConfigurationSettings it = runnerAndConfigurationSettings2;
                boolean bl4 = false;
                if (runManager.hasSettings(it) && Intrinsics.areEqual((Object)it, (Object)runManager.getSelectedConfiguration()) ^ true && ((executionEnvironment = this.mainSlotData.getEnvironment()) == null || (executionEnvironment = RunToolbarDataKt.getRunToolbarProcess(executionEnvironment)) == null || !executionEnvironment.isTemporaryProcess())) {
                    runManager.setSelectedConfiguration(this.mainSlotData.getConfiguration());
                    if (RunToolbarProcess.Companion.getLogNeeded()) {
                        LOG.info("MANAGER saveSlotsConfiguration. change selected configuration by main: " + this.mainSlotData.getConfiguration() + " RunToolbar");
                    }
                }
            }
        }
        Iterable $this$mapNotNull$iv = list2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            String it = (String)element$iv$iv;
            boolean bl6 = false;
            SlotDate slotDate = this.slotsData.get(it);
            if ((slotDate != null ? slotDate.getConfiguration() : null) == null) continue;
            runnerAndConfigurationSettings = runnerAndConfigurationSettings;
            boolean bl7 = false;
            boolean bl8 = false;
            RunnerAndConfigurationSettings it$iv$iv = runnerAndConfigurationSettings;
            boolean bl9 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List configurations = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (RunToolbarProcess.Companion.getLogNeeded()) {
            LOG.info("MANAGER saveSlotsConfiguration: " + configurations + " RunToolbar");
        }
        this.runToolbarSettings.setRunConfigurations(configurations);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public RunToolbarSlotManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.runToolbarSettings = RunToolbarSettings.Companion.getInstance(this.project);
        boolean bl = false;
        this.slotListeners = new ArrayList();
        bl = false;
        this.listeners = new ArrayList();
        bl = false;
        this.stateListeners = new ArrayList();
        this.mainSlotData = new SlotDate(null, 1, null);
        this.activeProcesses = new ActiveProcesses();
        bl = false;
        this.dataIds = new ArrayList();
        bl = false;
        this.slotsData = new LinkedHashMap();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public final void run() {
                if (this.getProject().isDisposed()) {
                    return;
                }
                slotsData.put(this.getMainSlotData$intellij_platform_execution_impl().getId(), this.getMainSlotData$intellij_platform_execution_impl());
                this.addListener$intellij_platform_execution_impl(new RunToolbarShortcutHelper(this.getProject()));
                Disposer.register((Disposable)((Disposable)this.getProject()), (Disposable)new Disposable(){

                    public final void dispose() {
                        MessageBusConnection messageBusConnection2 = connection;
                        if (messageBusConnection2 != null) {
                            messageBusConnection2.disconnect();
                        }
                        listeners.clear();
                        stateListeners.clear();
                        slotListeners.clear();
                    }
                });
            }
        });
        this.state = State.INACTIVE;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RunToolbarSlotManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(RunTo\u2026rSlotManager::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$getUpdateMainBySelected(RunToolbarSlotManager $this) {
        return $this.getUpdateMainBySelected();
    }

    public static final /* synthetic */ SlotDate access$addSlot(RunToolbarSlotManager $this) {
        return $this.addSlot();
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$update(RunToolbarSlotManager $this) {
        $this.update();
    }

    public static final /* synthetic */ List access$getDataIds$p(RunToolbarSlotManager $this) {
        return $this.dataIds;
    }

    public static final /* synthetic */ void access$setConnection$p(RunToolbarSlotManager $this, MessageBusConnection messageBusConnection2) {
        $this.connection = messageBusConnection2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\u0004J\u0006\u0010\b\u001a\u00020\u0004J\u0006\u0010\t\u001a\u00020\u0004j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarSlotManager$State;", "", "(Ljava/lang/String;I)V", "isActive", "", "isMainActive", "isMultipleProcesses", "isSingleMain", "isSinglePlain", "isSingleProcess", "MULTIPLE", "MULTIPLE_WITH_MAIN", "SINGLE_MAIN", "SINGLE_PLAIN", "INACTIVE", "intellij.platform.execution.impl"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State MULTIPLE;
        public static final /* enum */ State MULTIPLE_WITH_MAIN;
        public static final /* enum */ State SINGLE_MAIN;
        public static final /* enum */ State SINGLE_PLAIN;
        public static final /* enum */ State INACTIVE;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[5];
            State[] stateArray2 = stateArray;
            stateArray[0] = MULTIPLE = new State();
            stateArray[1] = MULTIPLE_WITH_MAIN = new State();
            stateArray[2] = SINGLE_MAIN = new State();
            stateArray[3] = SINGLE_PLAIN = new State();
            stateArray[4] = INACTIVE = new State();
            $VALUES = stateArray;
        }

        public final boolean isSingleProcess() {
            return this == SINGLE_PLAIN || this == SINGLE_MAIN;
        }

        public final boolean isSingleMain() {
            return this == SINGLE_MAIN;
        }

        public final boolean isSinglePlain() {
            return this == SINGLE_PLAIN;
        }

        public final boolean isMultipleProcesses() {
            return this == MULTIPLE || this == MULTIPLE_WITH_MAIN;
        }

        public final boolean isMainActive() {
            return this == MULTIPLE_WITH_MAIN || this == SINGLE_MAIN;
        }

        public final boolean isActive() {
            return this != INACTIVE;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/runToolbar/RunToolbarSlotManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/execution/runToolbar/RunToolbarSlotManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.impl"})
    public static final class Companion {
        @NotNull
        public final RunToolbarSlotManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(RunToolbarSlotManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (RunToolbarSlotManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

