/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runToolbar.components;

import com.intellij.execution.runToolbar.components.ComboBoxArrowIcon;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/execution/runToolbar/components/ComboBoxArrowComponent;", "", "()V", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "getView", "Ljavax/swing/JComponent;", "intellij.platform.execution.impl"})
public final class ComboBoxArrowComponent {
    @NotNull
    private final JLabel label = new JLabel(){
        private final ComboBoxArrowIcon defaultIcon;

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.updateIcon();
        }

        private final void updateIcon() {
            Icon icon2;
            if (UIUtil.isUnderWin10LookAndFeel()) {
                if (this.isEnabled()) {
                    icon2 = UIManager.getIcon("ComboBoxButton.arrowIcon");
                    if (icon2 == null) {
                        Icon icon3 = AllIcons.General.ArrowDown;
                        icon2 = icon3;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.General.ArrowDown");
                    }
                } else {
                    icon2 = UIManager.getIcon("ComboBoxButton.arrowIconDisabled");
                    if (icon2 == null) {
                        Icon icon4 = IconLoader.getDisabledIcon((Icon)AllIcons.General.ArrowDown);
                        icon2 = icon4;
                        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"IconLoader.getDisabledIc\u2026lIcons.General.ArrowDown)");
                    }
                }
            } else {
                icon2 = this.defaultIcon;
            }
            this.setIcon(icon2);
        }
        {
            this.defaultIcon = new ComboBoxArrowIcon();
            this.updateIcon();
        }
    };

    @NotNull
    public final JComponent getView() {
        return this.label;
    }

    @NotNull
    public final JLabel getLabel() {
        return this.label;
    }
}

