/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.actions.CreateAction;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.util.SmartList;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RunContentBuilder
extends RunTab {
    private static final String JAVA_RUNNER = "JavaRunner";
    private final List<AnAction> myRunnerActions;
    private final ExecutionResult myExecutionResult;
    @Nullable
    private SingleContentSupplier mySupplier;

    public RunContentBuilder(@NotNull ExecutionResult executionResult, @NotNull ExecutionEnvironment environment2) {
        if (executionResult == null) {
            RunContentBuilder.$$$reportNull$$$0(0);
        }
        if (environment2 == null) {
            RunContentBuilder.$$$reportNull$$$0(1);
        }
        super(environment2, RunContentBuilder.getRunnerType(executionResult.getExecutionConsole()));
        this.myRunnerActions = new SmartList();
        this.myExecutionResult = executionResult;
        this.myUi.getOptions().setMoveToGridActionEnabled(false).setMinimizeActionEnabled(false);
    }

    @NotNull
    public static ExecutionEnvironment fix(@NotNull ExecutionEnvironment environment2, @Nullable ProgramRunner runner) {
        if (environment2 == null) {
            RunContentBuilder.$$$reportNull$$$0(2);
        }
        if (runner == null || runner.equals(environment2.getRunner())) {
            ExecutionEnvironment executionEnvironment = environment2;
            if (executionEnvironment == null) {
                RunContentBuilder.$$$reportNull$$$0(3);
            }
            return executionEnvironment;
        }
        ExecutionEnvironment executionEnvironment = new ExecutionEnvironmentBuilder(environment2).runner(runner).build();
        if (executionEnvironment == null) {
            RunContentBuilder.$$$reportNull$$$0(4);
        }
        return executionEnvironment;
    }

    public void addAction(@NotNull AnAction action2) {
        if (action2 == null) {
            RunContentBuilder.$$$reportNull$$$0(5);
        }
        this.myRunnerActions.add(action2);
    }

    @NotNull
    private RunContentDescriptor createDescriptor() {
        RunProfile profile = this.myEnvironment.getRunProfile();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new RunContentDescriptor(profile, this.myExecutionResult, this.myUi);
        }
        ExecutionConsole console2 = this.myExecutionResult.getExecutionConsole();
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(profile, this.myExecutionResult, this.myUi);
        AnAction[] consoleActionsToMerge = AnAction.EMPTY_ARRAY;
        Content consoleContent = null;
        if (console2 != null) {
            if (console2 instanceof ExecutionConsoleEx) {
                ((ExecutionConsoleEx)console2).buildUi(this.myUi);
            } else {
                consoleContent = RunContentBuilder.buildConsoleUiDefault(this.myUi, console2);
            }
            this.initLogConsoles(profile, contentDescriptor, console2);
        }
        if (consoleContent != null && this.myUi.getContentManager().getContentCount() == 1 && console2 instanceof TerminalExecutionConsole) {
            consoleActionsToMerge = ((TerminalExecutionConsole)console2).createConsoleActions();
            consoleContent.setActions((ActionGroup)new DefaultActionGroup(), "RunnerToolbar", console2.getComponent());
        }
        ActionGroup toolbar = this.createActionToolbar(contentDescriptor, consoleActionsToMerge);
        if (Registry.is((String)"debugger.new.tool.window.layout")) {
            this.mySupplier = new RunTab.RunTabSupplier(toolbar){
                {
                    this.setMoveToolbar(true);
                }

                @Override
                @NotNull
                public List<AnAction> getContentActions() {
                    List<AnAction> list2 = List.of(RunContentBuilder.this.myUi.getOptions().getLayoutActions());
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list2;
                }

                @Override
                @NotNull
                public String getMainToolbarPlace() {
                    return "RunnerToolbar";
                }

                @Override
                @NotNull
                public String getContentToolbarPlace() {
                    return "RunnerToolbar";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/runners/RunContentBuilder$1", "getContentActions"));
                }
            };
            if (this.myUi instanceof RunnerLayoutUiImpl) {
                ((RunnerLayoutUiImpl)this.myUi).setLeftToolbarVisible(false);
            }
            DefaultActionGroup topToolbar = new DefaultActionGroup(new AnAction[]{new EmptyWhenDuplicate(toolbar, group2 -> group2 instanceof RunTab.ToolbarActionGroup)});
            this.myUi.getOptions().setTopLeftToolbar((ActionGroup)topToolbar, "RunnerToolbar");
        } else {
            this.myUi.getOptions().setLeftToolbar(toolbar, "RunnerToolbar");
        }
        if (profile instanceof RunConfigurationBase && console2 instanceof ObservableConsoleView && !ApplicationManager.getApplication().isUnitTestMode()) {
            ((ObservableConsoleView)console2).addChangeListener((ObservableConsoleView.ChangeListener)new ConsoleToFrontListener((RunConfigurationBase)profile, this.myProject, this.myEnvironment.getExecutor(), contentDescriptor, this.myUi), (Disposable)this);
        }
        RunContentDescriptor runContentDescriptor = contentDescriptor;
        if (runContentDescriptor == null) {
            RunContentBuilder.$$$reportNull$$$0(6);
        }
        return runContentDescriptor;
    }

    @Override
    @Nullable
    protected SingleContentSupplier getSupplier() {
        return this.mySupplier;
    }

    @NotNull
    private static String getRunnerType(@Nullable ExecutionConsole console2) {
        String id2;
        if (console2 instanceof ExecutionConsoleEx && (id2 = ((ExecutionConsoleEx)console2).getExecutionConsoleId()) != null) {
            String string = "JavaRunner." + id2;
            if (string == null) {
                RunContentBuilder.$$$reportNull$$$0(7);
            }
            return string;
        }
        return JAVA_RUNNER;
    }

    @NotNull
    public static Content buildConsoleUiDefault(@NotNull RunnerLayoutUi ui2, @NotNull ExecutionConsole console2) {
        if (ui2 == null) {
            RunContentBuilder.$$$reportNull$$$0(8);
        }
        if (console2 == null) {
            RunContentBuilder.$$$reportNull$$$0(9);
        }
        Content consoleContent = ui2.createContent("ConsoleContent", console2.getComponent(), CommonBundle.message((String)"title.console", (Object[])new Object[0]), null, console2.getPreferredFocusableComponent());
        consoleContent.setCloseable(false);
        RunContentBuilder.addAdditionalConsoleEditorActions(console2, consoleContent);
        ui2.addContent(consoleContent, 0, PlaceInGrid.bottom, false);
        Content content2 = consoleContent;
        if (content2 == null) {
            RunContentBuilder.$$$reportNull$$$0(10);
        }
        return content2;
    }

    public static void addAdditionalConsoleEditorActions(ExecutionConsole console2, Content consoleContent) {
        DefaultActionGroup consoleActions = new DefaultActionGroup();
        if (console2 instanceof ConsoleView) {
            for (AnAction action2 : ((ConsoleView)console2).createConsoleActions()) {
                consoleActions.add(action2);
            }
        }
        consoleContent.setActions((ActionGroup)consoleActions, "RunnerToolbar", console2.getComponent());
    }

    @NotNull
    private ActionGroup createActionToolbar(@NotNull RunContentDescriptor contentDescriptor, AnAction @NotNull [] consoleActions) {
        if (contentDescriptor == null) {
            RunContentBuilder.$$$reportNull$$$0(11);
        }
        if (consoleActions == null) {
            RunContentBuilder.$$$reportNull$$$0(12);
        }
        boolean isNewLayout = Registry.is((String)"debugger.new.tool.window.layout");
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add(ActionManager.getInstance().getAction("Rerun"));
        AnAction[] actions2 = contentDescriptor.getRestartActions();
        MoreActionGroup moreGroup = new MoreActionGroup();
        if (!isNewLayout) {
            actionGroup2.addAll(actions2);
        } else {
            for (AnAction action2 : actions2) {
                if (action2.getTemplatePresentation().getClientProperty(RunTab.PREFERRED_PLACE) == PreferredPlace.MORE_GROUP) {
                    moreGroup.add(action2);
                    continue;
                }
                actionGroup2.add(action2);
            }
        }
        if (!isNewLayout) {
            actionGroup2.add((AnAction)new CreateAction(AllIcons.General.Settings));
            actionGroup2.addSeparator();
        }
        actionGroup2.add(ActionManager.getInstance().getAction("Stop"));
        actionGroup2.addAll(this.myExecutionResult.getActions());
        if (consoleActions.length > 0) {
            actionGroup2.addSeparator();
            actionGroup2.addAll(consoleActions);
        }
        if (!isNewLayout) {
            for (AnAction anAction2 : this.myRunnerActions) {
                if (anAction2 != null) {
                    actionGroup2.add(anAction2);
                    continue;
                }
                actionGroup2.addSeparator();
            }
            actionGroup2.addSeparator();
            actionGroup2.add(this.myUi.getOptions().getLayoutActions());
            actionGroup2.addSeparator();
            actionGroup2.add(PinToolwindowTabAction.getPinAction());
        } else {
            actionGroup2.addSeparator();
            for (AnAction action3 : this.myRunnerActions) {
                if (PreferredPlace.TOOLBAR == action3.getTemplatePresentation().getClientProperty(RunTab.PREFERRED_PLACE)) {
                    actionGroup2.add(action3);
                    continue;
                }
                moreGroup.add(action3);
            }
            actionGroup2.add((AnAction)moreGroup);
        }
        DefaultActionGroup defaultActionGroup = actionGroup2;
        if (defaultActionGroup == null) {
            RunContentBuilder.$$$reportNull$$$0(13);
        }
        return defaultActionGroup;
    }

    public RunContentDescriptor showRunContent(@Nullable RunContentDescriptor reuseContent) {
        RunContentDescriptor descriptor2 = this.createDescriptor();
        Disposer.register((Disposable)descriptor2, (Disposable)this);
        Disposer.register((Disposable)this.myProject, (Disposable)descriptor2);
        RunContentManagerImpl.copyContentAndBehavior(descriptor2, reuseContent);
        this.myRunContentDescriptor = descriptor2;
        return descriptor2;
    }

    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RunContentBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "fix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "buildConsoleUiDefault";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fix";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildConsoleUiDefault";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyWhenDuplicate
    extends ActionGroup {
        @NotNull
        private final ActionGroup myDelegate;
        @NotNull
        private final Predicate<ActionGroup> myDuplicatePredicate;

        private EmptyWhenDuplicate(@NotNull ActionGroup delegate2, @NotNull Predicate<ActionGroup> isDuplicate) {
            if (delegate2 == null) {
                EmptyWhenDuplicate.$$$reportNull$$$0(0);
            }
            if (isDuplicate == null) {
                EmptyWhenDuplicate.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate2;
            this.myDuplicatePredicate = isDuplicate;
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            if (this.isToolbarDuplicatedAnywhere(this.getEventComponent(e))) {
                if (AnAction.EMPTY_ARRAY == null) {
                    EmptyWhenDuplicate.$$$reportNull$$$0(2);
                }
                return AnAction.EMPTY_ARRAY;
            }
            AnAction[] anActionArray = this.myDelegate.getChildren(e);
            if (anActionArray == null) {
                EmptyWhenDuplicate.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        @Nullable
        protected Component getEventComponent(@Nullable AnActionEvent e) {
            if (e == null) {
                return null;
            }
            SingleContentSupplier supplier2 = (SingleContentSupplier)e.getData(SingleContentSupplier.KEY);
            return supplier2 != null ? supplier2.getTabs().getComponent() : null;
        }

        private boolean isToolbarDuplicatedAnywhere(@Nullable Component parent) {
            for (Component component2 : UIUtil.uiTraverser((Component)parent)) {
                ActionGroup group2;
                if (!(component2 instanceof ActionToolbarImpl) || !this.myDuplicatePredicate.test(group2 = ((ActionToolbarImpl)component2).getActionGroup())) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "isDuplicate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/RunContentBuilder$EmptyWhenDuplicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder$EmptyWhenDuplicate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ConsoleToFrontListener
    implements ObservableConsoleView.ChangeListener {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Executor myExecutor;
        @NotNull
        private final RunContentDescriptor myRunContentDescriptor;
        @NotNull
        private final RunnerLayoutUi myUi;
        private final boolean myShowConsoleOnStdOut;
        private final boolean myShowConsoleOnStdErr;
        private final AtomicBoolean myFocused;

        public ConsoleToFrontListener(@NotNull RunConfigurationBase runConfigurationBase, @NotNull Project project, @NotNull Executor executor, @NotNull RunContentDescriptor runContentDescriptor, @NotNull RunnerLayoutUi ui2) {
            if (runConfigurationBase == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(0);
            }
            if (project == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(1);
            }
            if (executor == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(2);
            }
            if (runContentDescriptor == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(3);
            }
            if (ui2 == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(4);
            }
            this.myFocused = new AtomicBoolean();
            this.myProject = project;
            this.myExecutor = executor;
            this.myRunContentDescriptor = runContentDescriptor;
            this.myUi = ui2;
            this.myShowConsoleOnStdOut = runConfigurationBase.isShowConsoleOnStdOut();
            this.myShowConsoleOnStdErr = runConfigurationBase.isShowConsoleOnStdErr();
        }

        public void textAdded(@NotNull String text2, @NotNull ConsoleViewContentType type) {
            if (text2 == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(5);
            }
            if (type == null) {
                ConsoleToFrontListener.$$$reportNull$$$0(6);
            }
            if (this.myProject.isDisposed() || this.myUi.isDisposed()) {
                return;
            }
            if ((type == ConsoleViewContentType.NORMAL_OUTPUT && this.myShowConsoleOnStdOut || type == ConsoleViewContentType.ERROR_OUTPUT && this.myShowConsoleOnStdErr) && this.myFocused.compareAndSet(false, true)) {
                RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myExecutor, this.myRunContentDescriptor);
                this.myUi.selectAndFocus(this.myUi.findContent("ConsoleContent"), false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runConfigurationBase";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runContentDescriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ui";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/runners/RunContentBuilder$ConsoleToFrontListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textAdded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

