/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.PreferredPlace;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.ViewContext;
import com.intellij.execution.ui.layout.impl.GridImpl;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.MoreActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunTab
implements DataProvider,
Disposable {
    @ApiStatus.Experimental
    public static final Key<PreferredPlace> PREFERRED_PLACE = Key.create((String)"RunTab.preferredActionPlace");
    @NotNull
    protected final RunnerLayoutUi myUi;
    private LogFilesManager myManager;
    protected RunContentDescriptor myRunContentDescriptor;
    protected ExecutionEnvironment myEnvironment;
    protected final Project myProject;
    protected final GlobalSearchScope mySearchScope;
    private LogConsoleManagerBase logConsoleManager;

    protected RunTab(@NotNull ExecutionEnvironment environment2, @NotNull String runnerType) {
        if (environment2 == null) {
            RunTab.$$$reportNull$$$0(0);
        }
        if (runnerType == null) {
            RunTab.$$$reportNull$$$0(1);
        }
        this(environment2.getProject(), ExecutionSearchScopes.executionScope((Project)environment2.getProject(), (RunProfile)environment2.getRunProfile()), runnerType, environment2.getExecutor().getId(), environment2.getRunProfile().getName());
        this.myEnvironment = environment2;
    }

    public void dispose() {
        this.myRunContentDescriptor = null;
        this.myEnvironment = null;
        this.logConsoleManager = null;
    }

    protected RunTab(@NotNull Project project, @NotNull GlobalSearchScope searchScope2, @NotNull String runnerType, @NotNull String runnerTitle, @NotNull String sessionName) {
        if (project == null) {
            RunTab.$$$reportNull$$$0(2);
        }
        if (searchScope2 == null) {
            RunTab.$$$reportNull$$$0(3);
        }
        if (runnerType == null) {
            RunTab.$$$reportNull$$$0(4);
        }
        if (runnerTitle == null) {
            RunTab.$$$reportNull$$$0(5);
        }
        if (sessionName == null) {
            RunTab.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.mySearchScope = searchScope2;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(runnerType, runnerTitle, sessionName, (Disposable)this);
        this.myUi.getContentManager().addDataProvider((DataProvider)this);
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            RunTab.$$$reportNull$$$0(7);
        }
        if (LangDataKeys.RUN_PROFILE.is(dataId)) {
            return this.myEnvironment == null ? null : this.myEnvironment.getRunProfile();
        }
        if (ExecutionDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return this.myEnvironment;
        }
        if (LangDataKeys.RUN_CONTENT_DESCRIPTOR.is(dataId)) {
            return this.myRunContentDescriptor;
        }
        if (SingleContentSupplier.KEY.is(dataId)) {
            return this.getSupplier();
        }
        return null;
    }

    @Nullable
    protected SingleContentSupplier getSupplier() {
        return null;
    }

    @NotNull
    public LogConsoleManagerBase getLogConsoleManager() {
        if (this.logConsoleManager == null) {
            this.logConsoleManager = new LogConsoleManagerBase(this.myProject, this.mySearchScope){

                @Override
                protected Icon getDefaultIcon() {
                    return AllIcons.Debugger.Console;
                }

                @Override
                protected RunnerLayoutUi getUi() {
                    return RunTab.this.myUi;
                }

                @Override
                public ProcessHandler getProcessHandler() {
                    return RunTab.this.myRunContentDescriptor == null ? null : RunTab.this.myRunContentDescriptor.getProcessHandler();
                }
            };
        }
        LogConsoleManagerBase logConsoleManagerBase = this.logConsoleManager;
        if (logConsoleManagerBase == null) {
            RunTab.$$$reportNull$$$0(8);
        }
        return logConsoleManagerBase;
    }

    protected final void initLogConsoles(@NotNull RunProfile runConfiguration, @NotNull RunContentDescriptor contentDescriptor, @Nullable ExecutionConsole console2) {
        if (runConfiguration == null) {
            RunTab.$$$reportNull$$$0(9);
        }
        if (contentDescriptor == null) {
            RunTab.$$$reportNull$$$0(10);
        }
        ProcessHandler processHandler2 = contentDescriptor.getProcessHandler();
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configuration2 = (RunConfigurationBase)runConfiguration;
            if (this.myManager == null) {
                this.myManager = new LogFilesManager(this.myProject, this.getLogConsoleManager(), (Disposable)contentDescriptor);
            }
            this.myManager.addLogConsoles(configuration2, processHandler2);
            if (processHandler2 != null) {
                OutputFileUtil.attachDumpListener(configuration2, processHandler2, console2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RunTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RunTab";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogConsoleManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initLogConsoles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ToolbarActionGroup
    extends DefaultActionGroup {
        private final MoreActionGroup myMoreActionGroup = new MoreActionGroup();

        public ToolbarActionGroup(ActionGroup group2) {
            this.addAll(group2);
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            AnAction[] children2 = super.getChildren(e);
            if (e != null) {
                ToolWindow window = (ToolWindow)e.getData(PlatformDataKeys.TOOL_WINDOW);
                SingleContentSupplier data2 = (SingleContentSupplier)e.getData(SingleContentSupplier.KEY);
                if (data2 instanceof RunTabSupplier && window != null) {
                    ActionGroup actions2;
                    boolean isMoveToolbar = ((RunTabSupplier)data2).isMoveToolbar();
                    if (!isMoveToolbar) {
                        if (children2 == null) {
                            ToolbarActionGroup.$$$reportNull$$$0(0);
                        }
                        return children2;
                    }
                    ContentManager manager2 = window.getContentManager();
                    if (manager2.getContentCount() > 1 && (actions2 = data2.getToolbarActions()) != null) {
                        return this.merge(actions2.getChildren(e), children2);
                    }
                }
            }
            if (children2 == null) {
                ToolbarActionGroup.$$$reportNull$$$0(1);
            }
            return children2;
        }

        private AnAction @NotNull [] merge(AnAction @NotNull [] head, AnAction @NotNull [] tail) {
            if (head == null) {
                ToolbarActionGroup.$$$reportNull$$$0(2);
            }
            if (tail == null) {
                ToolbarActionGroup.$$$reportNull$$$0(3);
            }
            ArrayList<Object> result2 = new ArrayList<Object>(head.length + tail.length);
            result2.addAll(Arrays.asList(head));
            this.myMoreActionGroup.removeAll();
            if (ArrayUtil.getLastElement((Object[])head) instanceof MoreActionGroup) {
                result2.remove(result2.size() - 1);
            }
            result2.add(Separator.create());
            result2.addAll(Arrays.asList(tail));
            if (ArrayUtil.getLastElement((Object[])tail) instanceof MoreActionGroup) {
                this.myMoreActionGroup.addAll((ActionGroup)ArrayUtil.getLastElement((Object[])tail));
                result2.remove(result2.size() - 1);
            }
            if (ArrayUtil.getLastElement((Object[])head) instanceof MoreActionGroup) {
                this.myMoreActionGroup.add((AnAction)Separator.create());
                this.myMoreActionGroup.addAll((ActionGroup)ArrayUtil.getLastElement((Object[])head));
            }
            result2.add((Object)this.myMoreActionGroup);
            AnAction[] anActionArray = result2.toArray(EMPTY_ARRAY);
            if (anActionArray == null) {
                ToolbarActionGroup.$$$reportNull$$$0(4);
            }
            return anActionArray;
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/RunTab$ToolbarActionGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "head";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/RunTab$ToolbarActionGroup";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class RunTabSupplier
    implements SingleContentSupplier {
        @Nullable
        private final ActionGroup myActionGroup;
        private boolean myMoveToolbar = false;

        public RunTabSupplier(ActionGroup group2) {
            this.myActionGroup = group2;
        }

        @Override
        @NotNull
        public JBTabs getTabs() {
            RunnerContentUi contentUi = RunnerContentUi.KEY.getData((DataProvider)RunTab.this.myUi);
            JBTabs jBTabs = Objects.requireNonNull(contentUi).getTabs();
            if (jBTabs == null) {
                RunTabSupplier.$$$reportNull$$$0(0);
            }
            return jBTabs;
        }

        @Override
        @Nullable
        public ActionGroup getToolbarActions() {
            return this.myActionGroup;
        }

        @Override
        @NotNull
        public List<AnAction> getContentActions() {
            ActionGroup layout = new ActionGroup(ExecutionBundle.messagePointer((String)"runner.content.tooltip.layout.settings", (Object[])new Object[0]), () -> "", AllIcons.Debugger.RestoreLayout){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    RunnerContentUi contentUi = RunnerContentUi.KEY.getData((DataProvider)RunTab.this.myUi);
                    AnAction[] anActionArray = Objects.requireNonNull(contentUi).getViewActions();
                    if (anActionArray == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return anActionArray;
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    e.getPresentation().setEnabledAndVisible(this.getChildren(null).length > 0);
                }

                public boolean isDumbAware() {
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                        case 1: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 2;
                            break;
                        }
                        case 1: {
                            n2 = 3;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/runners/RunTab$RunTabSupplier$1";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getChildren";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/runners/RunTab$RunTabSupplier$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            layout.setPopup(true);
            layout.getTemplatePresentation().putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)Boolean.TRUE);
            List<1> list2 = List.of(layout);
            if (list2 == null) {
                RunTabSupplier.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        public void init(@Nullable ActionToolbar mainToolbar, @Nullable ActionToolbar contentToolbar) {
            JBTabs tabs = this.getTabs();
            if (tabs instanceof JBTabsEx) {
                ((JBTabsEx)tabs).setHideTopPanel(true);
            }
        }

        @Override
        public void reset() {
            JBTabs tabs = this.getTabs();
            if (tabs instanceof JBTabsEx) {
                ((JBTabsEx)tabs).setHideTopPanel(false);
            }
        }

        @Override
        public boolean isClosable(@NotNull TabInfo tab) {
            List<Content> gridContents;
            if (tab == null) {
                RunTabSupplier.$$$reportNull$$$0(2);
            }
            return (gridContents = ((GridImpl)((Object)tab.getComponent())).getContents()).size() > 0 && gridContents.get(0).isCloseable();
        }

        @Override
        public void close(@NotNull TabInfo tab) {
            if (tab == null) {
                RunTabSupplier.$$$reportNull$$$0(3);
            }
            GridImpl grid = (GridImpl)((Object)tab.getComponent());
            ViewContext context2 = (ViewContext)ViewContext.CONTEXT_KEY.getData(grid);
            Content[] content2 = (Content[])ViewContext.CONTENT_KEY.getData(grid);
            if (context2 == null || content2 == null || content2.length == 0) {
                SingleContentSupplier.super.close(tab);
                return;
            }
            context2.getContentManager().removeContent(content2[0], context2.isToDisposeRemovedContent());
        }

        public boolean isMoveToolbar() {
            return this.myMoveToolbar;
        }

        public void setMoveToolbar(boolean moveToolbar) {
            this.myMoveToolbar = moveToolbar;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/runners/RunTab$RunTabSupplier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tab";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentActions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/runners/RunTab$RunTabSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isClosable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "close";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

