/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.ui.TestsConsoleBuilderImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.StoringPropertyContainer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.DumbAwareToggleBooleanProperty;
import com.intellij.util.config.Storage;
import com.intellij.util.config.ToggleBooleanProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestConsoleProperties
extends StoringPropertyContainer
implements Disposable {
    public static final BooleanProperty SCROLL_TO_STACK_TRACE = new BooleanProperty("scrollToStackTrace", false);
    public static final BooleanProperty SORT_ALPHABETICALLY = new BooleanProperty("sortTestsAlphabetically", false);
    public static final BooleanProperty SORT_BY_DURATION = new BooleanProperty("sortTestsByDuration", false);
    public static final BooleanProperty SUITES_ALWAYS_ON_TOP = new BooleanProperty("suitesAlwaysOnTop", true);
    public static final BooleanProperty SELECT_FIRST_DEFECT = new BooleanProperty("selectFirtsDefect", false);
    public static final BooleanProperty TRACK_RUNNING_TEST = new BooleanProperty("trackRunningTest", true);
    public static final BooleanProperty HIDE_IGNORED_TEST = new BooleanProperty("hideIgnoredTests", false);
    public static final BooleanProperty HIDE_PASSED_TESTS = new BooleanProperty("hidePassedTests", true);
    public static final BooleanProperty SCROLL_TO_SOURCE = new BooleanProperty("scrollToSource", false);
    public static final BooleanProperty OPEN_FAILURE_LINE = new BooleanProperty("openFailureLine", true);
    public static final BooleanProperty TRACK_CODE_COVERAGE = new BooleanProperty("trackCodeCoverage", false);
    public static final BooleanProperty SHOW_STATISTICS = new BooleanProperty("showStatistics", false);
    public static final BooleanProperty SHOW_INLINE_STATISTICS = new BooleanProperty("showInlineStatistics", true);
    public static final BooleanProperty INCLUDE_NON_STARTED_IN_RERUN_FAILED = new BooleanProperty("includeNonStarted", true);
    public static final BooleanProperty HIDE_SUCCESSFUL_CONFIG = new BooleanProperty("hideConfig", false);
    private final Project myProject;
    private final Executor myExecutor;
    private ConsoleView myConsole;
    private boolean myUsePredefinedMessageFilter;
    private GlobalSearchScope myScope;
    private boolean myPreservePresentableName;
    protected final Map<AbstractProperty, List<TestFrameworkPropertyListener>> myListeners;

    public TestConsoleProperties(@NotNull Storage storage2, Project project, Executor executor) {
        if (storage2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(0);
        }
        super(storage2);
        this.myUsePredefinedMessageFilter = true;
        this.myPreservePresentableName = false;
        this.myListeners = new HashMap<AbstractProperty, List<TestFrameworkPropertyListener>>();
        this.myProject = project;
        this.myExecutor = executor;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public GlobalSearchScope getScope() {
        if (this.myScope == null) {
            this.myScope = this.initScope();
        }
        GlobalSearchScope globalSearchScope = this.myScope;
        if (globalSearchScope == null) {
            TestConsoleProperties.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @NotNull
    protected GlobalSearchScope initScope() {
        RunProfile configuration2 = this.getConfiguration();
        if (!(configuration2 instanceof ModuleRunProfile)) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                TestConsoleProperties.$$$reportNull$$$0(2);
            }
            return globalSearchScope;
        }
        Object[] modules2 = ((ModuleRunProfile)configuration2).getModules();
        if (modules2.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
            if (globalSearchScope == null) {
                TestConsoleProperties.$$$reportNull$$$0(3);
            }
            return globalSearchScope;
        }
        GlobalSearchScope[] scopes = (GlobalSearchScope[])ContainerUtil.map2Array((Object[])modules2, GlobalSearchScope.class, module -> GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])scopes);
        if (globalSearchScope == null) {
            TestConsoleProperties.$$$reportNull$$$0(4);
        }
        return globalSearchScope;
    }

    public boolean isPreservePresentableName() {
        return this.myPreservePresentableName;
    }

    public void setPreservePresentableName(boolean preservePresentableName) {
        this.myPreservePresentableName = preservePresentableName;
    }

    public <T> void addListener(@NotNull AbstractProperty<T> property2, @NotNull TestFrameworkPropertyListener<T> listener2) {
        if (property2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(5);
        }
        if (listener2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(6);
        }
        List listeners2 = this.myListeners.computeIfAbsent(property2, __ -> ContainerUtil.createLockFreeCopyOnWriteList());
        listeners2.add(listener2);
    }

    public <T> void addListenerAndSendValue(@NotNull AbstractProperty<T> property2, @NotNull TestFrameworkPropertyListener<T> listener2) {
        if (property2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(7);
        }
        if (listener2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(8);
        }
        this.addListener(property2, listener2);
        listener2.onChanged(property2.get((AbstractProperty.AbstractPropertyContainer)this));
    }

    public <T> void removeListener(@NotNull AbstractProperty<T> property2, @NotNull TestFrameworkPropertyListener listener2) {
        List<TestFrameworkPropertyListener> listeners2;
        if (property2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(9);
        }
        if (listener2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(10);
        }
        if ((listeners2 = this.myListeners.get(property2)) != null) {
            listeners2.remove(listener2);
        }
    }

    public Executor getExecutor() {
        return this.myExecutor;
    }

    public boolean isDebug() {
        return this.myExecutor.getId() == "Debug";
    }

    public boolean isPaused() {
        XDebugSession debuggerSession = XDebuggerManager.getInstance((Project)this.myProject).getDebugSession(this.getConsole());
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @Override
    protected <T> void onPropertyChanged(@NotNull AbstractProperty<T> property2, T value2) {
        List<TestFrameworkPropertyListener> listeners2;
        if (property2 == null) {
            TestConsoleProperties.$$$reportNull$$$0(11);
        }
        if ((listeners2 = this.myListeners.get(property2)) != null) {
            for (TestFrameworkPropertyListener listener2 : listeners2) {
                listener2.onChanged(value2);
            }
        }
    }

    public void setConsole(ConsoleView console2) {
        this.myConsole = console2;
    }

    public void dispose() {
        this.myListeners.clear();
    }

    public abstract RunProfile getConfiguration();

    public boolean isEditable() {
        return false;
    }

    protected ExecutionConsole getConsole() {
        return this.myConsole;
    }

    @NotNull
    public ConsoleView createConsole() {
        ConsoleView consoleView = new TestsConsoleBuilderImpl(this.getProject(), this.getScope(), !this.isEditable(), this.isUsePredefinedMessageFilter()).getConsole();
        if (consoleView == null) {
            TestConsoleProperties.$$$reportNull$$$0(12);
        }
        return consoleView;
    }

    public boolean isUsePredefinedMessageFilter() {
        return this.myUsePredefinedMessageFilter;
    }

    public void setUsePredefinedMessageFilter(boolean usePredefinedMessageFilter) {
        this.myUsePredefinedMessageFilter = usePredefinedMessageFilter;
    }

    public void appendAdditionalActions(DefaultActionGroup actionGroup2, JComponent parent, TestConsoleProperties target2) {
    }

    protected AnAction @Nullable [] createImportActions() {
        return null;
    }

    @NotNull
    protected ToggleBooleanProperty createIncludeNonStartedInRerun(TestConsoleProperties target2) {
        String text2 = ExecutionBundle.message((String)"junit.runing.info.include.non.started.in.rerun.failed.action.name", (Object[])new Object[0]);
        return new DumbAwareToggleBooleanProperty(text2, null, null, (AbstractProperty.AbstractPropertyContainer)target2, INCLUDE_NON_STARTED_IN_RERUN_FAILED);
    }

    @NotNull
    protected ToggleBooleanProperty createHideSuccessfulConfig(TestConsoleProperties target2) {
        String text2 = ExecutionBundle.message((String)"junit.runing.info.hide.successful.config.action.name", (Object[])new Object[0]);
        this.setIfUndefined((AbstractProperty<Boolean>)HIDE_SUCCESSFUL_CONFIG, true);
        return new DumbAwareToggleBooleanProperty(text2, null, null, (AbstractProperty.AbstractPropertyContainer)target2, HIDE_SUCCESSFUL_CONFIG);
    }

    @JdkConstants.TreeSelectionMode
    public int getSelectionMode() {
        return 1;
    }

    @NotNull
    public ExecutionTarget getExecutionTarget() {
        ExecutionTarget executionTarget = DefaultExecutionTarget.INSTANCE;
        if (executionTarget == null) {
            TestConsoleProperties.$$$reportNull$$$0(13);
        }
        return executionTarget;
    }

    @NotNull
    public String getWindowId() {
        return this.isDebug() ? "Debug" : "Run";
    }

    public void printExpectedActualHeader(Printer printer, String expected, String actual) {
        Printer.printExpectedActualHeader(printer, expected, actual);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/TestConsoleProperties";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/TestConsoleProperties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "initScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutionTarget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addListenerAndSendValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onPropertyChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

