/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import com.intellij.openapi.diagnostic.Logger;
import java.text.ParseException;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageParserCallback;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessagesParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceMessageUtil {
    private static final Logger LOG = Logger.getInstance(ServiceMessageUtil.class);

    private ServiceMessageUtil() {
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text2, boolean validateRequiredAttributes) {
        if (text2 == null) {
            ServiceMessageUtil.$$$reportNull$$$0(0);
        }
        return ServiceMessageUtil.parse(text2, validateRequiredAttributes, true, null);
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text2, boolean validateRequiredAttributes, boolean logErrorOnParseFailure) {
        if (text2 == null) {
            ServiceMessageUtil.$$$reportNull$$$0(1);
        }
        return ServiceMessageUtil.parse(text2, validateRequiredAttributes, logErrorOnParseFailure, null);
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text2, boolean validateRequiredAttributes, boolean logErrorOnParseFailure, @Nullable String testFrameworkName) {
        if (text2 == null) {
            ServiceMessageUtil.$$$reportNull$$$0(2);
        }
        if (text2.startsWith("##teamcity[") && text2.endsWith("]")) {
            ServiceMessagesParser parser = new ServiceMessagesParser();
            parser.setValidateRequiredAttributes(validateRequiredAttributes);
            MyServiceMessageParserCallback callback2 = new MyServiceMessageParserCallback(text2, logErrorOnParseFailure, testFrameworkName);
            parser.parse(text2, (ServiceMessageParserCallback)callback2);
            return callback2.getParsedMessage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/testframework/sm/ServiceMessageUtil", "parse"));
    }

    private static class MyServiceMessageParserCallback
    implements ServiceMessageParserCallback {
        @NotNull
        private final String myText;
        private final boolean myLogErrorOnParseFailure;
        @Nullable
        private final String myTestFrameworkName;
        private ServiceMessage myMessage;
        private boolean myParseFailed;

        MyServiceMessageParserCallback(@NotNull String text2, boolean logErrorOnParseFailure, @Nullable String testFrameworkName) {
            if (text2 == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myLogErrorOnParseFailure = logErrorOnParseFailure;
            this.myTestFrameworkName = testFrameworkName;
        }

        public void regularText(@NotNull String regularText) {
            if (regularText == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(1);
            }
            if (this.myLogErrorOnParseFailure) {
                LOG.error("Regular text encountered when parsing service message", new String[]{this.myText, regularText, this.getTestFrameworkName()});
            }
            this.myParseFailed = true;
        }

        public void serviceMessage(@NotNull ServiceMessage message2) {
            if (message2 == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(2);
            }
            if (this.myMessage != null) {
                if (this.myLogErrorOnParseFailure) {
                    LOG.error("Another service message already parsed", new String[]{this.myText, this.myMessage.asString(), message2.asString(), this.getTestFrameworkName()});
                }
                this.myParseFailed = true;
            }
            this.myMessage = message2;
        }

        public void parseException(@NotNull ParseException parseException, @NotNull String parseErrorText) {
            if (parseException == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(3);
            }
            if (parseErrorText == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(4);
            }
            if (this.myLogErrorOnParseFailure) {
                LOG.error("Failed to parse service message", (Throwable)parseException, new String[]{parseErrorText, this.getTestFrameworkName()});
            }
            this.myParseFailed = true;
        }

        @NotNull
        private String getTestFrameworkName() {
            Object object = this.myTestFrameworkName == null ? "unknown testFramework" : "testFramework:" + this.myTestFrameworkName;
            if (object == null) {
                MyServiceMessageParserCallback.$$$reportNull$$$0(5);
            }
            return object;
        }

        @Nullable
        public ServiceMessage getParsedMessage() {
            return this.myParseFailed ? null : this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regularText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parseException";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parseErrorText";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/sm/ServiceMessageUtil$MyServiceMessageParserCallback";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/sm/ServiceMessageUtil$MyServiceMessageParserCallback";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestFrameworkName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "regularText";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "serviceMessage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "parseException";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

