/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsOutputConsolePrinter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.ide.HelpIdProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.Disposer;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseTestsOutputConsoleView
implements ConsoleView,
ObservableConsoleView,
HelpIdProvider {
    private ConsoleView myConsole;
    private TestsOutputConsolePrinter myPrinter;
    protected TestConsoleProperties myProperties;
    private TestResultsPanel myTestResultsPanel;

    public BaseTestsOutputConsoleView(@NotNull TestConsoleProperties properties2, AbstractTestProxy unboundOutputRoot) {
        if (properties2 == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(0);
        }
        this.myProperties = properties2;
        this.myConsole = this.myProperties.createConsole();
        this.myPrinter = new TestsOutputConsolePrinter(this, properties2, unboundOutputRoot);
        this.myProperties.setConsole(this);
        Disposer.register((Disposable)this, (Disposable)this.myProperties);
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
    }

    public void initUI() {
        this.myTestResultsPanel = this.createTestResultsPanel();
        this.myTestResultsPanel.initUI();
        Disposer.register((Disposable)this, (Disposable)this.myTestResultsPanel);
    }

    protected abstract TestResultsPanel createTestResultsPanel();

    public void attachToProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(1);
        }
        this.myConsole.attachToProcess(processHandler2);
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(2);
        }
        if (contentType == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(3);
        }
        this.printNew(printer -> printer.print(text2, contentType));
    }

    public void allowHeavyFilters() {
    }

    public void clear() {
        this.myConsole.clear();
    }

    public void scrollTo(int offset) {
        this.myConsole.scrollTo(offset);
    }

    public void setOutputPaused(boolean value2) {
        if (this.myPrinter != null) {
            this.myPrinter.pause(value2);
        }
    }

    public boolean isOutputPaused() {
        return this.myPrinter == null ? true : this.myPrinter.isPaused();
    }

    public boolean hasDeferredOutput() {
        return this.myConsole.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(4);
        }
        this.myConsole.performWhenNoDeferredOutput(runnable2);
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(5);
        }
        this.myConsole.setHelpId(helpId);
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(6);
        }
        this.myConsole.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, HyperlinkInfo info2) {
        if (hyperlinkText == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(7);
        }
        this.printNew(new HyperLink(hyperlinkText, info2));
    }

    public int getContentSize() {
        return this.myConsole.getContentSize();
    }

    public boolean canPause() {
        return this.myPrinter != null && this.myPrinter.canPause() && this.myConsole.canPause();
    }

    @NotNull
    public JComponent getComponent() {
        TestResultsPanel testResultsPanel = this.myTestResultsPanel;
        if (testResultsPanel == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(8);
        }
        return testResultsPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTestResultsPanel;
    }

    public void dispose() {
        this.myPrinter = null;
        this.myProperties = null;
        this.myConsole = null;
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(10);
        }
        if (this.myConsole instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.myConsole).addChangeListener(listener2, parent);
        }
    }

    public AnAction @NotNull [] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(11);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @NotNull
    public ConsoleView getConsole() {
        ConsoleView consoleView = this.myConsole;
        if (consoleView == null) {
            BaseTestsOutputConsoleView.$$$reportNull$$$0(12);
        }
        return consoleView;
    }

    public TestsOutputConsolePrinter getPrinter() {
        return this.myPrinter;
    }

    private void printNew(Printable printable) {
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    @Nullable
    public String getHelpId() {
        return "reference.runToolWindow.testResultsTab";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/ui/BaseTestsOutputConsoleView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

