/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.UnknownBeforeRunTaskProvider;
import com.intellij.execution.ui.TagButton;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDSource;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.WrapLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BeforeRunComponent
extends JPanel
implements DnDTarget,
Disposable {
    private final List<TaskButton> myTags;
    private final InplaceButton myAddButton;
    private final JPanel myAddPanel;
    private final ActionLink myAddLabel;
    private final JLabel myDropFirst;
    Runnable myChangeListener;
    private RunConfiguration myConfiguration;

    public BeforeRunComponent(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            BeforeRunComponent.$$$reportNull$$$0(0);
        }
        super((LayoutManager)new WrapLayout(3, 0, JBUI.scale((int)6)));
        this.myTags = new ArrayList<TaskButton>();
        this.myDropFirst = new JLabel(AllIcons.General.DropPlace);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.add(Box.createVerticalStrut(30));
        JPanel panel2 = new JPanel(new FlowLayout(1, 0, 0));
        this.myDropFirst.setBorder((Border)JBUI.Borders.empty());
        panel2.add(this.myDropFirst);
        panel2.setPreferredSize(this.myDropFirst.getPreferredSize());
        this.add(panel2);
        this.myDropFirst.setVisible(false);
        JBEmptyBorder border = JBUI.Borders.emptyRight((int)5);
        this.myAddButton = new InplaceButton(ExecutionBundle.message((String)"run.configuration.before.run.add.task", (Object[])new Object[0]), AllIcons.General.Add, e -> this.showPopup());
        this.myAddPanel = new JPanel();
        this.myAddPanel.setBorder((Border)border);
        this.myAddPanel.add((Component)this.myAddButton);
        this.myAddLabel = new ActionLink(ExecutionBundle.message((String)"run.configuration.before.run.add.task", (Object[])new Object[0]), e -> this.showPopup());
        this.myAddLabel.setBorder((Border)border);
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)this, (Disposable)this);
    }

    private List<BeforeRunTaskProvider<BeforeRunTask<?>>> getProviders() {
        return ContainerUtil.filter((Collection)BeforeRunTaskProvider.EP_NAME.getExtensions((AreaInstance)this.myConfiguration.getProject()), provider2 -> provider2.createTask(this.myConfiguration) != null);
    }

    private TaskButton createTag(BeforeRunTaskProvider<BeforeRunTask<?>> provider2) {
        return new TaskButton(provider2, e -> {
            this.myChangeListener.run();
            this.buildPanel();
        });
    }

    private void updateAddLabel() {
        this.myAddLabel.setVisible(this.getEnabledTasks().isEmpty());
    }

    public void showPopup() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (BeforeRunTaskProvider<BeforeRunTask<?>> provider2 : this.getProviders()) {
            group2.add((AnAction)new TagAction(provider2));
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(ExecutionBundle.message((String)"add.new.before.run.task.name", (Object[])new Object[0]), (ActionGroup)group2, DataManager.getInstance().getDataContext((Component)this.myAddButton), false, false, false, null, -1, Conditions.alwaysTrue());
        popup2.showUnderneathOf((Component)this.myAddButton);
    }

    public void addOrRemove(Key<? extends BeforeRunTask<?>> providerId, boolean add2) {
        TaskButton taskButton = (TaskButton)((Object)ContainerUtil.find(this.myTags, button4 -> button4.myProvider.getId() == providerId));
        if (add2) {
            if (taskButton == null) {
                this.createTask(null, (BeforeRunTaskProvider)ContainerUtil.find(this.getProviders(), provider2 -> providerId == provider2.getId()));
            }
        } else if (taskButton != null) {
            this.myTags.remove((Object)taskButton);
        }
    }

    private void createTask(@Nullable AnActionEvent e, BeforeRunTaskProvider<BeforeRunTask<?>> myProvider) {
        BeforeRunTask task2 = myProvider.createTask(this.myConfiguration);
        if (task2 == null) {
            return;
        }
        TaskButton tag2 = this.createTag(myProvider);
        if (e == null) {
            this.addTask(tag2, task2);
            return;
        }
        myProvider.configureTask(e.getDataContext(), this.myConfiguration, task2).onSuccess(changed2 -> {
            if (!myProvider.canExecuteTask(this.myConfiguration, task2)) {
                return;
            }
            this.addTask(tag2, task2);
        });
    }

    private void addTask(TaskButton tag2, BeforeRunTask<?> task2) {
        task2.setEnabled(true);
        tag2.setTask(task2);
        this.myTags.remove((Object)tag2);
        this.myTags.add(tag2);
        this.buildPanel();
        this.myChangeListener.run();
    }

    public void reset(@NotNull RunnerAndConfigurationSettingsImpl s) {
        if (s == null) {
            BeforeRunComponent.$$$reportNull$$$0(1);
        }
        this.myConfiguration = s.getConfiguration();
        for (TaskButton tag2 : this.myTags) {
            this.remove((Component)((Object)tag2));
        }
        this.myTags.clear();
        List<BeforeRunTask<?>> tasks = s.getManager().getBeforeRunTasks(s.getConfiguration());
        for (BeforeRunTask<?> task2 : tasks) {
            BeforeRunTaskProvider taskProvider = (BeforeRunTaskProvider)ContainerUtil.find(this.getProviders(), provider2 -> task2.getProviderId() == provider2.getId());
            if (taskProvider == null) {
                taskProvider = new UnknownBeforeRunTaskProvider(task2.getProviderId().toString());
            }
            TaskButton tag3 = this.createTag(taskProvider);
            tag3.setTask(task2);
            this.myTags.add(tag3);
        }
        this.buildPanel();
    }

    private void buildPanel() {
        this.remove(this.myAddPanel);
        this.remove((Component)this.myAddLabel);
        int i2 = 1;
        for (TaskButton tag2 : this.myTags) {
            if (tag2.isVisible() && tag2.myTask != null) {
                tag2.myOrder = i2++;
                tag2.updateButton();
            }
            this.add((Component)((Object)tag2));
        }
        this.add(this.myAddPanel);
        this.add((Component)this.myAddLabel);
        this.updateAddLabel();
    }

    public void apply(RunnerAndConfigurationSettingsImpl s) {
        s.getManager().setBeforeRunTasks(s.getConfiguration(), (List<? extends BeforeRunTask<?>>)this.getEnabledTasks());
    }

    @NotNull
    private List<BeforeRunTask<?>> getEnabledTasks() {
        List<BeforeRunTask<?>> list2 = this.myTags.stream().filter(button4 -> button4.myTask != null && button4.isVisible()).map(button4 -> button4.myTask).collect(Collectors.toList());
        if (list2 == null) {
            BeforeRunComponent.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public <T extends BeforeRunTask<?>> boolean hasEnabledTask(Key<T> providerId) {
        return ContainerUtil.or(this.getEnabledTasks(), task2 -> task2.getProviderId() == providerId);
    }

    public void drop(DnDEvent event) {
        TagButton replaceButton = this.getReplaceButton(event);
        if (replaceButton == null) {
            return;
        }
        TaskButton button4 = (TaskButton)((Object)event.getAttachedObject());
        int i2 = this.myTags.indexOf(replaceButton);
        this.myTags.remove((Object)button4);
        this.myTags.add(i2, button4);
        this.buildPanel();
        this.myChangeListener.run();
        IdeFocusManager.getInstance((Project)this.myConfiguration.getProject()).requestFocus((Component)((Object)button4), false);
    }

    public void cleanUpOnLeave() {
        if (this.myTags != null) {
            this.myTags.forEach(button4 -> button4.showDropPlace(false));
        }
        this.myDropFirst.setVisible(false);
    }

    private TagButton getReplaceButton(DnDEvent event) {
        Object object = event.getAttachedObject();
        if (!(object instanceof TaskButton)) {
            return null;
        }
        Rectangle area = new Rectangle(event.getPoint().x - 5, event.getPoint().y - 5, 10, 10);
        TaskButton button4 = (TaskButton)((Object)ContainerUtil.find(this.myTags, tag2 -> tag2.isVisible() && tag2.getBounds().intersects(area)));
        if (button4 == null || button4 == object) {
            return null;
        }
        boolean left = button4.getBounds().getCenterX() > (double)event.getPoint().x;
        int i2 = this.myTags.indexOf((Object)button4);
        if (i2 < this.myTags.indexOf(object)) {
            if (!left) {
                button4 = (TaskButton)((Object)ContainerUtil.find(this.myTags, b -> b.isVisible() && this.myTags.indexOf(b) > i2));
            }
        } else if (left) {
            button4 = (TaskButton)((Object)ContainerUtil.findLast(this.myTags, b -> b.isVisible() && this.myTags.indexOf(b) < i2));
        }
        return button4 == object ? null : button4;
    }

    private TagButton getDropButton(TagButton replaceButton, DnDEvent event) {
        int i2 = this.myTags.indexOf(replaceButton);
        if (i2 > this.myTags.indexOf(event.getAttachedObject())) {
            return replaceButton;
        }
        return (TagButton)ContainerUtil.findLast(this.myTags, button4 -> button4.isVisible() && this.myTags.indexOf(button4) < i2);
    }

    public boolean update(DnDEvent event) {
        TagButton replace = this.getReplaceButton(event);
        if (replace != null) {
            TagButton dropButton = this.getDropButton(replace, event);
            this.myTags.forEach(button4 -> button4.showDropPlace(button4 == dropButton));
            this.myDropFirst.setVisible(dropButton == null);
            event.setDropPossible(true);
            return false;
        }
        this.myTags.forEach(button4 -> button4.showDropPlace(false));
        event.setDropPossible(false);
        return true;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/BeforeRunComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/BeforeRunComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TagAction
    extends AnAction
    implements PossiblyDumbAware {
        private final BeforeRunTaskProvider<BeforeRunTask<?>> myProvider;

        private TagAction(BeforeRunTaskProvider<BeforeRunTask<?>> provider2) {
            super(provider2.getName(), null, provider2.getIcon());
            this.myProvider = provider2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                TagAction.$$$reportNull$$$0(0);
            }
            BeforeRunComponent.this.createTask(e, this.myProvider);
        }

        public boolean isDumbAware() {
            return DumbService.isDumbAware(this.myProvider);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/ui/BeforeRunComponent$TagAction", "actionPerformed"));
        }
    }

    private final class TaskButton
    extends TagButton
    implements DnDSource {
        private final BeforeRunTaskProvider<BeforeRunTask<?>> myProvider;
        private final JLabel myDropPlace;
        private BeforeRunTask<?> myTask;
        private int myOrder;

        private TaskButton(BeforeRunTaskProvider<BeforeRunTask<?>> provider2, Consumer<AnActionEvent> action2) {
            if (provider2 == null) {
                TaskButton.$$$reportNull$$$0(0);
            }
            super(provider2.getName(), action2);
            this.myDropPlace = new JLabel(AllIcons.General.DropPlace);
            Disposer.register((Disposable)BeforeRunComponent.this, (Disposable)this);
            this.add(this.myDropPlace, JLayeredPane.DRAG_LAYER);
            this.myProvider = provider2;
            this.myDropPlace.setVisible(false);
            this.myButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && (!DumbService.isDumb((Project)BeforeRunComponent.this.myConfiguration.getProject()) || DumbService.isDumbAware(TaskButton.this.myProvider))) {
                        TaskButton.this.myProvider.configureTask(DataManager.getInstance().getDataContext((Component)((Object)TaskButton.this)), BeforeRunComponent.this.myConfiguration, TaskButton.this.myTask).onSuccess(aBoolean -> TaskButton.this.setTask(TaskButton.this.myTask));
                    }
                }
            });
            DnDManager.getInstance().registerSource((DnDSource)this, (JComponent)this.myButton, (Disposable)this);
            this.myButton.setToolTipText(ExecutionBundle.message((String)"run.configuration.before.run.tooltip", (Object[])new Object[0]));
            this.layoutButtons();
        }

        protected void layoutButtons() {
            super.layoutButtons();
            if (this.myDropPlace == null) {
                return;
            }
            Rectangle bounds2 = this.myButton.getBounds();
            Dimension size = this.myDropPlace.getPreferredSize();
            int gap = JBUI.scale((int)2);
            this.setPreferredSize(new Dimension(bounds2.width + size.width + 2 * gap, bounds2.height));
            this.myDropPlace.setBounds((int)(bounds2.getMaxX() + (double)gap), bounds2.y + (bounds2.height - size.height) / 2, size.width, size.height);
        }

        private void setTask(@Nullable BeforeRunTask<?> task2) {
            this.myTask = task2;
            this.setVisible(task2 != null);
        }

        private void updateButton() {
            if (this.myTask == null) {
                return;
            }
            this.setEnabled(!DumbService.isDumb((Project)BeforeRunComponent.this.myConfiguration.getProject()) || DumbService.isDumbAware(this.myProvider));
            this.updateButton(this.myOrder + ". " + this.myProvider.getDescription(this.myTask), this.myProvider.getTaskIcon(this.myTask));
        }

        private void showDropPlace(boolean show2) {
            this.myDropPlace.setVisible(show2);
        }

        public boolean canStartDragging(DnDAction action2, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                TaskButton.$$$reportNull$$$0(1);
            }
            return true;
        }

        public DnDDragStartBean startDragging(DnDAction action2, @NotNull Point dragOrigin) {
            if (dragOrigin == null) {
                TaskButton.$$$reportNull$$$0(2);
            }
            return new DnDDragStartBean((Object)this);
        }

        public String toString() {
            return this.myProvider.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragOrigin";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/BeforeRunComponent$TaskButton";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canStartDragging";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startDragging";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

