/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionAndVersion;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WslDistributionManagerImpl
extends WslDistributionManager {
    private static final Set<String> INTERNAL_DISTRIBUTIONS = Set.of("docker-desktop-data", "docker-desktop");

    @Override
    @NotNull
    protected List<String> loadInstalledDistributionMsIds() {
        Pair<GeneralCommandLine, List<String>> result2;
        long startNano;
        block8: {
            List<String> list2;
            WslDistributionManagerImpl.checkEdtAndReadAction();
            if (!new WSLCommandLineOptions().isLaunchWithWslExe()) {
                List<String> list3 = Collections.emptyList();
                if (list3 == null) {
                    WslDistributionManagerImpl.$$$reportNull$$$0(0);
                }
                return list3;
            }
            try {
                startNano = System.nanoTime();
                result2 = WslDistributionManagerImpl.doFetchDistributionsFromWslCli();
                if (result2 != null) break block8;
                list2 = Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info("Cannot parse WSL distributions", (Throwable)e);
                List<String> list4 = Collections.emptyList();
                if (list4 == null) {
                    WslDistributionManagerImpl.$$$reportNull$$$0(3);
                }
                return list4;
            }
            if (list2 == null) {
                WslDistributionManagerImpl.$$$reportNull$$$0(1);
            }
            return list2;
        }
        LOG.info("Fetched WSL distributions: " + result2.second + " (\"" + ((GeneralCommandLine)result2.first).getCommandLineString() + "\" done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
        List list5 = (List)result2.second;
        if (list5 == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(2);
        }
        return list5;
    }

    @Override
    @NotNull
    public List<WslDistributionAndVersion> loadInstalledDistributionsWithVersions() throws IOException, IllegalStateException {
        ProcessOutput output2;
        WslDistributionManagerImpl.checkEdtAndReadAction();
        Path wslExe = WSLDistribution.findWslExe();
        if (wslExe == null) {
            LOG.info("Cannot load WSL distributions with versions: wsl.exe is not found in %PATH%");
            List<WslDistributionAndVersion> list2 = List.of();
            if (list2 == null) {
                WslDistributionManagerImpl.$$$reportNull$$$0(4);
            }
            return list2;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{wslExe.toString(), "--list", "--verbose"}).withCharset(StandardCharsets.UTF_16LE);
        long startNano = System.nanoTime();
        try {
            output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)WSLDistribution.DEFAULT_TIMEOUT);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to run " + commandLine.getCommandLineString(), e);
        }
        if (output2.getExitCode() != 0 && output2.getStdout().endsWith("https://aka.ms/wslstore")) {
            LOG.info("Windows Subsystem for Linux has no installed distributions");
            List<WslDistributionAndVersion> list3 = Collections.emptyList();
            if (list3 == null) {
                WslDistributionManagerImpl.$$$reportNull$$$0(5);
            }
            return list3;
        }
        if (WslDistributionManagerImpl.isWslDisabled(output2)) {
            LOG.info("WSL is disabled in the system");
            List<WslDistributionAndVersion> list4 = Collections.emptyList();
            if (list4 == null) {
                WslDistributionManagerImpl.$$$reportNull$$$0(6);
            }
            return list4;
        }
        if (output2.isTimeout() || output2.getExitCode() != 0 || !output2.getStderr().isEmpty()) {
            throw new IOException("Failed to run " + commandLine.getCommandLineString() + ": " + output2);
        }
        List<WslDistributionAndVersion> versions = WslDistributionManagerImpl.parseWslVerboseListOutput(output2.getStdoutLines());
        LOG.info("Fetched WSL distributions: " + versions + " (\"" + commandLine.getCommandLineString() + "\" done in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
        List<WslDistributionAndVersion> list5 = versions;
        if (list5 == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(7);
        }
        return list5;
    }

    private static boolean isWslDisabled(@NotNull ProcessOutput output2) {
        if (output2 == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(8);
        }
        if (output2.getExitCode() == 0) {
            return false;
        }
        String stdout = output2.getStdout();
        return stdout.contains("--install") && stdout.contains("--list") && stdout.contains("--help");
    }

    @NotNull
    static List<WslDistributionAndVersion> parseWslVerboseListOutput(@NotNull List<String> stdoutLines) throws IllegalStateException {
        if (stdoutLines == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(9);
        }
        if (stdoutLines.isEmpty()) {
            throw new IllegalStateException("[wsl -l -v] parsing error: stdout is empty");
        }
        stdoutLines = ContainerUtil.subList(stdoutLines, (int)1);
        ArrayList<WslDistributionAndVersion> result2 = new ArrayList<WslDistributionAndVersion>(stdoutLines.size());
        for (String l : stdoutLines) {
            String distributionName;
            List words = StringUtil.split((String)l, (String)" ");
            if ("*".equals(ContainerUtil.getFirstItem((List)words))) {
                words = ContainerUtil.subList((List)words, (int)1);
            }
            if (StringUtil.isEmpty((String)(distributionName = (String)ContainerUtil.getFirstItem((List)words)))) {
                throw new IllegalStateException("[wsl -l -v] parsing error: malformed distribution name\nline: " + l + "\nstdout: " + StringUtil.join((Collection)stdoutLines, (String)"\n"));
            }
            int version2 = StringUtil.parseInt((String)((String)ContainerUtil.getLastItem((List)words)), (int)-1);
            if (version2 == -1) {
                throw new IllegalStateException("[wsl -l -v] parsing error: malformed version\nline: " + l + "\nstdout: " + StringUtil.join((Collection)stdoutLines, (String)"\n"));
            }
            if (INTERNAL_DISTRIBUTIONS.contains(distributionName)) continue;
            result2.add(new WslDistributionAndVersion(distributionName, version2));
        }
        ArrayList<WslDistributionAndVersion> arrayList = result2;
        if (arrayList == null) {
            WslDistributionManagerImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    private static Pair<GeneralCommandLine, List<String>> doFetchDistributionsFromWslCli() throws IOException {
        ProcessOutput output2;
        Path wslExe = WSLDistribution.findWslExe();
        if (wslExe == null) {
            LOG.info("Cannot parse WSL distributions: wsl.exe is not found in %PATH%");
            return null;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{wslExe.toString(), "--list", "--quiet"}).withCharset(StandardCharsets.UTF_16LE);
        try {
            output2 = ExecUtil.execAndGetOutput((GeneralCommandLine)commandLine, (int)WSLDistribution.DEFAULT_TIMEOUT);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed to run " + commandLine.getCommandLineString(), e);
        }
        if (output2.isTimeout() || output2.getExitCode() != 0 || !output2.getStderr().isEmpty()) {
            throw new IOException("Failed to run " + commandLine.getCommandLineString() + ": " + output2);
        }
        @NlsSafe List msIds = ContainerUtil.filter((Collection)output2.getStdoutLines(true), distribution2 -> !INTERNAL_DISTRIBUTIONS.contains(distribution2));
        return Pair.create((Object)commandLine, (Object)msIds);
    }

    private static void checkEdtAndReadAction() {
        Application application = ApplicationManager.getApplication();
        if (application == null || !application.isInternal() || application.isHeadlessEnvironment()) {
            return;
        }
        if (application.isReadAccessAllowed()) {
            LOG.error("Please call WslDistributionManager.getInstalledDistributions on a background thread and not under read action as it runs a potentially long operation.");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionManagerImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdoutLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstalledDistributionMsIds";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInstalledDistributionsWithVersions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionManagerImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWslVerboseListOutput";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isWslDisabled";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseWslVerboseListOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

