/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.featureStatistics.fusCollectors;

import com.intellij.featureStatistics.fusCollectors.OsDataCollector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\b\u0010\u0018\u001a\u00020\bH\u0016J\b\u0010\u0019\u001a\u00020\u0005H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0002J\u0016\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u001fH\u0002J\b\u0010 \u001a\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00158\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u00a8\u0006!"}, d2={"Lcom/intellij/featureStatistics/fusCollectors/OsDataCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ApplicationUsagesCollector;", "()V", "DISTROS", "", "", "getDISTROS$annotations", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "LINUX", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "", "LOCALES", "OS", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "OS_LANG", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "OS_NAME", "OS_NAMES", "OS_TZ", "TIMEZONE", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "getTIMEZONE$annotations", "detectIsUnderWsl", "getGroup", "getLanguage", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getOSName", "getReleaseData", "Lkotlin/Pair;", "getTimeZone", "intellij.platform.ide.impl"})
public final class OsDataCollector
extends ApplicationUsagesCollector {
    private final List<String> OS_NAMES = CollectionsKt.listOf((Object[])new String[]{"Windows", "Mac", "Linux", "FreeBSD", "Solaris", "Other"});
    private final List<String> LOCALES = CollectionsKt.listOf((Object[])new String[]{"am", "ar", "as", "az", "bn", "cs", "da", "de", "el", "en", "es", "fa", "fr", "gu", "ha", "hi", "hu", "ig", "in", "it", "ja", "kk", "kn", "ko", "ml", "mr", "my", "nb", "ne", "nl", "nn", "no", "or", "pa", "pl", "pt", "ro", "ru", "rw", "sd", "si", "so", "sv", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "yo", "zh", "zu"});
    private final List<String> DISTROS = CollectionsKt.listOf((Object[])new String[]{"almalinux", "alpine", "amzn", "arch", "bunsenlabs", "centos", "chromeos", "debian", "deepin", "devuan", "elementary", "fedora", "galliumos", "garuda", "gentoo", "kali", "linuxmint", "mageia", "manjaro", "neon", "nixos", "ol", "opensuse-leap", "opensuse-tumbleweed", "parrot", "pop", "pureos", "raspbian", "rhel", "rocky", "rosa", "sabayon", "slackware", "solus", "ubuntu", "void", "zorin", "other", "unknown"});
    private final EventLogGroup GROUP = new EventLogGroup("system.os", 13);
    private final StringEventField OS_NAME = EventFields.String((String)"name", this.OS_NAMES);
    private final StringEventField OS_LANG = EventFields.String((String)"locale", this.LOCALES);
    private final StringEventField OS_TZ = EventFields.StringValidatedByRegexp((String)"time_zone", (String)"time_zone");
    private final VarargEventId OS = this.GROUP.registerVarargEvent("os.name", new EventField[]{(EventField)this.OS_NAME, (EventField)EventFields.Version, (EventField)this.OS_LANG, (EventField)this.OS_TZ});
    @ApiStatus.ScheduledForRemoval(inVersion="2024.1")
    private final EventId1<String> TIMEZONE = this.GROUP.registerEvent("os.timezone", (EventField)EventFields.StringValidatedByRegexp((String)"value", (String)"time_zone"));
    private final EventId3<String, String, Boolean> LINUX = this.GROUP.registerEvent("linux", (EventField)EventFields.String((String)"distro", this.DISTROS), (EventField)EventFields.StringValidatedByRegexp((String)"release", (String)"version"), (EventField)EventFields.Boolean((String)"wsl"));

    private static /* synthetic */ void getDISTROS$annotations() {
    }

    private static /* synthetic */ void getTIMEZONE$annotations() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<MetricEvent> getMetrics() {
        String tz = this.getTimeZone();
        Set metrics = SetsKt.mutableSetOf((Object[])new MetricEvent[]{this.OS.metric(new EventPair[]{this.OS_NAME.with((Object)this.getOSName()), EventFields.Version.with((Object)SystemInfo.OS_VERSION), this.OS_LANG.with((Object)this.getLanguage()), this.OS_TZ.with((Object)tz)}), this.TIMEZONE.metric((Object)tz)});
        if (SystemInfo.isLinux) {
            void distro;
            Pair<String, String> pair = this.getReleaseData();
            String string = (String)pair.component1();
            String release2 = (String)pair.component2();
            boolean isUnderWsl = this.detectIsUnderWsl();
            Collection collection = metrics;
            MetricEvent metricEvent = this.LINUX.metric((Object)distro, (Object)release2, (Object)isUnderWsl);
            boolean bl = false;
            collection.add(metricEvent);
        }
        return metrics;
    }

    private final String getOSName() {
        return SystemInfo.isWindows ? "Windows" : (SystemInfo.isMac ? "Mac" : (SystemInfo.isLinux ? "Linux" : (SystemInfo.isFreeBSD ? "FreeBSD" : (SystemInfo.isSolaris ? "Solaris" : "Other"))));
    }

    private final String getLanguage() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        String string = locale.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Locale.getDefault().language");
        return string;
    }

    private final String getTimeZone() {
        OffsetDateTime offsetDateTime = OffsetDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"OffsetDateTime.now()");
        String string = offsetDateTime.getOffset().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"OffsetDateTime.now().offset.toString()");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Pair<String, String> getReleaseData() {
        Object object;
        try {
            Pair pair;
            object = Files.lines(Path.of("/etc/os-release", new String[0]));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Stream lines2 = (Stream)object;
                boolean bl3 = false;
                Set fields2 = SetsKt.setOf((Object[])new String[]{"ID", "VERSION_ID"});
                Stream stream = lines2;
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"lines");
                Sequence sequence = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)getReleaseData.1.values.1.INSTANCE), (Function1)((Function1)new Function1<List<? extends String>, Boolean>(fields2){
                    final /* synthetic */ Set $fields;

                    public final boolean invoke(@NotNull List<String> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return it.size() == 2 && this.$fields.contains(it.get(0));
                    }
                    {
                        this.$fields = set2;
                        super(1);
                    }
                }));
                boolean $i$f$associate = false;
                void var9_14 = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map2 = destination$iv$iv;
                    List it = (List)element$iv$iv;
                    boolean bl4 = false;
                    Pair pair2 = TuplesKt.to(it.get(0), (Object)StringsKt.trim((String)((String)it.get(1)), (char[])new char[]{'\"'}));
                    boolean bl5 = false;
                    map2.put(pair2.getFirst(), pair2.getSecond());
                }
                Map values2 = destination$iv$iv;
                String id2 = (String)values2.get("ID");
                String distro = id2 == null ? "unknown" : (this.DISTROS.contains(id2) ? id2 : "other");
                pair = TuplesKt.to((Object)distro, values2.get("VERSION_ID"));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
            }
            object = pair;
        }
        catch (IOException ignored) {
            object = TuplesKt.to((Object)"unknown", null);
        }
        return object;
    }

    private final boolean detectIsUnderWsl() {
        boolean bl;
        try {
            String osrelease;
            String string = osrelease = Files.readString(Path.of("/proc/sys/kernel/osrelease", new String[0]));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"osrelease");
            bl = StringsKt.contains$default((CharSequence)string, (CharSequence)"-microsoft-", (boolean)false, (int)2, null);
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }
}

