/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.feedback;

import com.intellij.feedback.FeedbackTypes;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/intellij/feedback/FeedbackTypeResolver;", "", "()V", "MIN_INACTIVE_TIME", "", "value", "", "isFeedbackNotificationEnabled", "()Z", "setFeedbackNotificationEnabled", "(Z)V", "isFeedbackNotificationEnabledPropertyName", "", "<set-?>", "Ljava/time/LocalDateTime;", "lastActivityTime", "getLastActivityTime", "()Ljava/time/LocalDateTime;", "checkActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "showFeedbackNotification", "intellij.platform.feedback"})
public final class FeedbackTypeResolver {
    private static final int MIN_INACTIVE_TIME = 10;
    @NotNull
    private static LocalDateTime lastActivityTime;
    private static final String isFeedbackNotificationEnabledPropertyName = "isProjectCreationNotificationEnabled";
    @NotNull
    public static final FeedbackTypeResolver INSTANCE;

    @NotNull
    public final LocalDateTime getLastActivityTime() {
        return lastActivityTime;
    }

    public final void checkActivity(@Nullable Project project) {
        if (Duration.between(LocalDateTime.now(), lastActivityTime).toMinutes() >= (long)10) {
            this.showFeedbackNotification(project);
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.now()");
        lastActivityTime = localDateTime;
    }

    public final boolean isFeedbackNotificationEnabled() {
        return PropertiesComponent.getInstance().getBoolean(isFeedbackNotificationEnabledPropertyName, true);
    }

    public final void setFeedbackNotificationEnabled(boolean value2) {
        PropertiesComponent.getInstance().setValue(isFeedbackNotificationEnabledPropertyName, value2);
    }

    /*
     * WARNING - void declaration
     */
    private final void showFeedbackNotification(Project project) {
        void $this$filterTo$iv$iv;
        if (!Registry.is((String)"platform.feedback", (boolean)false) || !this.isFeedbackNotificationEnabled()) {
            return;
        }
        FeedbackTypes[] $this$filter$iv = FeedbackTypes.values();
        boolean $i$f$filter = false;
        FeedbackTypes[] feedbackTypesArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var8_8 = $this$filterTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var8_8[j];
            boolean bl = false;
            if (!it.isSuitable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List suitableFeedbackTypes = (List)destination$iv$iv;
        if (suitableFeedbackTypes.isEmpty()) {
            return;
        }
        int feedbackIndex = Random.Default.nextInt(suitableFeedbackTypes.size());
        FeedbackTypes.showNotification$default((FeedbackTypes)((Object)suitableFeedbackTypes.get(feedbackIndex)), project, false, 2, null);
    }

    private FeedbackTypeResolver() {
    }

    static {
        FeedbackTypeResolver feedbackTypeResolver;
        INSTANCE = feedbackTypeResolver = new FeedbackTypeResolver();
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.now()");
        lastActivityTime = localDateTime;
    }
}

