/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.filePrediction.features.history.FileHistoryManager;
import com.intellij.filePrediction.features.history.FileHistoryManagerWrapper;
import com.intellij.filePrediction.features.history.FileHistoryPersistence;
import com.intellij.filePrediction.features.history.FilePredictionNGramFeatures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0003\u0016\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "manager", "Lcom/intellij/filePrediction/features/history/FileHistoryManager;", "calcNGramFeatures", "Lcom/intellij/filePrediction/features/history/FilePredictionNGramFeatures;", "candidates", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "calcNextFileProbability", "", "file", "dispose", "", "onFileOpened", "onProjectClosed", "Companion", "EditorManagerListener", "ProjectClosureListener", "intellij.platform.ml.impl"})
public final class FileHistoryManagerWrapper
implements Disposable {
    private final ExecutorService executor;
    private final FileHistoryManager manager;
    private final Project project;
    private static final int MAX_NGRAM_SEQUENCE = 3;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FilePredictionNGramFeatures calcNGramFeatures(@NotNull List<? extends VirtualFile> candidates) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        Iterable iterable = candidates;
        FileHistoryManager fileHistoryManager = this.manager;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getUrl(), (String)"it.url");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return fileHistoryManager.calcNGramFeatures((List<String>)collection);
    }

    public final double calcNextFileProbability(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
        return this.manager.calcNextFileProbability(string);
    }

    private final void onFileOpened(VirtualFile file2) {
        if (ProjectManagerImpl.isLight(this.project)) {
            return;
        }
        this.executor.submit(new Runnable(this, file2){
            final /* synthetic */ FileHistoryManagerWrapper this$0;
            final /* synthetic */ VirtualFile $file;

            public final void run() {
                BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.this$0, new Runnable(this){
                    final /* synthetic */ onFileOpened.1 this$0;

                    public final void run() {
                        FileHistoryManager fileHistoryManager = FileHistoryManagerWrapper.access$getManager$p(this.this$0.this$0);
                        String string = this.this$0.$file.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.url");
                        fileHistoryManager.onFileOpened(string);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = fileHistoryManagerWrapper;
                this.$file = virtualFile2;
            }
        });
    }

    private final void onProjectClosed(Project project) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, project){
            final /* synthetic */ FileHistoryManagerWrapper this$0;
            final /* synthetic */ Project $project;

            public final void run() {
                FileHistoryManagerWrapper.access$getManager$p(this.this$0).saveFileHistory(this.$project);
            }
            {
                this.this$0 = fileHistoryManagerWrapper;
                this.$project = project;
            }
        });
    }

    public void dispose() {
        this.executor.shutdown();
    }

    public FileHistoryManagerWrapper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"NextFilePrediction");
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"SequentialTaskExecutor.c\u2026tor(\"NextFilePrediction\")");
        this.executor = executorService;
        this.manager = new FileHistoryManager(FileHistoryPersistence.INSTANCE.loadNGrams(this.project, 3));
    }

    public static final /* synthetic */ FileHistoryManager access$getManager$p(FileHistoryManagerWrapper $this) {
        return $this.manager;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$ProjectClosureListener;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "projectClosing", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.ml.impl"})
    public static final class ProjectClosureListener
    implements ProjectManagerListener {
        public void projectClosing(@NotNull Project project) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                FileHistoryManagerWrapper fileHistoryManagerWrapper = Companion.getInstanceIfCreated(project);
                if (fileHistoryManagerWrapper == null) break block0;
                fileHistoryManagerWrapper.onProjectClosed(project);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$EditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.platform.ml.impl"})
    public static final class EditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile2 = event.getNewFile();
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile newFile = virtualFile2;
            FileEditorManager fileEditorManager = event.getManager();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"event.manager");
            Project project = fileEditorManager.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"event.manager.project");
            Companion.getInstance(project).onFileOpened(newFile);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper$Companion;", "", "()V", "MAX_NGRAM_SEQUENCE", "", "getInstance", "Lcom/intellij/filePrediction/features/history/FileHistoryManagerWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceIfCreated", "intellij.platform.ml.impl"})
    public static final class Companion {
        @NotNull
        public final FileHistoryManagerWrapper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(FileHistoryManagerWrapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (FileHistoryManagerWrapper)object;
        }

        @Nullable
        public final FileHistoryManagerWrapper getInstanceIfCreated(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$serviceIfCreated$iv = project;
            boolean $i$f$serviceIfCreated = false;
            return (FileHistoryManagerWrapper)$this$serviceIfCreated$iv.getServiceIfCreated(FileHistoryManagerWrapper.class);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

