/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction.features.history;

import com.intellij.internal.ml.ngram.NGramIncrementalModelRunner;
import com.intellij.internal.ml.ngram.NGramModelSerializer;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/filePrediction/features/history/FileHistoryPersistence;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NGRAM_FILE_NAME_SUFFIX", "", "deleteLegacyFile", "", "project", "Lcom/intellij/openapi/project/Project;", "getPathToStorage", "Ljava/nio/file/Path;", "suffix", "loadNGrams", "Lcom/intellij/internal/ml/ngram/NGramIncrementalModelRunner;", "nGramLength", "", "saveNGrams", "runner", "intellij.platform.ml.impl"})
public final class FileHistoryPersistence {
    private static final Logger LOG;
    private static final String NGRAM_FILE_NAME_SUFFIX = "-ngram";
    @NotNull
    public static final FileHistoryPersistence INSTANCE;

    public final void deleteLegacyFile(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            Path path2;
            if (!project.isDisposed() && (path2 = this.getPathToStorage(project, ".xml")) != null && PathKt.exists((Path)path2)) {
                PathKt.delete$default((Path)path2, (boolean)false, (int)1, null);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize file sequence ngrams", (Throwable)e);
        }
    }

    public final void saveNGrams(@NotNull Project project, @NotNull NGramIncrementalModelRunner runner) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
        Path path2 = this.getPathToStorage(project, NGRAM_FILE_NAME_SUFFIX);
        try {
            if (path2 != null) {
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                NGramModelSerializer.INSTANCE.saveNGrams(path2, runner);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot serialize file sequence ngrams", (Throwable)e);
        }
    }

    @NotNull
    public final NGramIncrementalModelRunner loadNGrams(@NotNull Project project, int nGramLength) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            if (!project.isDisposed()) {
                Path path2 = this.getPathToStorage(project, NGRAM_FILE_NAME_SUFFIX);
                return NGramModelSerializer.INSTANCE.loadNGrams(path2, nGramLength);
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot deserialize file sequence ngrams", (Throwable)e);
        }
        return NGramModelSerializer.INSTANCE.loadNGrams(null, nGramLength);
    }

    private final Path getPathToStorage(Project project, String suffix) {
        Path projectPath;
        String string = project.getPresentableUrl();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.presentableUrl ?: return null");
        String url = string;
        Path path2 = projectPath = Paths.get(VirtualFileManager.extractPath((String)url), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"projectPath");
        Object object = path2.getFileName();
        if (object == null || (object = object.toString()) == null) {
            String string2 = ((Object)projectPath).toString();
            int n = 0;
            int n2 = 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            object = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        Object dirName = object;
        String string5 = PathUtil.suggestFileName((String)((String)dirName + Integer.toHexString(((Object)projectPath).toString().hashCode())));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"PathUtil.suggestFileName\u2026h.toString().hashCode()))");
        String storageName = string5;
        return Paths.get(PathManager.getSystemPath(), "fileHistory", storageName + suffix);
    }

    private FileHistoryPersistence() {
    }

    static {
        FileHistoryPersistence fileHistoryPersistence;
        INSTANCE = fileHistoryPersistence = new FileHistoryPersistence();
        Logger logger = Logger.getInstance(FileHistoryPersistence.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FileH\u2026yPersistence::class.java)");
        LOG = logger;
    }
}

