/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.BundleBase;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.FindAllAction;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUsagesCollector;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.ShowFilterPopupGroup;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonPainter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.ActionLink;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchSession
implements SearchSession,
DataProvider,
SelectionListener,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    public static final DataKey<EditorSearchSession> SESSION_KEY = DataKey.create("EditorSearchSession");
    public static final Logger SELECTION_UPDATE_LOGGER = Logger.getInstance((String)"com.intellij.find.selection");
    private final Editor myEditor;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    @NotNull
    private final FindModel myFindModel;
    private final SearchReplaceComponent myComponent;
    private RangeMarker myStartSessionSelectionMarker;
    private RangeMarker myStartSessionCaretMarker;
    private String myStartSelectedText;
    private boolean mySelectionUpdatedFromSearchResults;
    private final ActionLink myClickToHighlightLabel;
    private final Disposable myDisposable;

    public EditorSearchSession(@NotNull Editor editor2, Project project) {
        if (editor2 == null) {
            EditorSearchSession.$$$reportNull$$$0(0);
        }
        this(editor2, project, EditorSearchSession.createDefaultFindModel(project, editor2));
    }

    public EditorSearchSession(final @NotNull Editor editor2, Project project, @NotNull FindModel findModel) {
        if (editor2 == null) {
            EditorSearchSession.$$$reportNull$$$0(1);
        }
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(2);
        }
        this.myClickToHighlightLabel = new ActionLink(FindBundle.message("link.click.to.highlight", new Object[0]), e -> {
            this.setMatchesLimit(Integer.MAX_VALUE);
            this.updateResults(true);
        });
        this.myDisposable = Disposer.newDisposable((String)EditorSearchSession.class.getName());
        assert (!editor2.isDisposed());
        this.myClickToHighlightLabel.setVisible(false);
        this.myFindModel = findModel;
        this.myEditor = editor2;
        this.saveInitialSelection();
        this.mySearchResults = new SearchResults(this.myEditor, project);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this, this.myDisposable);
        this.myComponent = SearchReplaceComponent.buildFor(project, this.myEditor.getContentComponent()).addPrimarySearchActions(this.createPrimarySearchActions()).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleWholeWordsOnlyAction(), new ToggleRegex(), new DefaultCustomComponentAction(() -> this.myClickToHighlightLabel)}).addSearchFieldActions(new RestorePreviousSettingsAction()).addPrimaryReplaceActions(new AnAction[]{new ReplaceAction(), new ReplaceAllAction(), new ExcludeAction()}).addExtraReplaceAction(new AnAction[]{new TogglePreserveCaseAction()}).addReplaceFieldActions(new AnAction[]{new PrevOccurrenceAction(false), new NextOccurrenceAction(false)}).withDataProvider(this).withCloseAction(this::close).withReplaceAction(this::replaceCurrent).build();
        this.myComponent.addListener(this);
        new UiNotifyConnector((Component)this.myComponent, new Activatable(){

            public void showNotify() {
                EditorSearchSession.this.initLivePreview();
            }

            public void hideNotify() {
                EditorSearchSession.this.myLivePreviewController.off();
                EditorSearchSession.this.mySearchResults.removeListener(EditorSearchSession.this);
            }
        });
        new SwitchToFind(this.getComponent());
        new SwitchToReplace(this.getComponent());
        this.myFindModel.addObserver(new FindModel.FindModelObserver(){
            boolean myReentrantLock = false;
            boolean myIsGlobal;
            boolean myIsReplace;
            {
                this.myIsGlobal = EditorSearchSession.this.myFindModel.isGlobal();
                this.myIsReplace = EditorSearchSession.this.myFindModel.isReplaceState();
            }

            public void findModelChanged(FindModel findModel1) {
                if (this.myReentrantLock) {
                    return;
                }
                try {
                    this.myReentrantLock = true;
                    String stringToFind = EditorSearchSession.this.myFindModel.getStringToFind();
                    if (!EditorSearchSession.wholeWordsApplicable(stringToFind)) {
                        EditorSearchSession.this.myFindModel.setWholeWordsOnly(false);
                    }
                    if (this.myIsGlobal != EditorSearchSession.this.myFindModel.isGlobal() || this.myIsReplace != EditorSearchSession.this.myFindModel.isReplaceState()) {
                        if (EditorSearchSession.this.myFindModel.getStringToFind().isEmpty() && EditorSearchSession.this.myFindModel.isGlobal()) {
                            EditorSearchSession.this.myFindModel.setStringToFind(StringUtil.notNullize((String)EditorSearchSession.this.myEditor.getSelectionModel().getSelectedText()));
                        }
                        if (!EditorSearchSession.this.myFindModel.isGlobal()) {
                            if (EditorSearchSession.this.myFindModel.getStringToFind().equals(EditorSearchSession.this.myStartSelectedText)) {
                                EditorSearchSession.this.myFindModel.setStringToFind("");
                            } else {
                                EditorSearchSession.this.restoreInitialCaretPositionAndSelection();
                            }
                        }
                        this.myIsGlobal = EditorSearchSession.this.myFindModel.isGlobal();
                        this.myIsReplace = EditorSearchSession.this.myFindModel.isReplaceState();
                    }
                    EditorSearchSession.this.updateUIWithFindModel();
                    EditorSearchSession.this.mySearchResults.clear();
                    EditorSearchSession.this.updateResults(true);
                    FindUtil.updateFindInFileModel(EditorSearchSession.this.getProject(), EditorSearchSession.this.myFindModel, !ConsoleViewUtil.isConsoleViewEditor(editor2));
                }
                finally {
                    this.myReentrantLock = false;
                }
            }
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
        this.updateMultiLineStateIfNeeded();
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.getEditor() == EditorSearchSession.this.myEditor) {
                    Disposer.dispose((Disposable)EditorSearchSession.this.myDisposable);
                    EditorSearchSession.this.myLivePreviewController.dispose();
                    EditorSearchSession.this.myStartSessionSelectionMarker.dispose();
                    EditorSearchSession.this.myStartSessionCaretMarker.dispose();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/EditorSearchSession$3", "editorReleased"));
            }
        }, this.myDisposable);
        this.myEditor.getSelectionModel().addSelectionListener((SelectionListener)this, this.myDisposable);
        FindUsagesCollector.triggerUsedOptionsStats(project, "FindInFile", findModel);
    }

    @NotNull
    protected AnAction[] createPrimarySearchActions() {
        AnAction[] anActionArray = new AnAction[]{new StatusTextAction(), new PrevOccurrenceAction(), new NextOccurrenceAction(), new FindAllAction(), new Separator(), new AddOccurrenceAction(), new RemoveOccurrenceAction(), new SelectAllAction(), new Separator(), new ToggleSelectionOnlyAction(), new ShowFilterPopupGroup()};
        if (anActionArray == null) {
            EditorSearchSession.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    private void saveInitialSelection() {
        if (this.mySelectionUpdatedFromSearchResults) {
            return;
        }
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        Document document = this.myEditor.getDocument();
        this.myStartSessionSelectionMarker = document.createRangeMarker(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd());
        this.myStartSessionCaretMarker = document.createRangeMarker(this.myEditor.getCaretModel().getOffset(), this.myEditor.getCaretModel().getOffset());
        this.myStartSelectedText = selectionModel.getSelectedText();
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    @Nullable
    public static EditorSearchSession get(@Nullable Editor editor2) {
        JComponent headerComponent = editor2 != null ? editor2.getHeaderComponent() : null;
        SearchReplaceComponent searchReplaceComponent = (SearchReplaceComponent)ObjectUtils.tryCast((Object)headerComponent, SearchReplaceComponent.class);
        return searchReplaceComponent != null ? SESSION_KEY.getData(searchReplaceComponent) : null;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor2, @Nullable Project project) {
        if (editor2 == null) {
            EditorSearchSession.$$$reportNull$$$0(4);
        }
        EditorSearchSession session2 = new EditorSearchSession(editor2, project);
        editor2.setHeaderComponent((JComponent)session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            EditorSearchSession.$$$reportNull$$$0(5);
        }
        return editorSearchSession;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor2, @NotNull FindModel findModel, @Nullable Project project) {
        if (editor2 == null) {
            EditorSearchSession.$$$reportNull$$$0(6);
        }
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(7);
        }
        EditorSearchSession session2 = new EditorSearchSession(editor2, project, findModel);
        editor2.setHeaderComponent((JComponent)session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            EditorSearchSession.$$$reportNull$$$0(8);
        }
        return editorSearchSession;
    }

    @Override
    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.myComponent;
        if (searchReplaceComponent == null) {
            EditorSearchSession.$$$reportNull$$$0(9);
        }
        return searchReplaceComponent;
    }

    public Project getProject() {
        return this.myComponent.getProject();
    }

    @NotNull
    private static FindModel createDefaultFindModel(Project project, Editor editor2) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)project).getFindInFileModel());
        if (editor2.getSelectionModel().hasSelection() && (selectedText = editor2.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        FindModel findModel2 = findModel;
        if (findModel2 == null) {
            EditorSearchSession.$$$reportNull$$$0(10);
        }
        return findModel2;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            EditorSearchSession.$$$reportNull$$$0(11);
        }
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        if (SESSION_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return this.myFindModel.isReplaceState() ? "Replace_the_found_target" : "ixFindText";
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(@NotNull SearchResults sr) {
        if (sr == null) {
            EditorSearchSession.$$$reportNull$$$0(12);
        }
        if (sr.getFindModel() == null) {
            return;
        }
        if (this.myComponent.getSearchTextComponent().getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            String status;
            boolean tooManyMatches;
            int matches = sr.getMatchesCount();
            boolean bl = tooManyMatches = matches > this.mySearchResults.getMatchesLimit();
            if (matches == 0 && !sr.getFindModel().isGlobal() && !this.myEditor.getSelectionModel().hasSelection()) {
                status = ApplicationBundle.message((String)"editorsearch.noselection", (Object[])new Object[0]);
                this.myComponent.setRegularBackground();
            } else {
                int cursorIndex = sr.getCursorVisualIndex();
                String string = tooManyMatches ? ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])new Object[]{this.mySearchResults.getMatchesLimit()}) : (status = cursorIndex != -1 ? ApplicationBundle.message((String)"editorsearch.current.cursor.position", (Object[])new Object[]{cursorIndex, matches}) : ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{matches}));
                if (!tooManyMatches && matches <= 0) {
                    this.myComponent.setNotFoundBackground();
                } else {
                    this.myComponent.setRegularBackground();
                }
            }
            this.myComponent.setStatusText(status);
            this.myClickToHighlightLabel.setVisible(tooManyMatches);
        }
        this.myComponent.updateActions();
    }

    @Override
    public void cursorMoved() {
        this.myComponent.updateActions();
    }

    @Override
    public void searchFieldDocumentChanged() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.setMatchesLimit(10000);
        String text2 = this.myComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(text2);
        this.updateResults(true);
        this.updateMultiLineStateIfNeeded();
    }

    private void updateMultiLineStateIfNeeded() {
        this.myFindModel.setMultiline(this.myComponent.getSearchTextComponent().getText().contains("\n") || this.myComponent.getReplaceTextComponent().getText().contains("\n"));
    }

    @Override
    public void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myComponent.getReplaceTextComponent().getText());
        this.updateMultiLineStateIfNeeded();
    }

    @Override
    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.myComponent.isMultiline());
    }

    @Override
    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(13);
        }
        return findModel;
    }

    @Override
    public boolean hasMatches() {
        return this.mySearchResults.hasMatches();
    }

    @Override
    public boolean isSearchInProgress() {
        return this.mySearchResults.isUpdating();
    }

    @Override
    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    @Override
    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    public boolean isLast(boolean forward) {
        return this.myLivePreviewController.isLast(forward ? SearchResults.Direction.DOWN : SearchResults.Direction.UP);
    }

    private void updateUIWithFindModel() {
        this.myComponent.update(this.myFindModel.getStringToFind(), this.myFindModel.getStringToReplace(), this.myFindModel.isReplaceState(), this.myFindModel.isMultiline());
        this.updateEmptyText();
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
    }

    private void updateEmptyText() {
        if (this.myComponent.getSearchTextComponent() instanceof ComponentWithEmptyText) {
            String emptyText = this.getEmptyText();
            ((ComponentWithEmptyText)this.myComponent.getSearchTextComponent()).getEmptyText().setText(StringUtil.capitalize((String)emptyText));
        }
    }

    private static void checkOption(List<? super String> chosenOptions, boolean state, String key) {
        if (state) {
            chosenOptions.add(StringUtil.toLowerCase((String)FindBundle.message(key, new Object[0]).replace(BundleBase.MNEMONIC_STRING, "")));
        }
    }

    @NotNull
    @NlsContexts.StatusText
    private String getEmptyText() {
        if (!this.myFindModel.getStringToFind().isEmpty()) {
            return "";
        }
        if (this.myFindModel.isGlobal()) {
            SmartList chosenOptions = new SmartList();
            EditorSearchSession.checkOption((List<? super String>)chosenOptions, this.myFindModel.isCaseSensitive(), "find.case.sensitive");
            EditorSearchSession.checkOption((List<? super String>)chosenOptions, this.myFindModel.isWholeWordsOnly() && !this.myFindModel.isRegularExpressions(), "find.whole.words");
            EditorSearchSession.checkOption((List<? super String>)chosenOptions, this.myFindModel.isRegularExpressions(), "find.regex");
            if (chosenOptions.isEmpty()) {
                return "";
            }
            if (chosenOptions.size() == 1) {
                String string = FindBundle.message("emptyText.used.option", chosenOptions.get(0));
                if (string == null) {
                    EditorSearchSession.$$$reportNull$$$0(14);
                }
                return string;
            }
            String string = FindBundle.message("emptyText.used.options", chosenOptions.get(0), chosenOptions.get(1));
            if (string == null) {
                EditorSearchSession.$$$reportNull$$$0(15);
            }
            return string;
        }
        String text2 = this.getEditor().getSelectionModel().getSelectedText();
        if (text2 != null && text2.contains("\n")) {
            boolean replaceState = this.myFindModel.isReplaceState();
            AnAction action2 = ActionManager.getInstance().getAction(replaceState ? "Replace" : "ToggleFindInSelection");
            Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])action2.getShortcutSet().getShortcuts());
            if (shortcut != null) {
                String string = ApplicationBundle.message((String)"editorsearch.in.selection.with.hint", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)});
                if (string == null) {
                    EditorSearchSession.$$$reportNull$$$0(16);
                }
                return string;
            }
        }
        String string = ApplicationBundle.message((String)"editorsearch.in.selection", (Object[])new Object[0]);
        if (string == null) {
            EditorSearchSession.$$$reportNull$$$0(17);
        }
        return string;
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value2) {
        this.mySearchResults.setMatchesLimit(value2);
    }

    private void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            try {
                this.myLivePreviewController.performReplace();
            }
            catch (FindManager.MalformedReplacementStringException e) {
                Messages.showErrorDialog((Component)this.myComponent, (String)e.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
            }
        }
    }

    public void addTextToRecent(JTextComponent textField2) {
        this.myComponent.addTextToRecent(textField2);
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        if (e == null) {
            EditorSearchSession.$$$reportNull$$$0(18);
        }
        this.saveInitialSelection();
        this.updateEmptyText();
    }

    @Override
    public void beforeSelectionUpdate() {
        this.mySelectionUpdatedFromSearchResults = true;
    }

    @Override
    public void afterSelectionUpdate() {
        this.mySelectionUpdatedFromSearchResults = false;
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    @Override
    public void close() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    private void initLivePreview() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        String text2 = this.myFindModel.getStringToFind();
        if (text2.isEmpty()) {
            this.nothingToSearchFor(allowedToChangedEditorSelection);
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text2);
                }
                catch (PatternSyntaxException e) {
                    this.myComponent.setNotFoundBackground();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    this.myComponent.setStatusText(FindBundle.message("find.incorrect.regexp", new Object[0]));
                    return;
                }
                if (text2.matches("\\|+")) {
                    this.nothingToSearchFor(allowedToChangedEditorSelection);
                    this.myComponent.setStatusText(ApplicationBundle.message((String)"editorsearch.empty.string.matches", (Object[])new Object[0]));
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance((Project)this.getProject());
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy2 = new FindModel();
                copy2.copyFrom(this.myFindModel);
                copy2.setReplaceState(false);
                findManager.setFindNextModel(copy2);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor(boolean allowedToChangedEditorSelection) {
        this.updateUIWithEmptyResults();
        this.mySearchResults.clear();
        if (allowedToChangedEditorSelection && !UIUtil.isClientPropertyTrue((Object)this.myComponent.getSearchTextComponent(), (Object)"JUST_CLEARED")) {
            this.restoreInitialCaretPositionAndSelection();
        }
    }

    private void restoreInitialCaretPositionAndSelection() {
        int originalSelectionStart = Math.min(this.myStartSessionSelectionMarker.getStartOffset(), this.myEditor.getDocument().getTextLength());
        int originalSelectionEnd = Math.min(this.myStartSessionSelectionMarker.getEndOffset(), this.myEditor.getDocument().getTextLength());
        try {
            if (this.myFindModel.isGlobal()) {
                this.mySelectionUpdatedFromSearchResults = true;
            }
            this.myEditor.getSelectionModel().setSelection(originalSelectionStart, originalSelectionEnd);
        }
        finally {
            this.mySelectionUpdatedFromSearchResults = false;
        }
        this.myEditor.getCaretModel().moveToOffset(Math.min(this.myStartSessionCaretMarker.getEndOffset(), this.myEditor.getDocument().getTextLength()));
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        EditorSearchSession.logSelectionUpdate();
    }

    public static void logSelectionUpdate() {
        if (SELECTION_UPDATE_LOGGER.isDebugEnabled()) {
            SELECTION_UPDATE_LOGGER.debug(new Throwable());
        }
    }

    private void updateUIWithEmptyResults() {
        this.myComponent.setRegularBackground();
        this.myComponent.setStatusText(ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{0}));
        this.myClickToHighlightLabel.setVisible(false);
    }

    public String getTextInField() {
        return this.myComponent.getSearchTextComponent().getText();
    }

    public void setTextInField(String text2) {
        this.myComponent.getSearchTextComponent().setText(text2);
        this.myFindModel.setStringToFind(text2);
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        this.myComponent.resetUndoRedoActions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/EditorSearchSession";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sr";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/EditorSearchSession";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrimarySearchActions";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultFindModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindModel";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "searchResultsUpdated";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExcludeAction
    extends ButtonAction
    implements LightEditCompatible {
        ExcludeAction() {
            super("", 'l');
        }

        @Override
        protected void update(@NotNull JButton button4) {
            FindResult cursor;
            if (button4 == null) {
                ExcludeAction.$$$reportNull$$$0(0);
            }
            button4.setEnabled((cursor = EditorSearchSession.this.mySearchResults.getCursor()) != null);
            button4.setText(cursor != null && EditorSearchSession.this.mySearchResults.isExcluded(cursor) ? FindBundle.message("button.include", new Object[0]) : FindBundle.message("button.exclude", new Object[0]));
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.exclude();
            EditorSearchSession.this.moveCursor(SearchResults.Direction.DOWN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ExcludeAction", "update"));
        }
    }

    private class ReplaceAllAction
    extends ButtonAction
    implements LightEditCompatible {
        ReplaceAllAction() {
            super(ApplicationBundle.message((String)"editorsearch.replace.all.action.text", (Object[])new Object[0]), 'a');
        }

        @Override
        protected void update(@NotNull JButton button4) {
            if (button4 == null) {
                ReplaceAllAction.$$$reportNull$$$0(0);
            }
            button4.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.performReplaceAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAllAction", "update"));
        }
    }

    private class ReplaceAction
    extends ButtonAction
    implements LightEditCompatible {
        ReplaceAction() {
            super(ApplicationBundle.message((String)"editorsearch.replace.action.text", (Object[])new Object[0]), 'p');
        }

        @Override
        protected void update(@NotNull JButton button4) {
            if (button4 == null) {
                ReplaceAction.$$$reportNull$$$0(0);
            }
            button4.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.replaceCurrent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAction", "update"));
        }
    }

    private static abstract class ButtonAction
    extends DumbAwareAction
    implements CustomComponentAction,
    ActionListener {
        private final @NlsActions.ActionText String myTitle;
        private final char myMnemonic;

        ButtonAction(@NotNull @NlsActions.ActionText String title2, char mnemonic) {
            if (title2 == null) {
                ButtonAction.$$$reportNull$$$0(0);
            }
            this.myTitle = title2;
            this.myMnemonic = mnemonic;
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                ButtonAction.$$$reportNull$$$0(1);
            }
            if (place == null) {
                ButtonAction.$$$reportNull$$$0(2);
            }
            JButton button4 = new JButton(this.myTitle);
            button4.setFocusable(false);
            if (!UISettings.getInstance().getDisableMnemonicsInControls()) {
                button4.setMnemonic(this.myMnemonic);
            }
            button4.setBorder(new DarculaButtonPainter(){

                @Override
                public Insets getBorderInsets(Component c) {
                    return JBUI.insets((int)1);
                }
            });
            button4.addActionListener(this);
            JButton jButton = button4;
            if (jButton == null) {
                ButtonAction.$$$reportNull$$$0(3);
            }
            return jButton;
        }

        public final void update(@NotNull AnActionEvent e) {
            JButton button4;
            if (e == null) {
                ButtonAction.$$$reportNull$$$0(4);
            }
            if ((button4 = (JButton)e.getPresentation().getClientProperty(COMPONENT_KEY)) != null) {
                this.update(button4);
            }
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ButtonAction.$$$reportNull$$$0(5);
            }
            this.onClick();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.onClick();
        }

        protected abstract void update(@NotNull JButton var1);

        protected abstract void onClick();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/EditorSearchSession$ButtonAction";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/EditorSearchSession$ButtonAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCustomComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createCustomComponent";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

